-- Copyright (c) 2020 Broadcom. All Rights Reserved.
-- The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.
--
-- THIS SOFTWARE CONTAINS CONFIDENTIAL INFORMATION AND TRADE SECRETS OF
-- BROADCOM. USE, DISCLOSURE OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
-- EXPRESS WRITTEN PERMISSION OF BROADCOM.
--
-- The Licensed Software and Documentation are deemed to be commercial computer
-- software as defined in FAR 12.212 and subject to restricted rights as
-- defined in FAR Section 52.227-19 "Commercial Computer Software - Restricted
-- Rights" and DFARS 227.7202, Rights in "Commercial Computer Software or
-- Commercial Computer Software Documentation," as applicable, and any successor
-- regulations, whether delivered by Broadcom as on premises or hosted services.
-- Any use, modification, reproduction release, performance, display or
-- disclosure of the Licensed Software and Documentation by the U.S. Government
-- shall be solely in accordance with the terms of this Agreement.

CREATE OR REPLACE VIEW REST_CONTENT_RECIPIENTS AS
   SELECT MESSAGERECIPIENTID      AS REST_CONTENT_RECIPIENT_ID,
          MESSAGEID               AS REST_CONTENT_ID,
          RECIPIENTIDENTIFIER     AS RECIPIENT_IDENTIFIER,
          RECIPIENTTYPE           AS RECIPIENT_TYPE
   FROM   MESSAGERECIPIENT;

CREATE OR REPLACE VIEW REST_CONTENT_ORIGINATORS AS
   SELECT MESSAGEORIGINATORID     AS REST_CONTENT_ORIGINATOR_ID,
          NETWORKSENDERIDENTIFIER AS SENDER_IDENTIFIER,
          IPADDRESS               AS IP_ADDRESS,
          NETWORKPORT             AS PORT
   FROM   MESSAGEORIGINATOR;


CREATE OR REPLACE VIEW REST_CONTENT_COMPONENTS AS
   SELECT MESSAGECOMPONENTID      AS REST_CONTENT_COMPONENT_ID,
          MESSAGEID               AS REST_CONTENT_ID,
          NAME                    AS ATTACHMENT_NAME,
          MIMETYPE                AS MIME_TYPE,
          COMPONENTTYPE           AS COMPONENT_TYPE,
          ORIGINALSIZE            AS ORIGINAL_SIZE
   FROM   MESSAGECOMPONENT;

CREATE OR REPLACE VIEW REST_CONDITION_VIOLATIONS AS
   SELECT CV.CONDITIONVIOLATIONID    AS REST_CONDITION_VIOLATION_ID,
          CV.MESSAGECOMPONENTID      AS REST_CONTENT_COMPONENT_ID,
          CV.INCIDENTID              AS REST_INCIDENT_ID,
          CV.VIOLATIONCOUNT          AS CONDITION_VIOLATION_COUNT,
          C.NAME                     AS POLICY_CONDITION_NAME,
          C.TYPE                     AS POLICY_CONDITION_TYPE
   FROM   CONDITIONVIOLATION CV,
          CONDITIONVIEW C
   WHERE  CV.CONDITIONID = C.CONDITIONID;

CREATE OR REPLACE VIEW REST_CONTENTS AS
   SELECT MESSAGEID                    AS REST_CONTENT_ID,
          MONITORID                    AS DETECTION_SERVER_ID,
          MESSAGEORIGINATORID          AS REST_CONTENT_ORIGINATOR_ID
   FROM   MESSAGE
   WHERE  MESSAGESOURCE = 'REST';

CREATE OR REPLACE VIEW REST_CONTEXT AS
   SELECT MESSAGEID                     AS REST_CONTENT_ID,
          REQUESTID                     AS REST_REQUEST_ID,
          CLIENTDOMAIN                  AS CLIENT_DOMAIN,
          CLIENTUSERID                  AS CLIENT_USER_ID,
          NETWORKPROTOCOL               AS NETWORK_PROTOCOL,
          NETWORKDIRECTION              AS NETWORK_DIRECTION,
          HTTPURL                       AS HTTP_URL,
          HTTPMETHOD                    AS HTTP_METHOD,
          HTTPUSERAGENT                 AS HTTP_USER_AGENT,
          HTTPBROWSER                   AS HTTP_BROWSER,
          HTTPSITECLASSIFICATION        AS HTTP_SITE_CLASSIFICATION,
          COMMONTRANSACTIONID           AS COMMON_TRANSACTION_ID,
          COMMONAPPLICATION             AS COMMON_APPLICATION,
          COMMONAPPLICATIONREPORTNAME   AS COMMON_APPLICATION_REPORT_NAME,
          COMMONFOLDER                  AS COMMON_FOLDER,
          COMMONCREATED                 AS COMMON_CREATED,
          COMMONLASTMODIFIED            AS COMMON_LAST_MODIFIED,
          COMMONLASTACCESSED            AS COMMON_LAST_ACCESSED,
          COMMONOWNER                   AS COMMON_OWNER,
          COMMONTAG                     AS COMMON_TAG,
          COMMONUSERID                  AS COMMON_USER_ID,
          COMMONUSERNAME                AS COMMON_USER_NAME,
          COMMONUSERTHREATSCORE         AS COMMON_USER_THREAT_SCORE,
          COMMONUSERISINTERNAL          AS COMMON_USER_IS_INTERNAL,
          COMMONUSERDOCSEXPOSEDCOUNT    AS COMMON_USER_DOCS_EXPOSED_COUNT,
          DEVICEISCOMPLIANT             AS DEVICE_IS_COMPLIANT,
          DEVICEISPERSONAL              AS DEVICE_IS_PERSONAL,
          DEVICEISTRUSTEDDEVICE         AS DEVICE_IS_TRUSTED_DEVICE,
          DEVICEISUNMANAGED             AS DEVICE_IS_UNMANAGED,
          DEVICEOS                      AS DEVICE_OS,
          DEVICETYPE                    AS DEVICE_TYPE,
          LOCATIONCOORDSLATITUDE        AS LOCATION_LATITUDE,
          LOCATIONCOORDSLONGITUDE       AS LOCATION_LONGITUDE,
          LOCATIONISINSIDEOFFICE        AS LOCATION_IS_INSIDE_OFFICE,
          LOCATIONREGION                AS LOCATION_REGION,
          LOCATIONREGIONCOUNTRY         AS LOCATION_REGION_COUNTRY,
          COMMONUSERACTIVITYTYPE        AS COMMON_USER_ACTIVITY_TYPE,
          COMMONDOCID                   AS COMMON_DOC_ID,
          COMMONDOCTYPE                 AS COMMON_DOC_TYPE,
          COMMONDOCACTIVITYCOUNT        AS COMMON_DOC_ACTIVITY_COUNT,
          COMMONDOCCREATORID            AS COMMON_DOC_CREATOR_ID,
          COMMONDOCEXPOSURESALLINTERNAL AS COMMON_DOC_EXPOSURES_INTERNAL,
          COMMONDOCEXPOSED              AS COMMON_DOC_EXPOSED,
          COMMONDOCEXPOSURESPUBLIC      AS COMMON_DOC_EXPOSURES_PUBLIC,
          COMMONDOCISINTERNAL           AS COMMON_DOC_IS_INTERNAL,
          COMMONDOCPARENTFOLDERID       AS COMMON_DOC_PARENT_FOLDER_ID
   FROM   RESTMESSAGEINFO;

CREATE OR REPLACE VIEW REST_INCIDENTS AS
   SELECT I.INCIDENTID                     AS REST_INCIDENT_ID,
          I.MESSAGEID                      AS REST_CONTENT_ID,
          I.INCIDENTSTATUSID               AS INCIDENT_STATUS_ID,
          I.POLICYID                       AS POLICY_ID,
          I.POLICYVERSION                  AS POLICY_VERSION,
          I.POLICYGROUPID                  AS POLICY_GROUP_ID,
          I.CUSTOMATTRIBUTESRECORDID       AS CUSTOM_ATTRIBUTE_ID,
          DO.NAME                          AS DATA_OWNER_NAME,
          DOE.EMAIL                        AS DATA_OWNER_EMAIL,
          I.MESSAGETYPE                    AS EVENT_TYPE_ID,
          I.INCIDENTSEVERITYID             AS INCIDENT_SEVERITY_ID,
          I.DETECTIONDATE                  AS DETECTION_DATE,
          I.MESSAGEDATE                    AS EVENT_DATE,
          I.CREATIONDATE                   AS CREATION_DATE,
          I.VIOLATIONCOUNT                 AS POLICY_VIOLATION_COUNT,
          I.BLOCKEDSTATUS                  AS RESPONSE_ACTION
   FROM   INCIDENT I,
          DATAOWNER DO,
          DATAOWNEREMAIL DOE
   WHERE  I.MESSAGESOURCE = 'REST'
   AND    I.DATAOWNERID = DO.DATAOWNERID (+)
   AND    I.DATAOWNEREMAILID = DOE.DATAOWNEREMAILID(+)
   AND    ISDELETED = 0;
