-- Copyright (c) 2019 Broadcom. All Rights Reserved.
-- The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.
--
-- THIS SOFTWARE CONTAINS CONFIDENTIAL INFORMATION AND TRADE SECRETS OF
-- BROADCOM. USE, DISCLOSURE OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
-- EXPRESS WRITTEN PERMISSION OF BROADCOM.
--
-- The Licensed Software and Documentation are deemed to be commercial computer
-- software as defined in FAR 12.212 and subject to restricted rights as
-- defined in FAR Section 52.227-19 "Commercial Computer Software - Restricted
-- Rights" and DFARS 227.7202, Rights in "Commercial Computer Software or
-- Commercial Computer Software Documentation," as applicable, and any successor
-- regulations, whether delivered by Broadcom as on premises or hosted services.
-- Any use, modification, reproduction release, performance, display or
-- disclosure of the Licensed Software and Documentation by the U.S. Government
-- shall be solely in accordance with the terms of this Agreement.

CREATE OR REPLACE VIEW PROTOCOLS AS
   SELECT PROTOCOLID             AS PROTOCOL_ID,
          NAME                   AS PROTOCOL_NAME,
          TYPE                   AS EVENT_TYPE_ID,
          ISDELETED              AS IS_DELETED,
          PORTS                  AS CONFIGURED_PORTS
    FROM PROTOCOL;

CREATE OR REPLACE VIEW NETWORK_CONTENT_RECIPIENTS AS
   SELECT MESSAGERECIPIENTID      AS NETWORK_CONTENT_RECIPIENT_ID,
          MESSAGEID               AS NETWORK_CONTENT_ID,
          RECIPIENTIDENTIFIER     AS RECIPIENT_IDENTIFIER,
          RECIPIENTTYPE           AS RECIPIENT_TYPE,
          IPADDRESS               AS IP_ADDRESS,
          PORT                    AS PORT
   FROM   MESSAGERECIPIENT;

CREATE OR REPLACE VIEW NETWORK_CONTENT_ORIGINATORS AS
   SELECT MESSAGEORIGINATORID     AS NETWORK_CONTENT_ORIGINATOR_ID,
          NETWORKSENDERIDENTIFIER AS SENDER_IDENTIFIER,
          IPADDRESS               AS IP_ADDRESS,
          NETWORKPORT             AS PORT,
          LASTACTIVITYTIME        AS LAST_ACTIVITY_TIME
   FROM   MESSAGEORIGINATOR;

CREATE OR REPLACE VIEW NETWORK_CONTENT_COMPONENTS AS
   SELECT MESSAGECOMPONENTID      AS NETWORK_CONTENT_COMPONENT_ID,
          MESSAGEID               AS NETWORK_CONTENT_ID,
          NAME                    AS ATTACHMENT_NAME,
          MIMETYPE                AS MIME_TYPE,
          COMPONENTTYPE           AS COMPONENT_TYPE,
          ORIGINALSIZE            AS ORIGINAL_SIZE
   FROM   MESSAGECOMPONENT;

CREATE OR REPLACE VIEW NETWORK_CONDITION_VIOLATIONS AS
   SELECT CV.CONDITIONVIOLATIONID    AS NETWORK_CONDITION_VIOLATION_ID,
          CV.VIOLATIONCOUNT          AS CONDITION_VIOLATION_COUNT,
          CV.MESSAGECOMPONENTID      AS NETWORK_CONTENT_COMPONENT_ID,
          CV.INCIDENTID              AS NETWORK_INCIDENT_ID,
          C.NAME                     AS POLICY_CONDITION_NAME,
          C.TYPE                     AS POLICY_CONDITION_TYPE
   FROM   CONDITIONVIOLATION CV,
          CONDITIONVIEW C
   WHERE  CV.CONDITIONID = C.CONDITIONID;

CREATE OR REPLACE VIEW NETWORK_CONTENTS AS
   SELECT MESSAGEID                     AS NETWORK_CONTENT_ID,
          MONITORID                     AS DETECTION_SERVER_ID,
          MESSAGEORIGINATORID           AS NETWORK_CONTENT_ORIGINATOR_ID,
          QUARANTINESTATUS              AS QUARANTINE_STATUS,
          MESSAGESUBJECT                AS SUBJECT,
          CHANNELSUBTYPE                AS CHANNEL_SUB_TYPE
   FROM   MESSAGE
   WHERE  MESSAGESOURCE = 'NETWORK';

CREATE OR REPLACE VIEW NETWORK_INCIDENTS AS
   SELECT I.INCIDENTID                      AS NETWORK_INCIDENT_ID,
          I.MESSAGEID                       AS NETWORK_CONTENT_ID,
          I.INCIDENTSTATUSID                AS INCIDENT_STATUS_ID,
          I.POLICYID                        AS POLICY_ID,
          I.POLICYVERSION                   AS POLICY_VERSION,
          I.POLICYGROUPID                   AS POLICY_GROUP_ID,
          I.CUSTOMATTRIBUTESRECORDID        AS CUSTOM_ATTRIBUTE_ID,
          DO.NAME                           AS DATA_OWNER_NAME,
          DOE.EMAIL                         AS DATA_OWNER_EMAIL,
          I.MESSAGETYPE                     AS EVENT_TYPE_ID,
          I.INCIDENTSEVERITYID              AS INCIDENT_SEVERITY_ID,
          I.DETECTIONDATE                   AS DETECTION_DATE,
          I.MESSAGEDATE                     AS EVENT_DATE,
          I.CREATIONDATE                    AS CREATION_DATE,
          I.VIOLATIONCOUNT                  AS POLICY_VIOLATION_COUNT,
          I.BLOCKEDSTATUS                   AS RESPONSE_ACTION
   FROM   INCIDENT I,
          DATAOWNER DO,
          DATAOWNEREMAIL DOE
   WHERE  MESSAGESOURCE = 'NETWORK'
   AND    I.DATAOWNERID = DO.DATAOWNERID (+)
   AND    I.DATAOWNEREMAILID = DOE.DATAOWNEREMAILID (+)
   AND    ISDELETED = 0;