-- Copyright (c) 2019 Broadcom. All Rights Reserved.
-- The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.
--
-- THIS SOFTWARE CONTAINS CONFIDENTIAL INFORMATION AND TRADE SECRETS OF
-- BROADCOM. USE, DISCLOSURE OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
-- EXPRESS WRITTEN PERMISSION OF BROADCOM.
--
-- The Licensed Software and Documentation are deemed to be commercial computer
-- software as defined in FAR 12.212 and subject to restricted rights as
-- defined in FAR Section 52.227-19 "Commercial Computer Software - Restricted
-- Rights" and DFARS 227.7202, Rights in "Commercial Computer Software or
-- Commercial Computer Software Documentation," as applicable, and any successor
-- regulations, whether delivered by Broadcom as on premises or hosted services.
-- Any use, modification, reproduction release, performance, display or
-- disclosure of the Licensed Software and Documentation by the U.S. Government
-- shall be solely in accordance with the terms of this Agreement.

CREATE OR REPLACE VIEW DETECTION_SERVERS AS
   SELECT INFORMATIONMONITORID           AS DETECTION_SERVER_ID,
          MONITORNAME                    AS DETECTION_SERVER_NAME,
          HOST                           AS ADDRESS,
          PORT                           AS PORT,
          ISDELETED                      AS IS_DELETED
   FROM   INFORMATIONMONITOR;

CREATE OR REPLACE VIEW POLICIES AS
   SELECT POLICYID              AS POLICY_ID,
          POLICYGROUPID         AS POLICY_GROUP_ID,
          NAME                  AS POLICY_NAME,
          LABEL                 AS POLICY_LABEL,
          DESCRIPTION           AS POLICY_DESCRIPTION,
          VERSION               AS CURRENT_POLICY_VERSION
   FROM   POLICY;

CREATE OR REPLACE VIEW POLICY_GROUPS AS
   SELECT POLICYGROUPID              AS POLICY_GROUP_ID,
          NAME                       AS POLICY_GROUP_NAME,
          DESCRIPTION                AS POLICY_GROUP_DESCRIPTION,
          EDITDATE                   AS MODIFIED_DATE,
          ISINTERNATIONALIZED        AS IS_I18N_KEY
   FROM   POLICYGROUP;

CREATE OR REPLACE VIEW INCIDENT_STATUSES AS
   SELECT INCIDENTSTATUSID               AS INCIDENT_STATUS_ID,
          NAME                           AS INCIDENT_STATUS_NAME,
          ISINTERNATIONALIZED            AS IS_I18N_KEY
   FROM   INCIDENTSTATUS;
