-- Copyright (c) 2019 Broadcom. All Rights Reserved.
-- The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.
--
-- THIS SOFTWARE CONTAINS CONFIDENTIAL INFORMATION AND TRADE SECRETS OF
-- BROADCOM. USE, DISCLOSURE OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
-- EXPRESS WRITTEN PERMISSION OF BROADCOM.
--
-- The Licensed Software and Documentation are deemed to be commercial computer
-- software as defined in FAR 12.212 and subject to restricted rights as
-- defined in FAR Section 52.227-19 "Commercial Computer Software - Restricted
-- Rights" and DFARS 227.7202, Rights in "Commercial Computer Software or
-- Commercial Computer Software Documentation," as applicable, and any successor
-- regulations, whether delivered by Broadcom as on premises or hosted services.
-- Any use, modification, reproduction release, performance, display or
-- disclosure of the Licensed Software and Documentation by the U.S. Government
-- shall be solely in accordance with the terms of this Agreement.

CREATE OR REPLACE VIEW ENDPOINT_CONTENT_RECIPIENTS AS
   SELECT MESSAGERECIPIENTID      AS ENDPOINT_CONTENT_RECIPIENT_ID,
          MESSAGEID               AS ENDPOINT_CONTENT_ID,
          RECIPIENTIDENTIFIER     AS RECIPIENT_IDENTIFIER,
          RECIPIENTTYPE           AS RECIPIENT_TYPE,
          IPADDRESS               AS IP_ADDRESS,
          PORT                    AS PORT
   FROM   MESSAGERECIPIENT;

CREATE OR REPLACE VIEW ENDPOINT_CONTENT_ORIGINATORS AS
   SELECT MESSAGEORIGINATORID     AS ENDPOINT_CONTENT_ORIGINATOR_ID,
          IPADDRESS               AS IP_ADDRESS,
          DOMAINUSERNAME          AS USER_NAME,
          ENDPOINTMACHINENAME     AS MACHINE_NAME,
          NETWORKSENDERIDENTIFIER AS SENDER_IDENTIFIER
   FROM   MESSAGEORIGINATOR;

CREATE OR REPLACE VIEW ENDPOINT_CONTENT_COMPONENTS AS
   SELECT MESSAGECOMPONENTID      AS ENDPOINT_CONTENT_COMPONENT_ID,
          MESSAGEID               AS ENDPOINT_CONTENT_ID,
          NAME                    AS ATTACHMENT_NAME,
          MIMETYPE                AS MIME_TYPE,
          COMPONENTTYPE           AS COMPONENT_TYPE,
          ORIGINALSIZE            AS ORIGINAL_SIZE
   FROM   MESSAGECOMPONENT;

CREATE OR REPLACE VIEW ENDPOINT_CONDITION_VIOLATIONS AS
   SELECT CV.CONDITIONVIOLATIONID    AS ENDPOINT_CONDITION_VIO_ID,
          CV.VIOLATIONCOUNT          AS CONDITION_VIOLATION_COUNT,
          CV.MESSAGECOMPONENTID      AS ENDPOINT_CONTENT_COMPONENT_ID,
          CV.INCIDENTID              AS ENDPOINT_INCIDENT_ID,
          C.NAME                     AS POLICY_CONDITION_NAME,
          C.TYPE                     AS POLICY_CONDITION_TYPE
   FROM   CONDITIONVIOLATION CV,
          CONDITIONVIEW C
   WHERE  CV.CONDITIONID = C.CONDITIONID;

CREATE OR REPLACE VIEW EP_INCIDENT_JUSTIFICATIONS AS
   SELECT INCIDENTJUSTIFICATIONID                 AS EP_INCIDENT_JUSTIFICATION_ID,
          INCIDENTID                              AS ENDPOINT_INCIDENT_ID,
          ENDPOINTJUSTIFICATIONLABELID            AS EP_JUSTIFICATION_LABEL_ID,
          ENDPOINTJUSTIFICATIONTEXT               AS EP_JUSTIFICATION_TEXT
   FROM   INCIDENTJUSTIFICATION;

CREATE OR REPLACE VIEW EP_JUSTIFICATION_LABELS AS
   SELECT ENDPOINTJUSTIFICATIONLABELID         AS EP_JUSTIFICATION_LABEL_ID,
          TEXT                                 AS EP_JUSTIFICATION_LABEL,
          TYPE                                 AS EP_JUSTIFICATION_TYPE,
          ISINTERNATIONALIZED                  AS IS_I18N_KEY
   FROM   ENDPOINTJUSTIFICATIONLABEL;

CREATE OR REPLACE VIEW ENDPOINT_CONTENTS AS
   SELECT M.MESSAGEID                     AS ENDPOINT_CONTENT_ID,
          M.MONITORID                     AS DETECTION_SERVER_ID,
          M.MESSAGEORIGINATORID           AS ENDPOINT_CONTENT_ORIGINATOR_ID,
          M.QUARANTINESTATUS              AS QUARANTINE_STATUS,
          M.ENDPOINTDOSVOLUMENAME         AS OS_VOLUMNE_NAME,
          M.ENDPOINTAPPLICATIONNAME       AS APPLICATION_NAME,
          M.ENDPOINTFILENAME              AS FILE_NAME,
          M.ENDPOINTFILEPATH              AS DESTINATION_FILE_PATH,
          M.ENDPOINTPRINTJOBTITLE         AS PRINT_JOB_TITLE,
          M.ENDPOINTAPPWINDOWTITLE        AS APP_WINDOW_TITLE,
          M.ENDPOINTPRINTERNAME           AS PRINTER_NAME,
          M.ENDPOINTPRINTERTYPE           AS PRINTER_TYPE,
          M.ENDPOINTSOURCEFILENAME        AS SOURCE_FILE_NAME,
          M.ENDPOINTSOURCEFILEPATH        AS SOURCE_FILE_PATH,
          M.ENDPOINTCONNECTIONSTATUS      AS ENDPOINT_LOCATION,
          ME.ISDETECTEDONENDPOINT         AS DETECTED_BY_AGENT,
          M.MESSAGESUBJECT                AS SUBJECT,
          M.ENDPOINTDEVICEINSTANCEID      AS DEVICE_INSTANCE_ID,
		  M.ENDPOINTSOURCEAPPLICATIONNAME AS SOURCE_APPLICATION_NAME,
		  M.ENDPOINTSOURCEAPPWINDOWTITLE  AS SOURCE_APP_WINDOW_TITLE
   FROM   MESSAGE M,
          MESSAGEEXT ME
   WHERE  MESSAGESOURCE = 'ENDPOINT'
   AND    ME.MESSAGEID = M.MESSAGEID;

CREATE OR REPLACE VIEW ENDPOINT_INCIDENTS AS
   SELECT I.INCIDENTID                      AS ENDPOINT_INCIDENT_ID,
          I.MESSAGEID                       AS ENDPOINT_CONTENT_ID,
          I.INCIDENTSTATUSID                AS INCIDENT_STATUS_ID,
          I.POLICYID                        AS POLICY_ID,
          I.POLICYVERSION                   AS POLICY_VERSION,
          I.POLICYGROUPID                   AS POLICY_GROUP_ID,
          I.CUSTOMATTRIBUTESRECORDID        AS CUSTOM_ATTRIBUTE_ID,
          DO.NAME                           AS DATA_OWNER_NAME,
          DOE.EMAIL                         AS DATA_OWNER_EMAIL,
          I.MESSAGETYPE                     AS EVENT_TYPE_ID,
          I.INCIDENTSEVERITYID              AS INCIDENT_SEVERITY_ID,
          I.DETECTIONDATE                   AS DETECTION_DATE,
          I.MESSAGEDATE                     AS EVENT_DATE,
          I.CREATIONDATE                    AS CREATION_DATE,
          I.VIOLATIONCOUNT                  AS POLICY_VIOLATION_COUNT,
          I.BLOCKEDSTATUS                   AS RESPONSE_ACTION
   FROM   INCIDENT I,
          DATAOWNER DO,
          DATAOWNEREMAIL DOE
   WHERE  MESSAGESOURCE = 'ENDPOINT'
   AND    I.DATAOWNERID = DO.DATAOWNERID (+)
   AND    I.DATAOWNEREMAILID = DOE.DATAOWNEREMAILID (+)
   AND    ISDELETED = 0;