# This file contains run-time application configuration, which will be copied
# to your release and executed as soon the system starts.
import Config

# For production, don't forget to configure the url host
# to something meaningful, Phoenix uses this information
# when generating URLs.
#
# Note we also include the path to a cache manifest
# containing the digested version of static files. This
# manifest is generated by the `mix phx.digest` task,
# which you should run after static files are built and
# before starting your production server.
config :schema, SchemaWeb.Endpoint,
  http: [port: System.get_env("PORT") || 8443],
  url: [
    host: "localhost",
    port: System.get_env("URL_PORT") || 443,
    path: System.get_env("SCHEMA_PATH") || "/"
  ]

# Configures the location of the schema files
config :schema, Schema.Repo, home: System.get_env("SCHEMA_DIR")
