/*! Copyright (c) 2021 Broadcom. All Rights Reserved. The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries. */
/******/ (function(modules) { // webpackBootstrap
/******/ 	// install a JSONP callback for chunk loading
/******/ 	function webpackJsonpCallback(data) {
/******/ 		var chunkIds = data[0];
/******/ 		var moreModules = data[1];
/******/ 		var executeModules = data[2];
/******/
/******/ 		// add "moreModules" to the modules object,
/******/ 		// then flag all "chunkIds" as loaded and fire callback
/******/ 		var moduleId, chunkId, i = 0, resolves = [];
/******/ 		for(;i < chunkIds.length; i++) {
/******/ 			chunkId = chunkIds[i];
/******/ 			if(Object.prototype.hasOwnProperty.call(installedChunks, chunkId) && installedChunks[chunkId]) {
/******/ 				resolves.push(installedChunks[chunkId][0]);
/******/ 			}
/******/ 			installedChunks[chunkId] = 0;
/******/ 		}
/******/ 		for(moduleId in moreModules) {
/******/ 			if(Object.prototype.hasOwnProperty.call(moreModules, moduleId)) {
/******/ 				modules[moduleId] = moreModules[moduleId];
/******/ 			}
/******/ 		}
/******/ 		if(parentJsonpFunction) parentJsonpFunction(data);
/******/
/******/ 		while(resolves.length) {
/******/ 			resolves.shift()();
/******/ 		}
/******/
/******/ 		// add entry modules from loaded chunk to deferred list
/******/ 		deferredModules.push.apply(deferredModules, executeModules || []);
/******/
/******/ 		// run deferred modules when all chunks ready
/******/ 		return checkDeferredModules();
/******/ 	};
/******/ 	function checkDeferredModules() {
/******/ 		var result;
/******/ 		for(var i = 0; i < deferredModules.length; i++) {
/******/ 			var deferredModule = deferredModules[i];
/******/ 			var fulfilled = true;
/******/ 			for(var j = 1; j < deferredModule.length; j++) {
/******/ 				var depId = deferredModule[j];
/******/ 				if(installedChunks[depId] !== 0) fulfilled = false;
/******/ 			}
/******/ 			if(fulfilled) {
/******/ 				deferredModules.splice(i--, 1);
/******/ 				result = __webpack_require__(__webpack_require__.s = deferredModule[0]);
/******/ 			}
/******/ 		}
/******/
/******/ 		return result;
/******/ 	}
/******/
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// object to store loaded and loading chunks
/******/ 	// undefined = chunk not loaded, null = chunk preloaded/prefetched
/******/ 	// Promise = chunk loading, 0 = chunk loaded
/******/ 	var installedChunks = {
/******/ 		0: 0
/******/ 	};
/******/
/******/ 	var deferredModules = [];
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	var jsonpArray = window["webpackJsonp"] = window["webpackJsonp"] || [];
/******/ 	var oldJsonpFunction = jsonpArray.push.bind(jsonpArray);
/******/ 	jsonpArray.push = webpackJsonpCallback;
/******/ 	jsonpArray = jsonpArray.slice();
/******/ 	for(var i = 0; i < jsonpArray.length; i++) webpackJsonpCallback(jsonpArray[i]);
/******/ 	var parentJsonpFunction = oldJsonpFunction;
/******/
/******/
/******/ 	// add entry module to deferred list
/******/ 	deferredModules.push([69,1]);
/******/ 	// run deferred modules when ready
/******/ 	return checkDeferredModules();
/******/ })
/************************************************************************/
/******/ ([
/* 0 */,
/* 1 */,
/* 2 */,
/* 3 */,
/* 4 */,
/* 5 */,
/* 6 */,
/* 7 */,
/* 8 */,
/* 9 */,
/* 10 */,
/* 11 */,
/* 12 */,
/* 13 */,
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

//NavIcons.ts
Object.defineProperty(exports, "__esModule", { value: true });
const home = /*html*/ `<svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 30 30">
    <g fill="none" fill-rule="evenodd" stroke-linecap="round" stroke-linejoin="round">
        <polygon class="primary-color" fill="#FFF" stroke="#A3A3A3" stroke-width="2" points="5 10.556 15 3.785 25 10.556 25 27 5 27"/>
        <polyline class="primary-color" stroke="#A3A3A3" stroke-width="2" points="12 27 12 17 18.083 17 18.083 27"/>
        <polyline class="primary-color" stroke="#A3A3A3" stroke-width="2" points="1.5 13 15 4 28.5 13"/>
    </g>
</svg>`;
exports.home = home;
const search = /*html*/ `<svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 30 30">
    <g fill="none" fill-rule="evenodd">
        <circle class="primary-color" cx="14" cy="13" r="11" fill="#FFF" stroke="#A3A3A3" stroke-width="2"/>
        <path class="primary-color" stroke="#A3A3A3" stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M21.5,22.5 L26.5,27.5"/>
    </g>
</svg>`;
exports.search = search;
const topn = /*html*/ `<svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 30 30">
    <g fill="none" fill-rule="evenodd">
        <rect class="primary-color" width="28" height="28" x="1" y="1" fill="#FFF" stroke="#A3A3A3" stroke-width="2" rx="8"/>
        <path class="primary-color" stroke="#A3A3A3" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7.5 9.5L7.5 22.5384048M12.5 6.9919575L12.5 22.5384048M17.5 15.9809101L17.5 22.5384048M22.5 12.9869041L22.5 22.5384048"/>
    </g>
</svg>`;
exports.topn = topn;
const schema = /*html*/ `<svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 30 30">
    <g fill="none" fill-rule="evenodd">
        <path class="primary-color" stroke="#A3A3A3" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M26.0950999,7.58917071 L26.0950999,6.70007258 C26.0950999,5.71850825 25.2772531,5.81097445 24.2675093,5.81097445 L11.3985301,5.81097445 C11.3985301,4.82941011 10.5797695,4.03277819 9.57093945,4.03277819 L5.91575825,4.03277819 C4.90601444,4.03277819 4.08816764,4.82941011 4.08816764,5.81097445 L4.08816764,7.58917071"/>
        <path class="primary-color" fill="#FFF" stroke="#A3A3A3" stroke-width="2" d="M3.21211209,10.367367 L26.9707899,10.367367 C27.9805337,10.367367 28.7983805,11.1631098 28.7983805,12.1455632 L26.9707899,23.7038389 C26.9707899,24.6862924 26.1529431,25.4820352 25.1431993,25.4820352 L5.03970269,25.4820352 C4.02995888,25.4820352 3.21211209,24.6862924 3.21211209,23.7038389 L1.38452148,12.1455632 C1.38452148,11.1631098 2.20236828,10.367367 3.21211209,10.367367 L3.21211209,10.367367 Z"/>
    </g>
</svg>`;
exports.schema = schema;
const config = /*html*/ `<svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 30 30">
    <g fill="none" fill-rule="evenodd">
        <rect class="primary-color" width="28" height="28" x="1" y="1" fill="#FFF" stroke="#A3A3A3" stroke-width="2" rx="8"/>
        <rect class="primary-color" width="20" height="8" x="5" y="5" stroke="#A3A3A3" stroke-width="2" rx="4"/>
        <rect class="primary-color" width="20" height="8" x="5" y="17" stroke="#A3A3A3" stroke-width="2" rx="4"/>
        <circle class="primary-color" cx="9" cy="9" r="2" fill="#A3A3A3"/>
        <circle class="primary-color" cx="9" cy="21" r="2" fill="#A3A3A3"/>
    </g>
</svg>`;
exports.config = config;
const settings = /*html*/ `<svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 30 30">
    <g fill="none" fill-rule="evenodd">
        <path class="primary-color" fill="#FFF" stroke="#A3A3A3" stroke-width="2" d="M12.16415,24.590048 L13.2939962,27.955488 L16.6824962,27.955488 L17.8113038,24.590048 L19.7542654,23.765328 L22.9734962,25.351328 L25.3702654,22.957248 L23.74715,19.775888 L24.5872654,17.819648 L27.9757654,16.670448 L27.9757654,13.284208 L24.5872654,12.176608 L23.74715,10.199568 L25.3702654,6.997408 L22.9734962,4.603328 L19.7542654,6.210128 L17.8113038,5.406208 L16.6824962,2.000208 L13.2939962,2.000208 L12.16415,5.406208 L10.1713423,6.210128 L7.00195769,4.603328 L4.60622692,6.997408 L6.17845769,10.199568 L5.38818846,12.176608 L1.99968846,13.284208 L1.99968846,16.670448 L5.38818846,17.819648 L6.17845769,19.775888 L4.60622692,22.957248 L7.00195769,25.351328 L10.1713423,23.765328 L12.16415,24.590048 Z"/>
        <path class="primary-color" stroke="#A3A3A3" stroke-width="2" d="M11,15 C11,17.2090658 12.7908353,19 15,19 C15.5794272,19 16.1396202,18.8773505 16.6540213,18.6433503 C18.0711379,17.9987066 19,16.5840124 19,15 C19,12.7906847 17.2093153,11 15,11 C12.7906847,11 11,12.7906847 11,15 Z"/>
    </g>
</svg>`;
exports.settings = settings;
const threatintel = /*html*/ `<svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 30 30">
    <g fill="none" fill-rule="evenodd">
        <circle class="primary-color" cx="15.5" cy="15.5" r="13.5" fill="#FFF" stroke="#A3A3A3" stroke-width="2"/>
        <circle class="primary-color" cx="15.5" cy="15.5" r="5.5" fill="#FFF" stroke="#A3A3A3" stroke-width="2"/>
        <path class="primary-color" stroke="#A3A3A3" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.5,2.5 L15.5,15.5"/>
    </g>
</svg>`;
exports.threatintel = threatintel;
const help = /*html*/ `<svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 30 30">
    <g fill="none" fill-rule="evenodd">
        <path class="primary-color" fill="#FFF" stroke="#A3A3A3" stroke-width="2" d="M1,15 C1,22.7317153 7.26828475,29 15,29 C22.7317153,29 29,22.7317153 29,15 C29,7.26828475 22.7317153,1 15,1 C7.26828475,1 1,7.26828475 1,15 Z"/>
        <path class="primary-color" fill="#A3A3A3" d="M16.2692308 21.6923077C16.2692308 22.5203077 15.5972308 23.1923077 14.7692308 23.1923077 13.9412308 23.1923077 13.2692308 22.5203077 13.2692308 21.6923077 13.2692308 20.8643077 13.9412308 20.1923077 14.7692308 20.1923077 15.5972308 20.1923077 16.2692308 20.8643077 16.2692308 21.6923077M14.6472998 19.0364717C14.4741104 19.0364717 14.3009209 19.041999 14.1286527 19.0346293 13.8421532 19.0226534 13.6422483 18.8559125 13.6404059 18.5740191 13.636721 17.6472713 13.6496181 16.7186811 13.962833 15.8297034 14.2097201 15.1277335 14.6878335 14.5814498 15.1816076 14.0452995 15.6210298 13.5671861 16.0595307 13.0872303 16.4851345 12.597141 16.6288449 12.4313213 16.7430762 12.2369438 16.8517803 12.04533 17.5832293 10.745488 16.7992707 9.20152257 15.3179483 9.00253896 14.6537483 8.91318058 14.0181063 8.94910818 13.4580043 9.36457858 12.8979022 9.78004899 12.6325908 10.3723937 12.5137533 11.0356724 12.4658499 11.3000627 12.4630862 11.5718227 12.4483467 11.8408191 12.4308435 12.1429794 12.2806846 12.3244598 11.977603 12.3391993 11.6118785 12.3567025 11.2443116 12.3567025 10.8785871 12.341963 10.5930088 12.3299871 10.4216618 12.1696947 10.4004737 11.8896437 10.2715028 10.1890709 10.9218845 8.39176983 12.6196937 7.45949477 13.4920894 6.98046015 14.430813 6.85793784 15.4091491 6.95282354 16.3027329 7.03941826 17.1207766 7.31854805 17.824589 7.89154714 18.6196022 8.54100753 19.0433636 9.39866374 19.1907589 10.3963454 19.3031478 11.1572735 19.2893295 11.9172803 18.9687448 12.6358323 18.6840877 13.274238 18.2492716 13.8103883 17.7730007 14.3179807 17.2626446 14.8615008 16.7522884 15.4068633 16.2649628 15.9724926 15.8227771 16.4856124 15.6449815 17.1019088 15.6634059 17.7780846 15.6689332 18.0065473 15.6643271 18.2350099 15.6587998 18.4634726 15.6505088 18.8549913 15.4690284 19.033708 15.0830371 19.0364717 14.9384055 19.0373929 14.7928526 19.0364717 14.6472998 19.0364717"/>
    </g>
</svg>`;


/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
const Condition_1 = __webpack_require__(26);
const schema_browser_1 = __webpack_require__(12);
class SimpleEventFilter {
    constructor(conditions = []) {
        this.valid = true;
        this._conditions = conditions;
    }
    get conditions() {
        return this._conditions;
    }
    addCondition(condition) {
        if (this._conditions.length >= 1) {
            let conditionArr = [];
            for (let c of this._conditions) {
                let newCondition = c.attribute + '' + c.operator + '' + c.value;
                conditionArr.push(newCondition);
            }
            let exists = conditionArr.indexOf(condition.toString());
            if (exists == -1) {
                this._conditions.push(condition);
                return true;
            }
            else {
                return false;
            }
        }
        else {
            this._conditions.push(condition);
            return true;
        }
    }
    removeCondition(condition) {
        let conditionIndex = this._conditions.indexOf(condition);
        this._conditions.splice(conditionIndex, 1);
    }
    get type() {
        return "simple";
    }
    toJson() {
        if (this._conditions.length === 0) {
            return;
        }
        //If only one condition, don't wrap in an AND block.
        if (this._conditions.length === 1) {
            return this._conditions[0].toJson();
        }
        let json = [];
        for (let condition of this._conditions) {
            json.push(condition.toJson());
        }
        return { "and": json };
    }
    static fromJson(eventFilter) {
        let simpleEventFilter = new SimpleEventFilter();
        let extractConditions = function (conditions) {
            if (Array.isArray(conditions)) {
                simpleEventFilter.addCondition(new Condition_1.default(new schema_browser_1.Attribute(conditions[0]), conditions[1], conditions[2]));
            }
            else {
                for (let condition of conditions["and"]) {
                    extractConditions(condition);
                }
            }
        };
        extractConditions(eventFilter);
        return simpleEventFilter;
    }
    toString() {
        return JSON.stringify(this.toJson());
    }
    clone() {
        let clone = new SimpleEventFilter();
        for (let condition of this._conditions) {
            clone._conditions.push(condition.clone());
        }
        clone.valid = this.valid;
        return clone;
    }
}
exports.default = SimpleEventFilter;


/***/ }),
/* 16 */,
/* 17 */,
/* 18 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

//GlobalIcons.ts
Object.defineProperty(exports, "__esModule", { value: true });
const HelpIcon = /*html*/ `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 13 13">
    <g fill-rule="evenodd">
        <circle cx="6.5" cy="6.5" r="6.5" class="primary-fill-color" />
        <path fill="#FFF" d="M7.16699219,8.15429688 L5.921875,8.15429688 C5.91861978,7.97525952 5.91699219,7.86621113 5.91699219,7.82714844 C5.91699219,7.42350059 5.98372329,7.09147266 6.1171875,6.83105469 C6.25065171,6.57063672 6.51757612,6.2776709 6.91796875,5.95214844 C7.31836138,5.62662598 7.5576168,5.41341196 7.63574219,5.3125 C7.7561855,5.15299399 7.81640625,4.9772145 7.81640625,4.78515625 C7.81640625,4.51822783 7.70979924,4.28955173 7.49658203,4.09912109 C7.28336482,3.90869045 6.99609556,3.81347656 6.63476562,3.81347656 C6.28645659,3.81347656 5.99511836,3.91275942 5.76074219,4.11132812 C5.52636602,4.30989683 5.36523481,4.61262817 5.27734375,5.01953125 L4.01757812,4.86328125 C4.0533856,4.28059604 4.30159275,3.78580933 4.76220703,3.37890625 C5.22282131,2.97200317 5.82747021,2.76855469 6.57617188,2.76855469 C7.36393623,2.76855469 7.99055757,2.97444456 8.45605469,3.38623047 C8.92155181,3.79801638 9.15429688,4.27734102 9.15429688,4.82421875 C9.15429688,5.12695464 9.06884851,5.41341011 8.89794922,5.68359375 C8.72704993,5.95377739 8.36165645,6.32161226 7.80175781,6.78710938 C7.51204282,7.027996 7.33219436,7.22167896 7.26220703,7.36816406 C7.1922197,7.51464917 7.16048174,7.77669082 7.16699219,8.15429688 Z M5.921875,10 L5.921875,8.62792969 L7.29394531,8.62792969 L7.29394531,10 L5.921875,10 Z"/>
    </g>
</svg>`;
exports.HelpIcon = HelpIcon;
const SaveIcon = /*html*/ `<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 20 20">
    <g fill="none" fill-rule="evenodd" stroke="#A6A7A7">
        <path class="primary-color" stroke-width="1.364" d="M0.681818182,0.681818182 L0.681818182,19.3181818 L19.3181818,19.3181818 L19.3181818,4.56813262 L15.4318674,0.681818182 L0.681818182,0.681818182 Z"/>
        <rect class="primary-color" width="10.065" height="5.779" x="4.968" y=".682" stroke-width="1.364"/>
        <path class="primary-color" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.364" d="M11.4285714,1.07142857 L11.4285714,6.12219129"/>
        <circle class="primary-color" cx="10" cy="12.857" r="2.89" stroke-width="1.364"/>
    </g>
</svg>`;
exports.SaveIcon = SaveIcon;
const SavedQueriesIcon = /*html*/ `<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 19 20">
    <g fill="none" fill-rule="evenodd">
        <g class="primary-fill-color">
            <polygon points="13.154 15.714 17.538 20 19 18.572 14.615 14.286"/>
            <path d="M8.76923077,0 C3.92642308,0 0,3.83785714 0,8.57285714 C0,13.3071429 3.92642308,17.145 8.76923077,17.145 C13.6120385,17.145 17.5384615,13.3071429 17.5384615,8.57285714 C17.5384615,3.83785714 13.6120385,0 8.76923077,0 M8.76923077,1.42857143 C12.7986923,1.42857143 16.0769231,4.63357143 16.0769231,8.57285714 C16.0769231,12.5121429 12.7986923,15.7164286 8.76923077,15.7164286 C4.73976923,15.7164286 1.46153846,12.5121429 1.46153846,8.57285714 C1.46153846,4.63357143 4.73976923,1.42857143 8.76923077,1.42857143"/>
        </g>
        <g transform="rotate(90 5.5 8.5)">
            <rect class="primary-fill-color" width="1.32" height="6.111" x=".88" y="3.056"/>
            <rect class="primary-fill-color" width="1.32" height="9.167" x="4.84"/>
            <rect class="primary-fill-color" width="1.32" height="9.167" x="8.36"/>
            <path class="primary-color" stroke-linecap="square" d="M0.22,10.0833333 L10.78,10.0833333"/>
        </g>
    </g>
</svg>`;
exports.SavedQueriesIcon = SavedQueriesIcon;
const SearchIcon = /*html*/ `<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 19 20">
    <g class="primary-fill-color" fill-rule="evenodd">
        <polygon points="13.154 15.714 17.538 20 19 18.572 14.615 14.286"/>
        <path d="M8.76923077,0 C3.92642308,0 0,3.83785714 0,8.57285714 C0,13.3071429 3.92642308,17.145 8.76923077,17.145 C13.6120385,17.145 17.5384615,13.3071429 17.5384615,8.57285714 C17.5384615,3.83785714 13.6120385,0 8.76923077,0 M8.76923077,1.42857143 C12.7986923,1.42857143 16.0769231,4.63357143 16.0769231,8.57285714 C16.0769231,12.5121429 12.7986923,15.7164286 8.76923077,15.7164286 C4.73976923,15.7164286 1.46153846,12.5121429 1.46153846,8.57285714 C1.46153846,4.63357143 4.73976923,1.42857143 8.76923077,1.42857143"/>
    </g>
</svg>`;
exports.SearchIcon = SearchIcon;
const DisabledSearchIcon = /*html*/ `<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 19 20">
    <g fill-rule="evenodd" fill="#cccccc" stroke="none">
        <polygon points="13.154 15.714 17.538 20 19 18.572 14.615 14.286"/>
        <path d="M8.76923077,0 C3.92642308,0 0,3.83785714 0,8.57285714 C0,13.3071429 3.92642308,17.145 8.76923077,17.145 C13.6120385,17.145 17.5384615,13.3071429 17.5384615,8.57285714 C17.5384615,3.83785714 13.6120385,0 8.76923077,0 M8.76923077,1.42857143 C12.7986923,1.42857143 16.0769231,4.63357143 16.0769231,8.57285714 C16.0769231,12.5121429 12.7986923,15.7164286 8.76923077,15.7164286 C4.73976923,15.7164286 1.46153846,12.5121429 1.46153846,8.57285714 C1.46153846,4.63357143 4.73976923,1.42857143 8.76923077,1.42857143"/>
    </g>
</svg>`;
exports.DisabledSearchIcon = DisabledSearchIcon;
const DownloadIcon = /*html*/ `<svg xmlns="http://www.w3.org/2000/svg" width="20" height="17" viewBox="0 0 20 17">
    <g fill="none" fill-rule="evenodd" class="primary-color" stroke-linecap="round" transform="translate(1)">
        <polyline stroke-linejoin="round" stroke-width="1.385" points="2.769 8.5 8.66 14.167 14.538 8.511" transform="matrix(-1 0 0 1 17.308 0)"/>
        <path stroke-width="1.385" d="M8.65384615,13.28125 L8.65384615,0.759567416" transform="matrix(-1 0 0 1 17.308 0)"/>
        <path stroke-linejoin="round" stroke-width="1.385" d="M0,16.2916667 L18,16.2916667 L0,16.2916667 Z"/>
    </g>
</svg>`;
exports.DownloadIcon = DownloadIcon;
const ColumnsIcon = /*html*/ `<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 16 18">
    <g class="primay-fill-color" fill-rule="evenodd" transform="rotate(90 8 8)">
        <rect width="18" height="3" y="4"/>
        <rect width="18" height="1"/>
        <rect width="18" height="1" y="10"/>
        <rect width="18" height="1" y="15"/>
    </g>
</svg>`;
exports.ColumnsIcon = ColumnsIcon;
const RemoveIcon = /*html*/ `<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25">
<g fill="none" fill-rule="evenodd">
  <circle cx="12.5" cy="12.5" r="12.5" class="primary-fill-color" />
  <g fill="#FFF" transform="rotate(45 3.964 16.036)">
    <rect width="1" height="15" x="7"/>
    <rect width="1" height="15" x="7" transform="rotate(90 7.5 7.5)"/>
  </g>
</g>
</svg>`;
exports.RemoveIcon = RemoveIcon;
const FilterIcon = /*html*/ `<svg xmlns="http://www.w3.org/2000/svg" width="21" height="19" viewBox="0 0 21 19">
  <path class="primary-fill-color" fill-rule="evenodd" d="M0.63798359,0 C0.0667975185,0 -0.215645594,0.706532228 0.19384442,1.11163921 L8.39979517,9.6199547 L8.39979517,16.5057045 C8.39979517,16.6767259 8.46699354,16.8391963 8.58459067,16.961049 L11.5108693,18.7450162 C11.9109096,19.1565365 12.5996928,18.8679378 12.5996928,18.2896716 L12.5996928,9.6199547 L20.8058918,1.11163921 C21.2153818,0.706532228 20.9339887,0 20.3628026,0 L0.63798359,0 Z"/>
</svg>`;
exports.FilterIcon = FilterIcon;
const DetailsIcon = /*html*/ `<svg xmlns="http://www.w3.org/2000/svg" width="21" height="16" viewBox="0 0 21 16">
<g fill="none" fill-rule="evenodd">
  <path class="primary-color" stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M19.0167494,7.5739645 L6.15384615,7.5739645"/>
  <ellipse cx="1.538" cy="1.515" class="primary-fill-color" fill-rule="nonzero" rx="1.538" ry="1.515"/>
  <path class="primary-color" stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M19.0167494,1.5147929 L6.15384615,1.5147929"/>
  <ellipse cx="1.538" cy="7.574" class="primary-fill-color" fill-rule="nonzero" rx="1.538" ry="1.515"/>
  <path class="primary-color" stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M19.0167494,13.6331361 L6.15384615,13.6331361"/>
  <ellipse cx="1.538" cy="13.633" class="primary-fill-color" fill-rule="nonzero" rx="1.538" ry="1.515"/>
</g>
</svg>`;
exports.DetailsIcon = DetailsIcon;
const PasteFilterIcon = /*html*/ `<svg xmlns="http://www.w3.org/2000/svg" width="25" height="24" viewBox="0 0 25 24">
    <g fill="none" fill-rule="evenodd">
        <path class="primary-fill-color" d="M6.80753115,7.5 C6.30837407,7.5 6.06154823,8.1175387 6.41939982,8.47161913 L13.5905453,15.9082424 L13.5905453,21.9266755 C13.5905453,22.0761554 13.6492697,22.2181613 13.7520373,22.3246657 L16.3092998,23.8839275 C16.6588933,24.2436135 17.260818,23.9913662 17.260818,23.4859374 L17.260818,15.9082424 L24.4321805,8.47161913 C24.7900321,8.1175387 24.5441238,7.5 24.0449667,7.5 L6.80753115,7.5 Z"/>
        <rect width="15.787" height="17.812" x=".675" y="2.564" class="primary-color" stroke-width="1.35" rx="1.036"/>
        <polygon class="primary-fill-color" points="6.694 4.318 10.711 4.318 12.05 2.159 5.355 2.159"/>
        <polygon class="primary-fill-color" points="13.121 2.159 11.112 0 5.757 0 3.749 2.159 7.765 2.159 7.765 1.439 9.104 1.439 9.104 2.159"/>
    </g>
</svg>`;
exports.PasteFilterIcon = PasteFilterIcon;


/***/ }),
/* 19 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//EventsModule.js
const angular = __webpack_require__(3);
const schema_browser_1 = __webpack_require__(12);
const EventService_1 = __webpack_require__(129);
exports.default = angular.module("icdx.events", [
    schema_browser_1.eventSchemaService.name,
    "icdx.eventarchive"
])
    .constant('eventServicePath', '/dx/archives/search')
    .constant('threatIntelPath', '/dx/intel/search')
    .factory('eventService', EventService_1.default).name;


/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
class RawEventFilter {
    constructor(filterString = "") {
        this.valid = true;
        this._filterString = filterString;
    }
    addCondition(condition) {
        if (this._filterString.length === 0) {
            this._filterString = condition.toString();
        }
        else {
            this._filterString = "(" + condition.toString() + ") AND (" + this._filterString + ")";
        }
    }
    get type() {
        return "raw";
    }
    get filterString() {
        return this._filterString;
    }
    set filterString(filterString) {
        this._filterString = filterString;
    }
    toString() {
        return this._filterString;
    }
    clone() {
        let clone = new RawEventFilter(this._filterString);
        clone.valid = this.valid;
        return clone;
    }
}
exports.default = RawEventFilter;


/***/ }),
/* 21 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
class PluginAttribute {
    constructor(pluginMetaAttribute, attribute) {
        this.pluginMetaAttribute = pluginMetaAttribute;
        this.name = this.pluginMetaAttribute.name;
    }
    get title() {
        return this.pluginMetaAttribute.title;
    }
    get description() {
        return this.pluginMetaAttribute.description;
    }
    get requirement() {
        return this.pluginMetaAttribute.requirement;
    }
    get isArray() {
        return this.pluginMetaAttribute.isArray;
    }
    get isRequired() {
        return this.pluginMetaAttribute.requirement === "required";
    }
    get isAdvanced() {
        return this.pluginMetaAttribute.advanced;
    }
    get isSystem() {
        return this.pluginMetaAttribute.requirement === "system";
    }
    get isValid() {
        return this.invalidAttributes.length === 0;
    }
}
exports.PluginAttribute = PluginAttribute;


/***/ }),
/* 22 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);

// EXTERNAL MODULE: ./node_modules/angular/index.js
var angular = __webpack_require__(3);
var angular_default = /*#__PURE__*/__webpack_require__.n(angular);

// EXTERNAL MODULE: ./node_modules/angular-material/index.js
var angular_material = __webpack_require__(11);
var angular_material_default = /*#__PURE__*/__webpack_require__.n(angular_material);

// CONCATENATED MODULE: ./src/events/eventwidgets/contextmenu.js
//contextmenu.js


//Disables the browsers context menu. This lets you control what right click does.
function disableBrowserContextMenuDirective($mdMenu) {
    return function(scope, element, attrs) {
        element.bind('contextmenu', function(event) {
            scope.$apply(function() {
                //We want the right click to still trigger closing of the menu.
                $mdMenu.hide();
                event.preventDefault();
            });
        });
    }
};

//Directive that captures a right click and fires it instead of the browsers built in context menu.
function rightClickDirective($parse) {
    return function(scope, element, attrs) {
        var callback = $parse(attrs.ngRightClick);
        element.bind('contextmenu', function(event) {
            scope.$apply(function() {
                callback(scope, { $event: event });
            });
        });
    }
};
// CONCATENATED MODULE: ./src/events/eventwidgets/widgets-module.js
//widgets-module.js





/* harmony default export */ var widgets_module = __webpack_exports__["default"] = (angular_default.a.module('ev.eventwidgets', [
        angular_material_default.a
    ])
    .directive('disableBrowserContextMenu', disableBrowserContextMenuDirective)
    .directive('ngRightClick', rightClickDirective));

/***/ }),
/* 23 */,
/* 24 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//HelpModule.ts
const angular = __webpack_require__(3);
const ngTranslate = __webpack_require__(10);
const HelpService_1 = __webpack_require__(116);
exports.default = angular.module('icdx.help', [
    ngTranslate
])
    .service('helpService', HelpService_1.default)
    .name;


/***/ }),
/* 25 */,
/* 26 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//Condition.ts
const moment = __webpack_require__(6);
class Condition {
    constructor(attribute, operator, value) {
        this._attribute = attribute;
        this._operator = operator;
        this.value = value;
    }
    set onChange(onChange) {
        this._onChange = onChange;
    }
    get attribute() {
        return this._attribute;
    }
    set attribute(attribute) {
        this._attribute = attribute;
        if (this.onChange !== undefined) {
            this._onChange();
        }
    }
    get operator() {
        switch (this._operator) {
            case "is":
                return "=";
            case "is_not":
                return "!=";
            default:
                return this._operator;
        }
    }
    set operator(operator) {
        this._operator = operator;
        if (this.onChange !== undefined) {
            this._onChange();
        }
    }
    get value() {
        if (typeof this._value === "string") {
            return this._value.replace(/&quot;/g, "\"");
        }
        return this._value;
    }
    set value(value) {
        if (typeof value === "string") {
            this._value = value.replace(/\\\"/g, "&quot;");
        }
        else {
            this._value = value;
        }
        this._value = value;
        if (this.onChange !== undefined) {
            this._onChange();
        }
    }
    valueToString(value) {
        if (typeof value === 'string') {
            return '\"' + value.replace(/&quot;/g, "\\\"") + '\"';
        }
        else {
            return value;
        }
    }
    toJson() {
        return [this._attribute.toString(), this._operator, moment.isMoment(this._value) ? moment(this._value).valueOf() : this._value];
    }
    toString() {
        let str = this._attribute.toString() + this._operator;
        if (typeof this.value === "string") {
            str += "\"" + this.value + "\"";
        }
        else {
            str += this.value;
        }
        return str;
    }
    clone() {
        return new Condition(this._attribute, this._operator, this._value);
    }
    getColor() {
        let colorCode = 0;
        let attribute = this.attribute.pathElements[this.attribute.pathElements.length - 1];
        for (let i = 0; i < attribute.length; i++) {
            colorCode += attribute.charCodeAt(i);
        }
        return { "background-color": Condition.colors[colorCode % 4] };
    }
}
Condition.colors = ["#007c3e", "#c89617", "#0360a3", "#ce1804"];
exports.default = Condition;


/***/ }),
/* 27 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//auth.ts
const $ = __webpack_require__(16);
const angular = __webpack_require__(3);
const moment = __webpack_require__(6);
const ngTranslate = __webpack_require__(10);
const ngCookies = __webpack_require__(43);
const ngMaterial = __webpack_require__(11);
__webpack_require__(113);
const AuthService_1 = __webpack_require__(115);
exports.default = angular.module('symc.auth', [
    ngTranslate,
    ngCookies,
    ngMaterial
]).name;
//Bundling the HTML files defined in the routes
let loginDialogTemplate = /*html*/ `
    <md-dialog class="auth-dialog">
        <form ng-submit="login()">
            <md-dialog-content class="md-dialog-content">
                <div class="signin" align="center">{{'auth.login' | translate}}</div>
                <div layout="column">
                    <div ng-style="{'visibility': authError === undefined ? 'hidden' : 'visible' }" style="padding-bottom: 5px;">
                        <span flex></span>
                        <span class="auth-error" translate="{{'auth.error.' + authError}}" translate-default="{{'auth.error.generic' | translate}}"></span>
                        <span flex></span>
                    </div>
                    <ux-textbox id="username" label="'auth.username'" ng-model="username" ng-change="username = newValue; authError = undefined;" on-validate="validUser()" autofocus="true"></ux-textbox>
                    <ux-textbox label="'auth.password'" ng-model="password" ng-change="password = newValue; authError = undefined;" on-validate="validPassword()" is-hidden="true"></ux-textbox>
                </div>
            </md-dialog-content>
            <md-dialog-actions layout="column">
                <div layout="row">
                    <span flex></span>
                    <div class="uxtoolkit" layout="row" style="overflow: hidden">
                        <div class="is--stratus" layout="row">
                            <input type="submit" class="button button__primary" value="{{(loggingIn ? 'auth.logging_in' : 'auth.login') | translate}}" ng-class="{ 'is--disabled': loggingIn || !validUser() || !validPassword() }">
                        </div>
                    </div>
                    <span flex></span>
                </div>
                <span class="schema-browser"><a ui-sref="home" ng-click="schemaBrowser();">Schema Browser</a></span>
                <!--<span class="privacy-policy">{{'auth.privacy_policy_agree' | translate}} <a href="https://www.symantec.com/enterprise-privacy" target="_blank">{{'auth.privacy_policy' | translate}}</a></span> -->
            </md-dialog-actions>
        </form>
    </md-dialog>`;
angular.module("symc.auth").config(function ($httpProvider) {
    $httpProvider.interceptors.push(function ($rootScope, $q, $timeout, $document, baseUrl) {
        let resetTimer = function () {
            if ($rootScope.authTimer !== undefined) {
                //Cancel existing timer so we can setup a new one.
                $timeout.cancel($rootScope.authTimer);
            }
            //Timeout after 30 minutes of activity.
            $rootScope.authTimer = $timeout($rootScope.doLogout, 1800000);
        };
        angular.element($document).on("click keydown keyup mousedown scroll focus mousewheel DOMMouseScroll", resetTimer);
        return {
            'response': function (response) {
                if (response.headers("x-epmp-date")) {
                    $rootScope.serverOffset = moment(parseInt(response.headers("x-epmp-date"))).diff(moment(new Date()));
                }
                if (!response.config.headers['X-Daemon'] && response.config.url.startsWith(baseUrl)) {
                    resetTimer();
                }
                return response;
            },
            'responseError': function (responseError) {
                if (responseError.status === 401 && !responseError.config.url.startsWith(baseUrl + "/v1/authentication")) {
                    return $rootScope.doLogin(responseError.config);
                }
                else {
                    return $q.reject(responseError);
                }
            }
        };
    });
});
angular.module("symc.auth").run(function ($rootScope, $window, $state, $mdDialog, $http, $q, authService) {
    $rootScope.$on('$stateChangeStart', function (event, toState, toParams) {
        const authRequired = toState.data.authRequired;
        if (authRequired && !authService.isAuthenticated()) {
            event.preventDefault();
            $rootScope.showLogin().then(function () {
                $state.go(toState.name, toParams);
            });
        }
    });
    $rootScope.showLogin = function () {
        return $mdDialog.show({
            controller: LoginDialog,
            template: loginDialogTemplate,
            hasBackdrop: false,
            clickOutsideToClose: false,
            escapeToClose: false,
            fullscreen: true,
            focusOnOpen: false
        });
    };
    $rootScope.doLogin = function (request) {
        let defer = $q.defer();
        //Multiple attempts to login are possible if there are timers and timeouts
        //running. First will be false, all others will be true.
        let multipleRequests = false;
        if ($rootScope.loginPromise === undefined) {
            $rootScope.loginPromise = $rootScope.showLogin();
        }
        else {
            multipleRequests = true;
        }
        $rootScope.loginPromise.then(function () {
            //Remove the bad Authorization header before performing the request
            //again if it is the first request.
            if (!multipleRequests && request.headers.Authorization !== undefined) {
                delete request.headers.Authorization;
            }
            if (request !== undefined) {
                $http(request).then(function (newResponse) {
                    defer.resolve(newResponse);
                });
            }
            delete $rootScope.loginPromise;
        }, function () {
            delete $rootScope.loginPromise;
        });
        return defer.promise;
    };
    $rootScope.doLogout = function () {
        authService.logout();
    };
});
/**
 * Controller for the column picker dialog.
 */
function LoginDialog($scope, $mdDialog, $timeout, authService, $window) {
    $scope.username = "";
    $scope.password = "";
    $scope.authError = undefined;
    $scope.loggingIn = false;
    angular.element("#auth").addClass("auth");
    $timeout(function () {
        $("#username").find("input").focus();
    });
    $scope.schemaBrowser = function () {
        $window.open('/icd-schema/');
    };
    $scope.validUser = function () {
        return $scope.username !== "";
    };
    $scope.validPassword = function () {
        return $scope.password !== "";
    };
    $scope.login = function () {
        if ($scope.loggingIn || !$scope.validUser() || !$scope.validPassword()) {
            //Already logging in
            return;
        }
        $scope.loggingIn = true;
        authService.login({
            'email': $scope.username,
            'password': $scope.password
        }).then(function () {
            $mdDialog.hide();
            angular.element("#auth").removeClass("auth");
            $scope.loggingIn = false;
        }, function (errorResponse) {
            console.log("failure", errorResponse);
            $scope.authError = errorResponse.status;
            $scope.loggingIn = false;
        });
    };
}
angular.module("symc.auth").factory('authService', AuthService_1.default);


/***/ }),
/* 28 */,
/* 29 */,
/* 30 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//EventListModule.ts
const angular = __webpack_require__(3);
const ngTranslate = __webpack_require__(10);
const ngMaterial = __webpack_require__(11);
const ngMaterialDataTable = __webpack_require__(23);
__webpack_require__(130);
const EventsModule_1 = __webpack_require__(19);
const EventDetailsModule_1 = __webpack_require__(132);
const widgets_module_1 = __webpack_require__(22);
const EventListComponent_1 = __webpack_require__(136);
const EventRendererDirective_1 = __webpack_require__(142);
const ExportEvents_1 = __webpack_require__(146);
const EventTools_1 = __webpack_require__(44);
class EventTemplateProvider {
    constructor() {
        this.templates = {};
        this.registerTemplate = function (eventField, template) {
            this.templates[eventField] = template;
        };
    }
    $get() {
        let self = this;
        let templateService = {};
        templateService.getTemplate = function (eventField) {
            return self.templates[eventField];
        };
        return templateService;
    }
    ;
}
exports.default = angular.module('ev.eventlist', [
    widgets_module_1.default.name,
    EventsModule_1.default,
    "symc.event-schema",
    EventDetailsModule_1.default,
    ngTranslate,
    ngMaterial,
    ngMaterialDataTable,
    'fixed.table.header'
])
    .provider("eventTemplate", EventTemplateProvider)
    .component('symEventList', new EventListComponent_1.default())
    .filter('translateColumns', function () {
    return EventTools_1.default.translateColumns;
})
    .directive('eventRenderer', EventRendererDirective_1.default)
    .directive('exportEvents', function (reactDirective, $translate) {
    return reactDirective(ExportEvents_1.ExportEvents, undefined, {}, { $translate: $translate });
})
    .name;


/***/ }),
/* 31 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//EventsModule.js
const angular = __webpack_require__(3);
const settings_module_1 = __webpack_require__(32);
const EventArchiveService_1 = __webpack_require__(185);
const ArchivePickerComponent_1 = __webpack_require__(186);
exports.default = angular.module("icdx.eventarchive", [
    settings_module_1.default
])
    .constant('eventServicePath', '/dx/archives/search')
    .component('archivePicker', new ArchivePickerComponent_1.default())
    .factory('eventArchiveService', EventArchiveService_1.default).name;


/***/ }),
/* 32 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var angular__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var angular__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(angular__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var angular_translate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10);
/* harmony import */ var angular_translate__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(angular_translate__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var angular_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(11);
/* harmony import */ var angular_material__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(angular_material__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var angular_material_data_table__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(23);
/* harmony import */ var angular_material_data_table__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(angular_material_data_table__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var ngreact__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(28);
/* harmony import */ var ngreact__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(ngreact__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _openc2_OpenC2Module__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(53);
/* harmony import */ var _openc2_OpenC2Module__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_openc2_OpenC2Module__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var src_events_eventfilter_EventFilterModule__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(54);
/* harmony import */ var src_events_eventfilter_EventFilterModule__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(src_events_eventfilter_EventFilterModule__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var src_common_errors_ErrorModule__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(55);
/* harmony import */ var src_common_errors_ErrorModule__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(src_common_errors_ErrorModule__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var src_common_help_HelpModule__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(24);
/* harmony import */ var src_common_help_HelpModule__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(src_common_help_HelpModule__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _ApiKeyOptions__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(56);
/* harmony import */ var _ApiKeyOptions__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_ApiKeyOptions__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _PluginActions__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(57);
/* harmony import */ var _PluginActions__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_PluginActions__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _PasteFilter__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(58);
/* harmony import */ var _PasteFilter__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_PasteFilter__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _SettingsService__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(59);
/* harmony import */ var _SettingsService__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(_SettingsService__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _ApiKeysService__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(60);
/* harmony import */ var _ApiKeysService__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(_ApiKeysService__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _PluginConfigListController__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(61);
/* harmony import */ var _PluginConfigListController__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(_PluginConfigListController__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var _SettingsLandingController__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(62);
/* harmony import */ var _SettingsLandingController__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(_SettingsLandingController__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var _ApiKeysController__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(63);
/* harmony import */ var _ApiKeysController__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(_ApiKeysController__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var _PluginConfigComponent__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(36);
/* harmony import */ var _PluginConfigComponent__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(_PluginConfigComponent__WEBPACK_IMPORTED_MODULE_17__);
//settings-module.js












/* harmony default export */ __webpack_exports__["default"] = (angular__WEBPACK_IMPORTED_MODULE_0___default.a.module('dxs.settings', [
    angular_translate__WEBPACK_IMPORTED_MODULE_1__,
    angular_material__WEBPACK_IMPORTED_MODULE_2___default.a,
    angular_material_data_table__WEBPACK_IMPORTED_MODULE_3___default.a,
    "uxtoolkit-lite",
    "symc.event-schema",
    src_events_eventfilter_EventFilterModule__WEBPACK_IMPORTED_MODULE_6___default.a,
    src_common_errors_ErrorModule__WEBPACK_IMPORTED_MODULE_7___default.a,
    ngreact__WEBPACK_IMPORTED_MODULE_4___default.a.name,
    _openc2_OpenC2Module__WEBPACK_IMPORTED_MODULE_5___default.a,
    src_common_help_HelpModule__WEBPACK_IMPORTED_MODULE_8___default.a
]).name);

//Bundling the HTML files defined in the routes
var pluginConfigListTemplate = __webpack_require__(170);
var settingsLandingTemplate = __webpack_require__(171);
var apiKeysTemplate = __webpack_require__(172);











angular__WEBPACK_IMPORTED_MODULE_0___default.a.module('dxs.settings')
    .factory('settingsService', _SettingsService__WEBPACK_IMPORTED_MODULE_12___default.a)
    .factory('apiKeysService', _ApiKeysService__WEBPACK_IMPORTED_MODULE_13___default.a)
    .controller('PluginConfigListController', _PluginConfigListController__WEBPACK_IMPORTED_MODULE_14___default.a)
    .controller('SettingsLandingController', _SettingsLandingController__WEBPACK_IMPORTED_MODULE_15___default.a)
    .controller('ApiKeysController', _ApiKeysController__WEBPACK_IMPORTED_MODULE_16___default.a)
    .component('plugin', new _PluginConfigComponent__WEBPACK_IMPORTED_MODULE_17__["PluginConfigComponent"]())
    .component('pluginAttribute', new _PluginConfigComponent__WEBPACK_IMPORTED_MODULE_17__["PluginConfigAttributeComponent"]())
    .directive('pluginActions', function(reactDirective, $translate) {
        return reactDirective(_PluginActions__WEBPACK_IMPORTED_MODULE_10__["PluginActions"], undefined, {}, { $translate: $translate });
    })
    .directive('apiKeyOptions', function(reactDirective, $translate) {
        return reactDirective(_ApiKeyOptions__WEBPACK_IMPORTED_MODULE_9__["ApiKeyOptions"], undefined, {}, { $translate: $translate });
    })
    .directive('pasteFilter', function(reactDirective, $translate) {
        return reactDirective(_PasteFilter__WEBPACK_IMPORTED_MODULE_11__["PasteFilter"], undefined, {}, { $translate: $translate });
    })
    .config(function($stateProvider) {
        $stateProvider.state('config', {
            data: {
                authRequired: true
            },
            params: {
                type: "config"
            },
            url: '/config/:category',
            template: pluginConfigListTemplate
        }).state('settings-icdx', {
            data: {
                authRequired: true
            },
            params: {
                type: "settings",
                category: "other/icdx"
            },
            url: '/settings/icdx',
            template: pluginConfigListTemplate
        }).state('settings-apikeys', {
            data: {
                authRequired: true
            },
            url: '/settings/apikeys',
            template: apiKeysTemplate
        }).state('settings', {
            data: {
                authRequired: true
            },
            url: '/settings/categories/:category',
            template: settingsLandingTemplate
        });
    });

/***/ }),
/* 33 */,
/* 34 */,
/* 35 */,
/* 36 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
const PluginConfig_1 = __webpack_require__(45);
__webpack_require__(181);
let pluginConfigTemplate = __webpack_require__(183);
let pluginConfigAttributeTemplate = __webpack_require__(184);
class PluginConfigComponent {
    constructor() {
        this.bindings = {
            plugin: '<',
            showAdvanced: '=',
            configOnly: "<",
            showEnable: "<",
            onChange: "&"
        };
        this.controller = PluginConfigController;
        this.template = pluginConfigTemplate;
    }
}
exports.PluginConfigComponent = PluginConfigComponent;
PluginConfigComponent.$$ngIsClass = true; //Fix for Firefox
class PluginConfigController {
    constructor() {
        this.configOnly = false;
        this.showEnable = false;
    }
    $onInit() {
        this.configOnly = (this.configOnly === undefined) ? false : this.configOnly;
        let configAttribute = this.plugin.attributes.get("config");
        this.configAttributes = configAttribute.attributes;
        this.uuidAttribute = this.plugin.attributes.get("uuid");
        this.nameAttribute = this.plugin.attributes.get("name");
        this.descriptionAttribute = this.plugin.attributes.get("desc");
        this.enabledAttribute = this.plugin.attributes.get("enabled");
    }
}
PluginConfigController.$inject = [];
class PluginConfigAttributeComponent {
    constructor() {
        this.bindings = {
            plugin: '<',
            pluginAttribute: '<',
            showAdvanced: '=',
            configOnly: "<",
            translationKey: '<',
            onChange: '&'
        };
        this.controller = PluginConfigAttributeController;
        this.template = pluginConfigAttributeTemplate;
    }
}
exports.PluginConfigAttributeComponent = PluginConfigAttributeComponent;
PluginConfigAttributeComponent.$$ngIsClass = true; //Fix for Firefox
class PluginConfigAttributeController {
    constructor($scope, $window, $translate, eventQueryService, apiKeysService) {
        this.$scope = $scope;
        this.$window = $window;
        this.$translate = $translate;
        this.eventQueryService = eventQueryService;
        this.apiKeysService = apiKeysService;
        this.applyFilter = this.applyFilter.bind(this);
    }
    $onInit() {
        this.configOnly = (this.configOnly === undefined) ? false : this.configOnly;
        let self = this;
        self.isArray = self.pluginAttribute.isArray;
        self.isObject = self.pluginAttribute instanceof PluginConfig_1.PluginObjectAttribute;
        if (self.isArray && !self.isObject && self.pluginAttribute.value !== undefined) {
            self.value = self.pluginAttribute.value.join(',');
        }
        if (self.pluginAttribute.subType === "filter") {
            self.$scope.openMenu = function ($mdMenu, ev) {
                $mdMenu.open(ev);
            };
            self.eventQueryService.getMyQueries().then(function (myQueries) {
                self.myQueries = myQueries;
                self.$scope.hasQueries = Object.keys(self.myQueries).length > 0;
            });
        }
        if (self.pluginAttribute.subType === "apikey.clientid") {
            self.apiKeysService.getApiKeys().then(function (apiKeys) {
                self.apiKeys = new Map();
                for (let apiKey of apiKeys) {
                    self.apiKeys.set(apiKey.clientId, apiKey.name);
                }
            });
        }
    }
    applyFilter(filter) {
        this.pluginAttribute.value = filter;
        this.onChange();
    }
    updateArrayValues(values) {
        this.pluginAttribute.value = values.split(',').map(item => item.trim()).filter(item => item !== '');
        if (this.pluginAttribute.type === "integer") {
            this.pluginAttribute.value = this.pluginAttribute.value.map(Number);
        }
        else if (this.pluginAttribute.type === "boolean") {
            this.pluginAttribute.value = this.pluginAttribute.value.map(Boolean).filter(Boolean);
        }
    }
    getCaption(pluginAttribute) {
        let pluginMetaAttribute = pluginAttribute.pluginMetaAttribute;
        let description = pluginMetaAttribute.description;
        if (pluginAttribute.type === "integer" && (pluginMetaAttribute.min > -2147483648 || pluginMetaAttribute.max < 2147483647)) {
            description += " " + this.$translate.instant("settings.range", { min: pluginMetaAttribute.min.toLocaleString(), max: pluginMetaAttribute.max.toLocaleString() });
        }
        return description;
    }
}


/***/ }),
/* 37 */,
/* 38 */,
/* 39 */,
/* 40 */,
/* 41 */,
/* 42 */,
/* 43 */,
/* 44 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
class EventTools {
    static restoreTranslatedObject(originalKey, object) {
        let transltaedOriginalKey = this.getObjectKey(object, originalKey);
        let restoredObject = {};
        if (object === null) {
            restoredObject[transltaedOriginalKey] = null;
        }
        else if (object["_enum"] !== null && Array.isArray(object["_enum"])) {
            restoredObject[transltaedOriginalKey] = object["_enum"];
            return restoredObject;
        }
        else if (object["_value"] !== null && Array.isArray(object["_value"])) {
            let restoredArray = [];
            for (const arrayElement of object["_value"]) {
                if (arrayElement !== null && typeof (arrayElement) === "object") {
                    let arrayObject = {};
                    for (let [key, value] of Object.entries(arrayElement)) {
                        this.addObject(arrayObject, this.restoreTranslatedObject(key, value));
                    }
                    restoredArray.push(arrayObject);
                }
                else {
                    restoredArray.push(arrayElement);
                }
            }
            restoredObject[transltaedOriginalKey] = restoredArray;
            return restoredObject;
        }
        else if (object["_value"] !== null && typeof (object["_value"]) === "object") {
            for (let [key, value] of Object.entries(object["_value"])) {
                if (value === null || value["_value"] === undefined) {
                    if (restoredObject[transltaedOriginalKey] === undefined)
                        restoredObject[transltaedOriginalKey] = {};
                    restoredObject[transltaedOriginalKey][key] = value;
                }
                else {
                    let obj = this.restoreTranslatedObject(key, value);
                    if (restoredObject[transltaedOriginalKey] === undefined)
                        restoredObject[transltaedOriginalKey] = {};
                    this.addObject(restoredObject[transltaedOriginalKey], obj);
                }
            }
        }
        else if (object["_enum"] !== undefined) {
            restoredObject[transltaedOriginalKey] = object["_enum"];
        }
        else if (object["_value"] !== undefined) {
            restoredObject[transltaedOriginalKey] = object["_value"];
        }
        else {
            restoredObject[transltaedOriginalKey] = object;
        }
        return restoredObject;
    }
    static addSubColumns(event, renderedEvent) {
        for (let [key, value] of Object.entries(event)) {
            let object = value["_value"];
            if (object !== null && typeof (object) === "object") {
                try {
                    for (let [subKey, subValue] of Object.entries(object)) {
                        let column = key + ":" + subKey;
                        if (subValue === null) {
                            renderedEvent[column] = null;
                            continue;
                        }
                        let eventValues = {};
                        let array = null;
                        if (subValue["_enum"] && Array.isArray(subValue["_enum"])) {
                            array = subValue["_value"];
                        }
                        else if (subValue["_value"] && Array.isArray(subValue["_value"])) {
                            array = subValue["_value"];
                        }
                        else if (Array.isArray(subValue)) {
                            array = subValue;
                        }
                        if (array != null) {
                            for (let index = 0; index < array.length; index++) {
                                if (typeof array[index] === "object") {
                                    for (let [arrKey, arrValue] of Object.entries(array[index])) {
                                        let arrColumn = column + ":" + index + ":" + arrKey;
                                        renderedEvent[arrColumn] = {};
                                        renderedEvent[arrColumn]["value"] = this.stringifyFirstValueFromObject(EventTools.restoreTranslatedObject(arrKey, arrValue));
                                        renderedEvent[arrColumn]["isNotFilterable"] = true;
                                    }
                                }
                                else {
                                    let arrColumn = column + ":" + index;
                                    renderedEvent[arrColumn] = {};
                                    renderedEvent[arrColumn]["value"] = array[index];
                                    renderedEvent[arrColumn]["isNotFilterable"] = true;
                                }
                            }
                        }
                        if (subValue["_enum"]) {
                            eventValues["enum"] = subValue["_value"];
                            eventValues["value"] = subValue["_enum"];
                        }
                        else {
                            eventValues["value"] = this.stringifyFirstValueFromObject(EventTools.restoreTranslatedObject(subKey, subValue));
                        }
                        renderedEvent[column] = eventValues;
                    }
                }
                catch (_a) {
                    continue;
                }
            }
        }
    }
    static stringifyFirstValueFromObject(object) {
        return this.stringifyIfRequired(object[Object.keys(object)[0]]);
    }
    static stringifyIfRequired(value) {
        if (typeof (value) === "object") {
            return JSON.stringify(value, null, 2);
        }
        if (typeof (value) === "string" && (value.startsWith("{") || value.startsWith("["))) {
            try {
                return JSON.stringify(JSON.parse(value), null, 2);
            }
            catch (_a) {
                return value;
            }
        }
        return value;
    }
    static getObjectKey(object, originalKey) {
        if (object === null || object["_name"] === undefined) {
            return originalKey;
        }
        return object["_name"];
    }
    static addObject(destination, object) {
        for (let [key, value] of Object.entries(object)) {
            destination[key] = value;
        }
    }
}
EventTools.translateColumns = function (input, events, translationCache) {
    if (!events || events.length == 0)
        return;
    let columnKeys = input;
    let translation = input;
    if (translationCache[columnKeys]) {
        return translationCache[columnKeys];
    }
    let subKeys = columnKeys.split(":");
    outerLoop: for (let index = 0; index < events.length; ++index) {
        let eventItem = events[index][subKeys[0]];
        for (let subKeyIndex = 0; subKeyIndex < subKeys.length; subKeyIndex++) {
            if (!eventItem)
                continue;
            let subKey = subKeys[subKeyIndex];
            let nextSubKey = subKeys[subKeyIndex + 1];
            if (eventItem && eventItem["_name"]) {
                translation = translation.replace(subKey, eventItem["_name"]);
                // if we've reached the end, break out of both loops
                if (!nextSubKey) {
                    break outerLoop;
                }
                if (Array.isArray(eventItem["_value"])) {
                    ++subKeyIndex;
                    let arrayIndex = nextSubKey;
                    nextSubKey = subKeys[subKeyIndex + 1];
                    if (eventItem["_value"][arrayIndex])
                        eventItem = eventItem["_value"][arrayIndex][nextSubKey];
                    else
                        eventItem = null;
                }
                else if (eventItem["_value"]) {
                    eventItem = eventItem["_value"][nextSubKey];
                }
                else
                    eventItem = eventItem[subKey][nextSubKey];
            }
        }
        ;
    }
    translationCache[columnKeys] = translation.replace(/ /g, '\u00a0');
    return translationCache[columnKeys];
};
exports.default = EventTools;


/***/ }),
/* 45 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
const PluginAttribute_1 = __webpack_require__(21);
exports.PluginAttribute = PluginAttribute_1.PluginAttribute;
const PluginObjectAttribute_1 = __webpack_require__(174);
exports.PluginObjectAttribute = PluginObjectAttribute_1.PluginObjectAttribute;
const PluginObjectArrayAttribute_1 = __webpack_require__(175);
exports.PluginObjectArrayAttribute = PluginObjectArrayAttribute_1.PluginObjectArrayAttribute;
const PluginValueAttribute_1 = __webpack_require__(176);
exports.PluginValueAttribute = PluginValueAttribute_1.PluginValueAttribute;
const PluginValueArrayAttribute_1 = __webpack_require__(177);
exports.PluginValueArrayAttribute = PluginValueArrayAttribute_1.PluginValueArrayAttribute;
const DELIM = '.';
class Plugin {
    constructor(pluginMeta, attributes) {
        this.pluginMeta = pluginMeta;
        this.attributes = attributes;
    }
    get category() {
        return this.pluginMeta.category;
    }
    get type() {
        return this.pluginMeta.type;
    }
    get title() {
        return this.pluginMeta.name;
    }
    get helpToken() {
        return this.pluginMeta.helpToken;
    }
    get uuid() {
        let uuidAttribute = this.attributes.get("uuid");
        return uuidAttribute === undefined ? undefined : uuidAttribute.value;
    }
    set uuid(uuid) {
        let uuidAttribute = this.attributes.get("uuid");
        uuidAttribute.value = uuid;
    }
    get revision() {
        let revisionAttribute = this.attributes.get("revision");
        return revisionAttribute === undefined ? undefined : revisionAttribute.value;
    }
    set revision(revision) {
        let revisionAttribute = this.attributes.get("revision");
        revisionAttribute.value = revision;
    }
    get name() {
        let nameAttribute = this.attributes.get("name");
        return nameAttribute === undefined ? undefined : nameAttribute.value;
    }
    set name(name) {
        let nameAttribute = this.attributes.get("name");
        nameAttribute.value = name;
    }
    get description() {
        let descriptionAttribute = this.attributes.get("desc");
        return descriptionAttribute === undefined ? undefined : descriptionAttribute.value;
    }
    set description(description) {
        let descriptionAttribute = this.attributes.get("desc");
        descriptionAttribute.value = description;
    }
    get enabled() {
        let enabledAttribute = this.attributes.get("enabled");
        return enabledAttribute === undefined ? false : enabledAttribute.value;
    }
    set enabled(enabled) {
        let enabledAttribute = this.attributes.get("enabled");
        enabledAttribute.value = enabled;
    }
    getAttributeValue(path) {
        let pathArr = path.split(".");
        let attributes = this.attributes;
        let attribute = undefined;
        //Iterate over the path finding the attribute being requested.
        for (let attributeName of pathArr) {
            if (attributes === undefined) {
                //The requested path doesn't exist.
                return undefined;
            }
            attribute = attributes.get(attributeName);
            if (attribute instanceof PluginObjectAttribute_1.PluginObjectAttribute) {
                attributes = attribute.attributeMap;
            }
            else {
                attributes = undefined;
            }
        }
        return attribute !== undefined ? attribute.value : undefined;
    }
    /**
     * true if the plugin is valid (IE: invalidAttributes.length === 0)
     */
    get isValid() {
        return this.invalidAttributes.length === 0;
    }
    /**
     * an array of PluginAttribute that do not pass validation rules.
     */
    get invalidAttributes() {
        let invalidAttributes = [];
        for (let attribute of this.attributes.values()) {
            if (attribute.requirement === "system") {
                continue;
            }
            invalidAttributes.push(...attribute.invalidAttributes);
        }
        return invalidAttributes;
    }
    get json() {
        let json = {};
        for (let pluginAttribute of this.attributes.values()) {
            for (let key in pluginAttribute.json) {
                json[key] = pluginAttribute.json[key];
            }
        }
        return json;
    }
    apply(pluginJson) {
        for (let attributeName in pluginJson) {
            let pluginAttributeJson = pluginJson[attributeName];
            let attribute = this.attributes.get(attributeName);
            if (attribute === undefined) {
                if (this.pluginMeta.metaAttributes[attributeName] === undefined) {
                    continue;
                }
                attribute = this.pluginMeta.metaAttributes[attributeName].newPluginAttribute();
                this.attributes.set(attributeName, attribute);
            }
            attribute.apply(pluginAttributeJson);
        }
    }
}
exports.Plugin = Plugin;


/***/ }),
/* 46 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//eventqueries-module.js
const angular = __webpack_require__(3);
const ngCookies = __webpack_require__(43);
const EventQueryService_1 = __webpack_require__(192);
const EventQueriesComponent_1 = __webpack_require__(193);
const QueryComponent_1 = __webpack_require__(195);
exports.default = angular.module('ev.eventqueries', [
    ngCookies
])
    .component('eventQueries', new EventQueriesComponent_1.default())
    .directive('queryComponent', function (reactDirective, $translate) {
    return reactDirective(QueryComponent_1.QueryComponent, undefined, {}, { $translate: $translate });
})
    .factory('eventQueryService', EventQueryService_1.default)
    .name;


/***/ }),
/* 47 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//QueryUrl.ts
const moment = __webpack_require__(6);
const SimpleEventFilter_1 = __webpack_require__(15);
const RawEventFilter_1 = __webpack_require__(20);
//Default values for query parameters. These values change as user
//makes selections which allows the parameters to be carried throughout
//the UI.
let timeSpanValue = 1440;
let timeSpanOf;
let timeSpanStart;
let timeSpanEnd;
let timeSpanType = "recent";
let archives = ["system"];
let field = "type_id";
let limit = 10;
let queryString;
//Returns the query object given parameters in the state.
let loadQuery = function ($stateParams, $state) {
    let query = {
        query: new SimpleEventFilter_1.default()
    };
    if ($stateParams["ts.value"]) {
        timeSpanValue = $stateParams["ts.value"];
    }
    if ($stateParams["ts.type"]) {
        timeSpanType = $stateParams["ts.type"];
    }
    if ($stateParams["ts.of"]) {
        timeSpanOf = $stateParams["ts.of"];
    }
    if ($stateParams["ts.start"]) {
        timeSpanStart = $stateParams["ts.start"];
    }
    if ($stateParams["ts.end"]) {
        timeSpanEnd = $stateParams["ts.end"];
    }
    if ($stateParams["archive"]) {
        archives = $stateParams["archive"];
    }
    if ($stateParams["field"]) {
        field = $stateParams["field"];
    }
    if ($stateParams["limit"]) {
        limit = $stateParams["limit"];
    }
    queryString = $stateParams["querystring"];
    switch (timeSpanType) {
        case "recent":
        case "relative":
            query.timeSpan = {};
            query.timeSpan[timeSpanType] = timeSpanValue;
            break;
        case "within":
            query.timeSpan = {
                of: moment(timeSpanOf)
            };
            query.timeSpan[timeSpanType] = timeSpanValue;
            break;
        case "absolute":
            query.timeSpan = {
                startDate: moment(timeSpanStart),
                endDate: moment(timeSpanEnd)
            };
            break;
    }
    query.archives = archives;
    if (queryString) {
        try {
            query.query = SimpleEventFilter_1.default.fromJson(JSON.parse(queryString));
        }
        catch (syntaxError) {
            query.query = new RawEventFilter_1.default(queryString);
        }
    }
    else {
        query.query = new SimpleEventFilter_1.default();
    }
    query.limit = limit;
    query.field = field;
    const params = {
        "ts.value": timeSpanValue,
        "ts.type": timeSpanType,
        "ts.of": timeSpanOf,
        "ts.start": timeSpanStart,
        "ts.end": timeSpanEnd,
        "archive": archives,
        "field": field,
        "limit": limit,
        "querystring": queryString
    };
    //Update the query string to match incoming parameters in case
    //defaults were applied.
    $state.go($state.current.name, params, { notify: false });
    return query;
};
exports.loadQuery = loadQuery;
let updateTimeSpan = function (timeSpan, $state) {
    let timeSpanParams = {
        "ts.value": null,
        "ts.of": null,
        "ts.start": null,
        "ts.end": null
    };
    if (timeSpan.recent) {
        timeSpanParams["ts.type"] = "recent";
        timeSpanType = "recent";
        timeSpanParams["ts.value"] = timeSpan.recent;
        timeSpanValue = timeSpan.recent;
    }
    else if (timeSpan.relative) {
        timeSpanParams["ts.type"] = "relative";
        timeSpanType = "relative";
        timeSpanParams["ts.value"] = timeSpan.relative;
        timeSpanValue = timeSpan.relative;
    }
    else if (timeSpan.within) {
        timeSpanParams["ts.type"] = "within";
        timeSpanType = "within";
        timeSpanParams["ts.value"] = timeSpan.within;
        timeSpanValue = timeSpan.within;
        timeSpanParams["ts.of"] = timeSpan.of.toISOString();
        timeSpanOf = timeSpan.of;
    }
    else {
        timeSpanParams["ts.type"] = "absolute";
        timeSpanType = "absolute";
        timeSpanParams["ts.start"] = timeSpan.startDate.toISOString();
        timeSpanStart = timeSpan.startDate.toISOString();
        timeSpanParams["ts.end"] = timeSpan.endDate.toISOString();
        timeSpanEnd = timeSpan.endDate.toISOString();
    }
    $state.go($state.current.name, timeSpanParams, { notify: false });
};
exports.updateTimeSpan = updateTimeSpan;
let updateArchives = function (archiveList, $state) {
    archives = archiveList;
    $state.current.params.value = { archives };
    $state.go($state.current.name, { archive: archives }, { notify: false });
};
exports.updateArchives = updateArchives;
let updateQueryString = function (aQueryString, $state) {
    queryString = aQueryString;
    $state.go($state.current.name, { querystring: queryString }, { notify: false });
};
exports.updateQueryString = updateQueryString;
let updateLimit = function (aLimit, $state) {
    limit = aLimit;
    $state.go($state.current.name, { limit: limit }, { notify: false });
};
exports.updateLimit = updateLimit;
let updateField = function (aField, $state) {
    field = aField;
    $state.go($state.current.name, { field: field }, { notify: false });
};
exports.updateField = updateField;


/***/ }),
/* 48 */,
/* 49 */,
/* 50 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//GlobalActions.tsx
const React = __webpack_require__(5);
const PropTypes = __webpack_require__(13);
const styled_components_1 = __webpack_require__(17);
const react_ux_toolkit_1 = __webpack_require__(7);
const Container = styled_components_1.default.div `
    padding: 8px 10px;
    cursor: pointer;
`;
const Text = styled_components_1.default.span `
    font-size: 14px;
    padding-right: 10px;
`;
const Chevron = styled_components_1.default.span `
    display: inline-block;
    background-position: -486px -574px;
    width: 13px;
    height: 8px;
    background-image: url(/resources/toolkit/img/scsem-icons-sprite-02.png);
    background-repeat: no-repeat;
    background-size: auto;
`;
class GlobalActions extends React.Component {
    constructor(props) {
        super(props);
    }
    render() {
        let $translate = this.props.$translate;
        let authenticated = this.props.user !== undefined && this.props.user !== null;
        return (React.createElement("div", null,
            React.createElement(react_ux_toolkit_1.DropDown, null,
                React.createElement(Container, { id: "content" },
                    React.createElement(Text, null, authenticated ? this.props.user : "Guest"),
                    React.createElement(Chevron, null)),
                React.createElement(react_ux_toolkit_1.MenuContent, { id: "menu" },
                    React.createElement("div", null,
                        React.createElement(react_ux_toolkit_1.MenuItem, { onClick: ($event) => this.props.help() }, $translate.instant("nav.help")),
                        React.createElement(react_ux_toolkit_1.MenuItem, { onClick: ($event) => this.props.about($event) }, $translate.instant("nav.about")),
                        !authenticated &&
                            React.createElement(react_ux_toolkit_1.MenuItem, { onClick: ($event) => this.props.signin() }, $translate.instant("nav.login")),
                        authenticated &&
                            React.createElement(react_ux_toolkit_1.MenuItem, { onClick: ($event) => this.props.signout() }, $translate.instant("nav.logout")))))));
    }
}
exports.GlobalActions = GlobalActions;
GlobalActions.propTypes = {
    user: PropTypes.string,
    help: PropTypes.func.isRequired,
    about: PropTypes.func.isRequired,
    signin: PropTypes.func.isRequired,
    signout: PropTypes.func.isRequired
};


/***/ }),
/* 51 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//HomeModule.ts
const angular = __webpack_require__(3);
const ngTranslate = __webpack_require__(10);
const ngMaterial = __webpack_require__(11);
const auth_1 = __webpack_require__(27);
const HelpModule_1 = __webpack_require__(24);
const HomeController_1 = __webpack_require__(118);
const StatsService_1 = __webpack_require__(121);
//Bundling the HTML files defined in the routes
var homeTemplate = __webpack_require__(122);
exports.default = angular.module('icdx.home', [
    auth_1.default,
    ngTranslate,
    "ui.router",
    ngMaterial,
    'tc.chartjs',
    HelpModule_1.default
])
    .factory('statsService', StatsService_1.default)
    .config(function ($stateProvider) {
    $stateProvider.state('home', {
        data: {
            authRequired: true
        },
        url: '/home',
        template: homeTemplate
    });
})
    .controller('HomeController', HomeController_1.default)
    .constant('statsServicePath', '/dx/stats/manage')
    .name;


/***/ }),
/* 52 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//EventSearchModule.ts
const angular = __webpack_require__(3);
const ngTranslate = __webpack_require__(10);
const schema_browser_1 = __webpack_require__(12);
const react_ux_toolkit_1 = __webpack_require__(7);
const auth_1 = __webpack_require__(27);
const TimeSpanModule_1 = __webpack_require__(123);
const EventsModule_1 = __webpack_require__(19);
const EventListModule_1 = __webpack_require__(30);
const EventQueryModule_1 = __webpack_require__(147);
const EventQueriesModule_1 = __webpack_require__(46);
const EventArchiveModule_1 = __webpack_require__(31);
const widgets_module_1 = __webpack_require__(22);
const HelpModule_1 = __webpack_require__(24);
const EventCountsComponent_1 = __webpack_require__(196);
const EventSearchController_1 = __webpack_require__(199);
//Bundling the HTML files defined in the routes
var eventSearchTemplate = __webpack_require__(202);
exports.default = angular.module('ev.eventsearch', [
    auth_1.default,
    TimeSpanModule_1.default,
    EventListModule_1.default,
    EventsModule_1.default,
    EventQueryModule_1.default.name,
    EventQueriesModule_1.default,
    EventArchiveModule_1.default,
    schema_browser_1.eventSchemaService.name,
    widgets_module_1.default.name,
    HelpModule_1.default,
    react_ux_toolkit_1.default,
    ngTranslate,
    'ui.router',
    'tc.chartjs'
]).config(function ($stateProvider) {
    $stateProvider.state('eventsearch', {
        data: {
            authRequired: true
        },
        url: '/eventsearch?ts.type&ts.value&ts.start&ts.end&ts.of&archive&querystring',
        template: eventSearchTemplate,
        resolve: {
            schema: function (eventSchemaService) {
                return eventSchemaService.getSchema();
            },
            translations: function ($translate) {
                return $translate.onReady();
            }
        },
        params: {
            "ts.type": {
                type: "string",
                dynamic: true
            },
            "ts.value": {
                type: "int",
                dynamic: true
            },
            "ts.of": {
                type: "string",
                dynamic: true
            },
            "ts.start": {
                type: "string",
                dynamic: true
            },
            "ts.end": {
                type: "string",
                dynamic: true
            },
            archive: {
                type: "string",
                array: true,
                dynamic: true
            },
            querystring: {
                type: "string",
                dynamic: true
            },
            query: {
                type: "any"
            }
        },
        controller: EventSearchController_1.default,
        controllerAs: '$ctrl'
    });
})
    .component('symEventCounts', new EventCountsComponent_1.default()).name;


/***/ }),
/* 53 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//OpenC2Module.ts
const angular = __webpack_require__(3);
const ngTranslate = __webpack_require__(10);
const ngMaterial = __webpack_require__(11);
const ActionApiKeysComponent_1 = __webpack_require__(149);
const OpenC2Service_1 = __webpack_require__(153);
var openC2Template = __webpack_require__(154);
exports.default = angular.module("cdx.openc2", [
    ngMaterial,
    ngTranslate
])
    .factory('openC2Service', OpenC2Service_1.default)
    .component('actionApiKeys', new ActionApiKeysComponent_1.default())
    .name;


/***/ }),
/* 54 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//EventFilterModule.ts
const angular = __webpack_require__(3);
const ngTranslate = __webpack_require__(10);
const ngMaterial = __webpack_require__(11);
__webpack_require__(155);
const react_ux_toolkit_1 = __webpack_require__(7);
const EventsModule_1 = __webpack_require__(19);
const EventFilterComponent_1 = __webpack_require__(160);
exports.default = angular.module('icdx.eventfilter', [
    ngMaterial,
    react_ux_toolkit_1.default,
    ngTranslate,
    EventsModule_1.default,
    "angular-uuid"
])
    .component('eventFilter', new EventFilterComponent_1.default())
    .name;


/***/ }),
/* 55 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//ErrorModule.js
const angular = __webpack_require__(3);
const ErrorService_1 = __webpack_require__(167);
exports.default = angular.module("icdx.errors", [])
    .factory('errorService', ErrorService_1.default).name;


/***/ }),
/* 56 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//ApiKeyOptions.tsx
const React = __webpack_require__(5);
const PropTypes = __webpack_require__(13);
const styled_components_1 = __webpack_require__(17);
const react_ux_toolkit_1 = __webpack_require__(7);
const Container = styled_components_1.default.div `
    padding: 8px 10px;
    cursor: pointer;
`;
const OptionsText = styled_components_1.default.span `
    color: rgb(0, 118, 163);
    font-size: 14px;
    padding-right: 10px;
`;
const BlueChevron = styled_components_1.default.span `
    display: inline-block;
    background-position: -486px -574px;
    width: 13px;
    height: 8px;
    background-image: url(/resources/toolkit/img/scsem-icons-sprite-02.png);
    background-repeat: no-repeat;
    background-size: auto;
`;
//Hidden element used to copy text to clipboard
const CopyInput = styled_components_1.default.input `
    display: none;
`;
class ApiKeyOptions extends React.Component {
    constructor(props) {
        super(props);
    }
    copyToClipboard(text) {
        var tempInput = document.createElement("input");
        tempInput.setAttribute("style", "position: absolute; left: -1000px; top: -1000px");
        tempInput.value = text;
        document.body.appendChild(tempInput);
        tempInput.select();
        document.execCommand("copy");
        document.body.removeChild(tempInput);
    }
    render() {
        let translationKey = this.props.translationKey;
        if (translationKey === undefined) {
            translationKey = "apikeys";
        }
        let $translate = this.props.$translate;
        return (React.createElement("div", null,
            React.createElement(react_ux_toolkit_1.DropDown, null,
                React.createElement(Container, { id: "content" },
                    React.createElement(OptionsText, null, $translate.instant("settings." + translationKey + ".options.title")),
                    React.createElement(BlueChevron, null)),
                React.createElement(react_ux_toolkit_1.MenuContent, { id: "menu" },
                    React.createElement(react_ux_toolkit_1.MenuItem, { onClick: ($event) => this.props.rename(this.props.apiKey, $event) }, $translate.instant("settings." + translationKey + ".options.rename")),
                    React.createElement(react_ux_toolkit_1.MenuItem, { onClick: ($event) => this.copyToClipboard(this.props.apiKey.key) }, $translate.instant("settings." + translationKey + ".options.copy")),
                    React.createElement(react_ux_toolkit_1.MenuItem, { onClick: ($event) => this.copyToClipboard(this.props.apiKey.clientId) }, $translate.instant("settings." + translationKey + ".options.copyClientId")),
                    React.createElement(react_ux_toolkit_1.MenuItem, { onClick: ($event) => this.copyToClipboard(this.props.apiKey.clientSecret) }, $translate.instant("settings." + translationKey + ".options.copyClientSecret")),
                    React.createElement(react_ux_toolkit_1.MenuItem, { onClick: ($event) => this.props.delete(this.props.apiKey, $event) }, $translate.instant("settings." + translationKey + ".options.delete"))))));
    }
}
exports.ApiKeyOptions = ApiKeyOptions;
ApiKeyOptions.propTypes = {
    apiKey: PropTypes.object.isRequired,
    rename: PropTypes.func.isRequired,
    delete: PropTypes.func.isRequired,
    translationKey: PropTypes.string
};


/***/ }),
/* 57 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//PluginActions.tsx
const React = __webpack_require__(5);
const PropTypes = __webpack_require__(13);
const styled_components_1 = __webpack_require__(17);
const react_ux_toolkit_1 = __webpack_require__(7);
const Container = styled_components_1.default.div `
    padding: 8px 10px;
    cursor: pointer;
`;
const OptionsText = styled_components_1.default.span `
    color: rgb(0, 118, 163);
    font-size: 14px;
    padding-right: 10px;
`;
const BlueChevron = styled_components_1.default.span `
    display: inline-block;
    background-position: -486px -574px;
    width: 13px;
    height: 8px;
    background-image: url(/resources/toolkit/img/scsem-icons-sprite-02.png);
    background-repeat: no-repeat;
    background-size: auto;
`;
class PluginActions extends React.Component {
    constructor(props) {
        super(props);
    }
    startPlugin($event) {
        this.props.startPlugin(this.props.plugin, $event);
    }
    stopPlugin($event) {
        this.props.stopPlugin(this.props.plugin, $event);
    }
    restartPlugin($event) {
        this.props.stopPlugin(this.props.plugin, $event);
    }
    render() {
        let $translate = this.props.$translate;
        return (React.createElement("div", null,
            React.createElement(react_ux_toolkit_1.DropDown, null,
                React.createElement(Container, { id: "content" },
                    React.createElement(OptionsText, null, $translate.instant("settings.actions.title")),
                    React.createElement(BlueChevron, null)),
                React.createElement(react_ux_toolkit_1.MenuContent, { id: "menu" },
                    this.props.process === undefined &&
                        React.createElement(react_ux_toolkit_1.MenuItem, { onClick: ($event) => this.props.start(this.props.plugin, $event) }, $translate.instant("settings.actions.start")),
                    this.props.process !== undefined && this.props.process.status_id === 2 &&
                        React.createElement("div", null,
                            React.createElement(react_ux_toolkit_1.MenuItem, { onClick: ($event) => this.props.stop(this.props.plugin, $event) }, $translate.instant("settings.actions.stop")),
                            React.createElement(react_ux_toolkit_1.MenuItem, { onClick: ($event) => this.props.restart(this.props.plugin, $event) }, $translate.instant("settings.actions.restart"))),
                    React.createElement(react_ux_toolkit_1.MenuItem, { onClick: ($event) => this.props.edit(this.props.plugin, $event) }, $translate.instant("settings.actions.edit")),
                    React.createElement(react_ux_toolkit_1.MenuItem, { onClick: ($event) => this.props.copy(this.props.plugin, $event) }, $translate.instant("settings.actions.copy")),
                    this.props.process === undefined &&
                        React.createElement(react_ux_toolkit_1.MenuItem, { onClick: ($event) => this.props.delete(this.props.plugin, $event) }, $translate.instant("settings.actions.delete")),
                    React.createElement(react_ux_toolkit_1.MenuItem, { onClick: ($event) => this.props.viewlogs(this.props.plugin, $event) }, $translate.instant("settings.actions.viewlogs"))))));
    }
}
exports.PluginActions = PluginActions;
PluginActions.propTypes = {
    rerender: PropTypes.number.isRequired,
    plugin: PropTypes.object.isRequired,
    process: PropTypes.object,
    edit: PropTypes.func.isRequired,
    copy: PropTypes.func.isRequired,
    start: PropTypes.func.isRequired,
    stop: PropTypes.func.isRequired,
    restart: PropTypes.func.isRequired,
    delete: PropTypes.func.isRequired,
    viewlogs: PropTypes.func.isRequired
};


/***/ }),
/* 58 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//PasteFilter.tsx
const React = __webpack_require__(5);
const PropTypes = __webpack_require__(13);
const react_ux_toolkit_1 = __webpack_require__(7);
const GlobalIcons_1 = __webpack_require__(18);
class PasteFilter extends React.Component {
    constructor(props) {
        super(props);
    }
    render() {
        let $translate = this.props.$translate;
        var queries = [];
        if (this.props.queries !== undefined) {
            for (let queryId in this.props.queries) {
                let query = this.props.queries[queryId];
                queries.push(React.createElement(react_ux_toolkit_1.MenuItem, { onClick: ($event) => this.props.applyFilter(query.query) },
                    React.createElement("span", null, query.name)));
            }
        }
        if (queries.length === 0) {
            queries.push(React.createElement(react_ux_toolkit_1.MenuItem, null,
                React.createElement("span", null, "No Saved Queries")));
        }
        return (React.createElement("div", null,
            React.createElement(react_ux_toolkit_1.DropDown, null,
                React.createElement("div", { id: "content" },
                    React.createElement(react_ux_toolkit_1.IconButton, { icon: GlobalIcons_1.PasteFilterIcon, tooltip: $translate.instant("settings.paste_filter_from_query") })),
                React.createElement(react_ux_toolkit_1.MenuContent, { id: "menu" }, queries))));
    }
}
exports.PasteFilter = PasteFilter;
PasteFilter.propTypes = {
    queries: PropTypes.object,
    applyFilter: PropTypes.func.isRequired
};


/***/ }),
/* 59 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
const PluginMeta_1 = __webpack_require__(173);
class SettingsService {
    constructor($http, $q, baseUrl) {
        this.$http = $http;
        this.$q = $q;
        this.baseUrl = baseUrl;
        this.repoServicePath = baseUrl + "/dx/repo/manage";
        this.launcherServicePath = baseUrl + "/dx/launcher/manage";
    }
    getPluginMetas(category) {
        let defer = this.$q.defer();
        let self = this;
        let payload = { id: 1, path: category };
        this.$http({
            method: 'POST',
            url: this.repoServicePath,
            headers: { 'Content-Type': 'application/json' },
            data: JSON.stringify(payload)
        }).then(function (response) {
            let pluginMetas = {};
            /**
             * Removes from the array any PluginMeta that is a parent of the given type.
             *
             * #return true if there are no children for the given type.
             */
            function prune(type) {
                for (let pluginMetaType in pluginMetas) {
                    //type is a parent of an existing PluginMeta
                    if (pluginMetaType.startsWith(type)) {
                        return false;
                    }
                    //Type is a child of an existing PluginMeta, remove the parent.
                    if (type.startsWith(pluginMetaType)) {
                        delete pluginMetas[pluginMetaType];
                    }
                }
                return true;
            }
            for (let i in response.data.list) {
                let pluginMeta = response.data.list[i];
                let type = response.data.list[i].path;
                if (type === undefined) {
                    continue;
                }
                pluginMeta.category = category;
                pluginMeta.type = type;
                //Convert from JSON object to TypeScript object
                if (prune(type)) {
                    pluginMetas[type] = new PluginMeta_1.PluginMeta(pluginMeta);
                }
            }
            defer.resolve(pluginMetas);
        }, function (errorResponse) {
            defer.reject(errorResponse);
        });
        return defer.promise;
    }
    getPlugins(category) {
        let defer = this.$q.defer();
        let self = this;
        let payload = { id: 2, path: category };
        this.$http({
            method: 'POST',
            url: this.repoServicePath,
            headers: { 'Content-Type': 'application/json' },
            data: JSON.stringify(payload)
        }).then(function (response) {
            let plugins = response.data.list;
            self.getPluginMetas(category).then(function (pluginMetas) {
                let pluginConfigs = [];
                for (let i in plugins) {
                    plugins[i].category = category;
                    plugins[i].type = plugins[i].path;
                    pluginConfigs.push(pluginMetas[plugins[i].type].newPlugin(plugins[i]));
                }
                defer.resolve(pluginConfigs);
            });
        }, function (errorResponse) {
            defer.reject(errorResponse);
        });
        return defer.promise;
    }
    getPlugin(category, type, uuid) {
        let defer = this.$q.defer();
        let self = this;
        let payload = { id: 4, path: type, uuid: uuid };
        this.$http({
            method: 'POST',
            url: this.repoServicePath,
            headers: { 'Content-Type': 'application/json' },
            data: JSON.stringify(payload)
        }).then(function (response) {
            self.getPluginMetas(category).then(function (pluginMetas) {
                let type = response.data.path;
                defer.resolve(pluginMetas[type].newPlugin(response.data));
            });
        }, function (errorResponse) {
            defer.reject(errorResponse);
        });
        return defer.promise;
    }
    savePlugin(plugin, restart = false) {
        let self = this;
        let defer = this.$q.defer();
        let id = 5;
        if (plugin.uuid === undefined) {
            id = 3;
        }
        let payload = { id: id, path: this.getPath(plugin), revision: plugin.revision };
        Object.assign(payload, plugin.json);
        this.$http({
            method: 'POST',
            url: this.repoServicePath,
            headers: { 'Content-Type': 'application/json' },
            data: JSON.stringify(payload)
        }).then(function (response) {
            plugin.uuid = response.data.uuid;
            plugin.revision = response.data.revision;
            if (restart) {
                self.restartPlugin(plugin).then(function (restartResponse) {
                    defer.resolve(plugin);
                }, function (restartErrorResponse) {
                    defer.reject(restartErrorResponse.data);
                });
            }
            else {
                defer.resolve(plugin);
            }
        }, function (errorResponse) {
            if (errorResponse.status === 409) {
                let message = errorResponse.data.message;
                let currentVersion = parseInt(message.slice(84));
                plugin.revision = currentVersion.toString();
                //Save the plugin again with the updated revision.
                self.savePlugin(plugin).then(function (plugin) {
                    defer.resolve(plugin);
                }, function (errorResponse) {
                    defer.reject(self.getErrorDetails(errorResponse));
                });
            }
            else {
                defer.reject(self.getErrorDetails(errorResponse));
            }
        });
        return defer.promise;
    }
    deletePlugin(plugin) {
        let defer = this.$q.defer();
        let payload = { id: 6, path: this.getPath(plugin), uuid: plugin.uuid, revision: plugin.revision };
        this.$http({
            method: 'POST',
            url: this.repoServicePath,
            headers: { 'Content-Type': 'application/json' },
            data: JSON.stringify(payload)
        }).then(function (response) {
            defer.resolve(response.data);
        }, function (errorResponse) {
            defer.reject(errorResponse);
        });
        return defer.promise;
    }
    startPlugin(plugin) {
        let defer = this.$q.defer();
        let payload = { id: 10, path: this.getPath(plugin), uuid: plugin.uuid };
        this.$http({
            method: 'POST',
            url: this.launcherServicePath,
            headers: { 'Content-Type': 'application/json' },
            data: JSON.stringify(payload)
        }).then(function (response) {
            defer.resolve();
        }, function (errorResponse) {
            defer.reject(errorResponse);
        });
        return defer.promise;
    }
    restartPlugin(plugin) {
        let defer = this.$q.defer();
        let payload = { id: 11, path: this.getPath(plugin), uuid: plugin.uuid };
        this.$http({
            method: 'POST',
            url: this.launcherServicePath,
            headers: { 'Content-Type': 'application/json' },
            data: JSON.stringify(payload)
        }).then(function (response) {
            defer.resolve();
        }, function (errorResponse) {
            defer.reject(errorResponse);
        });
        return defer.promise;
    }
    stopPlugin(plugin) {
        let defer = this.$q.defer();
        let payload = { id: 12, path: this.getPath(plugin), uuid: plugin.uuid };
        this.$http({
            method: 'POST',
            url: this.launcherServicePath,
            headers: { 'Content-Type': 'application/json' },
            data: JSON.stringify(payload)
        }).then(function (response) {
            defer.resolve();
        }, function (errorResponse) {
            defer.reject(errorResponse);
        });
        return defer.promise;
    }
    getRunningProcesses() {
        let defer = this.$q.defer();
        this.$http({
            method: 'POST',
            url: this.launcherServicePath,
            headers: { 'Content-Type': 'application/json' },
            data: JSON.stringify({ id: 2 })
        }).then(function (response) {
            defer.resolve(response.data);
        }, function (errorResponse) {
            defer.reject();
        });
        return defer.promise;
    }
    getStatus(category) {
        let defer = this.$q.defer();
        this.$http({
            method: 'POST',
            url: this.launcherServicePath,
            headers: { 'Content-Type': 'application/json', 'X-Daemon': true },
            data: JSON.stringify({ id: 4, path: category })
        }).then(function (response) {
            defer.resolve(response.data);
        }, function (errorResponse) {
            defer.reject();
        });
        return defer.promise;
    }
    getType(path) {
        return path.split('/').splice(1).join('/');
    }
    getPath(plugin) {
        return plugin.pluginMeta.type;
    }
    getErrorDetails(response) {
        let errorDetails = {
            httpStatus: response.status
        };
        if (response.data.message) {
            errorDetails.message = response.data.message;
        }
        return errorDetails;
    }
}
exports.default = SettingsService;
SettingsService.$inject = ['$http', '$q', 'baseUrl'];


/***/ }),
/* 60 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

//ApiKeysService.ts
Object.defineProperty(exports, "__esModule", { value: true });
class ApiKey {
    constructor(client) {
        this.client = client;
        this.privs = this.client.client_credentials_privs.split(" ").filter((priv) => priv !== "openc2:none");
        //Remove fields that shouldn't be returned to the identity service.
        delete client.client_secret_expires_at;
        delete client.client_id_issued_at;
    }
    get name() {
        return this.client.client_name;
    }
    set name(name) {
        this.client.client_name = name;
    }
    get clientId() {
        return this.client.client_id;
    }
    get clientSecret() {
        return this.client.client_secret;
    }
    get key() {
        return btoa(this.clientId + ":" + this.clientSecret);
    }
    //Call this to update priviledges that get sent to the identity service.
    updatePrivs() {
        if (this.privs.length > 0) {
            this.client.client_credentials_privs = this.privs.join(" ");
        }
        else {
            //TODO: When ID service is fixed, we should make this the empty string.
            this.client.client_credentials_privs = "openc2:none";
        }
    }
}
exports.ApiKey = ApiKey;
class ApiKeysService {
    constructor($http, $q, baseUrl) {
        this.$http = $http;
        this.$q = $q;
        this.baseUrl = baseUrl;
    }
    getApiKeys(type = "apikey") {
        let defer = this.$q.defer();
        this.$http({
            method: 'GET',
            url: this.baseUrl + "/oauth2/clients",
            headers: { 'Content-Type': 'application/json' }
        }).then(function (response) {
            let apiKeys = [];
            for (let apiKey of response.data) {
                if (apiKey.client_type === type && apiKey.client_credentials_privs !== undefined) {
                    apiKeys.push(new ApiKey(apiKey));
                }
            }
            defer.resolve(apiKeys);
        }, function (error) {
            defer.reject(error);
        });
        return defer.promise;
    }
    addApiKey(name, type = "apikey", privs = ["view_events"]) {
        let defer = this.$q.defer();
        let payload = {
            client_name: name,
            client_type: type,
            client_credentials_privs: privs.join(" "),
            token_endpoint_auth_method: "client_secret_basic",
            grant_types: ["client_credentials"],
            scope: "apikey"
        };
        this.$http({
            method: 'POST',
            url: this.baseUrl + "/oauth2/clients",
            headers: { 'Content-Type': 'application/json' },
            data: JSON.stringify(payload)
        }).then(function (response) {
            defer.resolve(new ApiKey(response.data));
        }, function (error) {
            defer.reject(error);
        });
        return defer.promise;
    }
    updateApiKey(apiKey) {
        let defer = this.$q.defer();
        apiKey.updatePrivs();
        this.$http({
            method: 'put',
            url: this.baseUrl + "/oauth2/clients/" + apiKey.clientId,
            headers: { 'Content-Type': 'application/json' },
            data: JSON.stringify(apiKey.client)
        }).then(function (response) {
            defer.resolve();
        }, function (error) {
            defer.reject(error);
        });
        return defer.promise;
    }
    deleteApiKey(apiKey) {
        let defer = this.$q.defer();
        this.$http({
            method: 'DELETE',
            url: this.baseUrl + "/oauth2/clients/" + apiKey.clientId
        }).then(function (response) {
            defer.resolve();
        }, function (error) {
            defer.reject(error);
        });
        return defer.promise;
    }
}
exports.default = ApiKeysService;
ApiKeysService.$inject = ['$http', '$q', 'baseUrl'];


/***/ }),
/* 61 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//PluginConfigListController.ts
const angular = __webpack_require__(3);
const moment = __webpack_require__(6);
__webpack_require__(178);
const react_ux_toolkit_1 = __webpack_require__(7);
let pluginDialogTemplate = __webpack_require__(180);
class SettingsController {
    constructor($rootScope, $scope, $stateParams, $mdDialog, $translate, $timeout, $interval, $state, settingsService, eventSchemaService, errorService, helpService, authService) {
        this.$rootScope = $rootScope;
        this.$scope = $scope;
        this.$stateParams = $stateParams;
        this.$mdDialog = $mdDialog;
        this.$translate = $translate;
        this.$timeout = $timeout;
        this.$interval = $interval;
        this.$state = $state;
        this.settingsService = settingsService;
        this.eventSchemaService = eventSchemaService;
        this.errorService = errorService;
        this.helpService = helpService;
        this.authService = authService;
        this.settings = {};
        this.processes = {};
        this.sortColumn = "name";
        this.status = "init";
        $scope.helpIcon = helpService.icon;
        this.edit = this.edit.bind(this);
        this.copy = this.copy.bind(this);
        this.start = this.start.bind(this);
        this.stop = this.stop.bind(this);
        this.restart = this.restart.bind(this);
        this.delete = this.delete.bind(this);
        this.viewlogs = this.viewlogs.bind(this);
        this.showHelp = this.showHelp.bind(this);
    }
    $onInit() {
        let self = this;
        this.category = this.$stateParams.category;
        this.type = this.$stateParams.type;
        this.$rootScope.section = this.type;
        this.settingsService.getPluginMetas(this.category).then(function (pluginMetas) {
            self.status = "loading";
            self.pluginMetas = pluginMetas;
            //Create buckets for all the types
            for (let i in pluginMetas) {
                let pluginMeta = pluginMetas[i];
                if (self.settings[pluginMeta.type] === undefined) {
                    self.settings[pluginMeta.type] = [];
                }
            }
            //Get the settings after the metadata is loaded.
            self.settingsService.getPlugins(self.category).then(function (plugins) {
                for (let i in plugins) {
                    let plugin = plugins[i];
                    let rootType = plugin.type.split('/')[0];
                    if (self.settings[plugin.type] === undefined) {
                        self.settings[plugin.type] = [];
                    }
                    self.settings[plugin.type].push(plugin);
                    //Hack: forces components to rerender by incrementing
                    plugin.rerender = 0;
                }
                self.updateRunningProcesses();
                self.status = "done";
            }, function () {
                self.status = "error";
            });
        }, function () {
            self.status = "error";
        });
        self.statusPromise = self.$interval(function () {
            if (self.authService.isAuthenticated()) {
                self.updateRunningProcesses();
            }
        }, 5000);
        self.$scope.$on('$destroy', function () {
            if (self.statusPromise) {
                self.$interval.cancel(self.statusPromise);
            }
        });
    }
    updateRunningProcesses() {
        const self = this;
        self.settingsService.getStatus(this.category).then(function (data) {
            self.processes = [];
            for (let process of data) {
                self.processes[process.uuid] = process;
            }
            for (let type in self.settings) {
                for (let setting of self.settings[type]) {
                    let process = self.processes[setting.uuid];
                    if (process !== undefined) {
                        setting.status = process.status_id;
                        if (setting.status === 2) {
                            setting.uptime = moment(process.started);
                            setting.uptimeTranslated = setting.uptime.from(moment(), true);
                        }
                    }
                    else {
                        setting.status = 4;
                        setting.uptime = undefined;
                        setting.uptimeTranslated = undefined;
                    }
                    setting.startupTranslated = self.$translate.instant('settings.startup.' + (setting.enabled ? "automatic" : 'manual'));
                    setting.statusTranslated = self.$translate.instant('settings.status.' + setting.status, { uptime: setting.uptimeTranslated });
                }
            }
        });
    }
    settingTypes() {
        let self = this;
        //Sort the setting by its type sorted by its translation.
        let settingNames = Object.keys(this.settings).sort((a, b) => {
            const aName = self.pluginMetas[a].name;
            const bName = self.pluginMetas[b].name;
            if (aName < bName) {
                return -1;
            }
            if (aName > bName) {
                return 1;
            }
            return 0;
        });
        return settingNames;
    }
    getSetting(settingName) {
        return this.settings[settingName];
    }
    configChanged(setting, key, newValue) {
        let keys = key.split('.');
        if (keys.length === 2) {
            setting.plugin[keys[0]][keys[1]] = newValue;
            setting.dirty = true;
        }
        else if (setting.plugin[key] !== undefined) {
            setting.plugin[key] = newValue;
            setting.dirty = true;
        }
        else if (setting.plugin.config[key] !== undefined) {
            setting.plugin[key] = newValue;
            setting.dirty = true;
        }
    }
    enabled(setting, newValue) {
        setting.plugin.enabled = newValue;
        setting.dirty = true;
    }
    addPlugin(pluginType, $mdMenu, $event) {
        let pluginMetas = this.getPluginMetasForType(pluginType);
        if (pluginMetas.length > 1) {
            $mdMenu.open();
        }
        else if (pluginMetas.length === 1) {
            this.add(pluginMetas[0], $event);
        }
        else {
            this.add(this.pluginMetas[pluginType], $event);
        }
    }
    add(pluginMeta, $event) {
        let plugin = pluginMeta.newPlugin();
        this.showAddPluginDialog(plugin, $event);
    }
    showAddPluginDialog(plugin, $event) {
        let self = this;
        this.$mdDialog.show({
            controller: PluginDialogController,
            template: pluginDialogTemplate,
            parent: angular.element(document.body),
            targetEvent: $event,
            bindToController: true,
            locals: {
                plugin: plugin,
                dirty: true,
                settingsService: this.settingsService,
                errorService: this.errorService,
                helpService: this.helpService,
                showEnable: true
            },
            clickOutsideToClose: false,
            fullscreen: true,
            onComplete: function () {
                self.$timeout(function () {
                    angular.element("#plugin-name").find(":input").trigger("focus");
                });
            }
        }).then(function (plugin) {
            let rootType = plugin.type.split('/')[0];
            self.settings[plugin.type].push(plugin);
        });
    }
    delete(plugin, $event) {
        let self = this;
        var confirm = react_ux_toolkit_1.UxDialog.convertConfirmToUx(this.$mdDialog.confirm()
            .title(this.$translate.instant("settings.dialog.delete.title", { category: this.category }))
            .textContent(this.$translate.instant("settings.dialog.delete.content", { category: this.category, pluginName: plugin.name }))
            .ok(this.$translate.instant("dialog.yes"))
            .cancel(this.$translate.instant("dialog.no")));
        this.$mdDialog.show(confirm).then(function () {
            self.settingsService.deletePlugin(plugin).then(function () {
                let index = self.settings[plugin.type].indexOf(plugin);
                self.settings[plugin.type].splice(index, 1);
            });
        });
    }
    viewlogs(plugin, $event) {
        let self = this;
        self.$timeout(function () {
            let params = {
                archive: "system",
                querystring: "feature_uid=\"" + plugin.uuid + '"',
                "ts.type": "relative",
                "ts.value": 60
            };
            self.$state.go("eventsearch", params);
        });
    }
    edit(plugin, $event) {
        let self = this;
        let pluginJson = plugin.json;
        this.$mdDialog.show({
            controller: PluginDialogController,
            template: pluginDialogTemplate,
            parent: angular.element(document.body),
            bindToController: true,
            targetEvent: $event,
            locals: {
                plugin: plugin,
                dirty: false,
                settingsService: this.settingsService,
                errorService: this.errorService,
                showEnable: true
            },
            clickOutsideToClose: false,
            fullscreen: true,
            onComplete: function () {
                self.$timeout(function () {
                    angular.element("#plugin-name").find(":input").trigger("focus");
                });
            }
        }).then(function (plugin) {
            if (plugin.status != 1 && plugin.status != 2) {
                return;
            }
            let confirm = react_ux_toolkit_1.UxDialog.convertConfirmToUx(self.$mdDialog.confirm()
                .title(self.$translate.instant("settings.dialog.saverestart.title", { pluginName: plugin.name }))
                .textContent(self.$translate.instant("settings.dialog.saverestart.content", { pluginName: plugin.name }))
                .ok(self.$translate.instant("dialog.yes"))
                .cancel(self.$translate.instant("dialog.no")));
            self.$mdDialog.show(confirm).then(function () {
                self.restart(plugin);
            });
        }, function () {
            plugin.apply(pluginJson);
        });
    }
    copy(plugin, $event) {
        let pluginJson = plugin.json;
        delete pluginJson.modified;
        delete pluginJson.uuid;
        pluginJson.name = this.$translate.instant("settings.actions.copy-name", { name: pluginJson.name }, undefined, false, null);
        let newPlugin = plugin.pluginMeta.newPlugin();
        newPlugin.apply(pluginJson);
        this.showAddPluginDialog(newPlugin, $event);
    }
    start(plugin, $event) {
        const self = this;
        plugin.status = 1;
        self.settingsService.startPlugin(plugin).then(function () {
            self.$timeout(function () {
                self.updateRunningProcesses();
                plugin.rerender++;
            }, 1000);
        });
    }
    stop(plugin, $event) {
        const self = this;
        plugin.status = 3;
        plugin.statusTranslated = self.$translate.instant('settings.status.' + plugin.status);
        plugin.uptime = undefined;
        self.settingsService.stopPlugin(plugin).then(function () {
            self.$timeout(function () {
                self.updateRunningProcesses();
                plugin.rerender++;
            }, 1000);
        });
    }
    restart(plugin, $event = undefined) {
        const self = this;
        plugin.status = 3;
        plugin.uptime = undefined;
        self.settingsService.restartPlugin(plugin).then(function () {
            self.$timeout(function () {
                self.updateRunningProcesses();
                plugin.rerender++;
            }, 1000);
        });
    }
    getPluginMetasForType(pluginType) {
        let pluginMetas = [];
        for (let pluginMetaType in this.pluginMetas) {
            let pluginMeta = this.pluginMetas[pluginMetaType];
            if (this.hasChildren(pluginMeta.type)) {
                continue;
            }
            if (pluginMeta.type.startsWith(pluginType)) {
                pluginMetas.push(pluginMeta);
            }
        }
        return pluginMetas;
    }
    hasChildren(pluginType) {
        for (let pluginMetaType in this.pluginMetas) {
            if (pluginMetaType !== pluginType && pluginMetaType.startsWith(pluginType)) {
                return true;
            }
        }
        return false;
    }
    showHelp() {
        let token;
        switch (this.category) {
            case "collector":
            default:
                token = "ICDX_Configuration_Collectors";
                break;
            case "forwarder":
                token = "ICDX_Configuration_Forwarders";
                break;
            case "adapter":
                token = "ICDX_Configuration_Adapters";
                break;
            case "intelligence":
                token = "ICDX_Configuration_Intelligence";
                break;
            case "other/icdx":
                token = "ICDX_Configuration_ICDx_Chaining";
                break;
        }
        this.helpService.help(token);
    }
}
exports.default = SettingsController;
SettingsController.$inject = ["$rootScope", "$scope", "$stateParams", "$mdDialog", "$translate", "$timeout", "$interval", "$state", "settingsService", "eventSchemaService", "errorService", "helpService", "authService"];
function PluginDialogController($mdDialog, $timeout, errorService, helpService) {
    let self = this;
    this.$scope.dirty = this.dirty;
    this.$scope.plugin = this.plugin;
    this.$scope.typeTranslationKey = "settings." + this.plugin.category + '.types.' + this.plugin.type;
    this.$scope.showAdvanced = false;
    this.$scope.showEnable = this.showEnable;
    this.$scope.cancel = function () {
        if (self.$scope.plugin.uuid === undefined) {
            $mdDialog.cancel();
        }
        else {
            self.settingsService.getPlugin(self.$scope.plugin.category, self.$scope.plugin.type, self.$scope.plugin.uuid).then(function (pluginConfig) {
                self.$scope.plugin.attributes = pluginConfig.attributes;
                self.plugin.dirty = false;
                $mdDialog.cancel();
            });
        }
    };
    this.$scope.save = function () {
        if (!self.$scope.dirty) {
            //No changes to save
            return;
        }
        let invalidAttributes = self.$scope.plugin.invalidAttributes;
        if (invalidAttributes.length === 0) {
            self.settingsService.savePlugin(self.$scope.plugin).then(function (plugin) {
                $mdDialog.hide(plugin);
            }, function (errorDetails) {
                self.errorService.displayError("settings.error.saveconfig.title", "settings.error.saveconfig.description", errorDetails.message);
            });
        }
        else {
            $timeout(function () {
                let focus = true;
                for (let attribute of invalidAttributes) {
                    let input;
                    if (attribute.subType === "filter") {
                        input = angular.element("#plugin-" + attribute.name).find(":input");
                    }
                    else {
                        input = angular.element("#plugin-" + attribute.name).find(":input");
                    }
                    input.trigger("blur");
                    //First invalid attribute should be focused.
                    if (focus) {
                        input.trigger("focus");
                        focus = false;
                    }
                }
            });
        }
    };
    this.$scope.showHelp = function () {
        helpService.help(self.$scope.plugin.helpToken);
    };
}


/***/ }),
/* 62 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//SettingsLandingController.ts
const angular = __webpack_require__(3);
class SettingsLandingController {
    constructor($rootScope, $scope, $stateParams, $timeout, $translate, $mdDialog, settingsService, errorService, helpService) {
        this.$rootScope = $rootScope;
        this.$scope = $scope;
        this.$stateParams = $stateParams;
        this.$timeout = $timeout;
        this.$translate = $translate;
        this.$mdDialog = $mdDialog;
        this.settingsService = settingsService;
        this.errorService = errorService;
        this.helpService = helpService;
        this._dirty = false;
        $rootScope.section = "settings";
        this.showHelp = this.showHelp.bind(this);
    }
    $onInit() {
        let self = this;
        self.category = self.$stateParams.category;
        let pluginPath;
        switch (self.category) {
            case "ldap":
                pluginPath = "other/id_epmp_dx";
                break;
            case "archive":
                pluginPath = "other/logger_dx";
                break;
            case "telemetry":
                pluginPath = "other/stats_dx";
                break;
            default:
                throw new Error("Unknown setting category: " + self.category);
        }
        self.settingsService.getPlugin(pluginPath, pluginPath, "default").then(function (plugin) {
            if (plugin === undefined) {
                self.settingsService.getPluginMetas(pluginPath).then(function (pluginMetas) {
                    self.plugin = pluginMetas[pluginPath].newPlugin();
                });
            }
            else {
                self.plugin = plugin;
            }
        });
    }
    get dirty() {
        return this._dirty;
    }
    set dirty(dirty) {
        this._dirty = dirty;
    }
    save($event) {
        let self = this;
        if (!self.dirty) {
            //Don't need to save
            return;
        }
        let invalidAttributes = self.plugin.invalidAttributes;
        if (invalidAttributes.length === 0) {
            self.settingsService.savePlugin(self.plugin, true).then(function (plugin) {
                self.dirty = false;
                self.$mdDialog.show(self.$mdDialog.alert()
                    .clickOutsideToClose(true)
                    .title(self.$translate.instant("settings." + self.category + ".saved-title"))
                    .textContent(self.$translate.instant("settings." + self.category + ".saved-message"))
                    .ok(self.$translate.instant("dialog.ok"))
                    .targetEvent($event));
            }, function (errorResponse) {
                self.errorService.displayError("settings.error.saveconfig.title", "settings.error.saveconfig.description", errorResponse.message);
            });
        }
        else {
            self.$timeout(function () {
                let focus = true;
                for (let attribute of invalidAttributes) {
                    let input = angular.element("#plugin-" + attribute.name).find(":input");
                    input.trigger("blur");
                    //First invalid attribute should be focused.
                    if (focus) {
                        input.trigger("focus");
                        focus = false;
                    }
                }
            });
        }
    }
    showHelp() {
        let token;
        switch (this.category) {
            case "archive":
            default:
                token = "ICDX_Settings_Event_Archive";
                break;
            case "ldap":
                token = "ICDX_Settings_Active_Directory";
                break;
            case "telemetry":
                token = "ICDX_Settings_Telemetry";
                break;
        }
        this.helpService.help(token);
    }
}
exports.default = SettingsLandingController;
SettingsLandingController.$inject = ["$rootScope", "$scope", "$stateParams", "$timeout", "$translate", "$mdDialog", "settingsService", "errorService", "helpService"];


/***/ }),
/* 63 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
const react_ux_toolkit_1 = __webpack_require__(7);
class ApiKeysController {
    constructor($rootScope, $scope, $mdDialog, $translate, apiKeysService, helpService) {
        this.$rootScope = $rootScope;
        this.$scope = $scope;
        this.$mdDialog = $mdDialog;
        this.$translate = $translate;
        this.apiKeysService = apiKeysService;
        this.helpService = helpService;
        this.apiKeys = [];
        this.sortColumn = "name";
        $rootScope.section = "settings";
        this.renameApiKey = this.renameApiKey.bind(this);
        this.deleteApiKey = this.deleteApiKey.bind(this);
        this.showHelp = this.showHelp.bind(this);
    }
    $onInit() {
        let self = this;
        self.$translate.onReady(function () {
            self.apiKeysService.getApiKeys().then(function (apiKeys) {
                self.apiKeys = apiKeys;
            }, function (error) {
                console.log("Unable to get API keys", error);
            });
        });
    }
    newApiKey($event) {
        let self = this;
        let prompt = react_ux_toolkit_1.UxDialog.convertPromptToUx(self.$mdDialog.prompt()
            .title(this.$translate.instant("settings.apikeys.dialog.add.title"))
            .textContent(this.$translate.instant("settings.apikeys.dialog.add.content"))
            .targetEvent($event)
            .required(true)
            .ok(this.$translate.instant("dialog.save"))
            .cancel(this.$translate.instant("dialog.cancel")));
        self.$mdDialog.show(prompt).then(function (name) {
            self.apiKeysService.addApiKey(name).then(function (apiKey) {
                self.apiKeys.push(apiKey);
            }, function (error) {
                console.log("Unable to create new API key.", error);
            });
        });
    }
    ;
    renameApiKey(apiKey, $event) {
        let self = this;
        let prompt = react_ux_toolkit_1.UxDialog.convertPromptToUx(self.$mdDialog.prompt()
            .title(this.$translate.instant("settings.apikeys.dialog.rename.title"))
            .textContent(this.$translate.instant("settings.apikeys.dialog.rename.content"))
            .targetEvent($event)
            .required(true)
            .ok(this.$translate.instant("dialog.save"))
            .cancel(this.$translate.instant("dialog.cancel")));
        self.$mdDialog.show(prompt).then(function (name) {
            console.log(apiKey, name);
            apiKey.name = name;
            self.apiKeysService.updateApiKey(apiKey);
        });
    }
    deleteApiKey(apiKey, $event) {
        let self = this;
        var confirm = react_ux_toolkit_1.UxDialog.convertConfirmToUx(self.$mdDialog.confirm()
            .title(this.$translate.instant("settings.apikeys.dialog.delete.title"))
            .textContent(this.$translate.instant("settings.apikeys.dialog.delete.content", { apikey: apiKey.name }))
            .targetEvent($event)
            .ok(self.$translate.instant("dialog.yes"))
            .cancel(self.$translate.instant("dialog.no")));
        self.$mdDialog.show(confirm).then(function () {
            self.apiKeysService.deleteApiKey(apiKey).then(function () {
                let index = self.apiKeys.indexOf(apiKey);
                self.apiKeys.splice(index, 1);
            }, function (error) {
                console.log("Unable to delete API key.", error);
            });
        });
    }
    showHelp() {
        this.helpService.help("ICDX_Settings_API_Keys");
    }
}
exports.default = ApiKeysController;
ApiKeysController.$inject = ["$rootScope", "$scope", "$mdDialog", "$translate", "apiKeysService", "helpService"];


/***/ }),
/* 64 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//EventTopnModule.ts
const angular = __webpack_require__(3);
const ngTranslate = __webpack_require__(10);
const schema_browser_1 = __webpack_require__(12);
const EventListModule_1 = __webpack_require__(30);
const EventsModule_1 = __webpack_require__(19);
const EventArchiveModule_1 = __webpack_require__(31);
const EventQueriesModule_1 = __webpack_require__(46);
const widgets_module_1 = __webpack_require__(22);
const HelpModule_1 = __webpack_require__(24);
const EventTopnController_1 = __webpack_require__(203);
//Bundling the HTML files defined in the routes
var eventTopNTemplate = __webpack_require__(206);
exports.default = angular.module("ev.eventtopn", [
    EventListModule_1.default,
    EventsModule_1.default,
    EventArchiveModule_1.default,
    EventQueriesModule_1.default,
    schema_browser_1.eventSchemaService.name,
    widgets_module_1.default.name,
    ngTranslate,
    'ui.router',
    'tc.chartjs',
    HelpModule_1.default
]).config(function ($stateProvider) {
    $stateProvider.state('eventtopn', {
        data: {
            authRequired: true
        },
        url: '/eventtopn?ts.type&ts.value&ts.start&ts.end&ts.of&archive&querystring&field&limit',
        template: eventTopNTemplate,
        resolve: {
            schema: function (eventSchemaService) {
                return eventSchemaService.getSchema();
            },
            translations: function ($translate) {
                return $translate.onReady();
            }
        },
        params: {
            "ts.type": {
                type: "string",
                dynamic: true
            },
            "ts.value": {
                type: "int",
                dynamic: true
            },
            "ts.of": {
                type: "string",
                dynamic: true
            },
            "ts.start": {
                type: "string",
                dynamic: true
            },
            "ts.end": {
                type: "string",
                dynamic: true
            },
            archive: {
                type: "string",
                array: true,
                dynamic: true
            },
            querystring: {
                type: "string",
                dynamic: true
            },
            field: {
                type: "string",
                dynamic: true
            },
            limit: {
                type: "int",
                dynamic: true
            }
        },
        controller: EventTopnController_1.default,
        controllerAs: '$ctrl'
    });
})
    .controller('TopnController', EventTopnController_1.default).name;


/***/ }),
/* 65 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//EventTopnModule.ts
const angular = __webpack_require__(3);
const ngTranslate = __webpack_require__(10);
const widgets_module_1 = __webpack_require__(22);
const ThreatIntelController_1 = __webpack_require__(207);
const ThreatIntelListComponent_1 = __webpack_require__(208);
const ThreatIntelService_1 = __webpack_require__(210);
//Bundling the HTML files defined in the routes
var threatIntelTemplate = __webpack_require__(211);
exports.default = angular.module("icdx.threatintel", [
    widgets_module_1.default.name,
    ngTranslate,
    'ui.router',
    'tc.chartjs'
]).config(function ($stateProvider) {
    $stateProvider.state('threatintel', {
        data: {
            authRequired: true
        },
        url: '/threatintel',
        template: threatIntelTemplate,
        params: {
            query: {
                id: null,
                name: "Last 10 Minutes",
                state: "eventtopn",
                field: "base.type_id",
                limit: 10,
                timeSpan: {
                    relative: 10
                },
                where: {
                    conditions: []
                }
            }
        }
    });
})
    .controller('ThreatIntelController', ThreatIntelController_1.default)
    .component('threatIntelList', new ThreatIntelListComponent_1.default())
    .constant('threatIntelPath', '/dx/intel/search')
    .factory('threatIntelService', ThreatIntelService_1.default).name;


/***/ }),
/* 66 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

//AboutDialog.ts
Object.defineProperty(exports, "__esModule", { value: true });
const template = /*html*/ `<md-dialog>
    <md-toolbar style="background-color: white;">
        <div class="uxtoolkit" layout-margin layout="row">
            <div class="is--stratus" layout="row" flex>
                <span class="type__primary-headline" flex>About {{"icdx.title" | translate}}</span>
            </div>
        </div>
    </md-toolbar>
    <md-dialog-content layout="column">
        <div class="uxtoolkit" layout="row">
            <div class="is--stratus">
                <table style="margin: 0 16px;">
                    <tr>
                        <td>
                            <span class="type__fifth-headline">ICDx Version</span>
                        </td>
                        <td style="padding-left: 10px;">
                            <a href="/icdx.json" target="_blank"><span class="type__fifth-headline">{{$ctrl.icdx.version}}</span>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <span class="type__fifth-headline">Schema Version</span>
                        </td>
                        <td style="padding-left:10px;">{{$ctrl.icdx.others.event_schema}}</td>
                    </tr>                    
                </table>                
                <div style="padding: 10px 15px 5px;">
                    <a href="https://docs.broadcom.com/doc/end-user-agreement-english" target="_blank">End User License Agreement</a>
                </div>                                
            </div>
        </div>
    </md-dialog-content>
    <md-dialog-actions layout="row">
        <span flex></span>
        <div class="uxtoolkit" layout="row" style="overflow: hidden">
            <div class="is--stratus" layout="row">
                <div class="button button__primary" ng-click="$ctrl.close()">
                    <span>Close</span>
                </div>
            </div>
        </div>
    </md-dialog-actions>
</md-dialog>`;
class AboutDialogController {
    constructor($rootScope, $mdDialog) {
        this.$rootScope = $rootScope;
        this.$mdDialog = $mdDialog;
        this.icdx = $rootScope.icdx;
    }
    close() {
        this.$mdDialog.hide();
    }
    ;
}
AboutDialogController.$inject = ["$rootScope", "$mdDialog", "helpService"];
/**
 * Shows the about dialog for ICDx.
 *
 * @param ev The triggering event, ex: MouseEvent
 * @param $mdDialog The dialog service
 */
function showAbout(ev, $mdDialog) {
    $mdDialog.show({
        controller: AboutDialogController,
        template: template,
        targetEvent: ev,
        controllerAs: "$ctrl",
        bindToController: true,
        clickOutsideToClose: true,
        fullscreen: false
    });
}
exports.showAbout = showAbout;


/***/ }),
/* 67 */,
/* 68 */,
/* 69 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16);
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var angular_material_angular_material_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(70);
/* harmony import */ var angular_material_angular_material_css__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(angular_material_angular_material_css__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var angular_material_data_table_dist_md_data_table_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(72);
/* harmony import */ var angular_material_data_table_dist_md_data_table_css__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(angular_material_data_table_dist_md_data_table_css__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var angular_moment_picker_dist_angular_moment_picker_min_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(74);
/* harmony import */ var angular_moment_picker_dist_angular_moment_picker_min_css__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(angular_moment_picker_dist_angular_moment_picker_min_css__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _icdx_portal_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(76);
/* harmony import */ var _icdx_portal_css__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_icdx_portal_css__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var angular__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(3);
/* harmony import */ var angular__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(angular__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var angular_material__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(11);
/* harmony import */ var angular_material__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(angular_material__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var angular_translate__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(10);
/* harmony import */ var angular_translate__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(angular_translate__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var angular_translate_loader_static_files__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(84);
/* harmony import */ var angular_translate_loader_static_files__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(angular_translate_loader_static_files__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var ngreact__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(28);
/* harmony import */ var ngreact__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(ngreact__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(6);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var react_ux_toolkit__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(7);
/* harmony import */ var react_ux_toolkit__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react_ux_toolkit__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _GlobalActions__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(50);
/* harmony import */ var _GlobalActions__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(_GlobalActions__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var schema_browser__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(12);
/* harmony import */ var schema_browser__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(schema_browser__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var chart_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(29);
/* harmony import */ var chart_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(chart_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var tc_angular_chartjs__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(110);
/* harmony import */ var tc_angular_chartjs__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(tc_angular_chartjs__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var sym_ux_toolkit_dist_js_sym_toolkit__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(111);
/* harmony import */ var sym_ux_toolkit_dist_js_sym_toolkit__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(sym_ux_toolkit_dist_js_sym_toolkit__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var src_common_auth_auth__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(27);
/* harmony import */ var src_common_auth_auth__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(src_common_auth_auth__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var src_common_home_HomeModule__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(51);
/* harmony import */ var src_common_home_HomeModule__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(src_common_home_HomeModule__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var src_events_eventsearch_EventSearchModule__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(52);
/* harmony import */ var src_events_eventsearch_EventSearchModule__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(src_events_eventsearch_EventSearchModule__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var src_events_eventtopn_EventTopnModule__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(64);
/* harmony import */ var src_events_eventtopn_EventTopnModule__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(src_events_eventtopn_EventTopnModule__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var src_common_threatintel_ThreatIntelModule__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(65);
/* harmony import */ var src_common_threatintel_ThreatIntelModule__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(src_common_threatintel_ThreatIntelModule__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var src_config_settings_settings_module__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(32);
/* harmony import */ var _NavIcons__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(14);
/* harmony import */ var _NavIcons__WEBPACK_IMPORTED_MODULE_23___default = /*#__PURE__*/__webpack_require__.n(_NavIcons__WEBPACK_IMPORTED_MODULE_23__);
/* harmony import */ var _AboutDialog__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(66);
/* harmony import */ var _AboutDialog__WEBPACK_IMPORTED_MODULE_24___default = /*#__PURE__*/__webpack_require__.n(_AboutDialog__WEBPACK_IMPORTED_MODULE_24__);
//icdx-portal.js






































/* harmony default export */ __webpack_exports__["default"] = (angular__WEBPACK_IMPORTED_MODULE_5___default.a.module("dxsportal", [
        angular_material__WEBPACK_IMPORTED_MODULE_6___default.a,
        ngreact__WEBPACK_IMPORTED_MODULE_9___default.a.name,
        "uxtoolkit-lite",
        angular_translate__WEBPACK_IMPORTED_MODULE_7___default.a,
        src_common_auth_auth__WEBPACK_IMPORTED_MODULE_17___default.a,
        src_common_home_HomeModule__WEBPACK_IMPORTED_MODULE_18___default.a,
        src_events_eventsearch_EventSearchModule__WEBPACK_IMPORTED_MODULE_19___default.a,
        src_events_eventtopn_EventTopnModule__WEBPACK_IMPORTED_MODULE_20___default.a,
        src_common_threatintel_ThreatIntelModule__WEBPACK_IMPORTED_MODULE_21___default.a,
        schema_browser__WEBPACK_IMPORTED_MODULE_13__["schemaBrowserModule"].name,
        src_config_settings_settings_module__WEBPACK_IMPORTED_MODULE_22__["default"]
    ])
    .constant('baseUrl', '/api')
    .constant('schemaLocation', '/event-schema')
    .config(
        function($urlRouterProvider, $translateProvider, $mdAriaProvider, $mdThemingProvider, $qProvider, $sanitizeProvider) {
            $qProvider.errorOnUnhandledRejections(false);

            $urlRouterProvider.otherwise(function($injector, $location) {
                $injector.invoke(['$state', function($state) {
                    $state.go('home');
                }]);
            });

            $translateProvider.useStaticFilesLoader({
                files: [{
                    prefix: 'lang/icdx_portal_',
                    suffix: '.json'
                }, {
                    prefix: 'lang/schema_browser_',
                    suffix: '.json'
                }, {
                    prefix: 'event-schema/event_schema_',
                    suffix: '.json'
                }]
            });
            $translateProvider.preferredLanguage('en');
            $translateProvider.fallbackLanguage('en');
            $translateProvider.useSanitizeValueStrategy('sanitize');

            $mdAriaProvider.disableWarnings();

            $mdThemingProvider.definePalette('SYMC-Primary', {
                '50': 'e0f1f8',
                '100': 'b3dcee',
                '200': '80c4e3',
                '300': '4dacd7',
                '400': '269bcf',
                '500': '0089c6',
                '600': '0081c0',
                '700': '0076b9',
                '800': '006cb1',
                '900': '0059a4',
                'A100': 'cee6ff',
                'A200': '9bcbff',
                'A400': '68b0ff',
                'A700': '4fa3ff',
                'contrastDefaultColor': 'light',
                'contrastDarkColors': [
                    '50',
                    '100',
                    '200',
                    '300',
                    'A100',
                    'A200',
                    'A400',
                    'A700'
                ],
                'contrastLightColors': [
                    '400',
                    '500',
                    '600',
                    '700',
                    '800',
                    '900'
                ]
            });

            $mdThemingProvider.definePalette('SYMC-Accent', {
                '50': 'e5e5e5',
                '100': 'bfbfbf',
                '200': '949494',
                '300': '696969',
                '400': '484848',
                '500': '282828',
                '600': '242424',
                '700': '1e1e1e',
                '800': '181818',
                '900': '0f0f0f',
                'A100': '505050',
                'A200': '282828',
                'A400': '282828',
                'A700': '000000',
                'contrastDefaultColor': 'light',
                'contrastDarkColors': [
                    '50',
                    '100',
                    '200',
                    'A100'
                ],
                'contrastLightColors': [
                    '300',
                    '400',
                    '500',
                    '600',
                    '700',
                    '800',
                    '900',
                    'A200',
                    'A400',
                    'A700'
                ]
            });


            $mdThemingProvider.theme('default')
                .primaryPalette('SYMC-Primary')
                .accentPalette('SYMC-Accent');

            $sanitizeProvider.enableSvg(true);
        })
    .run(
        function($http) {
            $http.defaults.headers.common['Content-Type'] = "application/json";
            $http.defaults.headers.common['Accept'] = "application/json";
            $http.defaults.headers.common['x-epmp-customer-id'] = "dxs";
            $http.defaults.headers.common['x-epmp-domain-id'] = "dxs";
        }
    )
    .controller("DxsPortalController",
        function($scope, $rootScope, $window, $mdSidenav, $translate, $http, $timeout, $symNav, $state, $mdDialog, authService, eventSchemaService, helpService) {
            $rootScope.demo = false;
            $rootScope.openc2 = false;

            const schemaBrowserRoute = 'schema-landing';

            $scope.app = {
                nav: {
                    selected: "home",
                    navigate: function(route, routeParams) {
                        if (route === schemaBrowserRoute) {
                            $window.open('/icd-schema/');
                        }
                        else {
                            $state.go(route, routeParams);
                        }
                    },
                    items: []
                }
            };

            //TODO: Modify the app to define the privileges that a tile needs and hide the tile for users without the required priviledges.
            let authenticatedNavItems = [{
                name: "home",
                translation: "Home",
                route: "home",
                icon: _NavIcons__WEBPACK_IMPORTED_MODULE_23__["home"]
            }, {
                name: "eventsearch",
                translation: "Search",
                route: "eventsearch",
                icon: _NavIcons__WEBPACK_IMPORTED_MODULE_23__["search"]
            }, {
                name: "eventtopn",
                translation: "Top N",
                route: "eventtopn",
                icon: _NavIcons__WEBPACK_IMPORTED_MODULE_23__["topn"]
            }, {
                name: "schema",
                translation: "Schema",
                route: schemaBrowserRoute,
                icon: _NavIcons__WEBPACK_IMPORTED_MODULE_23__["schema"]
            }, {
                name: "config",
                translation: "Configuration",
                route: "config",
                routeParams: { category: 'collector' },
                icon: _NavIcons__WEBPACK_IMPORTED_MODULE_23__["config"]
            }, {
                name: "settings",
                translation: "Settings",
                route: "settings",
                routeParams: { category: 'archive' },
                icon: _NavIcons__WEBPACK_IMPORTED_MODULE_23__["settings"]
            }];

            let unauthenticatedNavItems = [{
                name: "icd-schema",
                translation: "ICD Schema",
                route: schemaBrowserRoute,
                icon: _NavIcons__WEBPACK_IMPORTED_MODULE_23__["schema"]
            }];


            $scope.app.nav.items = (authService.isAuthenticated() ? authenticatedNavItems : unauthenticatedNavItems);

            $rootScope.$watch("section", function(newValue, oldValue) {
                $scope.section = newValue;
                $scope.subsection = undefined;
                $scope.app.nav.selected = newValue;
            });

            $rootScope.$watch("subsection", function(newValue, oldValue) {
                $scope.subsection = newValue;
                if (!authService.isAuthenticated()) {
                    $scope.app.nav.selected = newValue;
                }
            });

            $rootScope.serverDate = function() {
                let date = moment__WEBPACK_IMPORTED_MODULE_10___default()();
                if ($rootScope.serverOffset !== undefined) {
                    return date.add($rootScope.serverOffset);
                }

                return date;
            };

            $rootScope.serverOffset = 0;
            moment__WEBPACK_IMPORTED_MODULE_10___default.a.now = function() {
                return +new Date() + $rootScope.serverOffset;
            };

            $scope.translateReady = false;
            $translate.onReady(function() {
                $scope.translateReady = true;
                angular__WEBPACK_IMPORTED_MODULE_5___default.a.element("#overlay").removeClass("overlay");
                $scope.app.title = $translate.instant("icdx.title");
            });

            let authMenuItem = {
                id: "",
                displayName: "Sign Out",
                isSelected: false,
                onClick: function() {
                    authService.logout("home");
                }
            };

            $scope.onHelp = function() {
                helpService.helpHome();
            };

            $scope.onAbout = function(event) {
                Object(_AboutDialog__WEBPACK_IMPORTED_MODULE_24__["showAbout"])(event, $mdDialog);
            };

            $scope.onSignIn = function() {
                $rootScope.showLogin();
            };

            $scope.onSignOut = function() {
                authService.logout("home");
            };

            $scope.showLicenseAgreement = function() {
                $mdDialog.show({
                    controller: "EulaController",
                    template: `<md-dialog flex>
                        <md-dialog-content>
                            <span ng-bind-html="eula" layout-margin></span>
                        </md-dialog-content>
                        <md-dialog-actions layout="row">
                            <span flex></span>
                            <div class="uxtoolkit" layout="row" style="overflow: hidden">
                                <div class="is--stratus" layout="row">
                                    <div class="button button__primary" ng-click="close()">
                                        <span>{{'dialog.close' | translate}}</span>
                                    </div>
                                </div>
                            </div>
                        </md-dialog-actions>
                    </md-dialog>`,
                    parent: angular__WEBPACK_IMPORTED_MODULE_5___default.a.element(document.body),
                    clickOutsideToClose: true,
                    fullscreen: true
                });
            };

            $translate('nav.help').then(function(translation) {
                $scope.symDropdownModel.uiModel.items[0].displayName = translation;
            });

            $translate('nav.about').then(function(translation) {
                $scope.symDropdownModel.uiModel.items[1].displayName = translation;
            });

            $translate('nav.logout').then(function(translation) {
                $scope.symDropdownModel.uiModel.items[2].displayName = translation;
            });

            $scope.closeNav = function() {
                $timeout(function() {
                    $symNav.toggleNav();
                });
            };

            $rootScope.user = authService.user;

            $rootScope.$on("login-success", function(event, user) {
                $scope.app.nav.items = authenticatedNavItems;
                $rootScope.user = user;
                $scope.app.nav.selected = $scope.section;
            });

            $rootScope.$on("logout-success", function(event, user) {
                $scope.app.nav.items = unauthenticatedNavItems;
                $rootScope.user = user;
                $scope.app.nav.selected = $scope.subsection;
            });

            $scope.isAuthenticated = function() {
                return authService.isAuthenticated();
            };

            $http.get('icdx.json').then(function(response) {
                // you can do some processing here
                $rootScope.icdx = response.data;
                console.log("Loading ICDX Portal", $rootScope.icdx);

                $rootScope.version = response.data.version !== undefined ? response.data.version : "DEV";
                $rootScope.demo = response.data.demo !== undefined ? response.data.demo : false;

                $rootScope.openc2 = response.data.openc2 !== undefined ? response.data.openc2 : false;

                if ($rootScope.demo) {
                    $scope.app.nav.items.splice(3, 0, {
                        name: "threatintel",
                        translation: "Threat Intelligence",
                        route: "threatintel",
                        icon: _NavIcons__WEBPACK_IMPORTED_MODULE_23__["threatintel"]
                    });
                }
            }, function(response) {
                $rootScope.version = "DEV";
            });

            eventSchemaService.getSchema().then(function(schema) {
                $scope.schemaVersion = eventSchemaService.getSchemaVersion();
            });
        }
    )
    .controller("LanguageController",
        function($scope, $rootScope, $translate) {
            $scope.selectedLanguage = 'en';

            $scope.languageChanged = function() {
                $translate.use($scope.selectedLanguage);
            };

            $scope.isSelected = function(section) {
                return $rootScope.section === section;
            }
        }
    )
    .directive('globalActions', function(reactDirective, $translate) {
        return reactDirective(_GlobalActions__WEBPACK_IMPORTED_MODULE_12__["GlobalActions"], undefined, {}, { $translate: $translate });
    })
    .value("App", react_ux_toolkit__WEBPACK_IMPORTED_MODULE_11__["App"])
    .name);

/***/ }),
/* 70 */,
/* 71 */,
/* 72 */,
/* 73 */,
/* 74 */,
/* 75 */,
/* 76 */
/***/ (function(module, exports, __webpack_require__) {

var content = __webpack_require__(77);
content = content.__esModule ? content.default : content;

if (typeof content === 'string') {
  content = [[module.i, content, '']];
}

var options = {}

options.insert = "head";
options.singleton = false;

var update = __webpack_require__(9)(content, options);

if (content.locals) {
  module.exports = content.locals;
}


/***/ }),
/* 77 */
/***/ (function(module, exports, __webpack_require__) {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(8);
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.i, "body {\n    font-family: 'Roboto', sans-serif !important;\n    font-size: 16px;\n    color: #515151;\n    background-color: #ffffff;\n    -webkit-font-smoothing: antialiased;\n    -moz-osx-font-smoothing: grayscale;\n    overflow-x: hidden;\n}\n\nmd-content {\n    background-color: transparent !important;\n}\n\nmd-sidenav {\n    height: 100%;\n}\n\n.md-select-menu-container {\n    z-index: 85 !important;\n    background: #fff;\n}\n\n.md-dialog-container {\n    z-index: 80;\n}\n\ntd {\n    white-space: nowrap;\n}\n\n.sidenav-button {\n    text-align: left;\n}\n\n.sidenav-button>md-icon {\n    padding-right: 24px;\n}\n\n.avatar {\n    border-radius: 50%;\n    width: 48px;\n    height: 48px;\n    margin-bottom: 8px;\n}\n\n.title-icon {\n    width: 44px;\n    height: 36px;\n    font-size: 36px;\n}\n\n.landingIcon {\n    font-size: 50px;\n    text-align: center;\n    line-height: 80px;\n    width: 80px;\n    height: 80px;\n    border-radius: 50%;\n    overflow: hidden;\n}\n\n.footer {\n    font-size: 12px;\n    font-weight: 400;\n    text-align: center;\n    color: #616161;\n    position: absolute;\n    left: 80px;\n    bottom: 0px;\n    width: calc(100% - 80px);\n    height: 30px;\n    overflow-x: hidden;\n}\n\n.logo {\n    width: 38px;\n    height: 38px;\n    background: url('data:image/png;base64,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') no-repeat;\n}\n\n\n/* Rules for sizing the icon. */\n\n.material-icons.md-18 {\n    font-size: 18px;\n}\n\n.material-icons.md-24 {\n    font-size: 24px;\n}\n\n.material-icons.md-36 {\n    font-size: 36px;\n}\n\n.material-icons.md-48 {\n    font-size: 48px;\n}\n\n.uxtoolkit {\n    overflow: hidden;\n}\n\n.uxtoolkit .is--stratus .nav-text {\n    margin-top: 7px;\n}\n\n.uxtoolkit .is--stratus .icon__nav-icdx {\n    width: 38px;\n    height: 38px;\n    background-repeat: no-repeat;\n}\n\n.uxtoolkit .is--stratus .global__header-container {\n    z-index: 65 !important;\n}\n\n.uxtoolkit .is--stratus .global__nav-container {\n    z-index: 60 !important;\n}\n\n.uxtoolkit .is--stratus .global__nav {\n    outline: none;\n}\n\n\n/* Fix for UX Toolkit nav */\n\n.uxtoolkit .is--stratus .button__tab {\n    outline: none\n}\n\nol {\n    list-style-type: none;\n    counter-reset: item;\n    margin: 0;\n    padding: 0;\n}\n\nol>li {\n    display: table;\n    counter-increment: item;\n    margin-bottom: 0.6em;\n}\n\nol>li:before {\n    content: counters(item, \".\") \". \";\n    display: table-cell;\n    padding-right: 0.6em;\n}\n\nli ol>li {\n    margin: 0;\n}\n\nli ol>li:before {\n    content: counters(item, \".\") \" \";\n}\n\n.eula-title {\n    margin: 0 16px !important;\n}\n\n.eula-frame {\n    border: 1px solid #dcdcdc !important;\n}\n\n.eula-body {\n    margin: 8px 16px !important;\n    font-size: 12px !important;\n}\n\n.eula-body-preserve-line-break {\n    white-space: pre !important;\n}\n\n.eula li {\n    margin-top: 10px !important;\n}\n\n.icon {\n    width: 24px;\n    height: 24px;\n}\n\n.icon svg {\n    width: 24px;\n    height: 24px;\n}\n\n.icon .primary-fill-color {\n    fill: #366BB2;\n}\n\n.icon .primary-color {\n    stroke: #366BB2;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),
/* 78 */,
/* 79 */,
/* 80 */,
/* 81 */,
/* 82 */,
/* 83 */,
/* 84 */,
/* 85 */,
/* 86 */,
/* 87 */,
/* 88 */,
/* 89 */,
/* 90 */,
/* 91 */,
/* 92 */,
/* 93 */,
/* 94 */,
/* 95 */,
/* 96 */,
/* 97 */,
/* 98 */,
/* 99 */,
/* 100 */,
/* 101 */,
/* 102 */,
/* 103 */,
/* 104 */,
/* 105 */,
/* 106 */,
/* 107 */,
/* 108 */,
/* 109 */,
/* 110 */,
/* 111 */,
/* 112 */,
/* 113 */
/***/ (function(module, exports, __webpack_require__) {

var content = __webpack_require__(114);
content = content.__esModule ? content.default : content;

if (typeof content === 'string') {
  content = [[module.i, content, '']];
}

var options = {}

options.insert = "head";
options.singleton = false;

var update = __webpack_require__(9)(content, options);

if (content.locals) {
  module.exports = content.locals;
}


/***/ }),
/* 114 */
/***/ (function(module, exports, __webpack_require__) {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(8);
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.i, ".auth-dialog {\n    min-width: 400px;\n}\n\n.auth-dialog .signin {\n    font-size: 14px;\n    text-align: center;\n    color: #666666;\n    padding-bottom: 20px;\n}\n\n.auth-dialog .auth-error {\n    font-size: 12px;\n    color: red;\n}\n\n.auth-dialog .schema-browser {\n    padding-top: 10px;\n    padding-bottom: 20px;\n}\n\n.auth-dialog a {\n    font-size: 9px;\n    font-weight: 500;\n    text-align: center;\n    color: #00aeef;\n    padding-top: 10px;\n    padding-bottom: 20px;\n    text-decoration: none;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),
/* 115 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//AuthService.ts
const angular = __webpack_require__(3);
class AuthService {
    constructor($http, $window, $rootScope, $q, $state, baseUrl) {
        this.$http = $http;
        this.$window = $window;
        this.$rootScope = $rootScope;
        this.$q = $q;
        this.$state = $state;
        this.baseUrl = baseUrl;
        this.sessionStorage = $window.sessionStorage;
        let accessToken = this.sessionStorage.getItem("access-token");
        if (accessToken !== null) {
            $http.defaults.headers.common['Authorization'] = "Bearer " + accessToken;
        }
    }
    login(credentials) {
        let self = this;
        const defer = self.$q.defer();
        self.$http({
            method: 'POST',
            url: self.baseUrl + "/v1/authentication?response_type=token",
            data: JSON.stringify(credentials)
        }).then(function (response) {
            //Setting the token in every HTTP call's header.
            self.$http.defaults.headers.common['Authorization'] = "Bearer " + response.data.access_token;
            //Adding the token to a cookie for future session.
            self.sessionStorage.setItem("access-token", response.data.access_token);
            self.sessionStorage.setItem("user", credentials.email);
            self.$rootScope.$emit("login-success", credentials.email);
            self.$http({
                method: 'GET',
                url: self.baseUrl + "/v1/tokens/" + response.data.access_token
            }).then(function (tokenResponse) {
                self.sessionStorage.setItem("privs", tokenResponse.data.result.sp.privs.split(" "));
                defer.resolve();
            }, function (errorResponse) {
                defer.reject(errorResponse);
            });
        }, function (errorResponse) {
            defer.reject(errorResponse);
        });
        return defer.promise;
    }
    ;
    logout(state) {
        let self = this;
        angular.element("#auth").addClass("auth");
        let accessToken = this.sessionStorage.getItem("access-token");
        if (accessToken !== null) {
            self.$http({
                method: 'DELETE',
                url: self.baseUrl + "/v1/tokens/" + accessToken
            });
        }
        this.sessionStorage.removeItem("access-token");
        this.sessionStorage.removeItem("privs");
        this.sessionStorage.removeItem("user");
        delete this.$http.defaults.headers.common['Authorization'];
        self.$rootScope.user = null;
        self.$rootScope.$emit("logout-success");
        if (state === undefined || this.$state.current.name === state) {
            //If no state is specified or if the state specified is the current state, just reload
            this.$state.reload();
        }
        else {
            //otherwise transition to the new state.
            this.$state.go(state);
        }
    }
    get user() {
        return this.sessionStorage.getItem("user");
    }
    isAuthenticated() {
        return this.sessionStorage.getItem("access-token") !== null;
    }
    ;
}
exports.default = AuthService;
AuthService.$inject = ['$http', '$window', '$rootScope', '$q', '$state', 'baseUrl'];
;


/***/ }),
/* 116 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
// HelpService.js
const urls = __webpack_require__(117);
const homeHelpUrl = urls.ICDX_Path + urls.ICDX_Main + "?locale=EN_US";
class HelpService {
    constructor($window, $http, $q) {
        this.$window = $window;
        this.$http = $http;
        this.$q = $q;
    }
    helpHome() {
        this.$window.open(homeHelpUrl, "_blank");
    }
    help(token) {
        const helpUrl = urls.ICDX_Path + urls[token] + "?locale=EN_US";
        this.$window.open(helpUrl, "_blank");
    }
}
exports.default = HelpService;
HelpService.$inject = ['$window', '$http', '$q'];
;


/***/ }),
/* 117 */
/***/ (function(module) {

module.exports = JSON.parse("{\"ICDX_Path\":\"https://techdocs.broadcom.com/content/broadcom/techdocs/us/en/symantec-security-software/integrated-cyber-defense/integrated-cyber-defense-exchange/\",\"ICDX_Main\":\"1-4-3.html\",\"ICDX_Home\":\"1-4-3/Events/accessing-the-dashboards-v126919740-d2707e25997.html\",\"ICDX_Schema\":\"1-4-3/Schema/overview-of-the-v127012906-d2707e37597.html\",\"ICDX_Search\":\"1-4-3/Events/managing-event-queries-in-v126919745-d2707e26206.html\",\"ICDX_Top_N\":\"1-4-3/Events/managing-top-n-queries-in-v127014881-d2707e27295.html\",\"ICDX_Settings_Active_Directory\":\"1-4-3/Settings/integrating-with-active-directory-v125547222-d2707e3782.html\",\"ICDX_Settings_API_Keys\":\"1-4-3/Settings/managing-api-keys-v126919642-d2707e3924.html\",\"ICDX_Settings_Event_Archive\":\"1-4-3/Settings/configuring-the-common-archive-in-v127258389-d2707e3679.html\",\"ICDX_Settings_Telemetry\":\"1-4-3/Settings/Sending-Telemetry-Information-to-Symantec.html\",\"ICDX_Configuration_Collectors\":\"1-4-3/Collectors/understanding-collector-configurations-in-v126958903-d2707e4251.html\",\"ICDX_Configuration_Collectors_AMQP\":\"1-4-3/Collectors/configuring-collectors-v127510233-d2707e5275.html\",\"ICDX_Configuration_Collectors_CloudSOC\":\"1-4-3/Collectors/configuring-collectors-v132940123-d2707e5707.html\",\"ICDX_Configuration_Collectors_ICDm\":\"1-4-3/Collectors/configuring-collectors-v133463340-d2707e10856.html\",\"ICDX_Configuration_Collectors_ICDM_EDR_Incidents\":\"1-4-3/Collectors/Configuring-Symantec-Integrated-Cyber-Defense-Manager-EDR-Incidents-Collectors.html\",\"ICDX_Configuration_Collectors_SCCS\":\"1-4-3/Collectors/configuring-collectors-v135313842-d2707e6375.html\",\"ICDX_Configuration_Collectors_SDCS_6_5_1\":\"1-4-3/Collectors/configuring-collectors-v125547232-d2707e7029.html\",\"ICDX_Configuration_Collectors_SDLP_14_6\":\"1-4-3/Collectors/configuring-collectors-v126919648-d2707e7658.html\",\"ICDX_Configuration_Collectors_SEDR\":\"1-4-3/Collectors/configuring-collectors-v127849745-d2707e8958.html\",\"ICDX_Configuration_Collectors_SEPM_14\":\"1-4-3/Collectors/configuring-collectors-v126919655-d2707e10248.html\",\"ICDX_Configuration_Collectors_SESC\":\"1-4-3/Collectors/configuring-collectors-v126919658-d2707e8390.html\",\"ICDX_Configuration_Collectors_SSA\":\"1-4-3/Collectors/configuring-collectors-v132940132-d2707e12616.html\",\"ICDX_Configuration_Collectors_SSWG_6_7\":\"1-4-3/Collectors/configuring-collectors-v126919661-d2707e12024.html\",\"ICDX_Configuration_Collectors_SWSS\":\"1-4-3/Collectors/configuring-collectors-v126919666-d2707e13784.html\",\"ICDX_Configuration_Collectors_Syslog\":\"1-4-3/Collectors/configuring-collectors-v132302344-d2707e14378.html\",\"ICDX_Configuration_Forwarders\":\"1-4-3/Forwarders/understanding-forwarder-configurations-in-v126986909-d2707e14793.html\",\"ICDX_Configuration_Forwarders_AMAZONS3\":\"1-4-3/Forwarders/configuring-forwarders-v129655708-d2707e15053.html\",\"ICDX_Configuration_Forwarders_AMQP\":\"1-4-3/Forwarders/configuring-forwarders-v126919717-d2707e17990.html\",\"ICDX_Configuration_Forwarders_ES_6\":\"1-4-3/Forwarders/configuring-forwarders-v126919709-d2707e16231.html\",\"ICDX_Configuration_Forwarders_JSON_File\":\"1-4-3/Forwarders/configuring-json-file-forwarders-v126919714-d2707e16916.html\",\"ICDX_Configuration_Forwarders_KAFKA\":\"1-4-3/Forwarders/configuring-forwarders-v130027282-d2707e15710.html\",\"ICDX_Configuration_Forwarders_MSAzure_Log_Analytics\":\"1-4-3/Forwarders/configuring-forwarders-v131944722-d2707e17438.html\",\"ICDX_Configuration_Forwarders_Splunk_7\":\"1-4-3/Forwarders/configuring-forwarders-v126919726-d2707e18899.html\",\"ICDX_Configuration_Forwarders_Anomali\":\"1-4-3/Forwarders/Configuring-Anomali-Match-Forwarders.html\",\"ICDX_Configuration_Forwarders_SYSLOG\":\"1-4-3/Forwarders/configuring-forwarders-v131841069-d2707e20147.html\",\"ICDX_Configuration_Forwarders_SYSLOG_CEF\":\"1-432/Forwarders/configuring-forwarders-v129998423-d2707e20793.html\",\"ICDX_Configuration_ICDx_Chaining\":\"1-4-3/ICDx-Chaining/about-setting-up-chaining-v129971957-d2707e21207.html\",\"ICDX_Configuration_ICDx_Chaining_Receiver\":\"1-4-3/ICDx-Chaining/configuring-receivers-v129971974-d2707e21330.html\",\"ICDX_Configuration_ICDx_Chaining_Sender_AMQP\":\"1-4-3/ICDx-Chaining/setting-up-senders-v129972073-d2707e21727/configuring-senders-v129972106-d2707e21837.html\",\"ICDX_Configuration_ICDx_Chaining_Sender_HTTP\":\"1-4-3/ICDx-Chaining/setting-up-senders-v129972073-d2707e21727/configuring-senders-http-v129972195-d2707e22410.html\"}");

/***/ }),
/* 118 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

//HomeController.ts
Object.defineProperty(exports, "__esModule", { value: true });
const moment = __webpack_require__(6);
__webpack_require__(119);
class HomeController {
    constructor($scope, $rootScope, $interval, statsService, authService, helpService) {
        this.$scope = $scope;
        this.$rootScope = $rootScope;
        this.$interval = $interval;
        this.statsService = statsService;
        this.authService = authService;
        this.helpService = helpService;
        this.status = "loading";
        this._stats = [];
        this.charts = {};
        this.selectedCharts = [];
        this.selectedChartsCount = 0;
        this._category = "collector";
        $rootScope.section = "home";
        $scope.helpIcon = helpService.icon;
        this.showHelp = this.showHelp.bind(this);
    }
    $onInit() {
        let self = this;
        self.load();
        self.refreshPromise = self.$interval(function () {
            if (self.authService.isAuthenticated()) {
                self.load(true);
            }
        }, 15000);
        self.$scope.$on('$destroy', function () {
            if (self.refreshPromise) {
                self.$interval.cancel(self.refreshPromise);
            }
        });
        this.chartOptions = {
            animation: false,
            responsive: true,
            maintainAspectRatio: false,
            legend: {
                position: 'right'
            },
            datasets: {
                barPercentage: 1.0,
                categoryPercentage: 1.0
            },
            scales: {
                xAxes: [{
                        type: 'time',
                        ticks: {
                            autoSkip: true,
                            maxTicksLimit: 20,
                            maxRotation: 0,
                            minRotation: 0
                        },
                        offset: true,
                        stacked: true,
                        distribution: 'series',
                        time: {
                            unit: 'minute',
                            displayFormats: {
                                'minute': 'HH:mm'
                            }
                        },
                        gridLines: {
                            display: false
                        }
                    }],
                yAxes: [{
                        stacked: true,
                        ticks: {
                            beginAtZero: true,
                            padding: 10,
                            userCallback: function (label, index, labels) {
                                if (Math.floor(label) === label) {
                                    return label.toLocaleString(); //Only return a label when it is a whole number
                                }
                            }
                        },
                        gridLines: {
                            display: false
                        }
                    }]
            },
            tooltips: {
                enabled: false,
                mode: "index",
                callbacks: {
                    label: function (tooltipItem, data) {
                        let label = data.datasets[tooltipItem.datasetIndex].label || '';
                        if (label) {
                            label += ': ' + tooltipItem.yLabel.toLocaleString();
                        }
                        return label;
                    }
                },
                custom: function (tooltipModel) {
                    // Tooltip Element
                    let tooltipEl = document.getElementById('chartjs-tooltip');
                    // Create element on first render
                    if (!tooltipEl) {
                        tooltipEl = document.createElement('div');
                        tooltipEl.id = 'chartjs-tooltip';
                        tooltipEl.innerHTML = "<table></table>";
                        document.getElementById('app-view').appendChild(tooltipEl);
                    }
                    // Hide if no tooltip
                    if (tooltipModel.opacity === 0) {
                        tooltipEl.style.opacity = 0;
                        return;
                    }
                    // Set caret Position
                    tooltipEl.classList.remove('above', 'below', 'no-transform');
                    if (tooltipModel.yAlign) {
                        tooltipEl.classList.add(tooltipModel.yAlign);
                    }
                    else {
                        tooltipEl.classList.add('no-transform');
                    }
                    function getBody(bodyItem) {
                        return bodyItem.lines;
                    }
                    // Set Text
                    if (tooltipModel.body) {
                        var titleLines = tooltipModel.title || [];
                        var bodyLines = tooltipModel.body.map(getBody);
                        var innerHtml = '<thead>';
                        titleLines.forEach(function (title) {
                            let translatedValue = `Time: ${moment(title).format("HH:mm")}`;
                            innerHtml += '<tr><th>' + translatedValue + '</th></tr>';
                        });
                        innerHtml += '</thead><tbody>';
                        bodyLines.forEach(function (body, i) {
                            var colors = tooltipModel.labelColors[i];
                            var style = 'background:' + colors.backgroundColor;
                            style += '; border-color:' + colors.borderColor;
                            style += '; border-width: 2px';
                            var span = '<span class="chartjs-tooltip-key" style="' + style + '"></span>';
                            innerHtml += '<tr><td>' + span + body + '</td></tr>';
                        });
                        let total = 0;
                        for (let dataPoint of tooltipModel.dataPoints) {
                            total += dataPoint.yLabel;
                        }
                        var style = "background: black;";
                        var span = '<span class="chartjs-tooltip-key" style="' + style + '"></span>';
                        innerHtml += "<tr><td>" + span + "Total: " + total.toLocaleString() + "</td></tr>";
                        innerHtml += '</tbody>';
                        var tableRoot = tooltipEl.querySelector('table');
                        tableRoot.innerHTML = innerHtml;
                    }
                    // `this` will be the overall tooltip
                    var positionX = tooltipModel.caretX + this._chart.canvas.offsetLeft - 20;
                    var positionY = this._chart.canvas.offsetTop - 50;
                    // Display, position, and set styles for font
                    tooltipEl.style.opacity = 1;
                    tooltipEl.style.zIndex = 100;
                    tooltipEl.style.position = 'absolute';
                    tooltipEl.style.left = positionX.toString() + 'px';
                    tooltipEl.style.top = positionY.toString() + 'px';
                    tooltipEl.style.padding = tooltipModel.yPadding + 'px ' + tooltipModel.xPadding + 'px';
                }
            }
        };
    }
    get category() {
        return this._category;
    }
    set category(category) {
        this._category = category;
        this.updateSelectedCharts();
    }
    get stats() {
        let stats = [];
        for (let stat of this._stats) {
            if (stat.category === this.category) {
                stats.push(stat);
            }
        }
        return stats;
    }
    load(daemon = false) {
        let self = this;
        if (self.loadPromise !== undefined) {
            ("Already loading");
            return; //Already loading
        }
        let start = moment().subtract(1, 'hours').startOf('minute').toDate();
        self.loadPromise = self.statsService.getStatsHistogram(start, daemon);
        self.loadPromise.then(function (statsHistograms) {
            try {
                for (let i in statsHistograms) {
                    let chart = self.getChart(statsHistograms[i].uuid);
                    let modified = statsHistograms[i].modified;
                    chart.name = statsHistograms[i].name;
                    if (modified) {
                        chart.modified = moment(modified).format("MM/DD/YYYY HH:mm:ss");
                    }
                    else {
                        chart.modified = '';
                    }
                    chart.category = statsHistograms[i].category;
                    chart.data = {
                        datasets: statsHistograms[i].series
                    };
                    if (chart.chart != undefined) {
                        for (let j in chart.chart.legend.legendItems) {
                            chart.data.datasets[j].hidden = chart.chart.legend.legendItems[j].hidden;
                        }
                    }
                    self.updateSelectedCharts();
                }
            }
            finally {
                self.status = "done";
                self.loadPromise = undefined;
            }
        });
    }
    getChart(name) {
        if (this.charts[name] === undefined) {
            this.charts[name] = {};
        }
        return this.charts[name];
    }
    updateSelectedCharts() {
        this.selectedCharts = [];
        this.selectedChartsCount = 0;
        for (let path in this.charts) {
            if (this.charts[path].category === this.category) {
                this.selectedCharts.push(this.charts[path]);
                this.selectedChartsCount++;
            }
        }
    }
    showHelp() {
        this.helpService.help("ICDX_Home");
    }
}
exports.default = HomeController;
HomeController.$inject = ["$scope", "$rootScope", "$interval", "statsService", "authService", "helpService"];


/***/ }),
/* 119 */
/***/ (function(module, exports, __webpack_require__) {

var content = __webpack_require__(120);
content = content.__esModule ? content.default : content;

if (typeof content === 'string') {
  content = [[module.i, content, '']];
}

var options = {}

options.insert = "head";
options.singleton = false;

var update = __webpack_require__(9)(content, options);

if (content.locals) {
  module.exports = content.locals;
}


/***/ }),
/* 120 */
/***/ (function(module, exports, __webpack_require__) {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(8);
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.i, ".kpi-header {\n    min-width: 250px;\n    font-size: 14px;\n    font-weight: bold;\n    color: #000000;\n    padding-top: 15px;\n    padding-bottom: 15px;\n    padding-left: 24px;\n}\n\n.kpi-horizontal-divider {\n    width: auto;\n    height: 1px;\n    background-color: #a3a3a3;\n    margin-top: 15px;\n}\n\n.kpi-updated-on {\n    font-size: 10px;\n    text-align: right;\n    color: #a3a3a3;\n    margin-top: 3px;\n}\n\n#chartjs-tooltip {\n    opacity: 1;\n    position: absolute;\n    background: #FFF;\n    color: #000;\n    border-radius: 5px;\n    border: 1px solid #000;\n    pointer-events: none;\n    transform: translate(50%, 50%);\n    font-size: 10px;\n}\n\n.chartjs-tooltip-key {\n    display: inline-block;\n    width: 10px;\n    height: 10px;\n    margin-right: 5px;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),
/* 121 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//StatsService.ts
const moment = __webpack_require__(6);
const tinycolor = __webpack_require__(25);
class StatsService {
    constructor($http, $q, baseUrl, statsServicePath) {
        this.$http = $http;
        this.$q = $q;
        this.baseUrl = baseUrl;
        this.statsServicePath = statsServicePath;
    }
    getStats(daemon) {
        let defer = this.$q.defer();
        let self = this;
        this.$http({
            method: 'GET',
            url: this.baseUrl + "/dx/stats/manage",
            headers: { 'Content-Type': 'application/json', 'X-Daemon': daemon },
            data: JSON.stringify([])
        }).then(function (response) {
            defer.resolve(response.data.list);
        }, function (errorResponse) {
            defer.reject(errorResponse);
        });
        return defer.promise;
    }
    getStatsHistogram(start, daemon) {
        let defer = this.$q.defer();
        let self = this;
        let payload = { type_id: 22 };
        this.$http({
            method: 'POST',
            url: this.baseUrl + this.statsServicePath,
            headers: { 'Content-Type': 'application/json', 'X-Daemon': daemon },
            data: JSON.stringify(payload)
        }).then(function (response) {
            try {
                let statsHistograms = [];
                let now = moment();
                for (let data of response.data) {
                    if (data.path === undefined) {
                        continue;
                    }
                    let statsHistogram = {
                        name: data.name,
                        uuid: data.uuid,
                        path: data.path + "/" + data.name,
                        category: data.path.split("/")[0]
                    };
                    if (data.last_event_time > 0) {
                        statsHistogram.modified = moment(data.last_event_time);
                    }
                    statsHistogram.series = data.stats;
                    for (let series of statsHistogram.series) {
                        for (let index in series.data) {
                            series.data[index] = { x: moment(series.data[index][0] * 60000), y: series.data[index][1] };
                        }
                        series.label = series.name;
                        delete series.name;
                        series.borderColor = "#fff";
                        series.borderWidth = 1;
                        series.borderSkipped = "left";
                        series.backgroundColor = tinycolor(series.color).setAlpha(0.9).toRgbString();
                        delete series.color;
                    }
                    statsHistograms.push(statsHistogram);
                }
                defer.resolve(statsHistograms);
            }
            catch (e) {
                defer.reject(e);
            }
        }, function (errorResponse) {
            defer.reject(errorResponse);
        });
        return defer.promise;
    }
}
exports.default = StatsService;
StatsService.$inject = ['$http', '$q', 'baseUrl', 'statsServicePath'];


/***/ }),
/* 122 */
/***/ (function(module, exports) {

var angular=window.angular,ngModule;
try {ngModule=angular.module(["icdx.home"])}
catch(e){ngModule=angular.module("icdx.home",[])}
var v1="<md-content ng-controller=\"HomeController as $ctrl\" layout=\"column\" layout-margin flex>\n<div style=\"margin-left: 16px; overflow: hidden\" layout=\"row\">\n<div class=\"uxtoolkit\">\n<div class=\"is--stratus\">\n<div class=\"button button__tab\" ng-class=\"{ 'is--active': $ctrl.category==='collector' }\" ng-click=\"$ctrl.category='collector'\">\n<span>Collectors</span>\n</div>\n<div class=\"button button__tab\" ng-class=\"{ 'is--active': $ctrl.category==='forwarder' }\" ng-click=\"$ctrl.category='forwarder'\">\n<span>Forwarders</span>\n</div>\n<div class=\"button button__tab\" ng-class=\"{ 'is--active': $ctrl.category==='other' }\" ng-click=\"$ctrl.category='other'\">\n<span>System</span>\n</div>\n</div>\n</div>\n<div flex></div>\n<div style=\"background-color: transparent; display: flex; flex-direction: column; justify-content: center; margin-right: 24px;\">\n<help-button on-help=\"$ctrl.showHelp\"/>\n</div>\n</div>\n<div id=\"home\" ng-if=\"$ctrl.status==='done'\">\n<div class=\"kpi-header\" ng-if=\"$ctrl.selectedChartsCount===0\">\n<span>{{'stats.' + $ctrl.category + '.emptyresults' | translate}}</span>\n</div>\n<div ng-repeat=\"chart in $ctrl.selectedCharts | orderBy:'name'\">\n<div layout=\"row\">\n<div class=\"kpi-header\">{{chart.name}}</div>\n<div style=\"min-width: 30px\" flex></div>\n<div class=\"kpi-updated-on\">{{chart.modified}}</div>\n</div>\n<div layout=\"row\" flex>\n<canvas tc-chartjs-bar chart=\"chart.chart\" chart-data=\"chart.data\" chart-options=\"$ctrl.chartOptions\" height=\"200px\"></canvas>\n</div>\n</div>\n</div>\n<div ng-if=\"$ctrl.status==='loading'\" style=\"height: 300px;\" layout=\"row\" layout-align=\"center center\">\n<div class=\"overlay\">\n<div class=\"ldr\" flex>\n<div class=\"ldr-blk\"></div>\n<div class=\"ldr-blk an_delay\"></div>\n<div class=\"ldr-blk an_delay\"></div>\n<div class=\"ldr-blk\"></div>\n</div>\n</div>\n</div>\n</md-content>";
var id1="home.html";
var inj=angular.element(window.document).injector();
if(inj){inj.get("$templateCache").put(id1,v1);}
else{ngModule.run(["$templateCache",function(c){c.put(id1,v1)}]);}
module.exports=v1;

/***/ }),
/* 123 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//EventsModule.js
const angular = __webpack_require__(3);
const ngTranslate = __webpack_require__(10);
const TimeSpanPickerComponent_1 = __webpack_require__(124);
exports.default = angular.module("icdx.timespan", [
    ngTranslate
])
    .component('timeSpanPicker', new TimeSpanPickerComponent_1.default())
    .name;


/***/ }),
/* 124 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
const moment = __webpack_require__(6);
const humanize = __webpack_require__(125);
const timeSpanDialogs = __webpack_require__(126);
__webpack_require__(127);
let timeSpanPickerTemplate = /*html*/ `
<md-input-container style="margin-bottom: 0; max-height: 600px;">
    <label>{{'event_query.timespan.label' | translate}}</label>
    <md-select ng-model="$ctrl.timeSpanModel" md-container-class="TimeSpanPicker">
        <md-optgroup label="Time Spans">
            <md-option value="TIMESPAN_LAST_15" ng-click="$ctrl.timeSpan = 'TIMESPAN_LAST_15'">Last 15 Minutes</md-option>
            <md-option value="TIMESPAN_LAST_60" ng-click="$ctrl.timeSpan = 'TIMESPAN_LAST_60'">Last 60 Minutes</md-option>
            <md-option value="TIMESPAN_LAST_240" ng-click="$ctrl.timeSpan = 'TIMESPAN_LAST_240'">Last 4 Hours</md-option>
            <md-option value="TIMESPAN_LAST_1440" ng-click="$ctrl.timeSpan = 'TIMESPAN_LAST_1440'">Last 24 Hours</md-option>
            <md-option value="TIMESPAN_LAST_10080" ng-click="$ctrl.timeSpan = 'TIMESPAN_LAST_10080'">Last 7 Days</md-option>
        </md-optgroup>
        <md-optgroup label="Custom Time Spans">
            <md-option value="TIMESPAN_RECENT" ng-click="$ctrl.timeSpan = 'TIMESPAN_RECENT'">{{'timespanpicker.recent' | translate}}<span ng-if="$ctrl.ngModel.recent !== undefined" class="absolute"> {{$ctrl.humanizeDuration}}</span></md-option>

            <md-option value="TIMESPAN_LAST" ng-click="$ctrl.timeSpan = 'TIMESPAN_LAST'">{{'timespanpicker.last' | translate}}<span ng-if="$ctrl.ngModel.relative !== undefined" class="absolute"> {{$ctrl.humanizeDuration}}</span></md-option>

            <md-option value="TIMESPAN_WITHIN" ng-click="$ctrl.timeSpan = 'TIMESPAN_WITHIN'">{{'timespanpicker.within' | translate}}<span ng-if="$ctrl.ngModel.within !== undefined" class="absolute">  {{$ctrl.humanizeDuration}} of {{$ctrl.ngModel.of.toDate() | date : "MM/dd/yyyy HH:mm"}}</span></md-option>

            <md-option value="TIMESPAN_ABSOLUTE" ng-click="$ctrl.timeSpan = 'TIMESPAN_ABSOLUTE'">{{'timespanpicker.absolute' | translate}}<span ng-if="$ctrl.ngModel.startDate !== undefined" class="absolute"> ({{$ctrl.ngModel.startDate.toDate() | date : "MM/dd/yyyy HH:mm"}} - {{$ctrl.ngModel.endDate.toDate() | date : "MM/dd/yyyy HH:mm"}})</span></md-option>
        </md-optgroup>
    </md-select>
</md-input-container>`;
class TimeSPanPickerComponent {
    constructor() {
        this.bindings = {
            ngModel: '<'
        };
        this.controller = TimeSpanPickerController;
        this.template = timeSpanPickerTemplate;
    }
}
exports.default = TimeSPanPickerComponent;
TimeSPanPickerComponent.$$ngIsClass = true; //Fix for Firefox
class TimeSpanPickerController {
    constructor($scope, $rootScope, $timeout, $translate, $mdDialog, $window) {
        this.$scope = $scope;
        this.$rootScope = $rootScope;
        this.$timeout = $timeout;
        this.$translate = $translate;
        this.$mdDialog = $mdDialog;
        this.$window = $window;
    }
    ;
    $onInit() {
    }
    get ngModel() {
        return this._ngModel;
    }
    set ngModel(ngModel) {
        if (ngModel.recent != undefined) {
            this._timeSpan = "TIMESPAN_RECENT";
        }
        else if (ngModel.relative != undefined) {
            this._timeSpan = "TIMESPAN_LAST";
        }
        else if (ngModel.within != undefined) {
            this._timeSpan = "TIMESPAN_WITHIN";
        }
        else {
            this._timeSpan = "TIMESPAN_ABSOLUTE";
        }
        this._ngModel = ngModel;
    }
    get timeSpanModel() {
        return this._timeSpan;
    }
    set timeSpanModel(timeSpanModel) {
        //Do Nothing, use ng-click
    }
    get timeSpan() {
        return this._timeSpan;
    }
    set timeSpan(timeSpan) {
        let self = this;
        let oldTimeSpan = self._timeSpan;
        self.$timeout(function () {
            if (timeSpan === "TIMESPAN_RECENT") {
                self.recentTimeSpan(oldTimeSpan);
            }
            else if (timeSpan === "TIMESPAN_ABSOLUTE") {
                self.absoluteTimeSpan(oldTimeSpan);
            }
            else if (timeSpan === "TIMESPAN_LAST") {
                self.lastTimeSpan(oldTimeSpan);
            }
            else if (timeSpan === "TIMESPAN_WITHIN") {
                self.withinTimeSpan(oldTimeSpan);
            }
            else if (timeSpan.startsWith("TIMESPAN_LAST_")) {
                self.ngModel = {
                    relative: parseInt(timeSpan.substring(14))
                };
                self.$scope.$emit("timeSpanChanged", self.ngModel);
            }
        }, 500);
    }
    get of() {
        if (this.ngModel.of === undefined) {
            return moment();
        }
        else {
            return moment(this.ngModel.of);
        }
    }
    get duration() {
        if (this.ngModel.recent !== undefined) {
            return moment.duration(this.ngModel.recent, "minutes");
        }
        else if (this.ngModel.relative !== undefined) {
            return moment.duration(this.ngModel.relative, "minutes");
        }
        else if (this.ngModel.within !== undefined) {
            return moment.duration(this.ngModel.within, "minutes");
        }
        else {
            return moment.duration(1, "days");
        }
    }
    get humanizeDuration() {
        return humanize.duration(this.duration, this.$translate);
    }
    recentTimeSpan(oldTimeSpan) {
        let self = this;
        self.$mdDialog.show(timeSpanDialogs.relativeDialog(this.duration)).then(function (timeSpan) {
            self.ngModel = {
                recent: timeSpan.duration.asMinutes()
            };
            self.$scope.$emit("timeSpanChanged", self.ngModel);
        }, function () {
            self._timeSpan = oldTimeSpan;
        });
    }
    lastTimeSpan(oldTimeSpan) {
        let self = this;
        self.$mdDialog.show(timeSpanDialogs.relativeDialog(this.duration)).then(function (timeSpan) {
            self.ngModel = {
                relative: timeSpan.duration.asMinutes()
            };
            self.$scope.$emit("timeSpanChanged", self.ngModel);
        }, function () {
            self._timeSpan = oldTimeSpan;
        });
    }
    withinTimeSpan(oldTimeSpan) {
        let self = this;
        self.$mdDialog.show(timeSpanDialogs.withinDialog(this.duration, this.of)).then(function (timeSpan) {
            self.ngModel = {
                within: timeSpan.duration.asMinutes(),
                of: timeSpan.of
            };
            self.$scope.$emit("timeSpanChanged", self.ngModel);
        }, function () {
            self._timeSpan = oldTimeSpan;
        });
    }
    absoluteTimeSpan(oldTimeSpan) {
        let self = this;
        if (self.ngModel.startDate === undefined) {
            const startDate = this.$window.localStorage.getItem(this.$rootScope.user + '.tsdStartDate');
            const endDate = this.$window.localStorage.getItem(this.$rootScope.user + '.tsdEndDate');
            if (startDate !== null) {
                self.ngModel = {
                    startDate: moment(parseInt(startDate)).startOf("minute"),
                    endDate: moment(parseInt(endDate)).startOf("minute")
                };
            }
            else {
                self.ngModel = {
                    startDate: moment().subtract(1, "d"),
                    endDate: moment()
                };
            }
        }
        self.$mdDialog.show(timeSpanDialogs.absoluteDialog(self.ngModel)).then(function (timeSpan) {
            self._ngModel = timeSpan;
            self.$window.localStorage.setItem(self.$rootScope.user + '.tsdStartDate', timeSpan.startDate.valueOf());
            self.$window.localStorage.setItem(self.$rootScope.user + '.tsdEndDate', timeSpan.endDate.valueOf());
            self.$scope.$emit("timeSpanChanged", self.ngModel);
        }, function () {
            self._timeSpan = oldTimeSpan;
        });
    }
}
TimeSpanPickerController.$inject = ["$scope", "$rootScope", "$timeout", "$translate", "$mdDialog", "$window"];
;


/***/ }),
/* 125 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
function duration(duration, $translate) {
    const days = getDays(duration, $translate);
    const hours = getHours(duration, $translate);
    const minutes = getMinutes(duration, $translate);
    let durationArray = [];
    if (days !== undefined) {
        durationArray.push(days);
    }
    if (hours !== undefined) {
        durationArray.push(hours);
    }
    if (minutes !== undefined) {
        durationArray.push(minutes);
    }
    return durationArray.join(", ");
}
exports.duration = duration;
function getDays(duration, $translate) {
    if (duration.asDays() > 1) {
        let days = Math.floor(duration.asDays());
        return days === 1 ? $translate.instant("humanize.day") : $translate.instant("humanize.days", { days: days });
    }
    else if (duration.asDays() === 1) {
        return $translate.instant("humanize.hours", { hours: 24 });
    }
    return;
}
function getHours(duration, $translate) {
    if (duration.hours() > 1) {
        return $translate.instant("humanize.hours", { hours: duration.hours() });
    }
    else if (duration.hours() === 1) {
        if (duration.asHours() === 1) {
            return $translate.instant("humanize.minutes", { minutes: 60 });
        }
        else {
            return $translate.instant("humanize.hour");
        }
    }
    else {
        return;
    }
}
function getMinutes(duration, $translate) {
    if (duration.minutes() > 1) {
        return $translate.instant("humanize.minutes", { minutes: duration.minutes() });
    }
    else if (duration.minutes() === 1) {
        if (duration.asMinutes() === 1) {
            return $translate.instant("humanize.seconds", { seconds: 60 });
        }
        else {
            return $translate.instant("humanize.minute");
        }
    }
    else {
        return;
    }
}


/***/ }),
/* 126 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
const moment = __webpack_require__(6);
const absoluteTimeSpanDialogTemplate = /*html*/ `
    <md-dialog>
        <form name="datepicker" ng-submit="$ctrl.apply()" autofocus>
            <md-dialog-content class="md-dialog-content">
                <h2 class="md-title">{{'event_query.timespan.title'| translate}}</h2>
                <div layout="column">
                    <div layout="row" moment-picker="$ctrl.startDate" max-date="$ctrl.maxStartDate" min-view="month" max-view="hour" today="true">
                        <md-input-container style="margin-bottom: 0px;">
                            <label>{{'event_query.timespan.from'| translate}}</label>
                            <input name="from" ng-model="$ctrl.formattedStartDate" readonly required>
                            <div ng-messages="datepicker.from.$error">
                                <div ng-message="$ctrl.valid">{{'event_query.timespan.invalid'| translate}}</div>
                            </div>
                        </md-input-container>
                    </div>
                    <div layout="row" moment-picker="$ctrl.endDate" min-date="$ctrl.minEndDate" min-view="month" max-view="hour" today="true">
                        <md-input-container style="margin-bottom: 0px;">
                            <label>{{'event_query.timespan.to'| translate}}</label>
                            <input name="to" id="submitButton" ng-model="$ctrl.formattedEndDate" readonly required>
                            <div ng-messages="datepicker.to.$error">
                                <div ng-message="$ctrl.valid">{{'event_query.timespan.invalid'| translate}}</div>
                            </div>
                        </md-input-container>
                    </div>
                </div>
            </md-dialog-content>
            <md-dialog-actions layout="row">
                <div class="uxtoolkit" flex>
                    <div class="is--stratus" flex layout="row">
                        <span flex></span>
                        <div class="button button__cancel" ng-click="$ctrl.cancel()">
                            <span>{{'event_query.timespan.cancel'| translate}}</span>
                        </div>
                        <input class="button button__primary" id="sbutton" type="submit" value="{{'event_query.timespan.ok'| translate}}"  md-autofocus>
                    </div>
                </div>
            </md-dialog-actions>
        </form>
    </md-dialog>`;
class AbsoluteTimeSpanDialogController {
    constructor($scope, $rootScope, $timeout, $mdDialog, $window, eventService, timeSpan) {
        this.$scope = $scope;
        this.$rootScope = $rootScope;
        this.$timeout = $timeout;
        this.$mdDialog = $mdDialog;
        this.$window = $window;
        this.eventService = eventService;
        this.valid = false;
        this.startDate = moment(timeSpan.startDate);
        this.endDate = moment(timeSpan.endDate);
    }
    $onInit() {
    }
    get startDate() {
        return this._startDate;
    }
    set startDate(startDate) {
        this._startDate = startDate;
        this.minEndDate = moment(this._startDate).add(1, "minute");
        this.valid = moment(this._startDate).isBefore(moment(this._endDate));
        this.formattedStartDate = moment(this._startDate).format("MM/DD/YYYY hh:mm A");
    }
    get endDate() {
        return this._endDate;
    }
    set endDate(endDate) {
        this._endDate = endDate;
        this.maxStartDate = moment(this._endDate).subtract(1, "minute");
        this.valid = moment(this._startDate).isBefore(moment(this._endDate));
        this.formattedEndDate = moment(this._endDate).format("MM/DD/YYYY hh:mm A");
    }
    apply() {
        let timeSpan = {
            startDate: moment(this.startDate),
            endDate: moment(this.endDate)
        };
        this.$mdDialog.hide(timeSpan);
    }
    cancel() {
        this.$mdDialog.cancel();
    }
}
function absoluteDialog(timeSpan) {
    return {
        controller: AbsoluteTimeSpanDialogController,
        controllerAs: "$ctrl",
        locals: {
            timeSpan: timeSpan
        },
        template: absoluteTimeSpanDialogTemplate,
        clickOutsideToClose: false,
        fullscreen: false
    };
}
exports.absoluteDialog = absoluteDialog;
const relativeTimeSpanDialogTemplate = /*html*/ `
    <md-dialog>
        <form name="datepicker" ng-submit="$ctrl.apply()">
            <md-dialog-content class="md-dialog-content">
                <h2 class="md-title">Time Span</h2>
                    <div layout="column">
                        <div layout="row">
                            <md-input-container style="margin-bottom: 0px; width: 120px;">
                                <label>{{"event_query.timespan.days" | translate}}</label>
                                <input id="days" type="number" min="0" max="3653" ng-model="$ctrl.days" ng-blur="$ctrl.blur()"  md-autofocus>
                            </md-input-container>
                            <md-input-container style="margin-bottom: 0px; width: 120px;">
                                <label>{{"event_query.timespan.hours" | translate}}</label>
                                <input type="number" min="0" max="24" ng-model="$ctrl.hours" ng-blur="$ctrl.blur()">
                            </md-input-container>
                            <md-input-container style="margin-bottom: 0px; width: 120px;">
                                <label>{{"event_query.timespan.minutes" | translate}}</label>
                                <input type="number" min="0" max="60" ng-model="$ctrl.minutes" ng-blur="$ctrl.blur()">
                            </md-input-container>
                        </div>
                        <div ng-if="$ctrl.of !== undefined" layout="row" moment-picker="$ctrl.of" min-view="month" max-view="hour" today="true" flex>
                            <md-input-container style="margin-bottom: 0px;" flex>
                                <label>{{'event_query.timespan.of'| translate}}</label>
                                <input ng-model="$ctrl.formattedOf" readonly>
                            </md-input-container>
                        </div>
                    </div>
            </md-dialog-content>
            <md-dialog-actions layout="row">
                <div class="uxtoolkit" flex>
                    <div class="is--stratus" flex layout="row">
                        <span flex></span>
                        <div class="button button__cancel" ng-click="$ctrl.cancel()">
                            <span>{{'event_query.timespan.cancel'| translate}}</span>
                        </div>
                        <input class="button button__primary" type="submit" ng-class="{'is--disabled': ($ctrl.duration.asMinutes() === 0) }" value="{{'event_query.timespan.ok'| translate}}">
                    </div>
                </div>
            </md-dialog-actions>
        </form>
    </md-dialog>`;
class RelativeTimeSpanDialogController {
    constructor($timeout, $mdDialog, duration, of) {
        this.$timeout = $timeout;
        this.$mdDialog = $mdDialog;
        this.valid = false;
        this.minutes = duration.minutes();
        this.hours = duration.hours();
        this.days = Math.floor(duration.asDays());
        this._of = of;
    }
    get minutes() {
        return this._minutes;
    }
    set minutes(minutes) {
        if (minutes < 0) {
            this._minutes = 0;
        }
        else {
            this._minutes = minutes;
        }
    }
    get hours() {
        return this._hours;
    }
    set hours(hours) {
        if (hours < 0) {
            this._hours = 0;
        }
        else {
            this._hours = hours;
        }
    }
    get days() {
        return this._days;
    }
    set days(days) {
        if (days < 0) {
            this._days = 0;
        }
        else {
            this._days = days;
        }
    }
    get of() {
        return this._of;
    }
    set of(of) {
        this._of = of;
        this.formattedOf = moment(this._of).format("MM/DD/YYYY hh:mm A");
    }
    get duration() {
        let duration = moment.duration();
        if (this.minutes !== undefined && this.minutes !== null) {
            duration.add(this.minutes, "m");
        }
        if (this.hours !== undefined && this.hours !== null) {
            duration.add(this.hours, "h");
        }
        if (this.days !== undefined && this.days !== null) {
            duration.add(this.days, "d");
        }
        return duration;
    }
    blur() {
        if (this.minutes === null || this.minutes === undefined) {
            this.minutes = 0;
        }
        if (this.hours === null || this.hours === undefined) {
            this.hours = 0;
        }
        if (this.days === null || this.days === undefined) {
            this.days = 0;
        }
    }
    apply() {
        if (this.duration.asMinutes() !== 0) {
            this.$mdDialog.hide({ duration: this.duration, of: moment(this._of) });
        }
    }
    cancel() {
        this.$mdDialog.cancel();
    }
}
function relativeDialog(duration) {
    return {
        controller: RelativeTimeSpanDialogController,
        controllerAs: "$ctrl",
        locals: {
            duration: duration,
            of: undefined
        },
        template: relativeTimeSpanDialogTemplate,
        clickOutsideToClose: false,
        fullscreen: false
    };
}
exports.relativeDialog = relativeDialog;
function withinDialog(duration, of) {
    return {
        controller: RelativeTimeSpanDialogController,
        controllerAs: "$ctrl",
        locals: {
            duration: duration,
            of: of
        },
        template: relativeTimeSpanDialogTemplate,
        clickOutsideToClose: false,
        fullscreen: false
    };
}
exports.withinDialog = withinDialog;


/***/ }),
/* 127 */
/***/ (function(module, exports, __webpack_require__) {

var content = __webpack_require__(128);
content = content.__esModule ? content.default : content;

if (typeof content === 'string') {
  content = [[module.i, content, '']];
}

var options = {}

options.insert = "head";
options.singleton = false;

var update = __webpack_require__(9)(content, options);

if (content.locals) {
  module.exports = content.locals;
}


/***/ }),
/* 128 */
/***/ (function(module, exports, __webpack_require__) {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(8);
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.i, ".TimeSpanPicker md-select-menu {\n    max-height: 600px;\n}\n\n.TimeSpanPicker md-select-menu md-content {\n    max-height: 600px;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),
/* 129 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//EventsService.js
const angular = __webpack_require__(3);
const moment = __webpack_require__(6);
const SimpleEventFilter_1 = __webpack_require__(15);
const RawEventFilter_1 = __webpack_require__(20);
const FROM = "from";
class EventService {
    constructor($http, $q, baseUrl, eventSchemaService, eventArchiveService, eventServicePath, threatIntelPath) {
        this.$http = $http;
        this.$q = $q;
        this.baseUrl = baseUrl;
        this.eventSchemaService = eventSchemaService;
        this.eventArchiveService = eventArchiveService;
        this.eventServicePath = eventServicePath;
        this.threatIntelPath = threatIntelPath;
        this.TranslationMode = {
            noTranslation: 0,
            enumeratedValues: 1,
            enumeratedValuesAndAttributeNames: 2,
            verbose: 3
        };
        let self = this;
        //Starting with known default indexed fields
        self.indexedFields = ["category_id", "type", "type_id", "id", "severity_id", "device_name", "device_ip", "device_os_name", "device_group", "user_name", "product_name", "product_ver", "feature_name", "feature_ver"];
        //Retrieve the indexed fields from the server.
        $http({
            method: 'POST',
            url: this.baseUrl + this.eventServicePath,
            headers: { 'Content-Type': 'application/json' },
            data: "{id: 10}"
        }).then(function (response) {
            self.indexedFields = response.data;
        }, function (errorResponse) {
            console.log("Unable to get indexed fields, using known defaults", errorResponse);
        });
    }
    getIndexedFields() {
        return this.indexedFields;
    }
    isIndexed(field) {
        var convertedField = field.replace(/\./g, "$");
        return this.getIndexedFields().indexOf(field) >= 0;
    }
    ;
    getEventCounts(query, daemon = false) {
        let self = this;
        const defer = this.$q.defer();
        const eventCounts = {};
        eventCounts.id = 7;
        if (query.timeSpan.recent !== undefined) {
            eventCounts.timespan = query.timeSpan.recent * 60;
        }
        else {
            eventCounts.start = this.getStartDate(query.timeSpan);
            eventCounts.end = this.getEndDate(query.timeSpan);
        }
        eventCounts[FROM] = this.eventArchiveService.expandArchives(query.archives);
        eventCounts.time_field = "log_time";
        this.configureResolution(query, eventCounts);
        if (query.query) {
            eventCounts.where = query.query.toString();
        }
        this.execute(eventCounts, daemon).then(function (response) {
            if (response.data !== undefined && response.data.length > 0) {
                defer.resolve(response.data);
            }
            else {
                //For recent queries that return no data, requery last 24hrs.
                if (query.timeSpan.recent !== undefined) {
                    let timeSpan = {
                        relative: query.timeSpan.recent
                    };
                    eventCounts.start = self.getStartDate(timeSpan);
                    eventCounts.end = self.getEndDate(timeSpan);
                    delete eventCounts.timespan;
                    self.execute(eventCounts, daemon).then(function (response) {
                        if (response.data !== undefined && response.data.length > 0) {
                            defer.resolve(response.data);
                        }
                        else {
                            defer.reject({ status: 500 });
                        }
                    }, function (errorResponse) {
                        defer.reject({ status: errorResponse.status, message: errorResponse.data.message });
                    });
                }
                else {
                    //Unknown data.
                    defer.reject({ status: 500 });
                }
            }
        }, function (errorResponse) {
            defer.reject({ status: errorResponse.status, message: errorResponse.data.message });
        });
        return defer.promise;
    }
    ;
    getEvents(query, mode) {
        var defer = this.$q.defer();
        var eventSearch = {};
        eventSearch.id = 1;
        eventSearch.limit = query.limit;
        eventSearch.translate = mode;
        if (query.timeSpan.recent !== undefined) {
            eventSearch.timespan = query.timeSpan.recent * 60;
        }
        else {
            eventSearch.start = this.getStartDate(query.timeSpan);
            eventSearch.end = this.getEndDate(query.timeSpan);
        }
        eventSearch[FROM] = this.eventArchiveService.expandArchives(query.archives);
        //eventSearch.flatten = true;
        if (query.query !== undefined) {
            eventSearch.where = query.query.toString();
        }
        if (query.filter !== undefined) {
            eventSearch.filter = query.filter.toString();
        }
        if (query.next) {
            eventSearch.next = query.next;
        }
        this.execute(eventSearch, false).then(function (response) {
            if (response.status === 204) {
                defer.resolve({ result: [] });
                return;
            }
            let events = [];
            for (let event of response.data.result) {
                events.push(event);
            }
            response.data.result = events;
            defer.resolve(response.data);
        }, function (errorResponse) {
            defer.reject(errorResponse.status);
        });
        return defer.promise;
    }
    ;
    getEvent(eventId) {
        var defer = this.$q.defer();
        var eventSearch = {};
        eventSearch.id = 0;
        eventSearch.uuid = eventId;
        this.$http({
            method: 'POST',
            url: this.baseUrl + this.eventServicePath,
            headers: { 'Content-Type': 'application/json' },
            data: JSON.stringify(eventSearch)
        }).then(function (response) {
            defer.resolve(response.data);
        }, function (errorResponse) {
            defer.reject(errorResponse);
        });
        return defer.promise();
    }
    getTopN(query, daemon = false) {
        var defer = this.$q.defer();
        var topN = {
            version: 2,
            id: 3,
            field: query.field,
            limit: query.limit
        };
        if (query.timeSpan.recent !== undefined) {
            topN.timespan = query.timeSpan.recent * 60;
        }
        else {
            topN.start = this.getStartDate(query.timeSpan);
            topN.end = this.getEndDate(query.timeSpan);
        }
        topN[FROM] = this.eventArchiveService.expandArchives(query.archives);
        if (query.query) {
            topN.where = query.query.toString();
        }
        this.$http({
            method: 'POST',
            url: this.baseUrl + this.eventServicePath,
            headers: { 'Content-Type': 'application/json', 'X-Daemon': daemon },
            data: JSON.stringify(topN)
        }).then(function (response) {
            defer.resolve({
                data: response.data,
            });
        }, function (errorResponse) {
            defer.reject(errorResponse.status);
        });
        return defer.promise;
    }
    ;
    execute(payload, daemon) {
        return this.$http({
            method: 'POST',
            url: this.baseUrl + this.eventServicePath,
            headers: { 'Content-Type': 'application/json', 'X-Daemon': daemon },
            data: JSON.stringify(payload)
        });
    }
    getTimeInterval(timeIntervalString) {
        let multiplier = Math.abs(timeIntervalString.substring(0, timeIntervalString.length - 1));
        let resolution = this.getResolution(timeIntervalString);
        switch (resolution) {
            case "s":
                return multiplier * 1000;
            case "m":
                return multiplier * 60 * 1000;
            case "h":
                return multiplier * 60 * 60 * 1000;
            case "d":
                return multiplier * 24 * 60 * 60 * 1000;
        }
    }
    getResolution(timeIntervalString) {
        return timeIntervalString.substring(timeIntervalString.length - 1, timeIntervalString.length);
    }
    ;
    convertFilter(eventFilter) {
        const defer = this.$q.defer();
        this.$http({
            method: 'POST',
            url: this.baseUrl + this.eventServicePath,
            headers: { 'Content-Type': 'application/json' },
            data: JSON.stringify({ id: 11, where: eventFilter.toString() })
        }).then(function (response) {
            try {
                if (eventFilter.type === "raw") {
                    if (response.data === "") {
                        defer.resolve(new SimpleEventFilter_1.default());
                    }
                    else {
                        defer.resolve(SimpleEventFilter_1.default.fromJson(JSON.parse(response.data)));
                    }
                }
                else {
                    defer.resolve(new RawEventFilter_1.default(response.data));
                }
                eventFilter.valid = true;
            }
            catch (syntaxError) {
                eventFilter.valid = false;
                defer.reject(syntaxError);
            }
        }, function (errorResponse) {
            eventFilter.valid = false;
            defer.reject({ status: errorResponse.status, message: errorResponse.data.message });
        });
        return defer.promise;
    }
    /**
     * Convert the where clause to a event service query string.
     */
    buildSearchText(where) {
        var esWhere = "";
        angular.forEach(where, function (clause) {
            if (esWhere !== "") {
                esWhere += " AND ";
            }
            var field;
            if (typeof (clause.field) === 'string') {
                field = clause.field.split('.');
            }
            else {
                field = clause.field.slice();
            }
            var eventType = field.shift();
            var eventSchema = this.getSchemaByPath(eventType);
            let schema = this.getSchemaByPath(clause.field, true);
            var value;
            switch (schema.type) {
                case 'integer':
                case 'boolean':
                    value = clause.value;
                    break;
                case 'string':
                case 'url':
                default:
                    value = '"' + clause.value + '"';
                    //Event service needs the \ escaped.
                    value = value.replace(/\\/gi, "\\\\");
                    break;
            }
            if (eventType === "base") {
                esWhere += field.join(".") + " " + clause.operator + " " + value;
            }
            else {
                schema = this.getSchemaByType(eventType);
                esWhere += field.join(".") + " " + clause.operator + " " + value;
                if (field != "type_id") {
                    esWhere = "(" + esWhere + " AND type_id=" + eventSchema.type_id + ")";
                }
            }
        });
        return esWhere;
    }
    getStartDate(timeSpan) {
        if (timeSpan.relative !== undefined) {
            return moment().endOf('second').add(1, 'ms').subtract(timeSpan.relative, 'minutes').valueOf();
        }
        else if (timeSpan.recent !== undefined) {
            return moment().endOf('second').add(1, 'ms').subtract(timeSpan.recent, 'minutes').valueOf();
        }
        else if (timeSpan.within !== undefined) {
            return moment(timeSpan.of).add(1, "ms").subtract(timeSpan.within, "minutes").valueOf();
        }
        else {
            return moment(timeSpan.startDate).valueOf();
        }
    }
    getEndDate(timeSpan) {
        if (timeSpan.relative !== undefined) {
            return moment().endOf('second').add(1, 'ms').valueOf();
        }
        else if (timeSpan.within !== undefined) {
            return moment(timeSpan.of).add(1, "ms").add(timeSpan.within, "minutes").valueOf();
        }
        else {
            return moment(timeSpan.endDate).valueOf();
        }
    }
    configureResolution(query, eventCounts) {
        let start = moment(this.getStartDate(query.timeSpan));
        let end = moment(this.getEndDate(query.timeSpan));
        let window = end.valueOf() - start.valueOf();
        let time;
        let offset;
        let resolution = "1m";
        if (window >= 7 * 24 * 60 * 60 * 1000) {
            resolution = "1d";
            start.startOf("day");
            end.endOf("day").add(1, "milliseconds");
        }
        else if (window >= 48 * 60 * 60 * 1000) {
            resolution = "1h";
            start.startOf("hour");
            end.endOf("hour").add(1, "milliseconds");
        }
        else if (window >= 24 * 60 * 60 * 1000) {
            resolution = "10m";
            start.startOf("minute");
            time = start.minute();
            offset = time % 10;
            start.subtract(offset, "minutes");
            end.endOf("minute").add(1, "milliseconds");
            time = end.minute();
            offset = 10 - time % 10;
            end.add(offset, "minutes");
        }
        else if (window >= 4 * 60 * 60 * 1000) {
            resolution = "5m";
            start.startOf("minute");
            time = start.minute();
            offset = time % 5;
            start.subtract(offset, "minutes");
            end.endOf("minute").add(1, "milliseconds");
            time = end.minute();
            offset = 5 - time % 5;
            end.add(offset, "minutes");
        }
        else if (window >= 30 * 60 * 1000) {
            resolution = "1m";
            start.startOf("minute");
            end.endOf("minute").add(1, "milliseconds");
        }
        else {
            resolution = "1s";
            start.startOf("second");
            time = start.second();
            offset = time % 15;
            start.subtract(offset, "second");
            end.endOf("second").add(1, "milliseconds");
            time = end.second();
            offset = 15 - time % 15;
            end.add(offset, "second");
        }
        eventCounts.start = start.valueOf();
        eventCounts.end = end.valueOf();
        eventCounts.time_interval = resolution;
    }
    /**
     * Given an array of archives, any generic archive is expanded to include it's list of specific archives. For example, "all" will expand to all the collector archives included the default archive but won't include the system archive or any OpenC2 archives.
     *
     * @return an array of archives.
     */
    expandArchives(archives) {
        let archivesSet = new Set();
        for (let archive of archives) {
            switch (archive) {
                case "all":
                    break;
                default:
                    archivesSet.add(archive);
                    break;
            }
        }
        return Array.from(archivesSet);
    }
}
exports.default = EventService;
EventService.$inject = ['$http', '$q', 'baseUrl', 'eventSchemaService', 'eventArchiveService', 'eventServicePath', 'threatIntelPath'];
;
class EventServiceError {
}
exports.EventServiceError = EventServiceError;


/***/ }),
/* 130 */,
/* 131 */,
/* 132 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//EventDetailsModule.ts
const angular = __webpack_require__(3);
const ngTranslate = __webpack_require__(10);
const ngMaterial = __webpack_require__(11);
const EventDetailsFactory_1 = __webpack_require__(133);
exports.default = angular.module('ev.eventdetails', [
    ngMaterial,
    ngTranslate
])
    .factory('eventDetails', EventDetailsFactory_1.default)
    .factory('translationCache', ['$cacheFactory', function ($cacheFactory) {
        return $cacheFactory('translation-cache');
    }])
    .name;


/***/ }),
/* 133 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
__webpack_require__(134);
//Bundling the HTML files defined in the routes
var eventDetailsTemplate = /*html*/ `
    <md-dialog>
        <div class="uxtoolkit" layout-margin layout="row" style="height: 150px;">
            <div class="is--stratus" layout="row" flex>
                <span class="type__tertiary-headline" flex>{{'event_details.title'| translate}}</span>
            </div>
        </div>
        <md-dialog-content layout="row" tabindex="-1" name="eventDetailsDialogContent" layout-padding layout-wrap>
            <md-table-container>
                <table md-table style="width: 100%">
                    <thead md-head md-order="$ctrl.sortColumn">
                        <tr md-row>
                            <th md-column minwidth="15%" md-order-by="translatedName">Attribute</th>
                            <th md-column>Value</th>
                        </tr>
                    </thead>
                    <tbody md-body>
                        <tr md-row ng-repeat="attribute in $ctrl.attributes | orderBy: $ctrl.sortColumn" style="outline: none;">
                            <td md-cell style="vertical-align: text-top; vertical-align: top;">
                                <p layout="column">
                                    <span><b>{{attribute.translatedName}}</b></span>
                                    <span style="padding-top: 2px; font-size: 8pt; color:gray">{{attribute.name}}</span>
                                </p>
                            </td>
                            <td md-cell style="vertical-align: text-top; vertical-align: top; display: table-cell; white-space: normal;">
                                <p>
                                    <event-renderer type_id="$ctrl.event.type_id" column="$ctrl.event.schema.name + '.' + attribute.name" value="attribute.value" white-space-pre-wrap="true" flex></event-renderer>
                                </p>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </md-table-container>
        </md-dialog-content>
        <md-dialog-actions layout="row">
            <span flex></span>
            <div class="uxtoolkit" layout="row" style="overflow: hidden">
                <div class="is--stratus" layout="row">
                    <div class="button button__primary" ng-click="$ctrl.close()">
                        <span>{{'dialog.close' | translate}}</span>
                    </div>
                </div>
            </div>
        </md-dialog-actions>
    </md-dialog>`;
class EventDetailsController {
    constructor($scope, $mdDialog, $filter, eventSchemaService, event) {
        this.$scope = $scope;
        this.$mdDialog = $mdDialog;
        this.$filter = $filter;
        this.eventSchemaService = eventSchemaService;
        this.event = event;
        this.sortColumn = "translatedName";
        this.attributes = [];
        let typeId = event["type_id"];
        let schema = typeId === undefined ? undefined : eventSchemaService.getSchemaByTypeId(typeId);
        for (let attributeName of Object.keys(this.event)) {
            if (attributeName === "$$hashKey" || attributeName === "schema" || attributeName.indexOf(":") != -1) {
                continue;
            }
            this.attributes.push({
                name: attributeName,
                translatedName: (event[attributeName].translation == undefined ? attributeName : event[attributeName].translation),
                value: event[attributeName].value,
            });
        }
    }
    close() {
        this.$mdDialog.hide();
    }
    ;
}
EventDetailsController.$inject = ["$scope", "$mdDialog", "$filter", 'eventSchemaService', 'event'];
;
class EventDetailsFactory {
    constructor($mdDialog) {
        this.$mdDialog = $mdDialog;
        this.showEvent = function (event, onCloseDialog) {
            this.$mdDialog.show({
                controller: EventDetailsController,
                controllerAs: "$ctrl",
                locals: {
                    event: event
                },
                template: eventDetailsTemplate,
                clickOutsideToClose: true,
                fullscreen: false,
                onComplete: function () {
                    // To enable browser keyboard scrolling for element:
                    // 1) We need to set tabindex="-1" to make md-dialog-content element focusable, but to be skipped in tabulation order
                    // 2) We have to set focus to dialog content element, because scroll belongs to dialog content.
                    // We cannot use element ID here, because md-dialog-content overrides it by own internal logic, so "name" attribute is used.
                    const elements = document.getElementsByName("eventDetailsDialogContent");
                    if (elements.length > 0) {
                        elements[0].focus();
                    }
                }
            }).then(() => {
                if (onCloseDialog) {
                    onCloseDialog();
                }
            }, () => {
                if (onCloseDialog) {
                    onCloseDialog();
                }
            });
        };
    }
}
exports.default = EventDetailsFactory;
;


/***/ }),
/* 134 */
/***/ (function(module, exports, __webpack_require__) {

var content = __webpack_require__(135);
content = content.__esModule ? content.default : content;

if (typeof content === 'string') {
  content = [[module.i, content, '']];
}

var options = {}

options.insert = "head";
options.singleton = false;

var update = __webpack_require__(9)(content, options);

if (content.locals) {
  module.exports = content.locals;
}


/***/ }),
/* 135 */
/***/ (function(module, exports, __webpack_require__) {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(8);
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.i, ".event-details-container {\n  .event-details-headline {\n    font-size: 30px;\n  }\n  .event-details {\n    .event-detail {\n      float: left;\n      border-style: solid;\n      border-width: 1px;\n    }\n  }\n}\n\nmd-input-container textarea[md-no-autogrow].md-input {\n    height: inherit;\n    overflow-y: auto;\n}\n", ""]);
// Exports
module.exports = exports;


/***/ }),
/* 136 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//EventListComponent.ts
const angular = __webpack_require__(3);
const moment = __webpack_require__(6);
const $ = __webpack_require__(16);
__webpack_require__(137);
const SimpleEventFilter_1 = __webpack_require__(15);
const Condition_1 = __webpack_require__(26);
const EventTools_1 = __webpack_require__(44);
const schema_browser_1 = __webpack_require__(12);
const ColumnPickerController_1 = __webpack_require__(139);
const GlobalIcons_1 = __webpack_require__(18);
//Bundling the HTML files defined in the routes
let columnPickerTemplate = __webpack_require__(140);
let eventlistTemplate = __webpack_require__(141);
let eventlistContextMenu = /*html*/ `<md-card>
    <md-list>
        <div ng-if="ctrl.isFilterable && ctrl.value !== undefined && ctrl.attribute.attributeType.name !== 'log_time'">
            <md-subheader class="md-no-sticky">Filter By</md-subheader>
            <md-list-item ng-click="drilldown('=')">
                <icon-button icon="filterIcon" />
                <span class="event-filter-attribute">{{ctrl.attributeName | translateColumns: ctrl.events: ctrl.translationCache}}</span>
                <span style="padding-left: 5px; padding-right: 5px;">=</span>
                <event-renderer class="event-filter-value" type-id="ctrl.event.schema.typeId" translated-enum="ctrl.translatedEnum" column="ctrl.attributeName" value="ctrl.value" flex></event-renderer>
            </md-list-item>
            <md-list-item ng-click="drilldown('!=')">
                <icon-button icon="filterIcon" />
                <span class="event-filter-attribute">{{ctrl.attributeName | translateColumns: ctrl.events: ctrl.translationCache}}</span>
                <span style="padding-left: 5px; padding-right: 5px;">!=</span>
                <event-renderer class="event-filter-value" type-id="ctrl.event.schema.typeId" translated-enum="ctrl.translatedEnum" column="ctrl.attributeName" value="ctrl.value" flex></event-renderer>
            </md-list-item>
            <div ng-if="ctrl.attribute.attributeType.type === 'integer' || ctrl.attribute.attributeType.type === 'datetime'">
                <md-list-item ng-click="drilldown('<')">
                    <icon-button icon="filterIcon" />
                    <span class="event-filter-attribute">{{ctrl.attributeName | translateColumns: ctrl.events: ctrl.translationCache}}</span>
                    <span style="padding-left: 5px; padding-right: 5px;">&lt;</span>
                    <event-renderer class="event-filter-value" type-id="ctrl.event.schema.typeId" translated-enum="ctrl.translatedEnum" column="ctrl.attributeName" value="ctrl.value" flex></event-renderer>
                </md-list-item>
                <md-list-item ng-click="drilldown('>')">
                    <icon-button icon="filterIcon" />
                    <span class="event-filter-attribute">{{ctrl.attributeName | translateColumns: ctrl.events: ctrl.translationCache}}</span>
                    <span style="padding-left: 5px; padding-right: 5px;">&gt;</span>
                    <event-renderer class="event-filter-value" type-id="ctrl.event.schema.typeId" translated-enum="ctrl.translatedEnum" column="ctrl.attributeName" value="ctrl.value" flex></event-renderer>
                </md-list-item>
            </div>
        </div>
        <md-list-item ng-click="within()">
            <icon-button icon="filterIcon" />
            <span class="event-filter-attribute">Within 10 minutes</span>
        </md-list-item>
            <md-divider ></md-divider>
        <md-list-item ng-click="showDetails(ctrl.event)">
            <icon-button icon="detailsIcon" />
            <span>Event Details</span>
        </md-list-item>
    </md-list>
</md-card>`;
class EventListComponent {
    constructor() {
        this.bindings = {
            query: '<'
        };
        this.controller = EventListController;
        this.template = eventlistTemplate;
    }
}
exports.default = EventListComponent;
EventListComponent.$$ngIsClass = true; //Fix for Firefox
class EventListController {
    constructor($rootScope, $scope, $timeout, $window, $mdDialog, $mdPanel, $translate, $filter, eventService, eventSchemaService, eventDetails, translationCache) {
        this.$rootScope = $rootScope;
        this.$scope = $scope;
        this.$timeout = $timeout;
        this.$window = $window;
        this.$mdDialog = $mdDialog;
        this.$mdPanel = $mdPanel;
        this.$translate = $translate;
        this.$filter = $filter;
        this.eventService = eventService;
        this.eventSchemaService = eventSchemaService;
        this.eventDetails = eventDetails;
        this.translationCache = translationCache;
        this.attributeContextMenu = function ($mouseEvent, event, events, translationCache) {
            let self = this;
            let element = $mouseEvent.target;
            while (element !== undefined && element.localName !== "td") {
                element = element.parentElement;
            }
            let tdElement = element;
            let attribute;
            if (event.type_id !== undefined) {
                attribute = new schema_browser_1.Attribute("@" + event.type_id.enum + ":" + tdElement.id);
            }
            else {
                attribute = new schema_browser_1.Attribute(tdElement.id);
            }
            var position = self.$mdPanel.newPanelPosition()
                .relativeTo($mouseEvent.target)
                .addPanelPosition(self.$mdPanel.xPosition.ALIGN_START, self.$mdPanel.yPosition.BELOW);
            var config = {
                attachTo: angular.element(document.body),
                controller: function (mdPanelRef) {
                    self.contextMenuPanelRef = mdPanelRef;
                    this.$scope.filterIcon = GlobalIcons_1.FilterIcon;
                    this.$scope.detailsIcon = GlobalIcons_1.DetailsIcon;
                    let configSelf = this;
                    configSelf.event = event;
                    configSelf.events = events;
                    configSelf.translationCache = translationCache;
                    configSelf.attribute = attribute;
                    configSelf.attributeName = attribute.pathElements[0];
                    configSelf.value = event[configSelf.attributeName]["enum"];
                    if (configSelf.value === undefined) {
                        configSelf.value = event[configSelf.attributeName]["value"];
                    }
                    configSelf.isFilterable = true;
                    if (typeof (configSelf.value) === "string" && (configSelf.value.startsWith("[") || configSelf.value.startsWith("{"))
                        || event[configSelf.attributeName]["isNotFilterable"]) {
                        configSelf.isFilterable = false;
                    }
                    let prefix = "";
                    //If the attribute values are not derived, include the event type id.
                    if (configSelf.event.type_id.enum !== undefined && configSelf.attribute.attributeType !== undefined && !configSelf.attribute.attributeType.derived) {
                        prefix = "@" + configSelf.event.type_id.enum + ":";
                    }
                    if (configSelf.event[configSelf.attributeName] != undefined && configSelf.event[configSelf.attributeName]["enum"] != undefined) {
                        configSelf.translatedEnum = configSelf.event[configSelf.attributeName]["value"];
                    }
                    /**
                     * Applies a filter to the selected event key and value.
                     */
                    this.$scope.drilldown = function (operator) {
                        let condition = new Condition_1.default(new schema_browser_1.Attribute(prefix + configSelf.attributeName.replace(":", ".")), operator, configSelf.value);
                        delete self.query.next;
                        self.closeContextMenu();
                        self.$scope.$broadcast("drilldown", condition);
                        self.execute();
                    };
                    /**
                     * Applies a filter to the selected event key and value.
                     */
                    this.$scope.within = function () {
                        self.$scope.$emit("timeSpanChanged", {
                            within: 10,
                            of: configSelf.event.log_time
                        });
                        self.closeContextMenu();
                    };
                    this.$scope.showDetails = function (event) {
                        self.showDetails(event);
                    };
                },
                controllerAs: 'ctrl',
                template: eventlistContextMenu,
                panelClass: 'demo-menu-example',
                position: position,
                openFrom: $mouseEvent,
                clickOutsideToClose: true,
                escapeToClose: true,
                focusOnOpen: false,
                zIndex: 2
            };
            self.$mdPanel.open(config);
        };
        this.openMenu = function ($mdOpenMenu, $event) {
            $mdOpenMenu($event);
        };
        this.showColumnPickerDialog = function (ev) {
            let self = this;
            self.$mdDialog.show({
                controller: ColumnPickerController_1.ColumnPickerController,
                locals: {
                    columns: self.columns,
                    visibleColumns: self.visibleColumns,
                    events: self.events
                },
                controllerAs: "$ctrl",
                bindToController: true,
                template: columnPickerTemplate,
                targetEvent: ev,
                clickOutsideToClose: false,
                fullscreen: true
            }).then(function () {
                self.localStorage.setItem(self.$rootScope.user + '.visibleColumns', JSON.stringify(self.visibleColumns));
                self.returnFocusToEventList();
            }, () => self.returnFocusToEventList());
        };
        this.openExportMenu = function ($mdOpenMenu, ev) {
            $mdOpenMenu(ev);
        };
        this.nextPage = function () {
            this.pages.push(this.query.next);
            this.query.next = this.$scope.next;
            this.execute();
        };
        this.localStorage = $window.localStorage;
        this.search = this.search.bind(this);
        this.showColumnPickerDialog = this.showColumnPickerDialog.bind(this);
        this.exportJson = this.exportJson.bind(this);
        $scope.searchIcon = GlobalIcons_1.SearchIcon;
        $scope.columnsIcon = GlobalIcons_1.ColumnsIcon;
    }
    ;
    $onInit() {
        let self = this;
        // Listens for window resize events and updates the event list size.
        angular.element(this.$window).bind('resize', self.resize);
        self.columns = [];
        self.events = [];
        self.pages = [];
        if (self.query.filter === undefined) {
            self.query.filter = new SimpleEventFilter_1.default();
        }
        //todo: on change, save cookie
        // self.$scope.$watch('visibleColumns', function (newValue) {
        //     self.$cookies.putObject('visibleColumns', self.$scope.visibleColumns, { expires: new Date(864000000000000) });
        // }, true);
        /**
         * Watches the event query for changes so the event list can match.
         */
        self.$scope.$on("searchevents", function (event) {
            if (self.query.timeSpan !== undefined) {
                self.execute();
            }
        });
        /**
         * If the sort column goes from desc to asc, instead remove the sorting.
         */
        self.$scope.$watch('sortColumn', function (newValue, oldValue) {
            if (oldValue !== undefined && oldValue.startsWith("-") &&
                oldValue.endsWith(newValue)) {
                self.$scope.sortColumn = undefined;
            }
        }, true);
        self.$scope.renderedEventComparator = function (v1, v2) {
            if (v1.value == null)
                return -1;
            if (v2.value == null)
                return 1;
            return (v1.value.value < v2.value.value) ? -1 : 1;
        };
    }
    /**
     * Calculates where on the page the event list sits and sets
     * it's height to fill the screen.
     */
    resize() {
        let window = this.$window === undefined ? this : this.$window;
        let windowsHeight = angular.element(window).height();
        let eventList = angular.element("#eventlist");
        let paging = angular.element("#eventlist-paging");
        var eventListOffset = eventList.offset().top;
        var height = windowsHeight - eventListOffset - paging.height() - 30;
        eventList.height(height < 300 ? 300 : height);
    }
    returnFocusToEventList() {
        const elements = $('#eventlist .md-row.selected');
        if (elements.length > 0) {
            elements[0].focus();
        }
    }
    keyUp(keyEvent) {
        const self = this;
        let orderedEvents = [];
        if (self.$scope.sortColumn) {
            orderedEvents = self.$filter('orderBy')(self.renderedEvents, self.$scope.sortColumn);
        }
        else {
            orderedEvents = self.renderedEvents;
        }
        if (keyEvent.keyCode === 13) {
            const foundIndex = orderedEvents.findIndex(element => element.uuid === self.selectedEventUuid);
            if (foundIndex >= 0 && foundIndex < orderedEvents.length) {
                this.showDetails(orderedEvents[foundIndex]);
            }
        }
        else if (keyEvent.keyCode === 38) {
            const foundIndex = orderedEvents.findIndex(element => element.uuid === self.selectedEventUuid);
            if (foundIndex > 0) {
                self.selectedEventUuid = orderedEvents[foundIndex - 1].uuid;
            }
        }
        else if (keyEvent.keyCode === 40) {
            const foundIndex = orderedEvents.findIndex(element => element.uuid === self.selectedEventUuid);
            if (foundIndex >= 0 && foundIndex < orderedEvents.length - 1) {
                self.selectedEventUuid = orderedEvents[foundIndex + 1].uuid;
            }
        }
    }
    showDetails(event) {
        const self = this;
        this.eventDetails.showEvent(event, () => {
            self.returnFocusToEventList();
        });
        self.closeContextMenu();
    }
    ;
    exportJson($event) {
        if (this.downloadUrl !== undefined) {
            angular.element(document.body).remove(".download");
            window.URL.revokeObjectURL(this.downloadUrl);
            this.downloadUrl = undefined;
        }
        let self = this;
        let downloadedEvents;
        if (self.$scope.promise) {
            return;
        }
        else {
            self.$scope.promise = self.eventService.getEvents(self.query, self.eventService.TranslationMode.noTranslation);
        }
        self.$scope.promise.then(function (data) {
            let downloadedEvents = [];
            angular.forEach(data.result, function (event) {
                downloadedEvents.push(event);
            });
            let eventsJson = JSON.stringify(downloadedEvents, null, 2);
            let blob = new Blob([eventsJson], { type: "application/octet-stream" });
            self.downloadUrl = window.URL.createObjectURL(blob);
            let downloadLink = angular.element('<a class="download"></a>');
            downloadLink.attr('href', self.downloadUrl);
            downloadLink.attr('download', 'events.json');
            angular.element(document.body).append(downloadLink);
            downloadLink[0].click();
            self.$scope.promise = null;
        }, function (status) {
            self.$scope.error = status;
        });
    }
    ;
    search() {
        delete this.query.next;
        this.execute();
    }
    initDefaultColumnsIfRequired(self) {
        if (self.visibleColumns === undefined) {
            self.visibleColumns = JSON.parse(self.localStorage.getItem(self.$rootScope.user + '.visibleColumns'));
            if (self.visibleColumns === null) {
                self.visibleColumns = [
                    "log_time",
                    "time",
                    "type_id",
                    "event_id",
                    "severity_id",
                    "count",
                    "device_name",
                    "device_ip",
                    "product_name",
                    "product_ver",
                    "message"
                ];
            }
            // add translations for default columns
            self.translationCache["log_time"] = "Collected Time";
            self.translationCache["time"] = "Collected Time";
            self.translationCache["type_id"] = "Type";
            self.translationCache["event_id"] = "Event ID";
            self.translationCache["severity_id"] = "Severity";
            self.translationCache["count"] = "Count";
            self.translationCache["device_name"] = "Device Name";
            self.translationCache["device_ip"] = "Device IP Address";
            self.translationCache["product_name"] = "Product Name";
            self.translationCache["product_ver"] = "Product Version";
            self.translationCache["message"] = "Message";
        }
    }
    execute() {
        let self = this;
        self.initDefaultColumnsIfRequired(self);
        self.$scope.error = 0;
        self.events = [];
        self.renderedEvents = [];
        if (self.query.next === undefined) {
            self.pages = [];
        }
        if (self.$scope.promise) {
            return;
        }
        else {
            self.$scope.promise = self.eventService.getEvents(self.query, self.eventService.TranslationMode.verbose);
        }
        self.$scope.promise.then(function (data) {
            self.events = data.result;
            if (data.next !== undefined && data.next["_value"] !== undefined)
                self.$scope.next = data.next["_value"];
            else
                self.$scope.next = data.next;
            angular.forEach(self.events, function (event) {
                let renderedEvent = self.renderEvent(event);
                EventTools_1.default.addSubColumns(event, renderedEvent);
                self.renderedEvents.push(renderedEvent);
            });
            self.setHeaders();
            self.$scope.promise = null;
            self.$timeout(function () {
                self.resize();
            });
        }, function (status) {
            self.$scope.error = status;
        });
    }
    ;
    setHeaders() {
        let self = this;
        self.columns = [];
        for (let event of self.renderedEvents) {
            for (let [key, value] of Object.entries(event)) {
                if (self.columns.indexOf(key) === -1) {
                    self.columns.push(key);
                }
            }
        }
    }
    renderEvent(event) {
        let self = this;
        var renderedEvent = {};
        let schema = self.eventSchemaService.getSchemaByTypeId(event["type_id"]._value);
        if (schema === undefined) {
            //Default to base schema that all events should conform to.
            schema = self.eventSchemaService.getSchemaByType("base");
        }
        for (let [key, value] of Object.entries(event)) {
            let eventValues = {};
            let eventValue;
            if (value["_enum"] !== undefined) {
                eventValue = value["_enum"];
                eventValues["enum"] = value["_value"];
            }
            else if (value["_value"] !== undefined) {
                if (value["_value"] !== null && typeof (value["_value"]) === "object") {
                    eventValue = EventTools_1.default.stringifyFirstValueFromObject(EventTools_1.default.restoreTranslatedObject(key, value));
                }
                else {
                    eventValue = EventTools_1.default.stringifyIfRequired(value["_value"]);
                }
            }
            else {
                eventValue = EventTools_1.default.stringifyIfRequired(value);
            }
            eventValue = self.renderValue(eventValue, schema.attributes[key]);
            eventValues["translation"] = value["_name"];
            this.translationCache[key] = value["_name"];
            eventValues["value"] = eventValue;
            eventValues["attribute"] = schema.attributes[key];
            renderedEvent[key] = eventValues;
        }
        return renderedEvent;
    }
    renderValue(value, attribute) {
        if (attribute !== undefined) {
            if (attribute.type === "datetime") {
                // Some schema datetime attributes may contain either string or milliseconds
                // When string is passed then we display it 'as is' otherwise we expect UTC time in milliseconds
                //return typeof (value) == "string" ? value : moment.utc(value);
                if (typeof (value) == "string") {
                    return value;
                }
                else {
                    const zone = moment.tz(moment.tz.guess()).zoneAbbr();
                    return `${moment(value).local().format("MM/DD/YYYY HH:mm:ss.SSS")} ${zone}`;
                }
            }
        }
        //For date objects that were not in the schema
        if (value instanceof Date) {
            return moment(value);
        }
        return value;
    }
    closeContextMenu() {
        if (this.contextMenuPanelRef !== undefined) {
            this.contextMenuPanelRef.close();
        }
    }
    select(event) {
        this.selectedEventUuid = event.uuid;
    }
    prevPage() {
        this.query.next = this.pages.pop();
        this.execute();
    }
}
EventListController.$inject = ["$rootScope", "$scope", "$timeout", "$window", "$mdDialog", "$mdPanel", "$translate", "$filter", "eventService", "eventSchemaService", "eventDetails", "translationCache"];
;


/***/ }),
/* 137 */
/***/ (function(module, exports, __webpack_require__) {

var content = __webpack_require__(138);
content = content.__esModule ? content.default : content;

if (typeof content === 'string') {
  content = [[module.i, content, '']];
}

var options = {}

options.insert = "head";
options.singleton = false;

var update = __webpack_require__(9)(content, options);

if (content.locals) {
  module.exports = content.locals;
}


/***/ }),
/* 138 */
/***/ (function(module, exports, __webpack_require__) {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(8);
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.i, ".event-cell {\n    outline: none;\n}\n\ntable.event-table.md-table tbody.md-body>tr.md-row {\n    height: 35px;\n}\n\ntbody>.md-row:hover {\n    background-color: #f2f2f2;\n}\n\ntbody>.md-row.selected {\n    background-color: #dcdcdc;\n}\n\nmd-tooltip {\n    z-index: 100 !important;\n    background-color: white !important;\n    color: rgb(81, 81, 81) !important;\n    opacity: 1 !important;\n    border: 1px #e5e5e5 solid !important;\n    border-radius: 4px !important;\n    box-sizing: border-box !important;\n    height: auto !important;\n    max-width: 800px !important;\n    max-height: 400px !important;\n    white-space: pre-wrap !important;\n    padding: 8px 8px 8px 8px !important;\n    font-size: 0.875em !important;\n}\n\n.event-filter-attribute {\n    max-width: 800px;\n    text-overflow: ellipsis;\n}\n\n.event-filter-value {\n    max-width: 800px;\n    white-space: nowrap;\n    overflow: hidden;\n    text-overflow: ellipsis;\n}\n\n.eventlist-actions {\n    display: flex;\n    flex-direction: row;\n    align-items: flex-end;\n    margin: 0 8px;\n    height: 46px;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),
/* 139 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

//ColumnPickerController.ts
Object.defineProperty(exports, "__esModule", { value: true });
class ColumnPickerController {
    constructor($mdDialog, $filter, columns, visibleColumns, events, translationCache) {
        /*
         * Columns that will be visible in the event list.
         */
        this.$mdDialog = $mdDialog;
        this.$filter = $filter;
        this.visibleColumns = visibleColumns;
        this.events = events;
        this.translationCache = translationCache;
        /*
         * Available columns are a list of non-visible columns that can be added to the visibile column
         * list.
         */
        this.availableColumns = [];
        for (let column of columns) {
            if (this.visibleColumns.indexOf(column) < 0) {
                this.availableColumns.push(column);
            }
        }
    }
    close() {
        this.$mdDialog.hide();
    }
    ;
    /**
     * Makes a column visible in the event list. The column is removed from the available column array and added to the visible column array.
     */
    makeVisible(column) {
        this.visibleColumns.push(column);
        this.availableColumns = this.availableColumns.filter((availableColumn) => availableColumn !== column);
    }
    ;
    /**
     * Makes a column invisible in the event list. The column is removed from the visible column array and added to the available column array.
     */
    makeInvisible(column) {
        this.availableColumns.push(column);
        this.visibleColumns.splice(this.visibleColumns.indexOf(column), 1);
    }
    ;
    /**
     * Moves a column in the visible list up one space if it isn't at the top.
     */
    moveColumnUp(column) {
        const columnIndex = this.visibleColumns.indexOf(column);
        if (columnIndex !== 0) {
            let swapValue = this.visibleColumns[columnIndex - 1];
            this.visibleColumns[columnIndex - 1] = column;
            this.visibleColumns[columnIndex] = swapValue;
        }
    }
    ;
    /**
     * Moves a column in the visible list up one space if it isn't at the Bottom.
     */
    moveColumnDown(column) {
        const columnIndex = this.visibleColumns.indexOf(column);
        if (columnIndex !== this.visibleColumns.length - 1) {
            let swapValue = this.visibleColumns[columnIndex + 1];
            this.visibleColumns[columnIndex + 1] = column;
            this.visibleColumns[columnIndex] = swapValue;
        }
    }
    ;
    moveColumnTop(column) {
        const columnIndex = this.visibleColumns.indexOf(column);
        if (columnIndex > 0) {
            this.visibleColumns.splice(columnIndex, 1);
            this.visibleColumns.unshift(column);
        }
    }
    ;
    moveColumnBottom(column) {
        const columnIndex = this.visibleColumns.indexOf(column);
        if (columnIndex >= 0 && columnIndex !== this.visibleColumns.length - 1) {
            this.visibleColumns.push(...this.visibleColumns.splice(columnIndex, 1));
        }
    }
    ;
}
exports.ColumnPickerController = ColumnPickerController;
ColumnPickerController.$inject = ["$mdDialog", "$filter", "columns", "visibleColumns", "events", "translationCache"];


/***/ }),
/* 140 */
/***/ (function(module, exports) {

var angular=window.angular,ngModule;
try {ngModule=angular.module(["ev.eventlist"])}
catch(e){ngModule=angular.module("ev.eventlist",[])}
var v1="<md-dialog flex>\n<div class=\"uxtoolkit\" layout-margin style=\"overflow: visible;\">\n<div class=\"is--stratus\" layout=\"row\" flex>\n<span class=\"type__tertiary-headline\" flex>{{'event_list.selected_columns.title' | translate}}</span>\n</div>\n</div>\n<md-dialog-content>\n<div layout=\"row\" style=\"height: 600px;\">\n<div style=\"max-height: 100%;float: left;width:50%\">\n<md-subheader class=\"md-primary\">{{'event_list.selected_columns.available' | translate}}</md-subheader>\n<div style=\"max-height: 90%;overflow-y: scroll;\">\n<md-card layout=\"column\">\n<md-list>\n<md-list-item ng-repeat=\"column in $ctrl.availableColumns | orderBy: column\">\n<md-checkbox ng-checked=\"false\" ng-click=\"$ctrl.makeVisible(column)\"></md-checkbox>\n<span style=\"white-space: nowrap;\" flex>{{column | translateColumns: $ctrl.events: $ctrl.translationCache}}</span>\n</md-list-item>\n</md-list>\n</md-card>\n</div>\n</div>\n<div style=\"max-height: 100%;float: right;width: 50%\">\n<md-subheader class=\"md-primary\">{{'event_list.selected_columns.selected' | translate}}</md-subheader>\n<div style=\"max-height: 90%;overflow-y: scroll;\">\n<md-card layout=\"column\">\n<md-list>\n<md-list-item ng-repeat=\"column in $ctrl.visibleColumns\">\n<md-checkbox ng-checked=\"true\" ng-click=\"$ctrl.makeInvisible(column)\"></md-checkbox>\n<span style=\"white-space: nowrap;\" flex>{{column | translateColumns: $ctrl.events: $ctrl.translationCache}}</span>\n<md-icon class=\"md-secondary\" ng-click=\"$ctrl.moveColumnUp(column)\">arrow_upward</md-icon>\n<md-icon class=\"md-secondary\" ng-click=\"$ctrl.moveColumnDown(column)\">arrow_downward</md-icon>\n<md-icon class=\"md-secondary\" ng-click=\"$ctrl.moveColumnTop(column)\">vertical_align_top</md-icon>\n<md-icon class=\"md-secondary\" ng-click=\"$ctrl.moveColumnBottom(column)\">vertical_align_bottom</md-icon>\n</md-list-item>\n</md-list>\n</md-card>\n</div>\n</div>\n</div>\n</md-dialog-content>\n<md-dialog-actions layout=\"row\">\n<span flex></span>\n<div class=\"uxtoolkit\" layout=\"row\" style=\"overflow: hidden\">\n<div class=\"is--stratus\" layout=\"row\">\n<div class=\"button button__primary\" ng-click=\"$ctrl.close()\">\n<span>{{'dialog.close' | translate}}</span>\n</div>\n</div>\n</div>\n</md-dialog-actions>\n</md-dialog>";
var id1="columnpicker.html";
var inj=angular.element(window.document).injector();
if(inj){inj.get("$templateCache").put(id1,v1);}
else{ngModule.run(["$templateCache",function(c){c.put(id1,v1)}]);}
module.exports=v1;

/***/ }),
/* 141 */
/***/ (function(module, exports) {

var angular=window.angular,ngModule;
try {ngModule=angular.module(["ev.eventlist"])}
catch(e){ngModule=angular.module("ev.eventlist",[])}
var v1="<div layout=\"row\" layout-align=\"center center\" style=\"padding-left: 8px;\">\n<span style=\"font-size: 16px; padding-right: 8px; padding-left: 5px;\">{{'event_list.filter'| translate}}</span>\n<div style=\"margin-top: 8px; min-height: 46px;\" flex>\n<event-filter ng-model=\"$ctrl.query.filter\" ng-change=\"$ctrl.query.filter = newEventFilter\" flex></event-filter>\n</div>\n<div class=\"eventlist-actions\">\n<icon-button icon=\"searchIcon\" on-click=\"$ctrl.search\" tooltip=\"'event_search.search_tooltip' | translate\"/>\n<export-events export-json=\"$ctrl.exportJson\"/>\n<icon-button icon=\"columnsIcon\" on-click=\"$ctrl.showColumnPickerDialog\" tooltip=\"'event_list.selected_columns.title' | translate\"/>\n</div>\n</div>\n<div>\n<div ng-show=\"error === 0\">\n<md-table-container id=\"eventlist\">\n<table class=\"event-table\" md-table>\n<thead md-head fix-head md-order=\"sortColumn\">\n<tr md-row>\n<th md-column style=\"min-width: 36px;\">#</th>\n<th md-column ng-repeat=\"column in $ctrl.visibleColumns\" md-order-by=\"{{::column}}\">\n{{column|translateColumns: $ctrl.events: $ctrl.translationCache}}\n</th>\n</tr>\n<md-progress-linear ng-if=\"promise\" md-mode=\"indeterminate\"></md-progress-linear>\n</thead>\n<tbody md-body style=\"overflow: auto;\">\n<tr md-row ng-repeat=\"event in $ctrl.renderedEvents | orderBy: sortColumn:false:renderedEventComparator\" style=\"outline: none;\" ng-keyup=\"$ctrl.keyUp($event)\" ng-class=\"{ 'selected': $ctrl.selectedEventUuid === event.uuid }\" ng-click=\"$ctrl.select(event)\" ng-dblclick=\"$ctrl.showDetails(event)\" ng-right-click=\"$ctrl.attributeContextMenu($event, event, $ctrl.events, $ctrl.translationCache)\">\n<td md-cell>{{$index + ($ctrl.pages.length * $ctrl.query.limit) + 1}}</td>\n<td md-cell ng-repeat=\"column in $ctrl.visibleColumns\" id=\"{{::column}}\">\n<event-renderer type-id=\"event[column].attribute\" column=\"column\" value=\"event[column].value\" tooltip=\"true\" flex></event-renderer>\n</td>\n</tr>\n</tbody>\n</table>\n</md-table-container>\n</div>\n<div ng-if=\"error > 0\" style=\"height: 250px;\" layout=\"column\" layout-align=\"center center\">\n<p ng-if=\"error === 400\">\n<md-icon style=\"color: red\">error</md-icon> Invalid Query\n</p>\n<p ng-if=\"error !== 400\">\n<md-icon style=\"color: red\">error</md-icon> Error loading events\n</p>\n</div>\n<div id=\"eventlist-paging\" ng-show=\"!promise\" layout=\"row\" layout-align=\"start center\">\n<span flex></span>\n<span ng-if=\"$ctrl.events.length === 0\">{{\"event_list.no_events\" | translate}}</span>\n<span ng-if=\"$ctrl.events.length > 0\">{{($ctrl.pages.length * $ctrl.query.limit) + 1}} - {{($ctrl.pages.length * $ctrl.query.limit) + $ctrl.events.length}}</span>\n<md-button class=\"md-icon-button\" ng-click=\"$ctrl.prevPage()\" ng-disabled=\"$ctrl.pages.length === 0\">\n<md-tooltip md-direction=\"top\">{{'event_list.prev_tooltip'| translate}}</md-tooltip>\n<md-icon>navigate_before</md-icon>\n</md-button>\n<md-button class=\"md-icon-button\" ng-click=\"$ctrl.nextPage()\" ng-disabled=\"$ctrl.events.length !== $ctrl.query.limit\">\n<md-tooltip md-direction=\"top\">{{'event_list.next_tooltip'| translate}}</md-tooltip>\n<md-icon>navigate_next</md-icon>\n</md-button>\n</div>\n</div>";
var id1="EventList.html";
var inj=angular.element(window.document).injector();
if(inj){inj.get("$templateCache").put(id1,v1);}
else{ngModule.run(["$templateCache",function(c){c.put(id1,v1)}]);}
module.exports=v1;

/***/ }),
/* 142 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var moment_timezone__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(143);
/* harmony import */ var moment_timezone__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(moment_timezone__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var schema_browser__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(12);
/* harmony import */ var schema_browser__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(schema_browser__WEBPACK_IMPORTED_MODULE_2__);
//EventRendererDirective.ts




/* harmony default export */ __webpack_exports__["default"] = (function(eventTemplate, $compile, $translate, $filter, eventSchemaService) {
    return {
        restrict: 'E',
        scope: {
            typeId: '<',
            translatedEnum: '<',
            column: '<',
            value: '<',
            tooltip: '<',
            whiteSpacePreWrap: '<'
        },
        link: function(scope, element, attr) {
            scope.$watch("[typeId, translatedEnum, column, value, whiteSpacePreWrap]", function() {
                let attribute;
                if (typeof scope.column === "object") {
                    attribute = scope.column;
                } else if (scope.typeId !== undefined) {
                    attribute = new schema_browser__WEBPACK_IMPORTED_MODULE_2__["Attribute"]('@' + scope.typeId + ':' + scope.column);
                }

                let translatedValue;
                let tooltip = "";
                let description;
                if (attribute !== undefined && attribute.attributeType !== undefined) {
                    if (attribute.attributeType.type === "datetime") {
                        if (typeof (scope.value) == "string") {
                            translatedValue = escapeHtmlString(scope.value);
                        }
                        else {
                            try {
                                const zone = moment__WEBPACK_IMPORTED_MODULE_0__["tz"](moment__WEBPACK_IMPORTED_MODULE_0__["tz"].guess()).format('z');
                                translatedValue = `${moment__WEBPACK_IMPORTED_MODULE_0__(scope.value).local().format("MM/DD/YYYY HH:mm:ss.SSS")} ${zone}`;
                            }
                            catch (e) {
                                translatedValue = moment__WEBPACK_IMPORTED_MODULE_0__(scope.value).local().format("MM/DD/YYYY HH:mm:ss.SSS");
                                console.log("Error in timezone detection:" + e.message);
                            }
                        }
                    } else if (attribute.attributeType.enum !== undefined) {
                        if (Array.isArray(scope.value)) {
                            translatedValue = [];
                            for (let value of scope.value) {
                                translatedValue.push(escapeHtmlString($filter('schemaTranslate')(attribute.type.name + ".attributes." + attribute.attributeType.name + ".enum." + value + ".name")));
                            }
                        } else {
                            translatedValue = escapeHtmlString($filter('schemaTranslate')(attribute.type.name + ".attributes." + attribute.attributeType.name + ".enum." + scope.value + ".name"));
                        }
                    } else {
                        translatedValue = truncateIfRequired(scope.value, scope);
                        tooltip = getToolTip(scope.value, scope);
                    }

                    //The description from the schema
                    if (attribute.type.name === attribute.attributeType.name) {
                        description = scope.column;
                    } else {
                        description = $filter('schemaTranslate')(attribute.type.name + ".attributes." + attribute.attributeType.name + ".description");
                    }
                } else {
                    if (scope.column === "log_time" || scope.column === "base.log_time") {
                        translatedValue = moment__WEBPACK_IMPORTED_MODULE_0__(scope.value).format("MM/DD/YYYY HH:mm:ss.SSS");
                    } else if (scope.translatedEnum != undefined) {
                        translatedValue = escapeHtmlString(scope.translatedEnum);
                    } else {
                        translatedValue = truncateIfRequired(scope.value, scope);
                        tooltip = getToolTip(scope.value, scope);
                    }
                }

                if (scope.value === undefined) {
                    element.html("<span></span>");
                } else {
                    const spanStyle = (scope.whiteSpacePreWrap && scope.whiteSpacePreWrap === true) ? "style='white-space: pre-wrap'" : "";
                    element.html(`<div>${tooltip}<span ${spanStyle}>${translatedValue}</span></div>`);
                }

                $compile(element.contents())(scope);
            }, true);
        }
    };
});

const htmlEscapeChars = {
    "<": "&lt;",
    ">": "&gt;",
    "&": "&amp;",
    "=": "&#x3D;",
    "'": "&#39;",
    "\"": "&quot;",
    "/": "&#x2F;",
    "`": "&#x60;"
};

function escapeHtmlString(htmlString) {
    return String(htmlString).replace(/[&<>"'`=\/]/g, function(htmlChar) {
        return htmlEscapeChars[htmlChar];
    });
}

function getToolTip(value, scope) {
    if (scope.tooltip && scope.tooltip === true && value !== undefined && value.length > 60) {
        return `<md-tooltip md-delay='500' md-z-index='100' md-direction="top">${escapeHtmlString(value)}</md-tooltip>`;
    } else {
        return "";
    }
}

function truncateIfRequired(value, scope) {
    if (scope.tooltip && scope.tooltip === true && value !== undefined && value.length > 60) {
        return escapeHtmlString(value.substr(0, 60) + "(...)");
    } else {
        return escapeHtmlString(value);
    }
}

/***/ }),
/* 143 */,
/* 144 */,
/* 145 */,
/* 146 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//ExportOptions.tsx
const React = __webpack_require__(5);
const PropTypes = __webpack_require__(13);
const react_ux_toolkit_1 = __webpack_require__(7);
const GlobalIcons_1 = __webpack_require__(18);
class ExportEvents extends React.Component {
    constructor(props) {
        super(props);
    }
    render() {
        let $translate = this.props.$translate;
        return (React.createElement("div", { id: "content" },
            React.createElement(react_ux_toolkit_1.IconButton, { icon: GlobalIcons_1.DownloadIcon, onClick: ($event) => this.props.exportJson($event), tooltip: "Export to JSON" })));
    }
}
exports.ExportEvents = ExportEvents;
ExportEvents.propTypes = {
    exportJson: PropTypes.func.isRequired
};


/***/ }),
/* 147 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
const angular = __webpack_require__(3);
const ngMaterial = __webpack_require__(11);
const moment = __webpack_require__(6);
const ngMaterialDataTable = __webpack_require__(23);
const EnumCheckBox_1 = __webpack_require__(148);
const react_ux_toolkit_1 = __webpack_require__(7);
const EventListModule_1 = __webpack_require__(30);
const EventsModule_1 = __webpack_require__(19);
const EventArchiveModule_1 = __webpack_require__(31);
const widgets_module_1 = __webpack_require__(22);
const EventQueryComponent_1 = __webpack_require__(189);
window['moment'] = moment;
__webpack_require__(39);
exports.default = angular.module('ev.eventquery', [
    react_ux_toolkit_1.default,
    EventListModule_1.default,
    EventsModule_1.default,
    EventArchiveModule_1.default,
    widgets_module_1.default.name,
    ngMaterial,
    ngMaterialDataTable,
    "moment-picker"
])
    .config(['momentPickerProvider', function (momentPickerProvider) {
        momentPickerProvider.options({
            minutesStep: 1,
            minutesFormat: 'HH:mm'
        });
    }])
    .component('symEventQuery', new EventQueryComponent_1.default()).directive('enumCheckBox', function (reactDirective) {
    return reactDirective(EnumCheckBox_1.EnumCheckBox, undefined, {}, {});
});


/***/ }),
/* 148 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//EnumCheckBox.tsx
const React = __webpack_require__(5);
const react_ux_toolkit_1 = __webpack_require__(7);
/**
 * A checkbox where the checked status is the position in the array
 * instead of true or false.
 */
class EnumCheckBox extends React.Component {
    constructor(props) {
        super(props);
        this.onChange = this.onChange.bind(this);
    }
    onChange(enabled) {
        this.props.onChange(this.props.value, enabled);
    }
    render() {
        return (React.createElement(react_ux_toolkit_1.CheckBox, { onChange: this.onChange, label: this.props.label, checked: this.props.checked }));
    }
}
exports.EnumCheckBox = EnumCheckBox;


/***/ }),
/* 149 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
const react_ux_toolkit_1 = __webpack_require__(7);
__webpack_require__(150);
let template = __webpack_require__(152);
class ActionApiKeysComponent {
    constructor() {
        this.bindings = {
            plugin: '<',
            showAdvanced: '=',
            configOnly: "<",
            showEnable: "<",
            onChange: "&"
        };
        this.controller = ActionApiKeysController;
        this.template = template;
    }
}
exports.default = ActionApiKeysComponent;
ActionApiKeysComponent.$$ngIsClass = true; //Fix for Firefox
class ActionApiKeysController {
    constructor($rootScope, $mdDialog, $translate, openC2Service, apiKeysService, helpService) {
        this.$rootScope = $rootScope;
        this.$mdDialog = $mdDialog;
        this.$translate = $translate;
        this.openC2Service = openC2Service;
        this.apiKeysService = apiKeysService;
        this.helpService = helpService;
        this.apiKeysInfo = [];
        this.loading = true;
        this.error = false;
        this.actionsInfo = [];
        $rootScope.section = "settings";
        this.renameApiKey = this.renameApiKey.bind(this);
        this.deleteApiKey = this.deleteApiKey.bind(this);
    }
    $onInit() {
        let self = this;
        self.$translate.onReady(function () {
            self.openC2Service.getActions().then(function (actions) {
                for (let action of actions) {
                    let translatedName = self.$translate.instant("settings.openc2.actions." + action);
                    if (translatedName.startsWith("settings.openc2.actions.")) {
                        //Translation failed, use untranslated action name.
                        translatedName = action;
                    }
                    self.actionsInfo.push({
                        name: action,
                        translatedName: translatedName
                    });
                }
                self.apiKeysService.getApiKeys("icdx-actions").then(function (apiKeys) {
                    for (let apiKey of apiKeys) {
                        let apiKeyInfo = {
                            name: apiKey.name,
                            apiKey: apiKey,
                            actions: []
                        };
                        for (let actionInfo of self.actionsInfo) {
                            apiKeyInfo.actions.push({
                                name: actionInfo.name,
                                translatedName: actionInfo.translatedName,
                                enabled: self.hasAction(actionInfo.name, apiKey)
                            });
                        }
                        self.apiKeysInfo.push(apiKeyInfo);
                    }
                    self.loading = false;
                    self.error = false;
                });
            }, function () {
                self.loading = false;
                self.error = true;
            });
        });
    }
    hasAction(action, apiKey) {
        let privs = apiKey.privs.filter((priv) => {
            return priv === "openc2" || priv === "openc2:" + action;
        });
        return privs.length > 0;
    }
    updatePrivs(apiKeyInfo) {
        //First remove all privs
        apiKeyInfo.apiKey.privs = [];
        if (this.all(apiKeyInfo)) {
            //Only need to add top level privs if all is selected
            apiKeyInfo.apiKey.privs.push("openc2");
        }
        else {
            for (let action of apiKeyInfo.actions) {
                if (action.enabled) {
                    //Add all enabled actions only.
                    apiKeyInfo.apiKey.privs.push("openc2:" + action.name);
                }
            }
        }
        this.apiKeysService.updateApiKey(apiKeyInfo.apiKey);
    }
    all(apiKeyInfo) {
        let all = true;
        for (let action of apiKeyInfo.actions) {
            all = all && action.enabled;
        }
        return all;
    }
    toggleAction(apiKeyInfo, action) {
        let self = this;
        //Return a function that takes in an enabled flag used by the checkbox.
        return function (enabled) {
            action.enabled = enabled;
            self.updatePrivs(apiKeyInfo);
        };
    }
    toggleAll(apiKeyInfo) {
        let self = this;
        return function (enabled) {
            for (let action of apiKeyInfo.actions) {
                action.enabled = enabled;
            }
            self.updatePrivs(apiKeyInfo);
        };
    }
    newApiKey($event) {
        let self = this;
        let prompt = react_ux_toolkit_1.UxDialog.convertPromptToUx(self.$mdDialog.prompt()
            .title(this.$translate.instant("settings.openc2.dialog.add.title"))
            .textContent(this.$translate.instant("settings.openc2.dialog.add.content"))
            .targetEvent($event)
            .required(true)
            .ok(this.$translate.instant("dialog.ok"))
            .cancel(this.$translate.instant("dialog.cancel")));
        self.$mdDialog.show(prompt).then(function (name) {
            self.apiKeysService.addApiKey(name, "icdx-actions", ["openc2"]).then(function (apiKey) {
                let actions = [];
                for (let actionInfo of self.actionsInfo) {
                    actions.push({
                        name: actionInfo.name,
                        translatedName: actionInfo.translatedName,
                        enabled: self.hasAction(actionInfo.action, apiKey)
                    });
                }
                self.apiKeysInfo.push({
                    name: apiKey.name,
                    apiKey: apiKey,
                    actions: actions
                });
            }, function (error) {
                console.log("Unable to create new API key.", error);
            });
        });
    }
    ;
    renameApiKey(apiKey, $event) {
        let self = this;
        for (let apiKeyInfo of self.apiKeysInfo) {
            if (apiKeyInfo.apiKey.clientId === apiKey.clientId) {
                let prompt = react_ux_toolkit_1.UxDialog.convertPromptToUx(self.$mdDialog.prompt()
                    .title(this.$translate.instant("settings.openc2.dialog.rename.title"))
                    .textContent(this.$translate.instant("settings.openc2.dialog.rename.content"))
                    .targetEvent($event)
                    .required(true)
                    .ok(this.$translate.instant("dialog.save"))
                    .cancel(this.$translate.instant("dialog.cancel")));
                self.$mdDialog.show(prompt).then(function (name) {
                    console.log(apiKey, name);
                    apiKey.name = name;
                    self.apiKeysService.updateApiKey(apiKey);
                    apiKeyInfo.name = apiKey.name;
                });
            }
        }
    }
    deleteApiKey(apiKey, $event) {
        let self = this;
        for (let apiKeyInfo of self.apiKeysInfo) {
            if (apiKeyInfo.apiKey.clientId === apiKey.clientId) {
                let confirm = react_ux_toolkit_1.UxDialog.convertConfirmToUx(self.$mdDialog.confirm()
                    .title(this.$translate.instant("settings.openc2.dialog.delete.title"))
                    .textContent(this.$translate.instant("settings.openc2.dialog.delete.content", { apikey: apiKey.name }))
                    .targetEvent($event)
                    .ok(self.$translate.instant("dialog.yes"))
                    .cancel(self.$translate.instant("dialog.no")));
                self.$mdDialog.show(confirm).then(function () {
                    self.apiKeysService.deleteApiKey(apiKey).then(function () {
                        let index = self.apiKeysInfo.indexOf(apiKeyInfo);
                        self.apiKeysInfo.splice(index, 1);
                    }, function (error) {
                        console.log("Unable to delete API key.", error);
                    });
                });
            }
        }
    }
    showHelp() {
        this.helpService.help("ICDX_Settings_API_Keys");
    }
}
ActionApiKeysController.$inject = ["$rootScope", "$mdDialog", "$translate", "openC2Service", "apiKeysService", "helpService"];


/***/ }),
/* 150 */
/***/ (function(module, exports, __webpack_require__) {

var content = __webpack_require__(151);
content = content.__esModule ? content.default : content;

if (typeof content === 'string') {
  content = [[module.i, content, '']];
}

var options = {}

options.insert = "head";
options.singleton = false;

var update = __webpack_require__(9)(content, options);

if (content.locals) {
  module.exports = content.locals;
}


/***/ }),
/* 151 */
/***/ (function(module, exports, __webpack_require__) {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(8);
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.i, ".action-checkbox {\n    padding: 16px;\n}\n\n.action-all {\n    padding-right: 32px;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),
/* 152 */
/***/ (function(module, exports) {

var angular=window.angular,ngModule;
try {ngModule=angular.module(["dxs.settings"])}
catch(e){ngModule=angular.module("dxs.settings",[])}
var v1="<div layout=\"column\" style=\"overflow: visible;\">\n<div class=\"uxtoolkit\">\n<div class=\"is--stratus\">\n<span class=\"type__fourth-headline\">{{\"settings.openc2.header\" | translate}}</span>\n</div>\n</div>\n<p>{{\"settings.openc2.description\" | translate}}</p>\n<md-table-container id=\"eventlist\" style=\"overflow: visible;\">\n<table md-table flex style=\"overflow: visible;\">\n<thead md-head>\n<tr md-row>\n<th md-column style=\"width: 15%\">\n<span>Action API Key</span>\n</th>\n<th md-column>\n<span style=\"padding-left: 16px;\">Actions</span>\n</th>\n<th md-column style=\"width: 100px;\">\n<div class=\"uxtoolkit\" style=\"background-color: transparent;\">\n<div class=\"is--stratus\">\n<div class=\"button button__secondary is--transparent\" style=\"text-align: left;\" ng-click=\"$ctrl.newApiKey($event)\">\n<span style=\"font-size: .875em\" translate=\"settings.openc2.add\"></span>\n</div>\n</div>\n</div>\n</th>\n</tr>\n</thead>\n<tbody md-body style=\"overflow: auto;\">\n<tr md-row ng-if=\"!$ctrl.loading && !$ctrl.error && $ctrl.apiKeysInfo.length> 0\" ng-repeat=\"apiKeyInfo in $ctrl.apiKeysInfo | orderBy: 'name'\" style=\"outline: none;\">\n<td md-cell style=\"max-width: 0; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;\">{{apiKeyInfo.name}}</td>\n<td md-cell layout=\"row\">\n<div class=\"action-checkbox action-all\">\n<check-box checked=\"$ctrl.all(apiKeyInfo)\" label=\"'All'\" onchange=\"$ctrl.toggleAll(apiKeyInfo)\"></check-box>\n</div>\n<div class=\"action-checkbox\" ng-repeat=\"action in apiKeyInfo.actions\">\n<check-box checked=\"action.enabled\" label=\"action.translatedName\" onchange=\"$ctrl.toggleAction(apiKeyInfo, action)\"></check-box>\n</div>\n</td>\n<td md-cell>\n<div>\n<api-key-options apikey=\"apiKeyInfo.apiKey\" rename=\"$ctrl.renameApiKey\" delete=\"$ctrl.deleteApiKey\" translationkey=\"'openc2'\"/>\n</div>\n</td>\n</tr>\n<tr md-row ng-if=\"!$ctrl.loading && !$ctrl.error && $ctrl.apiKeysInfo.length===0\" style=\"outline: none;\">\n<td md-cell colspan=\"3\">\n<span class=\"md-body-1\">{{\"settings.openc2.emptyresults\" | translate}}</span>\n</td>\n</tr>\n<tr md-row ng-if=\"!$ctrl.loading && $ctrl.error\" style=\"outline: none;\">\n<td md-cell colspan=\"3\">\n<span class=\"md-body-1\">{{\"settings.openc2.error\" | translate}}</span>\n</td>\n</tr>\n<tr md-row ng-if=\"$ctrl.loading\" style=\"outline: none;\">\n<td md-cell colspan=\"3\">\n<span class=\"md-body-1\">{{\"settings.loading\" | translate}}</span>\n</td>\n</tr>\n</tbody>\n</table>\n</md-table-container>\n</div>";
var id1="ActionApiKeys.html";
var inj=angular.element(window.document).injector();
if(inj){inj.get("$templateCache").put(id1,v1);}
else{ngModule.run(["$templateCache",function(c){c.put(id1,v1)}]);}
module.exports=v1;

/***/ }),
/* 153 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

//OpenC2Service.ts
Object.defineProperty(exports, "__esModule", { value: true });
class OpenC2Service {
    constructor($http, $q, baseUrl) {
        this.$http = $http;
        this.$q = $q;
        this.baseUrl = baseUrl;
        this.openC2ServicePath = baseUrl + "/openc2/command";
    }
    getActions() {
        let defer = this.$q.defer();
        let self = this;
        let payload = {
            action: "query",
            target: {
                features: ["versions", "profiles", "pairs"]
            }
        };
        this.$http({
            method: 'POST',
            url: this.openC2ServicePath,
            headers: { 'Content-Type': 'application/json' },
            data: JSON.stringify(payload)
        }).then(function (response) {
            let pairs;
            if (response.data.pairs !== undefined) {
                pairs = response.data.pairs;
            }
            else if (response.data.results !== undefined && response.data.results.pairs !== undefined) {
                pairs = response.data.results.pairs;
            }
            else {
                defer.reject("Unable to retreive OpenC2 Action/target pairs.");
                return;
            }
            defer.resolve(Object.keys(pairs));
        }, function (errorResponse) {
            defer.reject(errorResponse);
        });
        return defer.promise;
    }
}
exports.default = OpenC2Service;
OpenC2Service.$inject = ['$http', '$q', 'baseUrl'];


/***/ }),
/* 154 */
/***/ (function(module, exports) {

var angular=window.angular,ngModule;
try {ngModule=angular.module(["cxs.openc2"])}
catch(e){ngModule=angular.module("cxs.openc2",[])}
var v1="<div layout=\"column\" style=\"overflow: visible;\">\n<div class=\"uxtoolkit\">\n<div class=\"is--stratus\">\n<span class=\"type__fourth-headline\">{{\"settings.openc2.header\" | translate}}</span>\n</div>\n</div>\n<p>{{\"settings.openc2.description\" | translate}}</p>\n<md-table-container id=\"eventlist\" style=\"overflow: visible;\">\n<table md-table flex style=\"overflow: visible;\">\n<thead md-head>\n<tr md-row>\n<th md-column style=\"width: 15%\">\n<span>Action API Key</span>\n</th>\n<th md-column>\n<span style=\"padding-left: 16px;\">Actions</span>\n</th>\n<th md-column style=\"width: 100px;\">\n<div class=\"uxtoolkit\" style=\"background-color: transparent;\">\n<div class=\"is--stratus\">\n<div class=\"button button__secondary is--transparent\" style=\"text-align: left;\" ng-click=\"$ctrl.newApiKey($event)\">\n<span style=\"font-size: .875em\" translate=\"settings.openc2.add\"></span>\n</div>\n</div>\n</div>\n</th>\n</tr>\n</thead>\n<tbody md-body style=\"overflow: auto;\">\n<tr md-row ng-if=\"!$ctrl.loading && !$ctrl.error && $ctrl.apiKeysInfo.length> 0\" ng-repeat=\"apiKeyInfo in $ctrl.apiKeysInfo | orderBy: 'name'\" style=\"outline: none;\">\n<td md-cell style=\"max-width: 0; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;\">{{apiKeyInfo.name}}</td>\n<td md-cell layout=\"row\">\n<div class=\"action-checkbox action-all\">\n<check-box checked=\"$ctrl.all(apiKeyInfo)\" label=\"'All'\" onchange=\"$ctrl.toggleAll(apiKeyInfo)\"></check-box>\n</div>\n<div class=\"action-checkbox\" ng-repeat=\"action in apiKeyInfo.actions\">\n<check-box checked=\"action.enabled\" label=\"action.translatedName\" onchange=\"$ctrl.toggleAction(apiKeyInfo, action)\"></check-box>\n</div>\n</td>\n<td md-cell>\n<div>\n<api-key-options apikey=\"apiKeyInfo.apiKey\" rename=\"$ctrl.renameApiKey\" delete=\"$ctrl.deleteApiKey\" translationkey=\"'openc2'\"/>\n</div>\n</td>\n</tr>\n<tr md-row ng-if=\"!$ctrl.loading && !$ctrl.error && $ctrl.apiKeysInfo.length===0\" style=\"outline: none;\">\n<td md-cell colspan=\"3\">\n<span class=\"md-body-1\">{{\"settings.openc2.emptyresults\" | translate}}</span>\n</td>\n</tr>\n<tr md-row ng-if=\"!$ctrl.loading && $ctrl.error\" style=\"outline: none;\">\n<td md-cell colspan=\"3\">\n<span class=\"md-body-1\">{{\"settings.openc2.error\" | translate}}</span>\n</td>\n</tr>\n<tr md-row ng-if=\"$ctrl.loading\" style=\"outline: none;\">\n<td md-cell colspan=\"3\">\n<span class=\"md-body-1\">{{\"settings.loading\" | translate}}</span>\n</td>\n</tr>\n</tbody>\n</table>\n</md-table-container>\n</div>";
var id1="ActionApiKeys.html";
var inj=angular.element(window.document).injector();
if(inj){inj.get("$templateCache").put(id1,v1);}
else{ngModule.run(["$templateCache",function(c){c.put(id1,v1)}]);}
module.exports=v1;

/***/ }),
/* 155 */,
/* 156 */,
/* 157 */,
/* 158 */,
/* 159 */,
/* 160 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//EventFilterComponent.ts
const angular = __webpack_require__(3);
const SimpleEventFilter_1 = __webpack_require__(15);
const RawEventFilter_1 = __webpack_require__(20);
const Condition_1 = __webpack_require__(26);
const ConditionDialog_1 = __webpack_require__(161);
__webpack_require__(165);
class EventFilterComponent {
    constructor() {
        this.bindings = {
            ngModel: "<",
            ngChange: "&",
            caption: "<",
            indexOnly: "<",
            onValidate: '&'
        };
        this.controller = EventFilterController;
        this.template = /*html*/ `
        <div id="{{$ctrl.id}}" class="event-filter" ng-blur="$ctrl.validate()">
            <div id="popupContainer">
            </div>
            <div class="event-filter-filterbox" ng-style="{ 'border-color': $ctrl.isValid || $ctrl.isValid === undefined ? '' : 'red' }" ng-if="!$ctrl.show">
                <div ng-repeat="condition in $ctrl.simpleEventFilter.conditions">
                    <div class="event-filter-token" ng-style="$ctrl.getColor(condition)" ng-click="$ctrl.showEditDialog(condition, $event)" style="outline: none; cursor: pointer;" layout="row">
                        <div style="padding-right: 5px; padding-top: 3px;" layout="row">
                            <md-tooltip>{{'filter.edit_condition_tooltip' | translate}}</md-tooltip>
                            <div class="event-filter-query">
                                <span ng-repeat="fieldTranslationKey in (condition.attribute | schemaTranslationKeys)" ng-if="fieldTranslationKey !== 'base'">{{fieldTranslationKey + ".name" | schemaTranslate}}<span ng-show="!$last">: </span></span>
                            </div>
                            
                            <div class="event-filter-query" style="padding-left: 5px; padding-right: 5px;">

                            <span translate="'operator.' + condition.attribute.attributeType.type + '.op' + condition.operator"  translate-default="{{condition.operator}}" ></span>
                            </div>

                            <div class="event-filter-query" style="max-width: 250px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;"> 
                                <event-renderer column="condition.attribute" value="condition.value" ></event-renderer>
                            </div>
                        </div>
                        <div class="event-filter-remove">
                            <md-tooltip>{{'filter.remove_condition_tooltip' | translate}}</md-tooltip>
                            <md-icon class="event-filter-remove-icon" ng-click="$ctrl.removeCondition(condition, $event)">close</md-icon>
                        </div>
                    </div>
                    <div ng-if="!$last" class="event-filter-logic-token">
                        <span class="event-filter-operator">AND</span>
                    </div>
                </div>
                <div class="event-filter-add-button" style="outline: none;" ng-click="$ctrl.showAddDialog($event)">
                    <md-tooltip>{{'filter.add_condition_tooltip' | translate}}</md-tooltip>
                    <md-icon>add</md-icon>
                </div>
                <div style="top: 9px;" class="event-filter-show">
                    <md-tooltip>{{'filter.show_tooltip' | translate}}</md-tooltip>
                    <span style="outline: none;" ng-click="$ctrl.show = true;">{{'filter.show' | translate}}</span>
                </div>
            </div>
            <div class="uxtoolkit" style="overflow: hidden; background-color: transparent; padding-bottom: 10px;" ng-hide="$ctrl.show">
                <div style="margin-top: 2px;" ng-class="$ctrl.captionClass" style="vertical-align: top;" >{{$ctrl.caption}}</div>
            </div>
            <div ng-if="$ctrl.show" style="position: relative;">
                <div class="event-filter-textbox">
                   <ux-textbox ng-model="$ctrl.rawEventFilter.filterString" caption="$ctrl.caption" ng-change="$ctrl.rawEventFilter.filterString = newValue; $ctrl.onChange();" ng-keypress="$ctrl.keypress($event)"></ux-textbox>
                   <md-tooltip ng-if="$ctrl.filterConvertErrorMessage !== ''">{{$ctrl.filterConvertErrorMessage}}</md-tooltip>                   
                </div>                
                <div style="z-index: 2; position: absolute; right: 10px;" class="event-filter-show">
                    <md-tooltip>{{'filter.hide_tooltip' | translate}}</md-tooltip>
                    <span style="outline: none;" ng-click="$ctrl.show = false;">{{'filter.hide' | translate}}</span>
                </div>
            </div>
        </div>`;
    }
}
exports.default = EventFilterComponent;
EventFilterComponent.$$ngIsClass = true; //Fix for Firefox
class EventFilterController {
    constructor($scope, $timeout, $mdDialog, $q, $translate, uuid, eventService) {
        this.$scope = $scope;
        this.$timeout = $timeout;
        this.$mdDialog = $mdDialog;
        this.$q = $q;
        this.$translate = $translate;
        this.uuid = uuid;
        this.eventService = eventService;
        this._show = false;
        this.captionClass = "type__item-description";
        this.isValid = true;
        this.simpleEventFilter = new SimpleEventFilter_1.default();
        this._rawEventFilter = new RawEventFilter_1.default();
        this._raw = "";
        this.colors = ["#007c3e", "#c89617", "#0360a3", "#ce1804"];
        this.throttleConvert = undefined;
        this.filterConvertValidationFailed = false;
        this.filterConvertErrorMessage = "";
    }
    $onInit() {
        let self = this;
        if (self.onValidate === undefined) {
            self.onValidate = function () {
                return true;
            };
        }
        self.id = self.uuid.v4();
        self.$scope.$on("drilldown", function (event, condition) {
            self.ngModel.addCondition(condition);
            self.eventService.convertFilter(self.eventFilter).then(function (convertedFilter) {
                if (!self.show) {
                    self.rawEventFilter = convertedFilter;
                }
                else {
                    self.simpleEventFilter = convertedFilter;
                }
                self.onChange();
            });
        });
    }
    get ngModel() {
        return this._ngModel;
    }
    set ngModel(ngModel) {
        let self = this;
        self._ngModel = ngModel;
        if (self.eventService === undefined) {
            return;
        }
        if (ngModel instanceof SimpleEventFilter_1.default) {
            self.simpleEventFilter = ngModel;
            //Convert to raw
            self.eventService.convertFilter(ngModel).then(function (rawEventFilter) {
                self.rawEventFilter = rawEventFilter;
            }, function () {
                self._show = true;
            });
        }
        else {
            self.rawEventFilter = ngModel;
            if (self.throttleConvert === undefined) {
                self.throttleConvert = self.$timeout(function () {
                    //Try converting the raw event filter if it is possible
                    self.eventService.convertFilter(self._ngModel).then(function (simpleEventFilter) {
                        self.simpleEventFilter = simpleEventFilter;
                        self.validate();
                    }, function () {
                        self._show = true;
                        self.validate();
                    });
                    self.throttleConvert = undefined;
                }, 1000);
            }
        }
    }
    get show() {
        return this._show;
    }
    set show(show) {
        let self = this;
        self.resetFilterCovertValidation();
        if (!show) {
            self.eventService.convertFilter(self.eventFilter).then(function (convertedFilter) {
                self._show = show;
                self.eventFilter = convertedFilter;
                self.onChange();
            }, function (error) {
                self.filterConvertValidationFailed = true;
                self.filterConvertErrorMessage = error.message ? error.message : "";
                self.validate();
            });
        }
        else {
            self._show = show;
            self.onChange();
        }
    }
    get eventFilter() {
        return this._show ? this.rawEventFilter : this.simpleEventFilter;
    }
    set eventFilter(eventFilter) {
        if (this._show) {
            this.rawEventFilter = eventFilter;
        }
        else {
            this.simpleEventFilter = eventFilter;
        }
    }
    get rawEventFilter() {
        return this._rawEventFilter;
    }
    set rawEventFilter(rawEventFilter) {
        this._rawEventFilter = rawEventFilter;
        this._raw = rawEventFilter.toString();
    }
    get raw() {
        return this._raw;
    }
    set raw(raw) {
        this._raw = raw;
        this._rawEventFilter = new RawEventFilter_1.default(raw);
        this.onChange();
    }
    showAddDialog($event) {
        let self = this;
        ConditionDialog_1.showConditionDialog(this.$mdDialog, $event, this.$q, {}, this.indexOnly).then(function (condition) {
            let c = self.simpleEventFilter.addCondition(new Condition_1.default(condition.field, condition.operator, condition.value));
            if (c === false) {
                self.$mdDialog.show(self.$mdDialog.alert()
                    .parent(angular.element(document.querySelector('#popupContainer')))
                    .clickOutsideToClose(true)
                    .title('Filter exists')
                    .textContent('The filter condition you have selected already exists.')
                    .ok('Ok')
                    .targetEvent($event));
            }
            else {
                self.eventService.convertFilter(self.simpleEventFilter).then(function (eventFilter) {
                    self.rawEventFilter = eventFilter;
                    self.onChange();
                });
            }
        });
        $event.stopPropagation();
    }
    showEditDialog(condition, $event) {
        let self = this;
        ConditionDialog_1.showConditionDialog(this.$mdDialog, $event, this.$q, condition, this.indexOnly).then(function (changedCondition) {
            condition.attribute = changedCondition.field;
            condition.operator = changedCondition.operator;
            condition.value = changedCondition.value;
            self.eventService.convertFilter(self.simpleEventFilter).then(function (eventFilter) {
                self.rawEventFilter = eventFilter;
                self.onChange();
            });
        });
        $event.stopPropagation();
    }
    removeCondition(condition, $event) {
        let self = this;
        self.simpleEventFilter.removeCondition(condition);
        self.eventService.convertFilter(self.simpleEventFilter).then(function (eventFilter) {
            self.rawEventFilter = eventFilter;
            self.onChange();
        });
        $event.stopPropagation();
    }
    /**
     * Updates the raw filter string and triggers a change event.
     *
     * @param newValue thew new raw filter value.
     */
    onChange() {
        this.resetFilterCovertValidation();
        this.validate();
        this.ngChange({
            newEventFilter: this.eventFilter.clone(),
            simple: this.simpleEventFilter.clone(),
            raw: this.rawEventFilter.clone()
        });
    }
    keypress($event) {
        if ($event.keyCode === 13) {
            this.$scope.$emit("execute");
        }
    }
    validate() {
        this.isValid = this.onValidate();
        if (this.filterConvertValidationFailed) {
            this.isValid = false;
        }
        let input = angular.element("#" + this.id).find(".form__item");
        let caption = angular.element("#" + this.id).find(".type__item-description");
        if (this.isValid || this.isValid === undefined) {
            input.removeClass("is--invalid");
            caption.removeClass("caption-error");
        }
        else {
            input.addClass("is--invalid");
            caption.addClass("caption-error");
        }
        if (this.caption !== undefined) {
            this.captionClass = this.isValid ? "type__item-description" : "caption-error";
        }
        return this.isValid;
    }
    getColor(condition) {
        let colorCode = 0;
        let attribute = condition.attribute.pathElements[condition.attribute.pathElements.length - 1];
        for (let i = 0; i < attribute.length; i++) {
            colorCode += attribute.charCodeAt(i);
        }
        return { "background-color": this.colors[colorCode % 4] };
    }
    resetFilterCovertValidation() {
        this.filterConvertValidationFailed = false;
        this.filterConvertErrorMessage = '';
    }
}
EventFilterController.$inject = ["$scope", "$timeout", "$mdDialog", "$q", "$translate", "uuid", "eventService"];


/***/ }),
/* 161 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//conditiondialog.js
const angular = __webpack_require__(3);
const moment = __webpack_require__(6);
const schema_browser_1 = __webpack_require__(12);
__webpack_require__(162);
let conditionDialogTemplate = __webpack_require__(164);
const OP_IN = "in";
/**
 * Controller for the condition builder dialog.
 */
class ConditionDialogController {
    /**
     * A condition that will be represented in the dialog. A condition is a Javascript object with
     * a field, operator and value.
     *
     * Ex:
     * {field: "aField", operator: "=", value: "aValue"}
     */
    constructor($scope, $mdDialog, $translate, $filter, $timeout, eventService, eventSchemaService, condition, indexOnly) {
        this.$scope = $scope;
        this.$mdDialog = $mdDialog;
        this.$translate = $translate;
        this.$filter = $filter;
        this.$timeout = $timeout;
        this.eventService = eventService;
        this.eventSchemaService = eventSchemaService;
        this.condition = condition;
        this.indexOnly = indexOnly;
        this.eventCategories = [];
        this.fields = [];
        this.selectValue = this.selectValue.bind(this);
    }
    $onInit() {
        let self = this;
        self.search = "";
        self.eventSchemaService.getSchema().then(function (schema) {
            self.$scope.types = self.eventSchemaService.getTypes();
            self.pathObj = new schema_browser_1.Attribute();
            self.$scope.schema = schema;
            self.$scope.baseSchema = self.$scope.types.findByName("base");
            self.$scope.schemaTree = self.eventSchemaService.getSchemaTree();
            for (let category of self.$scope.types.categories) {
                let translatedName = self.$translate.instant(category.name + ".name");
                self.eventCategories.push({
                    id: category.id,
                    translatedName: translatedName
                });
            }
            var dfs = function (type, depth) {
                var typeArray = [{
                        "key": type.name,
                        "depth": depth
                    }];
                for (let name in type.children) {
                    typeArray = typeArray.concat(dfs(type.children[name], depth + 1));
                }
                ;
                return typeArray;
            };
            self.$scope.sortColumn = "translatedName";
            self.$scope.eventTypes = dfs(self.$scope.types.eventTypes["base"], 0);
            //Load
            if (self.condition.attribute) {
                self.pathObj = self.condition.attribute.clone();
                self.selectEventType(self.pathObj.eventType.name);
                self.$scope.selectedType = self.pathObj.objectType !== undefined ? self.pathObj.objectType : self.pathObj.eventType;
                self.$scope.selectedAttribute = self.pathObj.attributeType;
                if (self.condition.operator === "!=" && self.condition.value == null) {
                    self.operator = undefined;
                    self.value = undefined;
                    self.$scope.show = "operator";
                }
                else {
                    self.selectOperator(self.condition.operator);
                    if (self.condition.operator === OP_IN) {
                        self.value = new Set(self.condition.value);
                    }
                    else {
                        self.value = self.condition.value;
                    }
                    self.$scope.show = "values";
                }
            }
            else {
                self.$scope.show = "events";
            }
        });
        self.$timeout(function () {
            angular.element("#condition-search").find(":input").focus();
        });
    }
    /**
     * The value given the data type. Enums will be numbers, strings will
     * be strings, dates will be a momentjs date.
     */
    get value() {
        return this._value;
    }
    set value(value) {
        if (this.$scope.selectedAttribute.type === "datetime") {
            this._value = value;
            this.formattedValue = moment(this._value).format("MM/DD/YYYY HH:mm:ss");
        }
        else {
            this._value = value;
        }
        if (this.$scope.selectedAttribute.enum !== undefined) {
            if (this.operator === OP_IN) {
                this.enumValue = Array.from(this._value).sort().toString();
            }
            else {
                this.enumValue = this._value;
            }
        }
    }
    /**
     * The string representation of the value when it is an enum.
     */
    get enumValue() {
        return this._enumValue;
    }
    /**
     * Sets the string representation of the value when it is an enum.
     * This lets us parse what the user enters and only push the change
     * down  to the actual value once it is valid.
     */
    set enumValue(enumValue) {
        this._enumValue = enumValue;
        //IN operator fixes
        if (this.operator === OP_IN) {
            let valueSet = new Set();
            for (let valueString of enumValue.split(',')) {
                let value = parseInt(valueString);
                if (!isNaN(value)) {
                    valueSet.add(parseInt(valueString));
                }
            }
            this._value = valueSet;
            this._enumValue = Array.from(this._value).sort().toString();
        }
        else {
            this._value = parseInt(enumValue);
        }
    }
    /**
     * Return true if the value is valid for the given type and operator.
     */
    get valid() {
        if (this.operator === OP_IN) {
            return Array.from(this._value).length > 0;
        }
        else {
            return this._value !== undefined;
        }
    }
    get search() {
        return this._search;
    }
    set search(search) {
        this._search = search;
        this.visibleFields = []; //Force the next time the visible fields is requested to recalculate it.
    }
    getEventTypes(categoryId) {
        let self = this;
        let eventTypes = this.$scope.types.findByCategoryId(categoryId).filter(function (eventType) {
            let translatedName = self.$translate.instant(eventType.name + ".name");
            eventType.translatedName = translatedName;
            return eventType.name.toLowerCase().includes(self.search.toLowerCase()) || translatedName.toLowerCase().includes(self.search.toLowerCase());
        });
        return eventTypes;
    }
    selectEventType(eventTypeName, $event = undefined) {
        this.$scope.show = "event";
        this.search = "";
        this.pathObj.typeId = schema_browser_1.Types.types.findByName(eventTypeName).typeId;
        //$scope.loadFields($event);
        this.$scope.schemaBranch = [];
        let currentType = this.pathObj.eventType;
        while (currentType !== undefined) {
            this.$scope.schemaBranch.push(currentType);
            currentType = currentType.parent;
        }
        this.$scope.selectedType = this.pathObj.eventType;
        this.$timeout(function () {
            angular.element("#condition-search").find(":input").focus();
        });
    }
    ;
    selectAttribute(attribute, $event = undefined) {
        this.pathObj.push(attribute);
        let type = this.pathObj.attributeType;
        if (type.type === 'object') {
            this.$scope.selectedType = type;
            this.$scope.show = "object";
        }
        else {
            this.$scope.selectedAttribute = type;
            this.$scope.show = "operator";
        }
    }
    getVisibleFields(schema) {
        let self = this;
        if (self.visibleFields[schema.name] !== undefined) {
            return self.visibleFields[schema.name];
        }
        let fields = [];
        for (let attributeName in schema.attributes) {
            let attribute = schema.attributes[attributeName];
            let translatedName = self.$filter("schemaTranslate")(schema.name + ".attributes." + attribute.name + ".name");
            if (attribute.derived || attribute.type === "json") {
                continue;
            }
            if (self.indexOnly && !self.eventService.isIndexed(attribute.name)) {
                continue;
            }
            fields.push({
                name: attribute.name,
                translatedName: translatedName
            });
        }
        self.visibleFields[schema.name] = fields.filter(function (field) {
            return field.name.toLowerCase().includes(self.search.toLowerCase()) || field.translatedName.toLowerCase().includes(self.search.toLowerCase());
        });
        return self.visibleFields[schema.name];
    }
    // TODO: add the IN operator
    getOperators() {
        switch (this.$scope.selectedAttribute.type) {
            case 'integer':
            case 'long':
                if (this.$scope.selectedAttribute.enum) {
                    return ['=', '<', '<=', '>=', '>', '!=', OP_IN, 'not_null'];
                }
                return ['=', '<', '<=', '>=', '>', '!=', 'not_null'];
            case 'string':
            case 'url':
                return ['=', '!=', 'like', 'not_like', 'match', 'not_match', 'not_null'];
            case 'datetime':
                return ['=', '<', '<=', '>=', '>', '!=', 'not_null'];
            default:
                return ['=', '!=', 'not_null'];
        }
    }
    selectOperator(operator) {
        if (this.$scope.selectedAttribute.type === "datetime") {
            this._value = moment();
        }
        else {
            this._value = undefined;
        }
        this.operator = operator;
        if (this.operator === OP_IN) {
            this._value = new Set();
        }
        if (this.operator === "not_null") {
            this.condition.field = this.pathObj.clone();
            this.condition.operator = "!=";
            this.condition.value = null;
            this.$mdDialog.hide();
        }
        else {
            this.$scope.show = "values";
        }
    }
    selectValue(value, enabled) {
        if (this.operator === OP_IN) {
            if (enabled) {
                this._value.add(parseInt(value));
            }
            else {
                this._value.delete(parseInt(value));
            }
            this._enumValue = Array.from(this._value).sort().toString();
        }
        else {
            this._value = parseInt(value);
            this._enumValue = this._value.toString();
        }
    }
    checked(value) {
        return this.value.has(parseInt(value));
    }
    back($event) {
        this.search = "";
        switch (this.$scope.show) {
            case "operator":
            case "object":
                this.operator = undefined;
                this.pathObj.pop();
                if (this.pathObj.objectType !== undefined) {
                    this.$scope.show = "object";
                }
                else {
                    this.$scope.show = "event";
                    this.$timeout(function () {
                        angular.element("#condition-search").find(":input").focus();
                    });
                }
                break;
            case "values":
                this._value = undefined;
                this._enumValue = undefined;
                this.operator = undefined;
                this.$scope.show = "operator";
                break;
            case "event":
                this.pathObj = new schema_browser_1.Attribute();
                this.$scope.show = "events";
                this.$timeout(function () {
                    angular.element("#condition-search").find(":input").focus();
                });
                break;
        }
    }
    cancel() {
        this.$mdDialog.cancel();
    }
    ok() {
        if (this.value === undefined || this.value.size === 0) {
            return;
        }
        this.condition.field = this.pathObj.clone();
        this.condition.operator = this.operator;
        if (this.$scope.selectedAttribute.type === "datetime") {
            this.condition.value = moment(this.value);
        }
        else if (this.$scope.selectedAttribute.type === "integer" || this.$scope.selectedAttribute.type === "long") {
            if (this.condition.operator === OP_IN) {
                this.condition.value = Array.from(this.value).sort();
            }
            else {
                this.condition.value = parseInt(this.value);
            }
        }
        else {
            this.condition.value = this.value;
        }
        this.$mdDialog.hide();
    }
}
;
function showConditionDialog($mdDialog, $event, $q, condition = {}, indexOnly = false) {
    let self = this;
    if (condition === undefined) {
        condition = {};
    }
    let defer = $q.defer();
    $mdDialog.show({
        controller: ConditionDialogController,
        controllerAs: "$ctrl",
        locals: {
            condition: condition,
            indexOnly: indexOnly
        },
        template: conditionDialogTemplate,
        targetEvent: $event,
        clickOutsideToClose: false,
        fullscreen: true,
        multiple: true,
        focusOnOpen: false
    }).then(function () {
        defer.resolve(condition);
    });
    return defer.promise;
}
exports.showConditionDialog = showConditionDialog;


/***/ }),
/* 162 */
/***/ (function(module, exports, __webpack_require__) {

var content = __webpack_require__(163);
content = content.__esModule ? content.default : content;

if (typeof content === 'string') {
  content = [[module.i, content, '']];
}

var options = {}

options.insert = "head";
options.singleton = false;

var update = __webpack_require__(9)(content, options);

if (content.locals) {
  module.exports = content.locals;
}


/***/ }),
/* 163 */
/***/ (function(module, exports, __webpack_require__) {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(8);
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.i, ".condition-value:hover {\n    background-color: inherit !important;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),
/* 164 */
/***/ (function(module, exports) {

var angular=window.angular,ngModule;
try {ngModule=angular.module(["ev.eventquery"])}
catch(e){ngModule=angular.module("ev.eventquery",[])}
var v1="<md-dialog style=\"height: 80%; min-width: 50%;\">\n<form ng-submit=\"$ctrl.ok()\" layout=\"column\" flex>\n<div class=\"uxtoolkit\" style=\"margin: 16px;\" layout=\"row\" style=\"overflow: visible\">\n<div class=\"is--stratus\" style=\"padding-bottom: 3px;\" layout=\"row\" flex>\n<span class=\"type__primary-headline\">{{'event_query.condition_dialog.title'| translate}}</span>\n<div ng-if=\"show !== 'events'\" ng-repeat=\"fieldTranslationKey in ($ctrl.pathObj | schemaTranslationKeys)\">\n<span class=\"type__primary-headline\" ng-show=\"$first\">: </span>\n<span class=\"type__primary-headline\">{{fieldTranslationKey + \".name\" | schemaTranslate}}</span>\n<span class=\"type__primary-headline\" ng-show=\"!$last\">.</span>\n</div>\n</div>\n</div>\n<md-dialog-content ng-if=\"show === 'events'\" class=\"md-dialog-content\" id=\"condition-dialog\" style=\"padding: 8px;\" layout=\"column\" flex>\n<div style=\"margin-left: 8px; margin-bottom: 16px;\">\n<ux-textbox id=\"condition-search\" label=\"'Filter by Event Type'\" ng-model=\"$ctrl.search\" ng-change=\"$ctrl.search = newValue\"></ux-textbox>\n</div>\n<div style=\"margin-left: 8px;\">Select an event type to see a list of searchable attributes.</div>\n<md-table-container>\n<table md-table style=\"width: 100%\">\n<thead md-head md-order=\"sortColumn\">\n<tr md-row>\n<th md-column md-order-by=\"translatedName\" width=\"15%\">Event Type</th>\n<th md-column md-order-by=\"typeId\" width=\"10%\">Type ID</th>\n<th md-column>Description</th>\n</tr>\n</thead>\n<tbody md-body>\n<tr md-row style=\"background-color: rgb(224, 241, 248); border-bottom-color: rgb(0, 129, 192);\">\n<td md-cell colspan=\"3\">\n<p><b>All Events</b></p>\n</td>\n</tr>\n<tr md-row ng-click=\"$ctrl.selectEventType('base', $event)\">\n<td md-cell ng-click=\"viewEventSchema(eventSchema.name)\">\n<p><b>{{\"base.name\" | translate}}</b></p>\n</td>\n<td md-cell>N/A</td>\n<td md-cell style=\"white-space: normal; word-wrap: break-word;\">\n<p>{{\"base.description\" | translate}}</p>\n</td>\n</tr>\n</tbody>\n<tbody md-body ng-repeat=\"category in $ctrl.eventCategories | orderBy: 'translatedName'\">\n<tr md-row style=\"background-color: rgb(224, 241, 248); border-bottom-color: rgb(0, 129, 192);\">\n<td md-cell colspan=\"3\">\n<p><b>{{category.translatedName}}</b></p>\n</td>\n</tr>\n<tr md-row style=\"cursor: pointer;\" ng-repeat=\"eventType in $ctrl.getEventTypes(category.id) | orderBy: sortColumn\" ng-click=\"$ctrl.selectEventType(eventType.name, $event)\">\n<td md-cell style=\"vertical-align: top; padding-top: 3px;\">\n<p layout=\"column\">\n<span><b>{{eventType.name + \".name\" | translate}}<b></b></b></span>\n</p>\n</td>\n<td md-cell style=\"vertical-align: top;\">\n<p>{{eventType.typeId}}</p>\n</td>\n<td md-cell style=\"white-space: normal; word-wrap: break-word;\">\n<p translate=\"{{eventType.name}}.description\" translate-default=\"\"></p>\n</td>\n</tr>\n</tbody>\n</table>\n</md-table-container>\n</md-dialog-content>\n<md-dialog-content ng-if=\"show === 'event'\" class=\"md-dialog-content\" id=\"condition-dialog\" style=\"padding: 8px;\" layout=\"column\" flex>\n<div style=\"margin-left: 8px; margin-bottom: 16px;\">\n<ux-textbox id=\"condition-search\" label=\"'Filter by Event Attribute'\" ng-model=\"$ctrl.search\" ng-change=\"$ctrl.search = newValue\"></ux-textbox>\n</div>\n<div style=\"margin-left: 8px;\">Select an event attribute.</div>\n<md-table-container>\n<table md-table style=\"width: 100%\">\n<thead md-head md-order=\"sortColumn\">\n<tr md-row>\n<th md-column md-order-by=\"translatedName\" width=\"15%\">Event Type</th>\n<th md-column>Description</th>\n</tr>\n</thead>\n<tbody md-body ng-repeat=\"schema in schemaBranch\">\n<tr md-row ng-if=\"$ctrl.getVisibleFields(schema).length !== 0\" style=\"background-color: rgb(224, 241, 248); border-bottom-color: rgb(0, 129, 192);\">\n<td md-cell colspan=\"2\">\n<p><b>{{schema.name +\".name\" | translate}}</b></p>\n</td>\n</tr>\n<tr md-row style=\"cursor: pointer;\" ng-repeat=\"field in $ctrl.getVisibleFields(schema) | orderBy: sortColumn\" ng-click=\"$ctrl.selectAttribute(field.name, $event)\">\n<td md-cell style=\"vertical-align: top; padding-top: 3px;\">\n<p layout=\"column\">\n<span><b>{{field.translatedName}}</b></span>\n<span style=\"padding-top: 2px; font-size: 8pt; color:gray\">{{field.name}}</span>\n</p>\n</td>\n<td md-cell style=\"white-space: normal;\">\n<p ng-bind-html=\"schema.name + '.attributes.' + field.name + '.description' | schemaTranslate\"></p>\n</td>\n</tr>\n</tbody>\n</table>\n</md-table-container>\n</md-dialog-content>\n<md-dialog-content ng-if=\"show === 'object'\" class=\"md-dialog-content\" id=\"condition-dialog\" style=\"padding: 8px;\" layout=\"column\" flex>\n<div style=\"margin-left: 8px; margin-bottom: 16px;\">\n<ux-textbox id=\"condition-search\" label=\"'Filter by Object Attribute'\" ng-model=\"$ctrl.search\" ng-change=\"$ctrl.search = newValue\"></ux-textbox>\n</div>\n<div style=\"margin-left: 8px;\">Select an object attribute.</div>\n<md-table-container>\n<table md-table style=\"width: 100%\">\n<thead md-head md-order=\"sortColumn\">\n<tr md-row>\n<th md-column md-order-by=\"translatedName\" width=\"15%\">Event Type</th>\n<th md-column>Description</th>\n</tr>\n</thead>\n<tbody md-body>\n<tr md-row style=\"cursor: pointer;\" ng-repeat=\"field in $ctrl.getVisibleFields(selectedType) | orderBy: sortColumn\" ng-click=\"$ctrl.selectAttribute(field.name, $event)\">\n<td md-cell style=\"vertical-align: top; padding-top: 3px;\">\n<p layout=\"column\">\n<span><b>{{field.translatedName}}</b></span>\n<span style=\"padding-top: 2px; font-size: 8pt; color:gray\">{{field.name}}</span>\n</p>\n</td>\n<td md-cell style=\"white-space: normal;\">\n<p ng-bind-html=\"selectedType.name + '.attributes.' + field.name + '.description' | schemaTranslate\"></p>\n</td>\n</tr>\n</tbody>\n</table>\n</md-table-container>\n</md-dialog-content>\n<md-dialog-content ng-if=\"show === 'operator'\" class=\"md-dialog-content\" id=\"condition-dialog\" style=\"padding: 8px;\" layout=\"column\" flex>\n<div style=\"margin-left: 8px;\">\n<p>Select an operator.</p>\n</div>\n<md-table-container>\n<table md-table style=\"width: 100%\">\n<tbody md-body>\n<tr md-row style=\"background-color: rgb(224, 241, 248); border-bottom-color: rgb(0, 129, 192);\">\n<td md-cell style=\"vertical-align: top; padding-top: 3px;\" width=\"15%\">\n<p layout=\"column\">\n<span><b>{{selectedType.name + '.attributes.' + selectedAttribute.name + '.name' | schemaTranslate}}</b></span>\n<span style=\"padding-top: 2px; font-size: 8pt; color:gray\">{{selectedAttribute.name}}</span>\n</p>\n</td>\n<td md-cell style=\"white-space: normal;\">\n<p ng-bind-html=\"selectedType.name + '.attributes.' + selectedAttribute.name + '.description' | schemaTranslate\"></p>\n</td>\n</tr>\n<tr md-row ng-repeat=\"operator in $ctrl.getOperators()\" ng-click=\"$ctrl.selectOperator(operator)\">\n<td md-cell>\n<p ng-bind-html=\"'operator.' + selectedAttribute.type + '.op' + operator | translate\"></p>\n</td>\n<td md-cell></td>\n</tr>\n</tbody>\n</table>\n</md-table-container>\n</md-dialog-content>\n<md-dialog-content ng-if=\"show === 'values'\" class=\"md-dialog-content\" id=\"condition-dialog\" style=\"padding: 8px;\" layout=\"column\" flex>\n<div style=\"margin-left: 8px;\">\n<p>Enter a value.</p>\n</div>\n<md-table-container>\n<table md-table style=\"width: 100%\">\n<tbody md-body>\n<tr md-row style=\"background-color: rgb(224, 241, 248); border-bottom-color: rgb(0, 129, 192);\">\n<td md-cell style=\"vertical-align: top; padding-top: 3px;\" width=\"15%\">\n<p layout=\"column\">\n<span><b>{{selectedType.name + '.attributes.' + selectedAttribute.name + '.name' | schemaTranslate}}</b></span>\n<span style=\"padding-top: 2px; font-size: 8pt; color:gray\">{{selectedAttribute.name}}</span>\n</p>\n</td>\n<td md-cell style=\"white-space: normal;\">\n<p ng-bind-html=\"selectedType.name + '.attributes.' + selectedAttribute.name + '.description' | schemaTranslate\"></p>\n</td>\n</tr>\n</tbody>\n<tbody md-body ng-if=\"selectedAttribute.type === 'boolean'\">\n<tr md-row class=\"condition-value\" layout-margin>\n<td md-cell>\n<p>\n<ux-toggle ng-model=\"$ctrl.value\" ng-change=\"$ctrl.value = newValue;\"></ux-toggle>\n</p>\n</td>\n<td md-cell>{{$ctrl.value === true ? \"True\" : \"False\"}}</td>\n</tr>\n\n</tbody>\n<tbody md-body ng-if=\"selectedAttribute.type === 'string' || selectedAttribute.type === 'url' || selectedAttribute.type === 'ip_address' || selectedAttribute.type === 'long'\">\n<tr md-row class=\"condition-value\" layout-margin>\n<td md-cell colspan=\"2\">\n<ux-textbox ng-model=\"$ctrl.value\" ng-change=\"$ctrl.value = newValue\" autofocus=\"true\"></ux-textbox>\n</td>\n</tr>\n</tbody>\n<tbody md-body ng-if=\"selectedAttribute.type === 'integer'\">\n<tr ng-if=\"selectedAttribute.enum === undefined\" md-row class=\"condition-value\" layout-margin>\n<td md-cell colspan=\"2\">\n<ux-textbox ng-model=\"$ctrl.value\" ng-change=\"$ctrl.value = newValue\" autofocus=\"true\"></ux-textbox>\n</td>\n</tr>\n<tr ng-if=\"selectedAttribute.enum !== undefined\" md-row class=\"condition-value\" layout-margin>\n<td md-cell colspan=\"2\">\n<ux-textbox ng-model=\"$ctrl.enumValue\" ng-change=\"$ctrl.enumValue = newValue\" autofocus=\"true\"></ux-textbox>\n</td>\n</tr>\n<tr md-row ng-if=\"selectedAttribute.enum\" class=\"condition-value\" ng-repeat=\"(key, value) in selectedAttribute.enum\">\n<td ng-if=\"$ctrl.operator !== 'in'\" md-cell>\n<radio-button name=\"'enum'\" value=\"{{key}}\" on-change=\"$ctrl.selectValue\" label=\"selectedType.name +'.attributes.' + selectedAttribute.name +'.enum.' + key + '.name' | schemaTranslate\" checked=\"$ctrl.value.toString() === key.toString()\"/>\n</td>\n<td ng-if=\"$ctrl.operator === 'in'\" md-cell>\n<enum-check-box value=\"{{key}}\" on-change=\"$ctrl.selectValue\" label=\"selectedType.name +'.attributes.' + selectedAttribute.name +'.enum.' + key + '.name' | schemaTranslate\" checked=\"$ctrl.checked(key)\"/>\n</td>\n<td md-cell>\n<p ng-if=\"(selectedType.name +'.attributes.' + selectedAttribute.name +'.enum.' + key + '.description' | schemaTranslate) !== key\" ng-bind-html=\"selectedType.name +'.attributes.' + selectedAttribute.name +'.enum.' + key + '.description' | schemaTranslate\"></p>\n</td>\n</tr>\n</tbody>\n<tbody ng-if=\"selectedAttribute.type === 'datetime'\">\n<tr md-row class=\"condition-value\" layout-margin>\n<td md-cell colspan=\"2\" style=\"padding-left: 0px; padding-right: 0px;\">\n<div moment-picker=\"$ctrl.value\" min-view=\"month\" max-view=\"minute\" today=\"true\">\n<ux-textbox ng-model=\"$ctrl.formattedValue\" ng-change=\"$ctrl.value = newValue\" autofocus=\"true\" readonly=\"readonly\"></ux-textbox>\n</div>\n</td>\n</tr>\n</tbody>\n</table>\n</md-table-container>\n</md-dialog-content>\n<md-dialog-actions>\n<div class=\"uxtoolkit\" flex>\n<div class=\"is--stratus\" flex layout=\"row\">\n<div ng-if=\"show !== 'events'\">\n<div class=\"button button__secondary is--transparent\" ng-click=\"$ctrl.back($event)\">\n<span>{{'event_query.condition_dialog.back'| translate}}</span>\n</div>\n</div>\n<span flex></span>\n<div>\n<div class=\"button button__cancel\" ng-click=\"$ctrl.cancel()\">\n<span>{{'event_query.condition_dialog.cancel'| translate}}</span>\n</div>\n<div class=\"button button__primary\" ng-class=\"{'is--disabled': !$ctrl.valid}\" ng-click=\"$ctrl.ok()\">\n<span>{{'event_query.condition_dialog.apply'| translate}}</span>\n</div>\n</div>\n</div>\n</div>\n</md-dialog-actions>\n</form>\n</md-dialog>";
var id1="conditiondialog.html";
var inj=angular.element(window.document).injector();
if(inj){inj.get("$templateCache").put(id1,v1);}
else{ngModule.run(["$templateCache",function(c){c.put(id1,v1)}]);}
module.exports=v1;

/***/ }),
/* 165 */
/***/ (function(module, exports, __webpack_require__) {

var content = __webpack_require__(166);
content = content.__esModule ? content.default : content;

if (typeof content === 'string') {
  content = [[module.i, content, '']];
}

var options = {}

options.insert = "head";
options.singleton = false;

var update = __webpack_require__(9)(content, options);

if (content.locals) {
  module.exports = content.locals;
}


/***/ }),
/* 166 */
/***/ (function(module, exports, __webpack_require__) {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(8);
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.i, ".event-filter-filterbox {\n    position: relative;\n    border: 1px solid #e5e5e5;\n    background-color: #f2f2f2;\n    min-height: 30px;\n    overflow: hidden;\n    font-size: 1em;\n    padding-left: 10px;\n    padding-right: 50px;\n    padding-top: 1px;\n    padding-bottom: 1px;\n    color: #282828;\n}\n\n.event-filter-token {\n    color: #FFF;\n    height: 22px;\n    width: auto;\n    margin-top: 4px;\n    margin-bottom: 4px;\n    margin-right: 4px;\n    padding-left: 5px;\n    border-radius: 4px;\n    float: left;\n}\n\n.event-filter-logic-token {\n    height: 22px;\n    width: auto;\n    margin-top: 4px;\n    margin-bottom: 4px;\n    margin-right: 4px;\n    padding-right: 10px;\n    padding-bottom: 0px;\n    padding-left: 10px;\n    background: #c9c9c9;\n    color: #FFF;\n    border-radius: 4px;\n    float: left;\n}\n\n.event-filter-query {\n    width: auto;\n    font-weight: 500;\n    font-size: 0.75em;\n}\n\n.event-filter-remove {\n    border-left: 1px solid white;\n    padding-left: 5px;\n    padding-top: 3px;\n}\n\n.event-filter-remove-icon {\n    color: white;\n    font-size: 16px;\n    cursor: pointer;\n    min-width: 0px !important;\n    min-height: 0px !important;\n}\n\n.event-filter-operator {\n    padding-top: 2px;\n    font-size: 0.75em;\n    font-weight: 500;\n    display: inline-block;\n    width: auto;\n    height: 22px;\n    position: relative;\n}\n\n.event-filter-add-button {\n    padding-left: 5px;\n    padding-top: 2px;\n    padding-bottom: 2px;\n    float: left;\n    cursor: pointer;\n}\n\n.event-filter-show {\n    position: absolute;\n    top: 10px;\n    right: 10px;\n    font-size: 0.75em;\n    color: #00aeef;\n    cursor: pointer;\n}\n\n.event-filter-show:hover {\n    color: #0076a3;\n}\n\n.event-filter-textbox {\n    z-index: 1;\n    left: 0;\n    width: 100%;\n}\n\n.event-filter-textbox .type__item-description.no-caption {\n    display: none !important;\n}\n\n.event-filter-textbox .form__item.input__text input[type=text] {\n    padding-right: 50px;\n}\n\n.event-filter .type__primary-label {\n    margin-bottom: 0px !important;\n}\n\n.event-filter {\n    height: 46px;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),
/* 167 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
__webpack_require__(168);
const errorDialogTemplate = /*html*/ `
    <md-dialog style="max-width: 800px;">
        <md-dialog-content>
            <div class="error" style="padding: 24px;">
                <div class="uxtoolkit">
                    <div class="is--stratus">
                        <h2 class="type__primary-headline" style="margin-bottom: 24px; text-transform: capitalize;">
                            {{$ctrl.titleKey | translate}}
                        </h2>
                    </div>
                </div>
                <div>
                    <p style="margin-top: 12px; margin-bottom: 25px;">{{$ctrl.descriptionKey | translate}}</p>
                </div>
                <div class="details">
                    {{$ctrl.details}}
                </div>
            </div>
        </md-dialog-content>
        <md-dialog-actions layout="row">
            <div class="uxtoolkit" layout="row" style="overflow: hidden" flex>
                <div class="is--stratus" layout="row" flex>
                    <span flex></span>
                    <div class="button button__primary" ng-click="close()">
                        <span>{{'dialog.close' | translate}}</span>
                    </div>
                </div>
            </div>
        </md-dialog-actions>
    </md-dialog>
`;
class ErrorService {
    constructor($mdDialog) {
        this.$mdDialog = $mdDialog;
    }
    displayError(titleKey, descriptionKey, details) {
        this.$mdDialog.show({
            controller: errorDialogController,
            controllerAs: "$ctrl",
            template: errorDialogTemplate,
            clickOutsideToClose: true,
            multiple: true,
            bindToController: true,
            locals: {
                titleKey: titleKey,
                descriptionKey: descriptionKey,
                details: details
            }
        });
    }
    displaySystemError(details) {
        this.displayError("error.title", "error.description", details);
    }
}
exports.default = ErrorService;
ErrorService.$inject = ['$mdDialog'];
;
function errorDialogController($mdDialog) {
    let $scope = this.$scope;
    $scope.close = function () {
        $mdDialog.hide();
    };
}


/***/ }),
/* 168 */
/***/ (function(module, exports, __webpack_require__) {

var content = __webpack_require__(169);
content = content.__esModule ? content.default : content;

if (typeof content === 'string') {
  content = [[module.i, content, '']];
}

var options = {}

options.insert = "head";
options.singleton = false;

var update = __webpack_require__(9)(content, options);

if (content.locals) {
  module.exports = content.locals;
}


/***/ }),
/* 169 */
/***/ (function(module, exports, __webpack_require__) {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(8);
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.i, ".error .details {\n    background-color: rgb(224, 241, 248);\n    border: 1px solid rgb(0, 129, 192);\n    padding: 10px;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),
/* 170 */
/***/ (function(module, exports) {

var angular=window.angular,ngModule;
try {ngModule=angular.module(["dxs.settings"])}
catch(e){ngModule=angular.module("dxs.settings",[])}
var v1="<md-content style=\"overflow: visible;\" ng-controller=\"PluginConfigListController as $ctrl\" layout=\"column\" layout-margin>\n<div style=\"margin-left: 16px; overflow: hidden\" layout=\"row\">\n<div class=\"uxtoolkit\">\n<div class=\"is--stratus\" ng-if=\"$ctrl.type === 'config'\">\n<div class=\"button button__tab\" ng-class=\"{ 'is--active': $ctrl.category === 'collector' }\" ui-sref=\"config({category: 'collector'})\">\n<span>Collectors</span>\n</div>\n<div class=\"button button__tab\" ng-class=\"{ 'is--active': $ctrl.category === 'forwarder' }\" ui-sref=\"config({category: 'forwarder'})\">\n<span>Forwarders</span>\n</div>\n<div class=\"button button__tab\" ng-class=\"{ 'is--active': $ctrl.category === 'adapter' }\" ui-sref=\"config({category: 'adapter'})\" ng-show=\"openc2\">\n<span>Action Adapters</span>\n</div>\n<div class=\"button button__tab\" ng-class=\"{ 'is--active': $ctrl.category === 'intelligence' }\" ui-sref=\"config({category: 'intelligence'})\" ng-show=\"demo\">\n<span>Threat Intelligence</span>\n</div>\n</div>\n<div class=\"is--stratus\" ng-if=\"$ctrl.type === 'settings'\">\n<div class=\"button button__tab\" ng-class=\"{ 'is--active': $ctrl.category === 'archive' }\" ui-sref=\"settings({category: 'archive'})\">\n<span>Common Archive</span>\n</div>\n<div class=\"button button__tab\" ng-class=\"{ 'is--active': $ctrl.category === 'ldap' }\" ui-sref=\"settings({category: 'ldap'})\">\n<span>Active Directory</span>\n</div>\n<div class=\"button button__tab\" ng-class=\"{ 'is--active': $ctrl.category === 'apikieys' }\" ui-sref=\"settings-apikeys\">\n<span>{{\"settings.apikeys.title\" | translate}}</span>\n</div>\n<div class=\"button button__tab\" ng-class=\"{ 'is--active': $ctrl.category === 'other/icdx' }\" ui-sref=\"settings/icdx\">\n<span>{{\"settings.other/icdx.name\" | translate}}</span>\n</div>\n<div class=\"button button__tab\" ng-class=\"{ 'is--active': $ctrl.category === 'telemetry' }\" ui-sref=\"settings({category: 'telemetry'})\">\n<span>Telemetry</span>\n</div>\n</div>\n</div>\n<div flex></div>\n<div style=\"background-color: transparent; display: flex; flex-direction: column; justify-content: center; margin-right: 24px;\">\n<help-button on-help=\"$ctrl.showHelp\"/>\n</div>\n</div>\n<div style=\"overflow: visible;\" layout-margin layout=\"column\">\n<p ng-if=\"$ctrl.type === 'settings'\" translate=\"settings.other/icdx.description\"></p>\n<md-table-container style=\"overflow: visible;\" id=\"eventlist\" ng-if=\"$ctrl.status === 'done'\">\n<table style=\"overflow: visible;\" class=\"event-table\" md-table>\n<thead md-head md-order=\"$ctrl.sortColumn\">\n<tr md-row>\n<th md-column style=\"width: 20%;\" md-order-by=\"name\">\n<span>\n<md-tooltip md-direction=\"top\">\n<span translate=\"settings.columns.sort\" translate-value-column=\"{{'settings.columns.name' | translate}}\"></span>\n</md-tooltip>\n{{\"settings.columns.name\" | translate}}\n</span>\n</th>\n<th md-column md-order-by=\"description\" style=\"width: 100%;\">\n<span>\n<md-tooltip md-direction=\"top\">\n<span translate=\"settings.columns.sort\" translate-value-column=\"{{'settings.columns.description' | translate}}\"></span>\n</md-tooltip>\n{{\"settings.columns.description\" | translate}}\n</span>\n</th>\n<th md-column style=\"min-width: 0px;\">\n<span translate=\"settings.columns.options\"></span>\n</th>\n<th md-column style=\"min-width: 0px;\" md-order-by=\"statusTranslated\">\n<span>\n<md-tooltip md-direction=\"top\">\n<span translate=\"settings.columns.sort\" translate-value-column=\"{{'settings.columns.status' | translate}}\"></span>\n</md-tooltip>\n{{\"settings.columns.status\" | translate}}\n</span>\n</th>\n<th md-column style=\"min-width: 0px;\" md-order-by=\"startupTranslated\">\n<span>\n<md-tooltip md-direction=\"top\">\n<span translate=\"settings.columns.sort\" translate-value-column=\"{{'settings.columns.startup-type' | translate}}\"></span>\n</md-tooltip>\n{{\"settings.columns.startup-type\" | translate}}\n</span>\n</th>\n</tr>\n</thead>\n<tbody md-body style=\"overflow: auto;\" ng-repeat=\"settingType in $ctrl.settingTypes()\">\n<tr md-row md-colors=\"{backgroundColor: 'primary-50', 'border-color': 'primary-600'}\">\n<td md-cell colspan=\"2\">\n<span class=\"md-body-2\">{{$ctrl.pluginMetas[settingType].name}}</span>\n</td>\n<td md-cell colspan=\"3\">\n<div>\n<div class=\"uxtoolkit\" style=\"background-color: transparent;\">\n<div class=\"is--stratus\">\n<div class=\"button button__secondary is--transparent\" style=\"min-width: 0;\" ng-click=\"$ctrl.add($ctrl.pluginMetas[settingType], $event)\">\n<span style=\"font-size: .875em\" translate=\"settings.add\">Add</span>\n</div>\n</div>\n</div>\n</div>\n</td>\n</tr>\n<tr md-row ng-if=\"$ctrl.settings[settingType].length > 0\" ng-repeat=\"setting in $ctrl.settings[settingType] | orderBy: $ctrl.sortColumn\" style=\"outline: none;\">\n<td md-cell>{{setting.name}}</td>\n<td md-cell style=\"max-width: 0; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;\">{{setting.description}}</td>\n<td md-cell style=\"white-space: nowrap\">\n<div>\n<plugin-actions rerender=\"setting.rerender\" plugin=\"setting\" process=\"$ctrl.processes[setting.uuid]\" edit=\"$ctrl.edit\" copy=\"$ctrl.copy\" enable=\"$ctrl.enable\" start=\"$ctrl.start\" stop=\"$ctrl.stop\" restart=\"$ctrl.restart\" delete=\"$ctrl.delete\" viewlogs=\"$ctrl.viewlogs\"/>\n</div>\n</td>\n<td md-cell style=\"white-space: nowrap;\">\n<i>{{setting.statusTranslated}}</i>\n</td>\n<td md-cell>{{setting.startupTranslated}}</td>\n</tr>\n<tr md-row ng-if=\"$ctrl.settings[settingType].length === 0\" style=\"outline: none;\">\n<td md-cell colspan=\"6\">\n<span class=\"md-body-1\">{{\"settings.\" + $ctrl.category + \".emptyresults\" | translate}}</span>\n</td>\n</tr>\n</tbody>\n</table>\n</md-table-container>\n<div ng-if=\"$ctrl.status === 'loading'\" class=\"overlay\" style=\"height: 250px;\" layout=\"column\" layout-align=\"center center\">\n<div class=\"ldr\">\n<div class=\"ldr-blk\"></div>\n<div class=\"ldr-blk an_delay\"></div>\n<div class=\"ldr-blk an_delay\"></div>\n<div class=\"ldr-blk\"></div>\n</div>\n</div>\n<div ng-if=\"$ctrl.status === 'error'\">\n<span translate=\"settings.error.download\" translate-value-category=\"{{$ctrl.category}}\"></span>\n</div>\n</div>\n</md-content>";
var id1="PluginConfigList.html";
var inj=angular.element(window.document).injector();
if(inj){inj.get("$templateCache").put(id1,v1);}
else{ngModule.run(["$templateCache",function(c){c.put(id1,v1)}]);}
module.exports=v1;

/***/ }),
/* 171 */
/***/ (function(module, exports) {

var angular=window.angular,ngModule;
try {ngModule=angular.module(["dxs.settings"])}
catch(e){ngModule=angular.module("dxs.settings",[])}
var v1="<md-content ng-controller=\"SettingsLandingController as $ctrl\" layout=\"column\" layout-margin>\n<div style=\"margin-left: 16px; overflow: hidden\" layout=\"row\">\n<div class=\"uxtoolkit\">\n<div class=\"is--stratus\">\n<div class=\"button button__tab\" ng-class=\"{ 'is--active': $ctrl.category === 'archive' }\" ui-sref=\"settings({category: 'archive'})\">\n<span>Common Archive</span>\n</div>\n<div class=\"button button__tab\" ng-class=\"{ 'is--active': $ctrl.category === 'ldap' }\" ui-sref=\"settings({category: 'ldap'})\">\n<span>Active Directory</span>\n</div>\n<div class=\"button button__tab\" ng-class=\"{ 'is--active': $ctrl.category === 'apikieys' }\" ui-sref=\"settings-apikeys\">\n<span>{{\"settings.apikeys.title\" | translate}}</span>\n</div>\n<div class=\"button button__tab\" ng-class=\"{ 'is--active': $ctrl.category === 'other/icdx' }\" ui-sref=\"settings-icdx\">\n<span>{{\"settings.other/icdx.name\" | translate}}</span>\n</div>\n<div class=\"button button__tab\" ng-class=\"{ 'is--active': $ctrl.category === 'telemetry' }\" ui-sref=\"settings({category: 'telemetry'})\">\n<span>Telemetry</span>\n</div>\n</div>\n</div>\n<div flex></div>\n<div style=\"background-color: transparent; display: flex; flex-direction: column; justify-content: center; margin-right: 24px;\">\n<help-button on-help=\"$ctrl.showHelp\"/>\n</div>\n</div>\n<div layout-margin layout=\"column\" ng-if=\"$ctrl.plugin !== undefined\">\n<p>{{$ctrl.plugin.pluginMeta.description}}</p>\n<form ng-submit=\"$ctrl.save($event)\">\n<plugin plugin=\"$ctrl.plugin\" show-advanced=\"true\" config-only=\"true\" on-change=\"$ctrl.dirty = true\" show-enable=\"$ctrl.category === 'ldap' || $ctrl.category === 'telemetry'\"></plugin>\n<div class=\"uxtoolkit\" layout=\"row\" style=\"overflow: hidden\">\n<span flex></span>\n<div class=\"is--stratus\" layout=\"row\">\n<input type=\"submit\" class=\"button button__primary\" ng-class=\"{'is--disabled': !$ctrl.dirty}\" value=\"{{'dialog.save' | translate}}\">\n</div>\n</div>\n</form>\n</div>\n</md-content>";
var id1="SettingsLanding.html";
var inj=angular.element(window.document).injector();
if(inj){inj.get("$templateCache").put(id1,v1);}
else{ngModule.run(["$templateCache",function(c){c.put(id1,v1)}]);}
module.exports=v1;

/***/ }),
/* 172 */
/***/ (function(module, exports) {

var angular=window.angular,ngModule;
try {ngModule=angular.module(["dxs.settings"])}
catch(e){ngModule=angular.module("dxs.settings",[])}
var v1="<md-content ng-controller=\"ApiKeysController as $ctrl\" style=\"overflow: visible;\" layout=\"column\" layout-margin>\n<div style=\"margin-left: 16px; overflow: hidden\" layout=\"row\">\n<div class=\"uxtoolkit\">\n<div class=\"is--stratus\">\n<div class=\"button button__tab\" ui-sref=\"settings({category: 'archive'})\">\n<span>Common Archive</span>\n</div>\n<div class=\"button button__tab\" ui-sref=\"settings({category: 'ldap'})\">\n<span>Active Directory</span>\n</div>\n<div class=\"button button__tab is--active\" ui-sref=\"settings-apikeys\">\n<span>{{\"settings.apikeys.title\" | translate}}</span>\n</div>\n<div class=\"button button__tab\" ng-class=\"{ 'is--active': $ctrl.category === 'other/icdx' }\" ui-sref=\"settings-icdx\">\n<span>{{\"settings.other/icdx.name\" | translate}}</span>\n</div>\n<div class=\"button button__tab\" ng-class=\"{ 'is--active': $ctrl.category === 'telemetry' }\" ui-sref=\"settings({category: 'telemetry'})\">\n<span>Telemetry</span>\n</div>\n</div>\n</div>\n<div flex></div>\n<div style=\"background-color: transparent; display: flex; flex-direction: column; justify-content: center; margin-right: 24px;\">\n<help-button on-help=\"$ctrl.showHelp\"/>\n</div>\n</div>\n<div layout-margin layout=\"column\" style=\"overflow: visible;\">\n<div>\n<div class=\"uxtoolkit\">\n<div class=\"is--stratus\">\n<span class=\"type__fourth-headline\">{{\"settings.apikeys.header\" | translate}}</span>\n</div>\n</div>\n<p>{{\"settings.apikeys.description\" | translate}}</p>\n<md-table-container id=\"eventlist\" style=\"overflow: visible;\">\n<table md-table flex style=\"overflow: visible;\">\n<thead md-head md-order=\"$ctrl.sortColumn\">\n<tr md-row>\n<th md-column md-order-by=\"name\" style=\"width: 15%\">\n<span>Name</span>\n</th>\n<th md-column>\n<span style=\"padding-left: 16px;\">Client ID</span>\n</th>\n<th md-column style=\"width: 100px;\">\n<div>\n<div class=\"uxtoolkit\" style=\"background-color: transparent;\">\n<div class=\"is--stratus\">\n<div class=\"button button__secondary is--transparent\" style=\"text-align: left;\" ng-click=\"$ctrl.newApiKey($event)\">\n<span style=\"font-size: .875em\" translate=\"settings.apikeys.add\"></span>\n</div>\n</div>\n</div>\n</div>\n</th>\n</tr>\n</thead>\n<tbody md-body style=\"overflow: auto;\">\n<tr md-row ng-if=\"$ctrl.apiKeys.length> 0\" ng-repeat=\"apiKey in $ctrl.apiKeys | orderBy: $ctrl.sortColumn\" style=\"outline: none;\">\n<td md-cell style=\"max-width: 0; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;\">{{apiKey.name}}</td>\n<td md-cell style=\"max-width: 0; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;\">\n<span style=\"padding-left: 16px;\">{{apiKey.clientId}}</span>\n</td>\n<td md-cell>\n<div>\n<api-key-options apikey=\"apiKey\" rename=\"$ctrl.renameApiKey\" delete=\"$ctrl.deleteApiKey\"/>\n</div>\n</td>\n</tr>\n<tr md-row ng-if=\"$ctrl.apiKeys.length === 0\" style=\"outline: none;\">\n<td md-cell colspan=\"3\">\n<span class=\"md-body-1\">{{\"settings.apikeys.emptyresults\" | translate}}</span>\n</td>\n</tr>\n</tbody>\n</table>\n</md-table-container>\n<div style=\"padding-top: 32px;\" ng-show=\"openc2\">\n<action-api-keys></action-api-keys>\n</div>\n</div>\n</div>\n</md-content>";
var id1="ApiKeys.html";
var inj=angular.element(window.document).injector();
if(inj){inj.get("$templateCache").put(id1,v1);}
else{ngModule.run(["$templateCache",function(c){c.put(id1,v1)}]);}
module.exports=v1;

/***/ }),
/* 173 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

//PluginConfig.ts
Object.defineProperty(exports, "__esModule", { value: true });
const PluginConfig_1 = __webpack_require__(45);
class PluginMeta {
    constructor(meta) {
        this.metaAttributes = new Map();
        this.category = meta.category;
        this.type = meta.type;
        this.name = meta.name;
        this.description = meta.desc;
        this.helpToken = meta.help_token;
        for (let attributeName in meta.attributes) {
            let pluginMetaAttribute = PluginMetaAttribute.generatePluginMetaAttribute(attributeName, meta.attributes[attributeName]);
            if (pluginMetaAttribute !== undefined) {
                this.metaAttributes.set(attributeName, pluginMetaAttribute);
            }
        }
    }
    get isRoot() {
        return this.type.indexOf('/') < 0;
    }
    newPlugin(pluginJson) {
        let pluginAttributes = new Map();
        for (let metaAttributeName of this.metaAttributes.keys()) {
            let metaAttribute = this.metaAttributes.get(metaAttributeName);
            pluginAttributes.set(metaAttributeName, metaAttribute.newPluginAttribute(pluginJson === undefined));
        }
        let plugin = new PluginConfig_1.Plugin(this, pluginAttributes);
        plugin.apply(pluginJson);
        return plugin;
    }
}
exports.PluginMeta = PluginMeta;
class PluginMetaAttribute {
    constructor(name, metaData) {
        this.isArray = false;
        this.name = name;
        this.title = metaData.name;
        this.description = metaData.desc;
        this.requirement = metaData.requirement;
        if (metaData.requirement === "optional") {
            this.advanced = metaData.advanced === undefined ? true : metaData.advanced;
        }
        else {
            this.advanced = metaData.advanced === undefined ? false : metaData.advanced;
        }
    }
    static generatePluginMetaAttribute(attributeName, attributeMetaJson) {
        switch (attributeMetaJson.type) {
            case "object":
                if (attributeMetaJson.is_array) {
                    return new PluginMetaObjectArrayAttribute(attributeName, attributeMetaJson);
                }
                else {
                    return new PluginMetaObjectAttribute(attributeName, attributeMetaJson);
                }
            default:
                if (attributeMetaJson.is_array) {
                    return new PluginMetaValueArrayAttribute(attributeName, attributeMetaJson);
                }
                else {
                    return new PluginMetaValueAttribute(attributeName, attributeMetaJson);
                }
        }
    }
}
exports.PluginMetaAttribute = PluginMetaAttribute;
class PluginMetaValueAttribute extends PluginMetaAttribute {
    constructor(name, metaData) {
        super(name, metaData);
        this.enum = new Map();
        this.min = -2147483648;
        this.max = 2147483647;
        this.type = metaData.type;
        this.subType = metaData.subtype;
        this.default = metaData.default;
        if (metaData.type === "integer") {
            if (metaData.range) {
                this.min = metaData.range[0];
                this.max = metaData.range[1];
            }
            for (let id in metaData.enum) {
                if (typeof metaData.enum[id] === "string") {
                    this.enum.set(parseInt(id), metaData.enum[id]);
                }
                else {
                    this.enum.set(parseInt(id), metaData.enum[id].name);
                }
            }
        }
        if (metaData.type === "boolean") {
            for (let id in metaData.enum) {
                if (typeof metaData.enum[id] === "string") {
                    this.enum.set(id === "true", metaData.enum[id]);
                }
                else {
                    this.enum.set(id === "true", metaData.enum[id].name);
                }
            }
        }
        if (metaData.type === "string") {
            if (metaData.pattern) {
                this.pattern = metaData.pattern;
            }
            for (let id in metaData.enum) {
                if (typeof metaData.enum[id] === "string") {
                    this.enum.set(id, metaData.enum[id]);
                }
                else {
                    this.enum.set(id, metaData.enum[id].name);
                }
            }
        }
    }
    newPluginAttribute(useDefault = false) {
        let attribute = undefined;
        if (useDefault) {
            if (this.type === "boolean") {
                //Boolean should never be undefined. Default to false.
                attribute = this.default === undefined ? false : this.default;
            }
            else {
                attribute = this.default;
            }
        }
        let pluginAttribute = new PluginConfig_1.PluginValueAttribute(this, attribute);
        return pluginAttribute;
    }
}
exports.PluginMetaValueAttribute = PluginMetaValueAttribute;
class PluginMetaObjectAttribute extends PluginMetaAttribute {
    constructor(name, metaData) {
        super(name, metaData);
        this.metaAttributes = new Map();
        this.type = "object";
        for (let attributeName in metaData.attributes) {
            let pluginMetaAttribute = PluginMetaAttribute.generatePluginMetaAttribute(attributeName, metaData.attributes[attributeName]);
            if (pluginMetaAttribute !== undefined) {
                this.metaAttributes.set(attributeName, pluginMetaAttribute);
            }
        }
    }
    newPluginAttribute(useDefault = false) {
        let pluginAttribute = new PluginConfig_1.PluginObjectAttribute(this, {});
        for (let metaAttributeName of this.metaAttributes.keys()) {
            let metaAttribute = this.metaAttributes.get(metaAttributeName);
            pluginAttribute.attributeMap.set(metaAttributeName, metaAttribute.newPluginAttribute(useDefault));
        }
        return pluginAttribute;
    }
}
exports.PluginMetaObjectAttribute = PluginMetaObjectAttribute;
class PluginMetaValueArrayAttribute extends PluginMetaValueAttribute {
    constructor(name, attributeMetaJson) {
        super(name, attributeMetaJson);
        this.isArray = true;
    }
    newPluginAttribute(useDefault = false) {
        let attribute = undefined;
        if (useDefault) {
            attribute = this.default === undefined ? [] : this.default;
        }
        return new PluginConfig_1.PluginValueArrayAttribute(this, attribute);
    }
}
exports.PluginMetaValueArrayAttribute = PluginMetaValueArrayAttribute;
class PluginMetaObjectArrayAttribute extends PluginMetaObjectAttribute {
    constructor(name, attributeMetaJson) {
        super(name, attributeMetaJson);
        this.isArray = true;
    }
    newPluginAttribute(useDefault = false) {
        return new PluginConfig_1.PluginObjectArrayAttribute(this, {});
    }
}


/***/ }),
/* 174 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
const PluginAttribute_1 = __webpack_require__(21);
class PluginObjectAttribute extends PluginAttribute_1.PluginAttribute {
    constructor(pluginMetaAttribute, attribute) {
        super(pluginMetaAttribute, attribute);
        this.attributeMap = new Map();
        this.type = "object";
    }
    get attributes() {
        return Array.from(this.attributeMap.values());
    }
    get invalidAttributes() {
        let invalidAttributes = [];
        for (let attribute of this.attributeMap.values()) {
            if (attribute.requirement === "system") {
                continue;
            }
            invalidAttributes.push(...attribute.invalidAttributes);
        }
        return invalidAttributes;
    }
    get value() {
        return undefined;
    }
    set value(value) { }
    get isRequired() {
        for (let key of this.attributeMap.keys()) {
            if (this.attributeMap.get(key).isRequired) {
                return true;
            }
        }
        return false;
    }
    /**
     * Returns true when all of the children fields are also advanced.
     */
    get isAdvanced() {
        if (this.pluginMetaAttribute.advanced) {
            return true;
        }
        for (let key of this.attributeMap.keys()) {
            //If the child is not advanced then we aren't either
            if (!this.attributeMap.get(key).isAdvanced) {
                return false;
            }
        }
        return true;
    }
    get json() {
        let json = {};
        //If there are no entries, treat it as a not part of the resulting JSON.
        if (this.attributeMap.size === 0) {
            return json;
        }
        json[this.name] = {};
        for (let pluginAttributeName of this.attributeMap.keys()) {
            let pluginAttributeJson = this.attributeMap.get(pluginAttributeName).json;
            if (pluginAttributeJson[pluginAttributeName] !== undefined) {
                json[this.name][pluginAttributeName] = pluginAttributeJson[pluginAttributeName];
            }
        }
        return json;
    }
    apply(pluginAttributeJson) {
        for (let attributeName in pluginAttributeJson) {
            let attribute = this.attributeMap.get(attributeName);
            if (attribute === undefined) {
                if (this.pluginMetaAttribute[attributeName] === undefined) {
                    continue;
                }
                attribute = this.pluginMetaAttribute[attributeName].newPluginAttribute();
                this.attributeMap.set(attributeName, attribute);
            }
            attribute.apply(pluginAttributeJson[attributeName]);
        }
    }
}
exports.PluginObjectAttribute = PluginObjectAttribute;


/***/ }),
/* 175 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
const PluginAttribute_1 = __webpack_require__(21);
class PluginObjectArrayAttribute extends PluginAttribute_1.PluginAttribute {
    constructor(pluginMetaAttribute, attribute) {
        super(pluginMetaAttribute, attribute);
        this.pluginMetaAttribute = pluginMetaAttribute;
    }
    get invalidAttributes() {
        return [];
    }
    get value() {
        return undefined;
    }
    set value(value) { }
    get json() {
        let json = {};
        return json;
    }
    apply(pluginAttributeJson) {
    }
}
exports.PluginObjectArrayAttribute = PluginObjectArrayAttribute;


/***/ }),
/* 176 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//PluginValueAttribute.ts
const moment = __webpack_require__(6);
const PluginAttribute_1 = __webpack_require__(21);
const SimpleEventFilter_1 = __webpack_require__(15);
const RawEventFilter_1 = __webpack_require__(20);
const patterns = {
    "host_name": /^(([\w\d]|[\w\d][\w\d\-]*[\w\d])\.)*([\w\d]|[\w\d][\w\d\-]*[\w\d])$/,
    "path_name": /^[\w]+[\w ~!@#%&*\-./]*$/,
    "file_name": /^[\w]+[\w ~!@#%&*\-.]*$/
};
class PluginValueAttribute extends PluginAttribute_1.PluginAttribute {
    constructor(pluginMetaAttribute, attribute) {
        super(pluginMetaAttribute, attribute);
        this.type = pluginMetaAttribute.type;
        this.subType = pluginMetaAttribute.subType;
        this.value = attribute;
        if (this.subType === "datetime" && this.value === undefined) {
            this.value = moment().startOf('minute').toDate();
        }
    }
    get value() {
        return this._value;
    }
    set value(value) {
        if (this.type === "integer" && typeof value === "string") {
            if (value.trim() === "") {
                this._value = undefined;
            }
            else if (!isNaN(Number(value))) {
                this._value = parseInt(value);
            }
            else {
                this._value = value;
            }
        }
        else if (this.type === "string" && this.subType === "filter") {
            if (value instanceof SimpleEventFilter_1.default || value instanceof RawEventFilter_1.default) {
                this._value = value;
            }
            else if (value === undefined || value.trim() === "") {
                this._value = new SimpleEventFilter_1.default();
            }
            else {
                try {
                    this._value = SimpleEventFilter_1.default.fromJson(JSON.parse(value));
                }
                catch (syntaxError) {
                    this._value = new RawEventFilter_1.default(value);
                }
            }
        }
        else if (this.type === "boolean") {
            this._value = value || value === "true";
        }
        else {
            this._value = value;
        }
    }
    get invalidAttributes() {
        if (this.type === "integer") {
            let meta = this.pluginMetaAttribute;
            if (!this.isRequired && this.value === undefined) {
                return [];
            }
        }
        if (this.pluginMetaAttribute.requirement === "required") {
            if (this.value === undefined || this.value === null) {
                return [this];
            }
            if (this.pluginMetaAttribute.type === "string" && this.value.toString().trim() === "") {
                return [this];
            }
        }
        return [];
    }
    get json() {
        let json = {};
        if (this.type === "string" && this.subType === "filter") {
            json[this.name] = this.value.toString();
        }
        else if (this.value !== undefined) {
            json[this.name] = this.value;
        }
        return json;
    }
    apply(attributeJson) {
        if (typeof attributeJson !== "object") {
            this.value = attributeJson;
        }
    }
}
exports.PluginValueAttribute = PluginValueAttribute;


/***/ }),
/* 177 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
const PluginAttribute_1 = __webpack_require__(21);
class PluginValueArrayAttribute extends PluginAttribute_1.PluginAttribute {
    constructor(pluginMetaAttribute, attribute) {
        super(pluginMetaAttribute, attribute);
        this.pluginMetaAttribute = pluginMetaAttribute;
        this._value = [];
        this.type = pluginMetaAttribute.type;
        this.value = attribute;
    }
    get invalidAttributes() {
        if (this.pluginMetaAttribute.requirement === "required" && this._value.length === 0) {
            return [this];
        }
        for (let value of this._value) {
            if (this.pluginMetaAttribute.type === "integer") {
                if (isNaN(value)) {
                    return [this];
                }
            }
        }
        return [];
    }
    get value() {
        return this._value;
    }
    set value(value) {
        if (value instanceof Array) {
            this._value = value;
        }
    }
    get json() {
        let json = {};
        json[this.name] = this._value;
        return json;
    }
    apply(pluginAttributeJson) {
        this.value = pluginAttributeJson;
    }
}
exports.PluginValueArrayAttribute = PluginValueArrayAttribute;


/***/ }),
/* 178 */
/***/ (function(module, exports, __webpack_require__) {

var content = __webpack_require__(179);
content = content.__esModule ? content.default : content;

if (typeof content === 'string') {
  content = [[module.i, content, '']];
}

var options = {}

options.insert = "head";
options.singleton = false;

var update = __webpack_require__(9)(content, options);

if (content.locals) {
  module.exports = content.locals;
}


/***/ }),
/* 179 */
/***/ (function(module, exports, __webpack_require__) {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(8);
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.i, ".md-open-menu-container.md-active {\n    z-index: 100;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),
/* 180 */
/***/ (function(module, exports) {

var angular=window.angular,ngModule;
try {ngModule=angular.module(["dxs.settings"])}
catch(e){ngModule=angular.module("dxs.settings",[])}
var v1="<form ng-submit=\"save()\">\n<md-dialog style=\"max-width: 800px; max-height: calc(90vh);\">\n<md-toolbar style=\"background-color: transparent; height: 50px;\" layout=\"row\">\n<span class=\"uxtoolkit\" layout=\"column\" layout-align=\"center\" layout-margin>\n<span class=\"type__tertiary-headline\" translate=\"{{'settings.' + plugin.category + '.dialog-title'}}\" translate-value-name=\"{{plugin.title}}\"></span>\n</span>\n<span flex></span>\n<div ng-if=\"plugin.helpToken !== undefined\" style=\"background-color: transparent; display: flex; flex-direction: column; justify-content: center; margin-right: 24px;\">\n<help-button on-help=\"showHelp\"/>\n</div>\n</md-toolbar>\n<md-dialog-content>\n<div style=\"padding: 0 24px;\" id=\"pluginConfig\">\n<plugin plugin=\"plugin\" show-advanced=\"showAdvanced\" on-change=\"dirty = true\" show-enable=\"showEnable\"></plugin>\n</div>\n</md-dialog-content>\n<md-dialog-actions layout=\"row\" style=\"padding-right: 16px; background-color: #f2f2f2;\">\n<div class=\"uxtoolkit\" style=\"background-color: transparent;\">\n<div class=\"is--stratus\" layout=\"row\" flex>\n<div ng-click=\"showAdvanced = !showAdvanced\" class=\"button button__secondary is--transparent\" style=\"margin-top: 16px; margin-bottom: 16px;\">\n<span ng-if=\"!showAdvanced\">Show Advanced</span>\n<span ng-if=\"showAdvanced\">Hide Advanced</span>\n</div>\n</div>\n</div>\n<span flex></span>\n<div class=\"uxtoolkit\" layout=\"row\" style=\"overflow: hidden; background-color: transparent;\">\n<div class=\"is--stratus\" layout=\"row\">\n<div class=\"button button__cancel\" ng-click=\"cancel()\" style=\"min-width: 60px; margin-right: 25px; margin-top: 16px; margin-bottom: 16px; margin-left: 10px;\">\n<span>Cancel</span>\n</div>\n<input type=\"submit\" class=\"button button__primary\" ng-class=\"{'is--disabled': !dirty}\" style=\"margin-top: 16px; margin-bottom: 16px;\" value=\"Save\">\n</div>\n</div>\n</md-dialog-actions>\n</md-dialog>\n</form>";
var id1="PluginDialog.html";
var inj=angular.element(window.document).injector();
if(inj){inj.get("$templateCache").put(id1,v1);}
else{ngModule.run(["$templateCache",function(c){c.put(id1,v1)}]);}
module.exports=v1;

/***/ }),
/* 181 */
/***/ (function(module, exports, __webpack_require__) {

var content = __webpack_require__(182);
content = content.__esModule ? content.default : content;

if (typeof content === 'string') {
  content = [[module.i, content, '']];
}

var options = {}

options.insert = "head";
options.singleton = false;

var update = __webpack_require__(9)(content, options);

if (content.locals) {
  module.exports = content.locals;
}


/***/ }),
/* 182 */
/***/ (function(module, exports, __webpack_require__) {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(8);
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.i, "plugin-attribute .ux-toggle {\n    width: 150px !important;\n}\n\n.settings-text {\n    margin-top: 17px;\n    margin-right: 5px;\n    width: 150px;\n}\n\n.settings-textbox {\n    width: 100%;\n}\n\n.attribute-object {\n    border-left: thin solid #dcdcdc;\n    margin-right: 0px;\n}\n\n.archive-attribute>.md-input-has-value {\n    margin: 10px 9;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),
/* 183 */
/***/ (function(module, exports) {

var angular=window.angular,ngModule;
try {ngModule=angular.module(["dxs.settings"])}
catch(e){ngModule=angular.module("dxs.settings",[])}
var v1="<div layout=\"row\" ng-if=\"$ctrl.showEnable && $ctrl.enabledAttribute.pluginMetaAttribute.enum.size === 0\">\n<span class=\"settings-text\" layout-align=\"start\">{{$ctrl.enabledAttribute.pluginMetaAttribute.title}}</span>\n<div class=\"uxtoolkit\" style=\"margin-top: 15px;\" flex>\n<ux-check-box ng-model=\"$ctrl.enabledAttribute.value\" style=\"width: 46px; overflow: hidden\" caption=\"$ctrl.enabledAttribute.pluginMetaAttribute.description\" ng-change=\"$ctrl.enabledAttribute.value = newValue; $ctrl.onChange();\"></ux-check-box>\n</div>\n</div>\n<div layout=\"row\" ng-if=\"!$ctrl.configOnly\">\n<span class=\"settings-text\" layout-align=\"start\">{{$ctrl.nameAttribute.title}}*</span>\n<div id=\"plugin-name\" flex>\n<ux-textbox class=\"settings-textbox\" ng-model=\"$ctrl.nameAttribute.value\" caption=\"$ctrl.nameAttribute.pluginMetaAttribute.description\" ng-change=\"$ctrl.nameAttribute.value = newValue; $ctrl.onChange();\" on-validate=\"$ctrl.nameAttribute.isValid\" max-length=\"30\"></ux-textbox>\n</div>\n</div>\n<div layout=\"row\" ng-if=\"!$ctrl.configOnly\">\n<span class=\"settings-text\" layout-align=\"start\">{{$ctrl.descriptionAttribute.title}}</span>\n<div id=\"plugin-description\" flex>\n<ux-textbox class=\"settings-textbox\" ng-model=\"$ctrl.descriptionAttribute.value\" caption=\"$ctrl.descriptionAttribute.pluginMetaAttribute.description\" ng-change=\"$ctrl.descriptionAttribute.value = newValue; $ctrl.onChange();\" on-validate=\"$ctrl.descriptionAttribute.isValid\"></ux-textbox>\n</div>\n</div>\n<div layout=\"row\" ng-if=\"!$ctrl.configOnly && $ctrl.uuidAttribute.value !== undefined\">\n<span class=\"settings-text\" layout-align=\"start\">{{$ctrl.uuidAttribute.title}}</span>\n<div id=\"plugin-uuid\" flex>\n<ux-textbox class=\"settings-textbox\" ng-readonly=\"true\" ng-model=\"$ctrl.uuidAttribute.value\" caption=\"$ctrl.uuidAttribute.pluginMetaAttribute.description\"></ux-textbox>\n</div>\n</div>\n<div layout=\"row\" ng-if=\"$ctrl.showEnable && $ctrl.enabledAttribute.pluginMetaAttribute.enum.size !== 0\">\n<span class=\"settings-text\" layout-align=\"start\">{{$ctrl.enabledAttribute.pluginMetaAttribute.title}}</span>\n<div class=\"uxtoolkit\" style=\"padding-top: 12px;\" flex>\n<ux-select ng-model=\"$ctrl.enabledAttribute.value\" options=\"$ctrl.enabledAttribute.pluginMetaAttribute.enum\" caption=\"$ctrl.enabledAttribute.pluginMetaAttribute.description\" ng-change=\"$ctrl.enabledAttribute.value = newValue; $ctrl.onChange();\" flex></ux-select>\n</div>\n</div>\n<div ng-repeat=\"pluginAttribute in $ctrl.configAttributes\" ng-show=\"!pluginAttribute.isAdvanced || $ctrl.showAdvanced\">\n<plugin-attribute plugin=\"$ctrl.plugin\" plugin-attribute=\"pluginAttribute\" on-change=\"$ctrl.onChange()\" show-advanced=\"$ctrl.showAdvanced\" config-only=\"$ctrl.configOnly\" translation-key=\"'settings.' + $ctrl.plugin.pluginMeta.category + '.' + $ctrl.plugin.pluginMeta.type\"></plugin-attribute>\n</div>";
var id1="PluginConfig.html";
var inj=angular.element(window.document).injector();
if(inj){inj.get("$templateCache").put(id1,v1);}
else{ngModule.run(["$templateCache",function(c){c.put(id1,v1)}]);}
module.exports=v1;

/***/ }),
/* 184 */
/***/ (function(module, exports) {

var angular=window.angular,ngModule;
try {ngModule=angular.module(["dxs.settings"])}
catch(e){ngModule=angular.module("dxs.settings",[])}
var v1="<div id=\"plugin-{{$ctrl.pluginAttribute.name}}\" ng-show=\"!$ctrl.pluginAttribute.isSystem &&(!$ctrl.pluginAttribute.isAdvanced || $ctrl.showAdvanced)\">\n<div ng-if=\"!$ctrl.isArray\">\n<div ng-if=\"!$ctrl.isObject\" layout=\"row\">\n<span class=\"settings-text\" layout=\"row\" layout-align=\"start\">{{$ctrl.pluginAttribute.title}}<span ng-show=\"$ctrl.pluginAttribute.isRequired && $ctrl.pluginAttribute.type !== 'boolean'\">*</span></span>\n<div ng-if=\"$ctrl.pluginAttribute.pluginMetaAttribute.enum.size === 0\" flex>\n<div ng-if=\"$ctrl.pluginAttribute.subType === undefined || $ctrl.pluginAttribute.subType === 'password'\" flex>\n<div ng-if=\"$ctrl.pluginAttribute.type === 'string' || \n                $ctrl.pluginAttribute.type === 'integer'\" flex>\n<ux-textbox ng-model=\"$ctrl.pluginAttribute.value\" caption=\"$ctrl.getCaption($ctrl.pluginAttribute)\" ng-change=\"$ctrl.pluginAttribute.value = newValue; $ctrl.onChange();\" on-validate=\"$ctrl.pluginAttribute.isValid\" is-hidden=\"$ctrl.pluginAttribute.subType === 'password'\" flex></ux-textbox>\n</div>\n<div ng-if=\"$ctrl.pluginAttribute.type === 'boolean'\" layout-align=\"start\" style=\"padding-bottom: 10px;\">\n<div style=\"padding-top: 12px;\">\n<ux-toggle ng-model=\"$ctrl.pluginAttribute.value\" caption=\"$ctrl.pluginAttribute.pluginMetaAttribute.description\" ng-change=\"$ctrl.pluginAttribute.value = newValue; $ctrl.onChange();\" style=\"width: 46px; overflow: hidden\"></ux-toggle>\n</div>\n</div>\n</div>\n<div ng-if=\"$ctrl.pluginAttribute.subType === 'filter'\" layout=\"row\" style=\"margin-top: 10px;\" flex>\n<event-filter ng-model=\"$ctrl.pluginAttribute.value\" caption=\"$ctrl.pluginAttribute.pluginMetaAttribute.description\" ng-change=\"$ctrl.pluginAttribute.value = raw; $ctrl.onChange();\" on-validate=\"$ctrl.pluginAttribute.isValid\" flex></event-filter>\n<paste-filter queries=\"$ctrl.myQueries\" apply-filter=\"$ctrl.applyFilter\"/>\n</div>\n<div ng-if=\"$ctrl.pluginAttribute.subType === 'apikey.clientid'\" layout=\"row\" style=\"margin-top: 10px;\" flex>\n<ux-select ng-if=\"$ctrl.apiKeys !== undefined\" ng-model=\"$ctrl.pluginAttribute.value\" options=\"$ctrl.apiKeys\" caption=\"$ctrl.pluginAttribute.pluginMetaAttribute.description\" ng-change=\"$ctrl.pluginAttribute.value = newValue; $ctrl.onChange();\" flex></ux-select>\n<ux-select ng-if=\"$ctrl.apiKeys === undefined\" ng-model=\"$ctrl.pluginAttribute.value\" caption=\"$ctrl.pluginAttribute.pluginMetaAttribute.description + test\" flex></ux-select>\n</div>\n<div ng-if=\"$ctrl.pluginAttribute.subType === 'datetime'\" layout=\"row\" flex>\n<ux-datetime ng-model=\"$ctrl.pluginAttribute.value\" caption=\"$ctrl.pluginAttribute.pluginMetaAttribute.description\" ng-change=\"$ctrl.pluginAttribute.value = newValue; $ctrl.onChange();\" flex>\n</ux-datetime>\n</div>\n</div>\n<div ng-if=\"$ctrl.pluginAttribute.pluginMetaAttribute.enum.size > 0\" flex>\n<div style=\"padding-top: 12px;\">\n<ux-select ng-model=\"$ctrl.pluginAttribute.value\" options=\"$ctrl.pluginAttribute.pluginMetaAttribute.enum\" caption=\"$ctrl.pluginAttribute.pluginMetaAttribute.description\" ng-change=\"$ctrl.pluginAttribute.value = newValue; $ctrl.onChange();\" flex></ux-select>\n</div>\n</div>\n</div>\n<div ng-if=\"$ctrl.isObject\">\n<h2 class=\"md-title\">{{$ctrl.pluginAttribute.title}}</h2>\n<div ng-class=\"{ 'attribute-object': !$ctrl.configOnly }\">\n<div ng-style=\"{ 'margin-left': $ctrl.configOnly ? undefined : '8px' }\">\n<plugin-attribute ng-repeat=\"pluginAttribute in $ctrl.pluginAttribute.attributes\" plugin=\"$ctrl.plugin\" plugin-attribute=\"pluginAttribute\" on-change=\"$ctrl.onChange()\" show-advanced=\"$ctrl.showAdvanced\" translation-key=\"$ctrl.translationKey + '.' + $ctrl.pluginAttribute.title\"></plugin-attribute>\n\n</div>\n</div>\n</div>\n</div>\n<div ng-if=\"$ctrl.isArray\">\n<div ng-if=\"!$ctrl.isObject\" layout=\"row\">\n<span class=\"settings-text\" layout-align=\"start\">{{$ctrl.pluginAttribute.title}}</span>\n<div class=\"archive-attribute\" ng-if=\"$ctrl.pluginAttribute.pluginMetaAttribute.subType === 'archive'\" flex>\n<archive-picker options=\"{showSelectAll: false, showLabel: false}\" selected-archives=\"$ctrl.pluginAttribute.value\" on-change=\"$ctrl.pluginAttribute.value = newValue; $ctrl.onChange();\"></archive-picker>\n<div class=\"uxtoolkit\">\n<div class=\"type__item-description\" style=\"vertical-align: top; margin-top: 2px;\">{{$ctrl.pluginAttribute.pluginMetaAttribute.description}}</div>\n</div>\n</div>\n<div ng-if=\"$ctrl.pluginAttribute.pluginMetaAttribute.subType !== 'archive'\" flex>\n<ux-textbox class=\"settings-textbox\" ng-if=\"$ctrl.pluginAttribute.type === 'string' || $ctrl.pluginAttribute.type === 'integer'\" ng-model=\"$ctrl.value\" caption=\"$ctrl.pluginAttribute.pluginMetaAttribute.description\" ng-change=\"$ctrl.updateArrayValues(newValue); $ctrl.onChange();\" on-validate=\"$ctrl.pluginAttribute.isValid\"></ux-textbox>\n</div>\n</div>\n</div>\n</div>";
var id1="PluginConfigAttribute.html";
var inj=angular.element(window.document).injector();
if(inj){inj.get("$templateCache").put(id1,v1);}
else{ngModule.run(["$templateCache",function(c){c.put(id1,v1)}]);}
module.exports=v1;

/***/ }),
/* 185 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
class EventService {
    constructor($http, $q, baseUrl, settingsService, eventServicePath, threatIntelPath) {
        this.$http = $http;
        this.$q = $q;
        this.baseUrl = baseUrl;
        this.settingsService = settingsService;
        this.eventServicePath = eventServicePath;
        this.threatIntelPath = threatIntelPath;
        this.collectorArchives = [];
        let self = this;
    }
    getArchives() {
        let self = this;
        if (self.getArchivesPromise !== undefined) {
            return self.getArchivesPromise;
        }
        let defer = self.$q.defer();
        self.getArchivesPromise = defer.promise;
        self.$http({
            method: 'POST',
            url: this.baseUrl + this.eventServicePath,
            headers: { 'Content-Type': 'application/json' },
            data: "{id: 12}"
        }).then(function (response) {
            self.settingsService.getPlugins("").then(function (plugins) {
                //The list of archives excluding ones that are missing a UUID.
                let archiveList = response.data.filter(archive => {
                    return archive.uuid !== undefined;
                });
                let archives = {
                    dedicated: [],
                    orphaned: [],
                    forwarded: []
                };
                //Reduce plugin list to collectors and listeners.
                let collectors = plugins.filter(plugin => plugin.type.startsWith("collector") || plugin.type.startsWith("other/icdx"));
                for (let collector of collectors) {
                    if (collector.type.startsWith("collector")) {
                        let pluginArchive = archiveList.find(archive => {
                            return archive.uuid === collector.uuid;
                        });
                        if (pluginArchive !== undefined) {
                            pluginArchive.name = collector.name;
                            archives.dedicated.push(pluginArchive);
                            //Remove the active collector archive from the list.
                            archiveList = archiveList.filter(archive => {
                                return archive !== pluginArchive;
                            });
                        }
                    }
                    else {
                        let pluginArchives = archiveList.filter(archive => {
                            let regex = /forwarded\/(.*)\/.*\/.*/g;
                            let uuidRegExpArray = regex.exec(archive.path);
                            if (uuidRegExpArray === null) {
                                return;
                            }
                            let uuid = uuidRegExpArray[1].split("/");
                            return uuid[uuid.length - 1] === collector.uuid;
                        });
                        for (let pluginArchive of pluginArchives) {
                            pluginArchive.name = collector.name + " - " + pluginArchive.uuid;
                            archives.forwarded.push(pluginArchive);
                            //Remove the active collector archive from the list.
                            archiveList = archiveList.filter(archive => {
                                return archive !== pluginArchive;
                            });
                        }
                    }
                }
                archives.orphaned = archiveList.filter(archive => {
                    archive.name = archive.uuid;
                    return true;
                });
                defer.resolve(archives);
            }, function (errorResponse) {
                defer.resolve(response.data);
            });
        }, function (errorResponse) {
            console.log("Unable to get archive list, using known defaults", errorResponse);
            defer.resolve([
                {
                    "path": "default",
                    "name": "Common Archive"
                }, {
                    "path": "system",
                    "name": "System Archive"
                }
            ]);
        });
        self.getArchivesPromise.finally(function () {
            self.getArchivesPromise = undefined;
        });
        return self.getArchivesPromise;
    }
    /**
     * Given an array of archives, any generic archive is expanded to include it's list of specific archives. For example, "all" will expand to all the collector archives included the default archive but won't include the system archive or any OpenC2 archives.
     *
     * @return an array of archives.
     */
    expandArchives(archives) {
        if (archives === undefined) {
            //Nothing to expand
            return;
        }
        let archivesSet = new Set();
        for (let archive of archives) {
            switch (archive) {
                case "all":
                    archivesSet.add("default");
                    for (let collectorArchive of this.collectorArchives) {
                        archivesSet.add(collectorArchive);
                    }
                    break;
                default:
                    archivesSet.add(archive);
                    break;
            }
        }
        return Array.from(archivesSet);
    }
}
exports.default = EventService;
EventService.$inject = ['$http', '$q', 'baseUrl', 'settingsService', 'eventServicePath'];
;


/***/ }),
/* 186 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
__webpack_require__(187);
let archivePickerTemplate = /*html*/ `
<md-input-container style="margin-bottom: 0; width: 100%; max-width: 100%;">
    <label ng-if="$ctrl.options.showLabel">Archives</label>
    <md-select ng-model="$ctrl.selectedArchives" md-on-open="$ctrl.loadArchives()" multiple md-container-class="ArchivePicker">
        <div ng-show="!$ctrl.loadingPromise">
            <md-input-container class="SelectAll">
                <md-checkbox ng-model="$ctrl.dedicatedAll">
                    <span>Collector Archives</span>
                </md-checkbox>
            </md-input-container>
            <div class="ArchiveGroup">
                <md-option ng-value="'default'" ng-click="$ctrl.select('default')">Common Archive</md-option>
                <md-option ng-repeat="archive in $ctrl.archives.dedicated" ng-click="$ctrl.select(archive.path)" ng-value="archive.path" class="WithPath">
                    <span class="ArchiveName">{{archive.name}}</span>
                    <div class="ArchivePath">{{archive.path}}</div>
                </md-option>
            </div>
        </div>
        
        <div ng-show="!$ctrl.loadingPromise && $ctrl.archives.forwarded.length > 0">
            <md-input-container class="SelectAll">
                <md-checkbox ng-model="$ctrl.forwardedAll">
                    <span>ICDx Chaining Archives</span>
                </md-checkbox>
            </md-input-container>
            <div class="ArchiveGroup">
                <md-option ng-repeat="archive in $ctrl.archives.forwarded" ng-click="$ctrl.select(archive.path)" ng-value="archive.path" class="WithPath">
                    <span class="ArchiveName">{{archive.name}}</span>
                    <div class="ArchivePath">{{archive.path}}</div>
                </md-option>
            </div>
        </div>

        <div ng-show="!$ctrl.loadingPromise && $ctrl.archives.orphaned.length > 0">
            <md-input-container class="SelectAll">
                <md-checkbox ng-model="$ctrl.orphanedAll">
                    <span>Orphaned Collector Archives</span>
                </md-checkbox>
            </md-input-container>
            <div class="ArchiveGroup">
                <md-option ng-repeat="archive in $ctrl.archives.orphaned" ng-click="$ctrl.select(archive.path)" ng-value="archive.path" class="WithPath">
                    <span class="ArchiveName">{{archive.name}}</span>
                    <div class="ArchivePath">{{archive.path}}</div>
                </md-option>
            </div>
        </div>
        
        <div ng-show="!$ctrl.loadingPromise">
            <md-option ng-value="'system'" ng-click="$ctrl.select('system')">System Archive</md-option>
        </div>
    </md-select>
</md-input-container>`;
class ArchivePickerComponent {
    constructor() {
        this.bindings = {
            selectedArchives: '<',
            onChange: '&',
            options: '<'
        };
        this.controller = ArchivePickerController;
        this.template = archivePickerTemplate;
    }
}
exports.default = ArchivePickerComponent;
ArchivePickerComponent.$$ngIsClass = true; //Fix for Firefox
class ArchivePickerController {
    constructor($scope, $timeout, $q, eventArchiveService) {
        this.$scope = $scope;
        this.$timeout = $timeout;
        this.$q = $q;
        this.eventArchiveService = eventArchiveService;
    }
    ;
    $onInit() {
        if (this.options === undefined) {
            this.options = {
                showLabel: true
            };
        }
        if (this.selectedArchives === undefined) {
            this.selectedArchives = ["system"];
        }
        else {
            this.selectedArchives = this.selectedArchives.slice();
        }
        let self = this;
        let defer = this.$q.defer();
        self.loadingPromise = defer.promise;
        self.eventArchiveService.getArchives().then(function (archives) {
            self.archives = archives;
            for (let archiveUuid in self.archives.forwarded) {
                let icdx = self.archives.forwarded[archiveUuid];
                //Adding getter/setter for 'all' since the ICDx collectors are dynamic.
                Object.defineProperty(icdx, 'all', {
                    get() {
                        let all = true;
                        if (self.archives !== undefined) {
                            for (let archive of icdx.archives) {
                                all = all && self.selectedArchives.indexOf(archive.path) >= 0;
                            }
                        }
                        return all;
                    },
                    set(all) {
                        //Deselect any currently selected dedicated archives
                        self.selectedArchives = self.selectedArchives.filter(selectedArchive => !icdx.archives.find(archive => archive.path === selectedArchive) && selectedArchive !== "default");
                        if (all) {
                            self.selectedArchives.push("default");
                            for (let archive of icdx.archives) {
                                self.selectedArchives.push(archive.path);
                            }
                        }
                        self.onLocalChange();
                    }
                });
            }
            //Filter the selected archives with only archives that we know about.
            self.selectedArchives = self.selectedArchives.filter(selectedArchive => {
                for (let archive of self.archives.dedicated) {
                    if (selectedArchive === archive.path) {
                        return true;
                    }
                }
                for (let archive of self.archives.forwarded) {
                    if (selectedArchive === archive.path) {
                        return true;
                    }
                }
                for (let archive of self.archives.orphaned) {
                    if (selectedArchive === archive.path) {
                        return true;
                    }
                }
                return selectedArchive === "default" || selectedArchive === "system";
            });
            self.onLocalChange(false);
            defer.resolve();
            self.loadingPromise = undefined;
        });
    }
    loadArchives() {
        return this.loadingPromise;
    }
    get collectorArchives() {
        return this.archives.dedicated.filter(archive => (!archive.orphaned && !archive.forwarded));
    }
    get dedicatedAll() {
        let all = this.selectedArchives.indexOf("default") >= 0;
        if (this.archives !== undefined) {
            for (let archive of this.archives.dedicated) {
                all = all && this.selectedArchives.indexOf(archive.path) >= 0;
            }
        }
        return all;
    }
    set dedicatedAll(all) {
        let self = this;
        //Deselect any currently selected dedicated archives
        self.selectedArchives = self.selectedArchives.filter(selectedArchive => !self.archives.dedicated.find(archive => archive.path === selectedArchive) && selectedArchive !== "default");
        if (all) {
            self.selectedArchives.push("default");
            for (let archive of self.archives.dedicated) {
                self.selectedArchives.push(archive.path);
            }
        }
        self.onLocalChange();
    }
    get forwardedAll() {
        let all = true;
        if (this.archives !== undefined) {
            for (let archive of this.archives.forwarded) {
                all = all && this.selectedArchives.indexOf(archive.path) >= 0;
            }
        }
        return all;
    }
    set forwardedAll(all) {
        let self = this;
        //Deselect any currently selected dedicated archives
        self.selectedArchives = self.selectedArchives.filter(selectedArchive => !self.archives.forwarded.find(archive => archive.path === selectedArchive));
        if (all) {
            for (let archive of self.archives.forwarded) {
                self.selectedArchives.push(archive.path);
            }
        }
        self.onLocalChange();
    }
    get orphanedAll() {
        let all = true;
        if (this.archives !== undefined) {
            for (let archive of this.archives.orphaned) {
                all = all && this.selectedArchives.indexOf(archive.path) >= 0;
            }
        }
        return all;
    }
    set orphanedAll(all) {
        let self = this;
        //Deselect any currently selected dedicated archives
        self.selectedArchives = self.selectedArchives.filter(selectedArchive => !self.archives.orphaned.find(archive => archive.path === selectedArchive));
        if (all) {
            for (let archive of self.archives.orphaned) {
                self.selectedArchives.push(archive.path);
            }
        }
        self.onLocalChange();
    }
    select(archivePath) {
        let self = this;
        self.$timeout(() => {
            self.onLocalChange();
        });
    }
    /**
     * When a change occurs, do some checks before bubbling up to the parent.
     * @param bubble if false, the parent won't receive the change.
     */
    onLocalChange(bubble = true) {
        if (this.selectedArchives.length === 0) {
            this.selectedArchives = ["default"];
        }
        if (this.onChange && bubble) {
            this.onChange({ newValue: this.selectedArchives.slice() });
        }
        this.$scope.$emit("ArchivesChanged", this.selectedArchives.slice());
    }
}
ArchivePickerController.$inject = ["$scope", "$timeout", "$q", "eventArchiveService"];
;


/***/ }),
/* 187 */
/***/ (function(module, exports, __webpack_require__) {

var content = __webpack_require__(188);
content = content.__esModule ? content.default : content;

if (typeof content === 'string') {
  content = [[module.i, content, '']];
}

var options = {}

options.insert = "head";
options.singleton = false;

var update = __webpack_require__(9)(content, options);

if (content.locals) {
  module.exports = content.locals;
}


/***/ }),
/* 188 */
/***/ (function(module, exports, __webpack_require__) {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(8);
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.i, ".ArchivePicker md-select-menu {\n    max-height: 600px;\n}\n\n.ArchivePicker md-select-menu md-content {\n    max-height: 600px;\n}\n\n.ArchiveGroup {\n    margin-left: 20px;\n    padding-left: 4px;\n    border-left: thin solid #dcdcdc;\n}\n\n.WithPath {\n    padding-bottom: 5px;\n}\n\n.ArchivePath {\n    font-size: 8pt;\n    white-space: nowrap;\n    overflow: hidden;\n    text-overflow: ellipsis;\n}\n\n.md-select-value .ArchivePath {\n    display: none;\n}\n\n.SelectAll {\n    margin: 0px;\n    padding-left: 11px;\n    height: 48px;\n}\n\n.ArchivePicker .md-checked .md-icon {\n    background-color: rgba(0, 137, 198, 0.87) !important;\n}\n\n.ArchivePicker .md-text {\n    color: rgb(0, 0, 0) !important;\n}\n\n.ArchivePicker md-checkbox {\n    margin: 0px;\n    padding: 13px 0;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),
/* 189 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
const SimpleEventFilter_1 = __webpack_require__(15);
__webpack_require__(190);
class EventQueryComponent {
    constructor() {
        this.bindings = {
            query: '<',
            queryChanged: '&',
        };
        this.controller = EventQueryComponentController;
        this.template = /*html*/ `
        <div layout="row">
            <div layout="row" layout-align="start center" flex>
                <div style="margin-top: 8px;" flex>
                    <event-filter ng-model="$ctrl.query.query" index-only="true" ng-change="$ctrl.query.query = newEventFilter; $ctrl.callback();" flex></event-filter>
                </div>
            </div>
        </div>`;
    }
}
exports.default = EventQueryComponent;
class EventQueryComponentController {
    constructor($scope, $rootScope, $window, $timeout, $translate, $mdDialog, $q, eventService) {
        this.$scope = $scope;
        this.$rootScope = $rootScope;
        this.$window = $window;
        this.$timeout = $timeout;
        this.$translate = $translate;
        this.$mdDialog = $mdDialog;
        this.$q = $q;
        this.eventService = eventService;
        this.showQuery = false;
        this.archives = [];
    }
    $onInit() {
        let self = this;
        this.$scope.$on("ArchivesChanged", function (event, archives) {
            self.query.archives = archives;
        });
        if (self.query.query === undefined) {
            self.query.query = new SimpleEventFilter_1.default();
        }
    }
    callback() {
        if (this.query.query !== undefined) {
            this.queryChanged({ newValue: this.query.query.toString() });
        }
    }
}
EventQueryComponentController.$inject = ["$scope", "$rootScope", "$window", "$timeout", "$translate", "$mdDialog", "$q", "eventService"];


/***/ }),
/* 190 */
/***/ (function(module, exports, __webpack_require__) {

var content = __webpack_require__(191);
content = content.__esModule ? content.default : content;

if (typeof content === 'string') {
  content = [[module.i, content, '']];
}

var options = {}

options.insert = "head";
options.singleton = false;

var update = __webpack_require__(9)(content, options);

if (content.locals) {
  module.exports = content.locals;
}


/***/ }),
/* 191 */
/***/ (function(module, exports, __webpack_require__) {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(8);
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.i, "md-menu-content {\n    max-height: 90vh;\n}\n\n.condition {\n    min-width: 150px;\n    border-radius: 16px;\n    height: 34px;\n    background: rgb(224, 224, 224);\n    color: rgb(66, 66, 66);\n    margin-right: 6px !important;\n}\n\n.condition-content {\n    display: inline-block;\n    padding: 0 12px 0 12px !important;\n}\n\n.indent1 {\n    padding-left: 30px;\n}\n\n.indent2 {\n    padding-left: 60px;\n}\n\n.indent3 {\n    padding-left: 90px;\n}\n\n.absolute {\n    text-transform: capitalize;\n}\n\nmd-option .absolute {\n    display: none;\n}\n\n.moment-picker .hour-view td {\n    height: 1.4em;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),
/* 192 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
const SimpleEventFilter_1 = __webpack_require__(15);
const RawEventFilter_1 = __webpack_require__(20);
class EventQueryService {
    constructor($rootScope, $http, $window, $q) {
        this.$rootScope = $rootScope;
        this.$http = $http;
        this.$window = $window;
        this.$q = $q;
        this.publicQueries = [{
                name: "Recent Events",
                state: "eventsearch",
                timeSpan: {
                    recent: 1440
                },
                query: ""
            }, {
                name: "Recent Top 10 By Product",
                state: "eventtopn",
                field: "product_name",
                limit: 10,
                timeSpan: {
                    recent: 1440
                },
                load: true,
                query: ""
            }, {
                name: "Recent Top 10 By Severity",
                state: "eventtopn",
                field: "severity_id",
                limit: 10,
                timeSpan: {
                    recent: 1440
                },
                load: true,
                query: ""
            }, {
                name: "Recent Telemetry",
                state: "eventtopn",
                field: "event_id",
                limit: 10,
                timeSpan: {
                    recent: 1440
                },
                load: true,
                archives: ["system"],
                query: "(event_id in [21001,21003]) or (event_id in [2003,2004] and feature_type!='system') or ((event_id = 1004 or type_id = 2) and severity_id > 2)"
            }];
        this.getPublicQueries = function () {
            let defer = this.$q.defer();
            defer.resolve(this.publicQueries);
            return defer.promise;
        };
        this.getMyQueries = function () {
            let defer = this.$q.defer();
            let myQueries = JSON.parse(this.$window.localStorage.getItem(this.$rootScope.user + ".queries"));
            if (myQueries === null) {
                myQueries = {};
            }
            for (let queryName of Object.keys(myQueries)) {
                let query = myQueries[queryName];
                try {
                    query.query = SimpleEventFilter_1.default.fromJson(JSON.parse(query.query));
                }
                catch (syntaxError) {
                    query.query = new RawEventFilter_1.default(query.query);
                }
            }
            defer.resolve(myQueries);
            return defer.promise;
        };
        this.saveQuery = function (queryToSave) {
            let self = this;
            let defer = self.$q.defer();
            queryToSave.defaultQuery = false;
            self.getMyQueries().then(function (myQueries) {
                myQueries[queryToSave.name] = queryToSave;
                let queries = {};
                for (let queryName of Object.keys(myQueries)) {
                    let query = myQueries[queryName];
                    queries[queryName] = {
                        defaultQuery: false,
                        name: query.name,
                        state: query.state,
                        field: query.field,
                        limit: query.limit,
                        timeSpan: query.timeSpan,
                        archives: query.archives,
                        query: query.query.toString()
                    };
                }
                self.$window.localStorage.setItem(self.$rootScope.user + ".queries", JSON.stringify(queries));
                defer.resolve(queryToSave);
                self.$rootScope.$emit('myQueriesChanged', myQueries);
            });
            return defer.promise;
        };
        this.removeQuery = function (query) {
            let self = this;
            let defer = self.$q.defer();
            self.getMyQueries().then(function (myQueries) {
                delete myQueries[query.name];
                self.$window.localStorage.setItem(self.$rootScope.user + ".queries", JSON.stringify(myQueries));
                defer.resolve(query);
                self.$rootScope.$emit(self.$rootScope.user + '.myQueriesChanged', myQueries);
            });
            return defer.promise;
        };
    }
}
exports.default = EventQueryService;
EventQueryService.$inject = ['$rootScope', '$http', '$window', '$q'];


/***/ }),
/* 193 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
const react_ux_toolkit_1 = __webpack_require__(7);
//Bundling the HTML files defined in the routes
var eventQueriesTemplate = __webpack_require__(194);
class EventQueriesComponent {
    constructor() {
        this.bindings = {
            plugin: '<',
            showAdvanced: '='
        };
        this.controller = EventQueriesController;
        this.template = eventQueriesTemplate;
    }
}
exports.default = EventQueriesComponent;
EventQueriesComponent.$$ngIsClass = true; //Fix for Firefox
class EventQueriesController {
    constructor($rootScope, $scope, $translate, $mdSidenav, $mdDialog, $state, eventQueryService) {
        this.$rootScope = $rootScope;
        this.$scope = $scope;
        this.$translate = $translate;
        this.$mdSidenav = $mdSidenav;
        this.$mdDialog = $mdDialog;
        this.$state = $state;
        this.eventQueryService = eventQueryService;
        $rootScope.$on('myQueriesChanged', function (event, myQueries) {
            $scope.myQueries = myQueries;
            $scope.myQueryNames = Object.keys(myQueries);
        });
        $scope.hideSavedQueries = function () {
            $mdSidenav('eventqueries').close();
        };
        $scope.execute = function (query) {
            $scope.hideSavedQueries();
            let timeSpan = query.timeSpan;
            let params = {
                archive: query.archives,
                querystring: query.query.toString(),
                limit: query.limit,
                field: query.field
            };
            if (params.querystring === "") {
                params.querystring = undefined;
            }
            if (timeSpan.recent) {
                params["ts.type"] = "recent";
                params["ts.value"] = timeSpan.recent;
            }
            else if (timeSpan.relative) {
                params["ts.type"] = "relative";
                params["ts.value"] = timeSpan.relative;
            }
            else if (timeSpan.within) {
                params["ts.type"] = "within";
                params["ts.value"] = timeSpan.within;
                params["ts.of"] = timeSpan.of.toISOString();
            }
            else {
                params["ts.type"] = "absolute";
                params["ts.start"] = timeSpan.startDate.toISOString();
                params["ts.end"] = timeSpan.endDate.toISOString();
            }
            if (query.timeSpan.recent !== undefined) {
                params["ts.type"];
            }
            $state.go(query.state, params, { reload: true });
        };
        $scope.remove = function (query, $event) {
            $mdDialog.show(react_ux_toolkit_1.UxDialog.convertConfirmToUx($mdDialog.confirm()
                .clickOutsideToClose(true)
                .title($translate.instant("event_queries.delete"))
                .textContent($translate.instant("event_queries.delete_message", { queryName: query.name }))
                .ok($translate.instant("dialog.yes"))
                .cancel($translate.instant("dialog.no"))
                .targetEvent($event))).then(function () {
                eventQueryService.removeQuery(query).then(function () {
                    delete $scope.myQueries[query.name];
                    $scope.myQueryNames.splice($scope.myQueryNames.indexOf(query.name), 1);
                });
            });
        };
        $scope.getIcon = function (query) {
            switch (query.state) {
                case "eventtopn":
                    return "pie_chart";
                case "eventsearch":
                default:
                    return "insert_chart";
            }
            ;
        };
        eventQueryService.getPublicQueries().then(function (publicQueries) {
            $scope.publicQueries = publicQueries;
        });
        eventQueryService.getMyQueries().then(function (myQueries) {
            $scope.myQueries = myQueries;
            $scope.myQueryNames = Object.keys(myQueries);
        });
    }
}


/***/ }),
/* 194 */
/***/ (function(module, exports) {

var angular=window.angular,ngModule;
try {ngModule=angular.module(["ev.eventqueries"])}
catch(e){ngModule=angular.module("ev.eventqueries",[])}
var v1="<md-sidenav class=\"md-sidenav-right\" style=\"z-index: 80;\" md-whiteframe=\"4\" md-component-id=\"eventqueries\">\n<md-content>\n<div flex>\n<md-subheader>Public Queries</md-subheader>\n<div ng-repeat=\"query in publicQueries\">\n<query-component query=\"query\" execute=\"execute\"/>\n</div>\n<md-divider ng-show=\"myQueryNames.length > 0\"></md-divider>\n<md-subheader ng-show=\"myQueryNames.length > 0\">My Queries</md-subheader>\n<div ng-repeat=\"queryName in myQueryNames | orderBy\">\n<query-component query=\"myQueries[queryName]\" execute=\"execute\" remove=\"remove\"/>\n</div>\n</div>\n</md-content>\n</md-sidenav>";
var id1="EventQueries.html";
var inj=angular.element(window.document).injector();
if(inj){inj.get("$templateCache").put(id1,v1);}
else{ngModule.run(["$templateCache",function(c){c.put(id1,v1)}]);}
module.exports=v1;

/***/ }),
/* 195 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//QueryComponent.tsx
const React = __webpack_require__(5);
const PropTypes = __webpack_require__(13);
const ReactTooltip = __webpack_require__(40);
const styled_components_1 = __webpack_require__(17);
const react_ux_toolkit_1 = __webpack_require__(7);
const GlobalIcons_1 = __webpack_require__(18);
const histogramIcon = /*html*/ `<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 20 17">
    <g fill="none" fill-rule="evenodd" transform="translate(1)">
        <rect width="2.348" height="10" y="5" class="primary-fill-color" />
        <rect width="2.348" height="10" x="9.391" y="5" class="primary-fill-color" />
        <rect width="2.348" height="15" x="3.13" class="primary-fill-color" />
        <rect width="2.348" height="8" x="12.522" y="7" class="primary-fill-color" />
        <rect width="2.348" height="12" x="6.261" y="3" class="primary-fill-color" />
        <rect width="2.348" height="6" x="15.652" y="9" class="primary-fill-color" />
        <path class="primary-color" stroke-linecap="square" d="M0.391304348,16.5 L17.6086957,16.5"/>
    </g>
</svg>`;
const barChartIcon = /*html*/ `<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 17 20">
    <g fill="none" fill-rule="evenodd" transform="rotate(90 8 9)">
        <rect width="2.16" height="10" x="1.44" y="5" class="primary-fill-color" />
        <rect width="2.16" height="15" x="7.92" class="primary-fill-color" />
        <rect width="2.16" height="15" x="13.68" class="primary-fill-color" />
        <path class="primary-color" stroke-linecap="square" d="M0.36,16.5 L17.64,16.5"/>
    </g>
</svg>`;
const Query = styled_components_1.default.div `
    display: flex;
    flex-direction: row;
    align-items: center;
    justify-content: space-between;
    padding: 0 10px;
`;
const QueryButton = styled_components_1.default.div `
    display: flex;
    flex-direction: row;
    align-items: center;
    justify-content: flex-start;
`;
const QueryName = styled_components_1.default.span `
    max-width: 225px;
    padding-left: 5px;
    overflow: hidden;
    white-space: nowrap;
    text-overflow: ellipsis;
`;
class QueryComponent extends React.Component {
    constructor(props) {
        super(props);
    }
    get icon() {
        switch (this.props.query.state) {
            case "eventtopn":
                return barChartIcon;
            case "eventsearch":
            default:
                return histogramIcon;
        }
        ;
    }
    render() {
        const $translate = this.props.$translate;
        const queryName = this.props.query.name;
        return (React.createElement("div", null,
            React.createElement(Query, { "data-tip": queryName.length >= 25 ? queryName : '' },
                React.createElement(QueryButton, { className: "button button__tertiary is--transparent" },
                    React.createElement(react_ux_toolkit_1.IconButton, { icon: this.icon, onClick: ($event) => this.props.execute(this.props.query, $event) },
                        React.createElement(QueryName, null, this.props.query.name))),
                this.props.remove &&
                    React.createElement(react_ux_toolkit_1.IconButton, { icon: GlobalIcons_1.RemoveIcon, tooltip: $translate.instant("event_queries.delete_tooltip"), onClick: ($event) => this.props.remove(this.props.query, $event) })),
            React.createElement(ReactTooltip, { place: "bottom", type: "light", effect: "solid", border: true, className: "tooltip" })));
    }
}
exports.QueryComponent = QueryComponent;
QueryComponent.propTypes = {
    query: PropTypes.object.isRequired,
    execute: PropTypes.func.isRequired,
    remove: PropTypes.func
};


/***/ }),
/* 196 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//EventCountsComponent.ts
const moment = __webpack_require__(6);
const tinycolor = __webpack_require__(25);
const EventCountsChartPlugin_1 = __webpack_require__(197);
const EventCounts_1 = __webpack_require__(198);
class EventCountsComponent {
    constructor() {
        this.bindings = {
            ngModel: "<"
        };
        this.controller = EventCountsController;
        this.template = /*html*/ `
            <div ng-if="$ctrl.loading" class="overlay" style="height: 250px;" layout="column" layout-align="center center">
                    <div class="ldr">
                        <div class="ldr-blk"></div>
                        <div class="ldr-blk an_delay"></div>
                        <div class="ldr-blk an_delay"></div>
                        <div class="ldr-blk"></div>
                    </div>
            </div>
            <div ng-if="!$ctrl.loading && $ctrl.error.status === 0" style="height: 250px;" flex>
                <div layout="row" layout-align="center center" flex>
                    <span><b>Total Event Count:</b> {{$ctrl.chartData.total.toLocaleString()}}</span>
                    <span style="padding-left: 10px;"><b>Time Range:</b> {{$ctrl.eventCounts.start.toDate() | date : "MM/dd/yyyy HH:mm"}} - {{$ctrl.eventCounts.end.toDate() | date : "MM/dd/yyyy HH:mm"}}</span>
                </div>
                <div id="wrapper" style="position: relative; height: 90%;">
                    <canvas tc-chartjs-bar id="event-counts-chart" chart-data="$ctrl.chartData" chart-options="$ctrl.chartOptions"
                    chart-plugins="chartPlugins"></canvas>
                </div>
            </div>
            <div ng-if="$ctrl.error.status > 0" style="height: 250px;"  layout="column" layout-align="center center">
                <p ng-if="$ctrl.error.status === 400">
                    <md-icon style='color: red'>error</md-icon> Invalid Query{{($ctrl.error.message && $ctrl.error.message !== "") ? ": " + $ctrl.error.message : ""}}
                </p>
                <p ng-if="$ctrl.error.status !== 400">
                    <md-icon style='color: red'>error</md-icon> Error loading event counts
                </p>
            </div>`;
    }
}
exports.default = EventCountsComponent;
EventCountsComponent.$$ngIsClass = true; //Fix for Firefox
class EventCountsController {
    constructor($scope, $q, $timeout, $translate, eventService) {
        this.$scope = $scope;
        this.$q = $q;
        this.$timeout = $timeout;
        this.$translate = $translate;
        this.eventService = eventService;
        this.logYAxis = {
            display: true,
            type: "logarithmic",
            ticks: {
                min: 1,
                padding: 10,
                callback: function (value, index, values) {
                    if (Math.log10(value) % 1 !== 0) {
                        return '';
                    }
                    if (value < 1000000) {
                        return value.toLocaleString();
                    }
                    else {
                        //divide by 100,000 then round, then divide by another 10 to make 1.0 equivalent to
                        //1,000,000.
                        return (Math.round(value / 100000) / 10).toLocaleString() + "M";
                    }
                }
            },
            gridLines: {
                drawTicks: false
            }
        };
        this.linearYAxis = {
            type: "linear",
            ticks: {
                beginAtZero: true,
                callback: function (value, index, values) {
                    if (Math.floor(value) === value) {
                        return value;
                    }
                },
                padding: 10
            },
            gridLines: {
                drawTicks: false
            }
        };
        this.loading = true;
        this.error = { status: 0 };
        this.eventCounts = new EventCounts_1.EventCounts();
        let self = this;
        this.drilldown = this.drilldown.bind(this);
        this.zoomIn = this.zoomIn.bind(this);
        this.zoomOut = this.zoomOut.bind(this);
        self.$scope.$on("searchcounts", function (event) {
            self.selectedStart = undefined;
            self.selectedEnd = undefined;
            self.selectedPivot = undefined;
            self.clearEventCounts();
            self.getEventCounts(self.ngModel);
        });
        self.$scope.$on("refreshcounts", function (event) {
            self.clearEventCounts();
            self.getEventCounts(self.ngModel);
        });
        self.$scope.chartPlugins = [
            EventCountsChartPlugin_1.EventCountsChartPlugin
        ];
        this.chartOptions = {
            animation: false,
            responsive: true,
            maintainAspectRatio: false,
            title: {
                display: false
            },
            legend: {
                display: false
            },
            scales: {
                xAxes: [{
                        offset: true,
                        type: 'time',
                        distribution: 'linear',
                        ticks: {
                            autoSkip: true,
                            maxTicksLimit: 20,
                            maxRotation: 0,
                            minRotation: 0
                        },
                        time: {
                            unit: 'hour',
                            displayFormats: {
                                'hour': 'HH:mm',
                                'minute': 'HH:mm',
                                'second': 'HH:mm:ss'
                            }
                        },
                        gridLines: {
                            display: true
                        },
                        barPercentage: 1.0,
                        categoryPercentage: 1.0
                    }],
                yAxes: [this.logYAxis]
            },
            tooltips: {
                mode: "index",
                callbacks: {
                    label: function (tooltipItem, chart) {
                        return self.$translate.instant("event_search.chart.column_name") + ": " + tooltipItem.yLabel.toLocaleString();
                    }
                }
            },
            hover: {
                onHover: function (hoverEvent, chartElement) {
                    let pointer = chartElement.length > 0;
                    document.getElementById('event-counts-chart').style.cursor = pointer ? "pointer" : "default";
                }
            },
            eventCounts: {
                onClick: self.drilldown,
                select: self.zoomIn,
                zoomIn: self.zoomIn,
                zoomOut: self.zoomOut
            }
        };
    }
    $onInit() {
        this.$scope.hasData = false;
    }
    clearEventCounts() {
        this.eventCounts = new EventCounts_1.EventCounts();
    }
    getEventCounts(query, loading = true) {
        let self = this;
        self.loading = loading;
        self.error = { status: 0 };
        self.eventService.getEventCounts(query).then(function (data) {
            self.$scope.hasData = true;
            self.eventCounts.pushCounts(data);
            self.backgroundColors = [];
            for (let i = 0; i < data.length; i++) {
                self.backgroundColors.push(EventCountsController.BG_COLOR);
            }
            self.chartData = {
                datasets: [{
                        label: self.$translate.instant("event_search.chart.column_name"),
                        backgroundColor: self.backgroundColors,
                        hoverBackgroundColor: EventCountsController.HOVER_BG_COLOR,
                        borderColor: "#FDBB30",
                        borderWidth: 1,
                        data: self.eventCounts.counts
                    }],
                total: self.eventCounts.total
            };
            self.setAxes();
            self.loading = false;
        }, (error) => {
            self.error = error;
            self.loading = false;
        });
    }
    ;
    setAxes() {
        //Choose the y axis
        if (this.eventCounts.max >= 10000) {
            this.chartOptions.scales.yAxes = [this.logYAxis];
            // Adjust logarithmic axis max value to improve axis values display
            let max = Math.pow(10, Math.ceil(Math.log10(this.eventCounts.max)));
            this.chartOptions.scales.yAxes[0].ticks.max = (max === 1 ? 10 : max);
        }
        else {
            this.chartOptions.scales.yAxes = [this.linearYAxis];
        }
        let resolution = this.eventCounts.resolution;
        if (resolution.asDays() >= 1) {
            this.chartOptions.scales.xAxes[0].time.unit = "day";
        }
        else if (resolution.asHours() >= 1) {
            this.chartOptions.scales.xAxes[0].time.unit = "hour";
        }
        else if (resolution.asMinutes() >= 1) {
            this.chartOptions.scales.xAxes[0].time.unit = "minute";
        }
        else {
            this.chartOptions.scales.xAxes[0].time.unit = "second";
        }
    }
    drilldown(chartElement, event) {
        //Wasn't a selection click.
        if (chartElement === undefined) {
            return;
        }
        let selectedMoment = this.chartData.datasets[0].data[chartElement._index].x;
        if (this.selectedPivot === undefined || !event.shiftKey) {
            this.selectedPivot = moment(selectedMoment);
            this.selectedStart = moment(selectedMoment);
            this.selectedEnd = moment(selectedMoment).add(this.getResolutionMs());
        }
        else {
            let currentStart = moment(selectedMoment);
            let currentEnd = moment(selectedMoment).add(this.getResolutionMs());
            let selectedStart = moment(this.selectedPivot);
            let selectedEnd = moment(this.selectedPivot).add(this.getResolutionMs());
            if (currentStart.isBefore(selectedStart)) { //What was clicked is before the current selection
                this.selectedStart = currentStart;
                this.selectedEnd = selectedEnd;
            }
            else if (currentEnd.isAfter(selectedEnd)) { //What was clicked is after the current selection
                this.selectedStart = selectedStart;
                this.selectedEnd = currentEnd;
            }
        }
        this.select();
    }
    zoomIn(start, end) {
        let self = this;
        self.$timeout(function () {
            let zoomed = self.eventCounts.zoomIn(start, end);
            //If the resolution is too course for zooming, get new events counts
            if (!zoomed) {
                let query;
                if (start.valueOf() < end.valueOf()) {
                    query = {
                        query: self.ngModel.query,
                        archives: self.ngModel.archives,
                        timeSpan: {
                            startDate: start,
                            endDate: end
                        }
                    };
                }
                else {
                    query = {
                        query: self.ngModel.query,
                        archives: self.ngModel.archives,
                        timeSpan: {
                            startDate: end,
                            endDate: start
                        }
                    };
                }
                self.getEventCounts(query, false);
            }
            self.chartData.datasets[0].data = self.eventCounts.counts;
            self.chartData.total = self.eventCounts.total;
            self.backgroundColors = [];
            for (let i = 0; i < self.chartData.datasets[0].data.length; i++) {
                self.backgroundColors.push(EventCountsController.BG_COLOR);
            }
            self.chartData.datasets[0].backgroundColor = self.backgroundColors;
        });
    }
    zoomOut() {
        let self = this;
        self.$timeout(function () {
            self.eventCounts.zoomOut();
            self.setAxes();
            self.chartData.datasets[0].data = self.eventCounts.counts;
            self.chartData.total = self.eventCounts.total;
            self.backgroundColors = [];
            for (let i = 0; i < self.chartData.datasets[0].data.length; i++) {
                self.backgroundColors.push(EventCountsController.BG_COLOR);
            }
            self.chartData.datasets[0].backgroundColor = self.backgroundColors;
        });
    }
    getResolutionMs() {
        return this.chartData.datasets[0].data[1].x.diff(this.chartData.datasets[0].data[0].x);
    }
    select() {
        //Iterate over the columns in the chart selecting columns that lie between the provided date range.
        for (let i in this.chartData.datasets[0].data) {
            let colStart = this.chartData.datasets[0].data[i].x;
            let colEnd = moment(colStart).add(this.getResolutionMs());
            if (colStart.isBetween(this.selectedStart, this.selectedEnd, null, '[)') || colEnd.isBetween(this.selectedStart, this.selectedEnd, null, '()')) {
                this.backgroundColors[i] = EventCountsController.SELECTED_BG_COLOR;
            }
            else {
                this.backgroundColors[i] = EventCountsController.BG_COLOR;
            }
        }
        this.$scope.$emit("selectTimeSpan", this.selectedStart, this.selectedEnd);
    }
}
EventCountsController.$inject = ["$scope", "$q", "$timeout", "$translate", "eventService"];
EventCountsController.BG_COLOR = tinycolor("#FDBB30").setAlpha(0.2).toRgbString();
EventCountsController.SELECTED_BG_COLOR = "#FDBB30";
EventCountsController.HOVER_BG_COLOR = tinycolor("#FDBB30").setAlpha(0.5).toRgbString();


/***/ }),
/* 197 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//Selection Plugin
const Chart = __webpack_require__(29);
const moment = __webpack_require__(6);
var helpers = Chart.helpers;
function getYAxis(chart) {
    for (var i in chart.scales) {
        var scale = chart.scales[i];
        if (!scale.isHorizontal()) {
            return scale;
        }
    }
}
function getXAxis(chart) {
    for (var i in chart.scales) {
        var scale = chart.scales[i];
        if (scale.isHorizontal()) {
            return scale;
        }
    }
}
let EventCountsChartPlugin = {
    id: 'event-counts',
    beforeInit: function (chart) {
        chart.eventCounts = {};
        let canvas = chart.eventCounts.canvas = chart.chart.ctx.canvas;
        chart.eventCounts.mouseDown = function (event) {
            //Only start drag when the left mouse button is pressed.
            if (event.button !== 0) {
                return;
            }
            document.body.addEventListener('mousemove', chart.eventCounts.mouseMove);
            document.body.addEventListener('mouseup', chart.eventCounts.mouseUp);
            event.preventDefault();
            chart.eventCounts.dragStart = event;
        };
        chart.eventCounts.mouseMove = function (event) {
            if (chart.eventCounts.dragStart && event.which === 1) {
                const xAxis = getXAxis(chart);
                const endValue = xAxis.getValueForPixel(event.offsetX);
                if (endValue.isAfter(moment(xAxis.min)) && endValue.isBefore(moment(xAxis.max))) {
                    chart.eventCounts.dragEnd = event;
                    chart.update();
                }
            }
        };
        chart.eventCounts.mouseUp = function (event) {
            //Only deal with selection if the drag was started.
            if (chart.eventCounts.dragStart === undefined) {
                return;
            }
            const startElement = chart.getElementAtEvent(chart.eventCounts.dragStart)[0];
            if (startElement !== undefined && chart.eventCounts.dragStart.x === event.x && chart.eventCounts.dragStart.y === event.y) {
                if (chart.options.eventCounts.onClick) {
                    chart.options.eventCounts.onClick(startElement, event);
                }
            }
            else {
                if (chart.options.eventCounts.select) {
                    const xAxis = getXAxis(chart);
                    const startValue = xAxis.getValueForPixel(chart.eventCounts.dragStart.offsetX);
                    const endValue = xAxis.getValueForPixel(event.offsetX);
                    if (!startValue.isSame(endValue)) {
                        chart.options.eventCounts.select(startValue, endValue);
                    }
                }
            }
            chart.eventCounts.dragStart = null;
            chart.eventCounts.dragEnd = null;
            document.body.removeEventListener('mousemove', chart.eventCounts.mouseMove);
            document.body.removeEventListener('mouseup', chart.eventCounts.mouseUp);
        };
        chart.eventCounts.wheel = function (event) {
            const xAxis = getXAxis(chart);
            let start = moment(xAxis.min);
            let end = moment(xAxis.max);
            let mouse = moment(xAxis.getValueForPixel(event.offsetX));
            let newStart;
            let newEnd;
            if (event.wheelDelta > 0) {
                let zoomDuration = moment.duration(moment.duration(end.diff(start)).asMilliseconds() / 3);
                newStart = moment(mouse).subtract(zoomDuration);
                newEnd = moment(mouse).add(zoomDuration);
                chart.options.eventCounts.zoomIn(newStart, newEnd);
            }
            else {
                chart.options.eventCounts.zoomOut();
            }
        };
        canvas.addEventListener('mousedown', chart.eventCounts.mouseDown);
        canvas.addEventListener('wheel', chart.eventCounts.wheel);
    },
    destroy: function (chart) {
        if (chart.eventCounts) {
            var canvas = chart.eventCounts.canvas;
            canvas.removeEventListener('mousedown', chart.eventCounts.mouseDown);
            canvas.removeEventListener('wheel', chart.eventCounts.wheel);
            delete chart.eventCounts;
        }
    },
    beforeDatasetsDraw: function (chart) {
        chart.chart.ctx.save();
        chart.chart.ctx.beginPath();
        if (chart.eventCounts.dragEnd) {
            let yAxis = getYAxis(chart);
            let start = chart.eventCounts.dragStart;
            let end = chart.eventCounts.dragEnd;
            let offsetX = start.target.getBoundingClientRect().left;
            let startX = Math.min(start.clientX, end.clientX) - offsetX;
            let endX = Math.max(start.clientX, end.clientX) - offsetX;
            let width = endX - startX;
            chart.chart.ctx.fillStyle = 'rgba(0, 0, 0, 0.8)';
            chart.chart.ctx.lineWidth = 1;
            chart.chart.ctx.fillRect(startX, yAxis.top, width, yAxis.bottom - yAxis.top);
        }
        chart.chart.ctx.rect(chart.chartArea.left, chart.chartArea.top, chart.chartArea.right - chart.chartArea.left, chart.chartArea.bottom - chart.chartArea.top);
        chart.chart.ctx.clip();
    },
    afterDatasetsDraw: function (chartInstance) {
        chartInstance.chart.ctx.restore();
    },
};
exports.EventCountsChartPlugin = EventCountsChartPlugin;


/***/ }),
/* 198 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//EventCounts.ts
const moment = __webpack_require__(6);
class EventCounts {
    constructor() {
        this._windows = [];
    }
    get counts() {
        return this._windows[this._windows.length - 1].counts;
    }
    get window() {
        return this._windows[this._windows.length - 1];
    }
    pushCounts(data) {
        let counts = [];
        for (let value of data) {
            counts.push({
                x: moment(value.value),
                y: value.count
            });
        }
        ;
        this._windows.push({
            counts: counts,
            start: counts[0].x,
            end: counts[counts.length - 1].x
        });
    }
    get resolution() {
        return moment.duration(this.counts[1].x.diff(this.counts[0].x));
    }
    get duration() {
        return moment.duration(this.end.diff(this.start));
    }
    get max() {
        let max = 0;
        for (let value of this.counts) {
            max = Math.max(value.y, max);
        }
        return max;
    }
    get start() {
        return this.window.start;
    }
    get end() {
        return this.window.end;
    }
    get total() {
        let total = 0;
        for (let value of this.counts) {
            total += value.y;
        }
        return total;
    }
    /**
     * Zooms the event count data.
     */
    zoomIn(start, end) {
        let counts = [];
        for (let count of this.counts) {
            if (count.x.isSameOrBefore(start) || count.x.isSameOrAfter(end)) {
                continue;
            }
            counts.push(count);
        }
        //Zoomed in too far
        if (counts.length < 40) {
            return false;
        }
        this._windows.push({
            counts: counts,
            start: start,
            end: end
        });
        return true;
    }
    zoomOut() {
        if (this._windows.length > 1) {
            this._windows.pop();
        }
    }
}
exports.EventCounts = EventCounts;


/***/ }),
/* 199 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//EventSearchController.ts
const react_ux_toolkit_1 = __webpack_require__(7);
const SimpleEventFilter_1 = __webpack_require__(15);
const QueryUrl_1 = __webpack_require__(47);
const GlobalIcons_1 = __webpack_require__(18);
__webpack_require__(200);
class EventSearchController {
    constructor($scope, $rootScope, $translate, $mdDialog, $mdSidenav, $stateParams, $state, $timeout, eventQueryService, eventArchiveService, helpService, schema) {
        this.$scope = $scope;
        this.$translate = $translate;
        this.$mdDialog = $mdDialog;
        this.$mdSidenav = $mdSidenav;
        this.$state = $state;
        this.$timeout = $timeout;
        this.eventQueryService = eventQueryService;
        this.eventArchiveService = eventArchiveService;
        this.helpService = helpService;
        this.showEventList = false;
        this.showHelp = this.showHelp.bind(this);
        this.showSavedQueries = this.showSavedQueries.bind(this);
        this.saveQuery = this.saveQuery.bind(this);
        this.search = this.search.bind(this);
        let self = this;
        $rootScope.section = "eventsearch";
        $scope.saveIcon = GlobalIcons_1.SaveIcon;
        $scope.savedQueriesIcon = GlobalIcons_1.SavedQueriesIcon;
        $scope.searchIcon = GlobalIcons_1.SearchIcon;
        $scope.eventCountsQuery = QueryUrl_1.loadQuery($stateParams, $state);
        if ($scope.eventCountsQuery.defaultQuery && $rootScope.eventCountsQuery !== undefined) {
            $scope.eventCountsQuery = $rootScope.eventCountsQuery;
        }
        $rootScope.eventCountsQuery = $scope.eventCountsQuery;
        self.eventQuery = {
            limit: 100,
            query: $scope.eventCountsQuery.query,
            where: $scope.eventCountsQuery.where
        };
        self.$scope.$on("selectTimeSpan", function (event, selectedStart, selectedEnd) {
            self.drilldown(selectedStart, selectedEnd);
            event.stopPropagation();
        });
        self.$scope.$on("execute", function (event) {
            event.stopPropagation();
            self.$scope.$broadcast("searchcounts");
        });
        self.$scope.$on("timeSpanChanged", function (event, timeSpan) {
            QueryUrl_1.updateTimeSpan(timeSpan, self.$state);
            self.$scope.eventCountsQuery.timeSpan = timeSpan;
            //Push down the change
            self.$scope.$broadcast("queryUpdated");
        });
        this.$scope.$on("ArchivesChanged", function (event, archives) {
            QueryUrl_1.updateArchives(archives, self.$state);
            self.$scope.eventCountsQuery.archives = archives;
        });
        this.$scope.queryChanged = function (filter) {
            QueryUrl_1.updateQueryString(filter.toString(), self.$state);
        };
    }
    ;
    $onInit() {
        let self = this;
        self.$timeout(function () {
            self.eventArchiveService.getArchives().then(function () {
                self.search();
            });
        });
    }
    search() {
        this.$scope.$broadcast("searchcounts");
        this.eventQuery.filter = new SimpleEventFilter_1.default();
        this.eventQuery.query = this.$scope.eventCountsQuery.query.clone();
        this.showEventList = false;
    }
    drilldown(startDate, endDate) {
        this.showEventList = true;
        this.eventQuery.archives = this.$scope.eventCountsQuery.archives;
        delete this.eventQuery.next;
        this.eventQuery.timeSpan = {
            startDate: startDate,
            endDate: endDate
        };
        this.$scope.$broadcast("searchevents");
        let self = this;
        this.$timeout(function () {
            self.$scope.$digest();
        });
    }
    showSavedQueries() {
        this.$mdSidenav('eventqueries').open();
    }
    showHelp() {
        this.helpService.help("ICDX_Search");
    }
    saveQuery(event) {
        let self = this;
        // Appending dialog to document.body to cover sidenav in docs app
        let prompt = react_ux_toolkit_1.UxDialog.convertPromptToUx(self.$mdDialog.prompt()
            .title(self.$translate.instant('event_search.save_query.title'))
            .textContent(self.$translate.instant('event_search.save_query.content'))
            .targetEvent(event)
            .ok(self.$translate.instant('dialog.save'))
            .cancel(self.$translate.instant('dialog.cancel'))
            .required(true));
        self.$mdDialog.show(prompt).then(function (result) {
            if (result === undefined || result.trim() === "") {
                self.$mdDialog.show(self.$mdDialog.alert()
                    .clickOutsideToClose(true)
                    .title(self.$translate.instant("event_search.save_query.failed_title"))
                    .textContent(self.$translate.instant("event_search.save_query.failed_message"))
                    .ok(self.$translate.instant("dialog.close")));
                return;
            }
            self.eventQueryService.getMyQueries().then(function (myQueries) {
                let query = self.$scope.eventCountsQuery;
                query.name = result;
                query.state = "eventsearch";
                if (myQueries[result] !== undefined) {
                    self.$mdDialog.show(self.$mdDialog.confirm()
                        .title(self.$translate.instant("event_search.save_query.overwrite_title"))
                        .textContent(self.$translate.instant("event_search.save_query.overwrite_message"))
                        .ok(self.$translate.instant("dialog.yes"))
                        .cancel(self.$translate.instant("dialog.no"))).then(function () {
                        self.eventQueryService.saveQuery(query);
                    });
                }
                else {
                    self.eventQueryService.saveQuery(query);
                }
            });
        });
    }
    ;
}
exports.default = EventSearchController;
EventSearchController.$inject = ["$scope", "$rootScope", "$translate", "$mdDialog", "$mdSidenav", "$stateParams", "$state", "$timeout", "eventQueryService", "eventArchiveService", "helpService", "schema"];


/***/ }),
/* 200 */
/***/ (function(module, exports, __webpack_require__) {

var content = __webpack_require__(201);
content = content.__esModule ? content.default : content;

if (typeof content === 'string') {
  content = [[module.i, content, '']];
}

var options = {}

options.insert = "head";
options.singleton = false;

var update = __webpack_require__(9)(content, options);

if (content.locals) {
  module.exports = content.locals;
}


/***/ }),
/* 201 */
/***/ (function(module, exports, __webpack_require__) {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(8);
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.i, ".event-actions {\n    display: flex;\n    flex-direction: row;\n    align-items: flex-end;\n    margin: 0 8px;\n}\n\n.search-button>div>div>div {\n    width: 36px;\n    height: 36px;\n}\n\n.search-button svg {\n    width: 36px;\n    height: 36px;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),
/* 202 */
/***/ (function(module, exports) {

var angular=window.angular,ngModule;
try {ngModule=angular.module(["ev.eventsearch"])}
catch(e){ngModule=angular.module("ev.eventsearch",[])}
var v1="<div style=\"overflow-x: hidden\" layout=\"column\">\n<div style=\"position: inherit; clear: right; padding-left: 8px;\">\n<div layout=\"row\" flex>\n<div layout=\"column\" flex>\n<div layout=\"row\" flex>\n<time-span-picker ng-model=\"eventCountsQuery.timeSpan\"></time-span-picker>\n<archive-picker selected-archives=\"eventCountsQuery.archives\" flex></archive-picker>\n<div class=\"event-actions\">\n<icon-button icon=\"saveIcon\" on-click=\"$ctrl.saveQuery\" tooltip=\"'event_search.save_query_tooltip' | translate\"/>\n<icon-button icon=\"savedQueriesIcon\" on-click=\"$ctrl.showSavedQueries\" tooltip=\"'event_search.saved_queries_tooltip' | translate\"/>\n<help-button on-help=\"$ctrl.showHelp\"/>\n</div>\n</div>\n<div layout=\"row\" layout-align=\"center center\">\n<span style=\"font-size: 16px; padding-right: 8px; padding-left: 5px;\">{{'event_search.filter.title' | translate}}</span>\n<event-filter ng-model=\"eventCountsQuery.query\" index-only=\"true\" ng-change=\"eventCountsQuery.query = newEventFilter; queryChanged(newEventFilter);\" style=\"padding-top: 10px;\" flex></event-filter>\n</div>\n</div>\n<div layout=\"row\" layout-align=\"center center\" style=\"padding: 0 16px 0 8px;\">\n<icon-button class=\"search-button\" icon=\"searchIcon\" on-click=\"$ctrl.search\" tooltip=\"'event_search.search_tooltip' | translate\"/>\n</div>\n</div>\n<sym-event-counts ng-model=\"eventCountsQuery\"></sym-event-counts>\n</div>\n<div layout=\"row\" layout-align=\"center center\">\n<sym-event-list ng-show=\"$ctrl.showEventList\" query=\"$ctrl.eventQuery\" total=\"selectedTotal\" flex></sym-event-list>\n</div>\n<event-queries></event-queries>\n</div>";
var id1="EventSearch.html";
var inj=angular.element(window.document).injector();
if(inj){inj.get("$templateCache").put(id1,v1);}
else{ngModule.run(["$templateCache",function(c){c.put(id1,v1)}]);}
module.exports=v1;

/***/ }),
/* 203 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//event-topn-controller
const tinycolor = __webpack_require__(25);
const moment = __webpack_require__(6);
const react_ux_toolkit_1 = __webpack_require__(7);
const GlobalIcons_1 = __webpack_require__(18);
const Condition_1 = __webpack_require__(26);
const QueryUrl_1 = __webpack_require__(47);
const schema_browser_1 = __webpack_require__(12);
__webpack_require__(204);
class EventTopnController {
    constructor($scope, $rootScope, $stateParams, $state, $mdSidenav, $mdDialog, $translate, eventService, eventSchemaService, eventQueryService, eventArchiveService, helpService, schema) {
        this.$scope = $scope;
        this.$rootScope = $rootScope;
        this.$stateParams = $stateParams;
        this.$state = $state;
        this.$mdSidenav = $mdSidenav;
        this.$mdDialog = $mdDialog;
        this.$translate = $translate;
        this.eventService = eventService;
        this.eventSchemaService = eventSchemaService;
        this.eventQueryService = eventQueryService;
        this.eventArchiveService = eventArchiveService;
        this.helpService = helpService;
        this.bgColors = [];
        this.hoverBgColors = [];
        this.showEventList = false;
        this.loading = false;
        this.error = 0;
        this.showHelp = this.showHelp.bind(this);
        this.showSavedQueries = this.showSavedQueries.bind(this);
        this.saveQuery = this.saveQuery.bind(this);
        this.getTopN = this.getTopN.bind(this);
        let self = this;
        $scope.saveIcon = GlobalIcons_1.SaveIcon;
        $scope.savedQueriesIcon = GlobalIcons_1.SavedQueriesIcon;
        $scope.searchIcon = GlobalIcons_1.SearchIcon;
        $scope.disabledSearchIcon = GlobalIcons_1.DisabledSearchIcon;
        $rootScope.section = "eventtopn";
        self.topNQuery = QueryUrl_1.loadQuery($stateParams, $state);
        $rootScope.topNQuery = self.topNQuery;
        self.eventQuery = {
            limit: 100,
            timeSpan: self.topNQuery.timeSpan,
        };
        self.$scope.$on("timeSpanChanged", function (event, timeSpan) {
            QueryUrl_1.updateTimeSpan(timeSpan, self.$state);
            self.topNQuery.timeSpan = timeSpan;
            self.eventQuery.timeSpan = timeSpan;
            //Push down the change
            self.$scope.$broadcast("queryUpdated");
        });
        self.$scope.$on("execute", function (event) {
            event.stopPropagation();
            self.getTopN();
        });
        this.$scope.$on("ArchivesChanged", function (event, archives) {
            QueryUrl_1.updateArchives(archives, self.$state);
            self.topNQuery.archives = archives;
        });
        this.$scope.queryChanged = function (filter) {
            QueryUrl_1.updateQueryString(filter.toString(), self.$state);
        };
        this.$scope.fieldChanged = function (field) {
            QueryUrl_1.updateField(self.topNQuery.field, self.$state);
        };
        this.$scope.limitChanged = function (limit) {
            QueryUrl_1.updateLimit(self.topNQuery.limit, self.$state);
        };
    }
    ;
    $onInit() {
        let self = this;
        self.chartOptions = {
            animation: false,
            responsive: true,
            maintainAspectRatio: false,
            title: {
                display: false
            },
            legend: {
                display: false
            },
            scales: {
                xAxes: [{
                        ticks: {
                            autoSkip: false,
                            beginAtZero: true,
                            maxRotation: 25,
                            minRotation: 0,
                            callback: function (value, index, values) {
                                let key = "base.attributes." + self.$scope.selectedField + ".enum." + value + ".name";
                                let translation = self.$translate.instant(key);
                                //Checking that the translation happened. Using startsWith since angular translate
                                //sometimes messes with the strings.
                                return translation.startsWith("base.attributes.") ? value : translation;
                            }
                        }
                    }],
                yAxes: [{
                        type: 'logarithmic',
                        ticks: {
                            padding: 10,
                            callback: function (value, index, values) {
                                if (Math.log10(value) % 1 !== 0) {
                                    return '';
                                }
                                if (value < 1000000) {
                                    return value.toLocaleString();
                                }
                                else {
                                    //divide by 100,000 then round, then divide by another 10 to make 1.0 equivalent to
                                    //1,000,000.
                                    return (Math.round(value / 100000) / 10).toLocaleString() + "M";
                                }
                            }
                        },
                        gridLines: {
                            drawTicks: false
                        }
                    }]
            },
            tooltips: {
                mode: "index",
                callbacks: {
                    label: function (tooltipItem, chart) {
                        return self.$translate.instant("event_search.chart.column_name") + ": " + tooltipItem.yLabel.toLocaleString();
                    }
                }
            },
            hover: {
                onHover: function (hoverEvent, chartElement) {
                    let pointer = false;
                    if (chartElement.length > 0 && self.selectedChartElement !== undefined) {
                        pointer = chartElement[0]._index !== self.selectedChartElement._index;
                    }
                    else {
                        pointer = chartElement.length > 0;
                    }
                    document.getElementById('topn-chart').style.cursor = pointer ? "pointer" : "default";
                }
            }
        };
        self.$translate.onReady(function () {
            self.eventArchiveService.getArchives().then(function () {
                self.getTopN();
            });
        });
    }
    getTopN(daemon = false) {
        let self = this;
        self.eventSchemaService.getSchema().then(function (schema) {
            self.$scope.indexedFields = self.eventService.getIndexedFields().slice().filter(field => field !== "id");
        });
        self.error = 0;
        self.loading = true;
        self.showEventList = false;
        self.eventQuery.originalQuery = self.topNQuery.query.clone();
        self.eventQuery.archives = self.topNQuery.archives;
        self.eventQuery.timeSpan = self.topNQuery.timeSpan;
        self.eventService.getTopN(self.topNQuery, daemon).then(function (topN) {
            //The field that the TopN chart is based on for drilldown.
            self.$scope.selectedField = self.topNQuery.field;
            self.$scope.selectedTimeSpan = self.topNQuery.timeSpan;
            self.$scope.selectedFilter = self.topNQuery.query.toString();
            let labels = [];
            let borderColors = [];
            self.bgColors = [];
            self.hoverBgColors = [];
            let data = [];
            let values = [];
            self.chartData = {
                labels: labels,
                values: values,
                datasets: [{
                        label: "Event Count",
                        borderWidth: 2,
                        borderColor: borderColors,
                        hoverBorderColor: borderColors,
                        backgroundColor: self.bgColors,
                        hoverBackgroundColor: self.hoverBgColors,
                        data: data
                    }]
            };
            self.startDate = topN.data.start;
            self.endDate = topN.data.end;
            for (let index in topN.data.result) {
                let value = topN.data.result[index];
                let valueData = value.value;
                let key = "base.attributes." + self.$scope.selectedField + ".enum." + valueData + ".name";
                let translation = self.$translate.instant(key);
                //Checking that the translation happened. Using startsWith since angular translate
                //sometimes messes with the strings.
                let valueText = translation.startsWith("base.attributes.") ? valueData : translation;
                labels.push(valueText);
                values.push(valueData);
                let color = tinycolor(EventTopnController.colors[parseInt(index) % 4]);
                borderColors.push(color);
                self.bgColors.push(tinycolor(color).setAlpha(0.2).toRgbString());
                self.hoverBgColors.push(tinycolor(color).setAlpha(0.5).toRgbString());
                data.push(value.count);
            }
            self.loading = false;
            if (data.length === 0) {
                self.showEventList = false;
            }
            else {
                // Logarithmic axis has issues when working with axis min value equal to 0, which was used to fix the issue
                // when user was unable to click on the bar, which value is equal to calculated minimum value of the logarithmic bar.
                // Dynamic calculation of min and max values based on data is implemented for logarithmic axis to workaround the problem.
                let min = Math.pow(10, Math.floor(Math.log10(Math.min(...data)))) / 10;
                let max = Math.pow(10, Math.ceil(Math.log10(Math.max(...data))));
                self.chartOptions.scales.yAxes[0].ticks.min = min;
                self.chartOptions.scales.yAxes[0].ticks.max = (max === 1 ? 10 : max);
            }
        }, function (status) {
            self.loading = false;
            self.error = status;
        });
    }
    get selectedChartElement() {
        return this._selectedChartElement;
    }
    set selectedChartElement(chartElement) {
        //Deselect the previous bar
        if (this._selectedChartElement !== undefined) {
            let index = this.selectedChartElement._index;
            let bgColor = tinycolor(this.bgColors[index]);
            this.bgColors[index] = bgColor.setAlpha(0.2).toRgbString();
            this.hoverBgColors[index] = bgColor.setAlpha(0.5).toRgbString();
        }
        {
            let index = chartElement._index;
            let bgColor = tinycolor(this.bgColors[index]);
            let hoverBgColor = tinycolor(this.hoverBgColors[index]);
            this.bgColors[index] = bgColor.setAlpha(1.0).toRgbString();
            this.hoverBgColors[index] = hoverBgColor.setAlpha(1.0).toRgbString();
        }
        this._selectedChartElement = chartElement;
    }
    drilldown(chartEvent) {
        //Bar wasn't selected
        if (chartEvent.element.length === 0) {
            return;
        }
        this.selectedChartElement = chartEvent.element[0];
        this.showEventList = true;
        this.eventQuery.query = this.eventQuery.originalQuery.clone();
        let index = this.selectedChartElement._index;
        let value = this.chartData.values[index];
        let condition = new Condition_1.default(new schema_browser_1.Attribute(this.$scope.selectedField), "=", value);
        this.eventQuery.query.addCondition(condition);
        this.eventQuery.timeSpan = {
            startDate: moment(this.startDate),
            endDate: moment(this.endDate)
        };
        delete this.eventQuery.next;
        this.$scope.$broadcast("searchevents");
        this.$scope.$digest();
    }
    ;
    showSavedQueries() {
        this.$mdSidenav('eventqueries').open();
    }
    saveQuery(event) {
        let self = this;
        // Appending dialog to document.body to cover sidenav in docs app
        const prompt = react_ux_toolkit_1.UxDialog.convertPromptToUx(self.$mdDialog.prompt()
            .title(self.$translate.instant('event_topn.save_query.title'))
            .textContent(self.$translate.instant('event_topn.save_query.content'))
            .targetEvent(event)
            .ok(self.$translate.instant('dialog.save'))
            .cancel(self.$translate.instant('dialog.cancel'))
            .required(true));
        self.$mdDialog.show(prompt).then(function (result) {
            if (result === undefined || result.trim() === "") {
                self.$mdDialog.show(self.$mdDialog.alert()
                    .clickOutsideToClose(true)
                    .title(self.$translate.instant("event_topn.save_query.failed_title"))
                    .textContent(self.$translate.instant("event_topn.save_query.failed_message"))
                    .ok(self.$translate.instant("dialog.close")));
                return;
            }
            self.eventQueryService.getMyQueries().then(function (myQueries) {
                let query = self.topNQuery;
                query.name = result;
                query.state = "eventtopn";
                if (myQueries[result] !== undefined) {
                    self.$mdDialog.show(self.$mdDialog.confirm()
                        .title(self.$translate.instant("event_topn.save_query.overwrite_title"))
                        .textContent(self.$translate.instant("event_topn.save_query.overwrite_message"))
                        .ok(self.$translate.instant("dialog.yes"))
                        .cancel(self.$translate.instant("dialog.no"))).then(function () {
                        self.eventQueryService.saveQuery(query);
                    });
                }
                else {
                    self.eventQueryService.saveQuery(query);
                }
            });
        });
    }
    showHelp() {
        this.helpService.help("ICDX_Top_N");
    }
}
exports.default = EventTopnController;
EventTopnController.$inject = ["$scope", "$rootScope", "$stateParams", "$state", "$mdSidenav", "$mdDialog", "$translate", "eventService", "eventSchemaService", "eventQueryService", "eventArchiveService", "helpService", "schema"];
EventTopnController.colors = ["#007c3e", "#c89617", "#0360a3", "#ce1804"];
;


/***/ }),
/* 204 */
/***/ (function(module, exports, __webpack_require__) {

var content = __webpack_require__(205);
content = content.__esModule ? content.default : content;

if (typeof content === 'string') {
  content = [[module.i, content, '']];
}

var options = {}

options.insert = "head";
options.singleton = false;

var update = __webpack_require__(9)(content, options);

if (content.locals) {
  module.exports = content.locals;
}


/***/ }),
/* 205 */
/***/ (function(module, exports, __webpack_require__) {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(8);
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.i, ".FieldPicker md-select-menu {\n    max-height: 600px;\n}\n\n.FieldPicker md-select-menu md-content {\n    max-height: 600px;\n}\n\n.topn-search-button>div>div>div {\n    width: 36px;\n    height: 36px;\n}\n\n.topn-search-button svg {\n    width: 36px;\n    height: 36px;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),
/* 206 */
/***/ (function(module, exports) {

var angular=window.angular,ngModule;
try {ngModule=angular.module(["ev.eventtopn"])}
catch(e){ngModule=angular.module("ev.eventtopn",[])}
var v1="<div layout=\"column\">\n<div style=\"position: inherit; clear: right; padding-left: 8px;\">\n<div layout=\"row\" flex>\n<div layout=\"column\" flex>\n<div layout=\"row\" flex>\n<md-input-container style=\"margin-bottom: 0; height: 30px;\">\n<label>{{'event_topn.limit' | translate}}</label>\n<input ng-model=\"$ctrl.topNQuery.limit\" type=\"number\" step=\"1\" min=\"2\" max=\"100\" ng-change=\"limitChanged()\">\n</md-input-container>\n<md-input-container style=\"margin-bottom: 0;\">\n<label>{{'event_topn.field' | translate}}</label>\n<md-select ng-model=\"$ctrl.topNQuery.field\" ng-change=\"fieldChanged()\" md-container-class=\"FieldPicker\">\n<md-option ng-repeat=\"field in indexedFields | schemaOrderBy:'base'\" value=\"{{field}}\">{{field | schemaFieldTranslate}}</md-option>\n</md-select>\n</md-input-container>\n<time-span-picker ng-model=\"$ctrl.topNQuery.timeSpan\"></time-span-picker>\n<archive-picker selected-archives=\"$ctrl.topNQuery.archives\" flex></archive-picker>\n<div class=\"event-actions\">\n<icon-button icon=\"saveIcon\" on-click=\"$ctrl.saveQuery\" tooltip=\"'event_topn.save_query_tooltip' | translate\"/>\n<icon-button icon=\"savedQueriesIcon\" on-click=\"$ctrl.showSavedQueries\" tooltip=\"'event_topn.saved_queries_tooltip' | translate\"/>\n<help-button on-help=\"$ctrl.showHelp\"/>\n</div>\n</div>\n<div layout=\"row\" layout-align=\"center center\">\n<span style=\"font-size: 16px; padding-right: 8px; padding-left: 5px;\">{{'event_topn.filter.title' | translate}}</span>\n<event-filter ng-model=\"$ctrl.topNQuery.query\" index-only=\"true\" ng-change=\"$ctrl.topNQuery.query = newEventFilter; queryChanged(newEventFilter);\" style=\"padding-top: 10px;\" flex></event-filter>\n</div>\n</div>\n<div ng-if=\"!$ctrl.topNQuery.limit\" layout=\"row\" layout-align=\"center center\" style=\"padding: 0 16px 0 8px;\" disabled=\"true\">\n<icon-button class=\"topn-search-button\" icon=\"disabledSearchIcon\" tooltip=\"'event_topn.search_tooltip' | translate\" disabled=\"true\"/>\n</div>\n<div ng-if=\"$ctrl.topNQuery.limit\" layout=\"row\" layout-align=\"center center\" style=\"padding: 0 16px 0 8px;\">\n<icon-button class=\"topn-search-button\" icon=\"searchIcon\" on-click=\"$ctrl.getTopN\" tooltip=\"'event_topn.search_tooltip' | translate\"/>\n</div>\n</div>\n</div>\n<div ng-if=\"$ctrl.loading\" class=\"overlay\" style=\"height: 300px;\" layout=\"column\" layout-align=\"center center\">\n<div class=\"ldr\">\n<div class=\"ldr-blk\"></div>\n<div class=\"ldr-blk an_delay\"></div>\n<div class=\"ldr-blk an_delay\"></div>\n<div class=\"ldr-blk\"></div>\n</div>\n</div>\n<div ng-if=\"!$ctrl.loading && !$ctrl.error\" style=\"max-height: 300px;\" layout=\"column\" flex>\n<div ng-if=\"$ctrl.chartData.datasets[0].data.length !== 0\" id=\"wrapper\" style=\"position: relative; height: 100%;\">\n<canvas id=\"topn-chart\" tc-chartjs-bar chart-data=\"$ctrl.chartData\" chart-options=\"$ctrl.chartOptions\" chart-click=\"$ctrl.drilldown(event)\" style=\"height: 300px;\"></canvas>\n</div>\n<div ng-if=\"!$ctrl.loading && $ctrl.chartData.datasets[0].data.length === 0\">\n<div layout=\"column\" layout-align=\"center center\">\n<p>\nNo Data in Selected Time Range\n</p>\n</div>\n</div>\n</div>\n<div ng-if=\"$ctrl.error > 0\" style=\"height: 300px;\" layout=\"column\" layout-align=\"center center\">\n<p ng-if=\"$ctrl.error === 400\">\n<md-icon style=\"color: red\">error</md-icon> Invalid Query\n</p>\n<p ng-if=\"$ctrl.error !== 400\">\n<md-icon style=\"color: red\">error</md-icon> Error loading Top N\n</p>\n</div>\n<div layout=\"row\" layout-align=\"center center\">\n<sym-event-list ng-show=\"$ctrl.showEventList\" query=\"$ctrl.eventQuery\" flex></sym-event-list>\n</div>\n<event-queries></event-queries>\n</div>";
var id1="EventTopn.html";
var inj=angular.element(window.document).injector();
if(inj){inj.get("$templateCache").put(id1,v1);}
else{ngModule.run(["$templateCache",function(c){c.put(id1,v1)}]);}
module.exports=v1;

/***/ }),
/* 207 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//ThreatIntelController.ts
const tinycolor = __webpack_require__(25);
class ThreatIntelController {
    constructor($scope, $rootScope, $mdDialog, $timeout, $translate, $interval, threatIntelService) {
        this.$scope = $scope;
        this.$rootScope = $rootScope;
        this.$mdDialog = $mdDialog;
        this.$timeout = $timeout;
        this.$translate = $translate;
        this.$interval = $interval;
        this.threatIntelService = threatIntelService;
        this.bgColors = [];
        this.hoverBgColors = [];
        this.field = "malware";
        let self = this;
        $rootScope.section = "threatintel";
        $scope.chartOptions = {
            animation: false,
            responsive: true,
            maintainAspectRatio: false,
            title: {
                display: false
            },
            legend: {
                display: false
            },
            scales: {
                xAxes: [{
                        ticks: {
                            autoSkip: false,
                            callback: function (value, index, values) {
                                let key = "base.attributes." + $scope.selectedField + ".enum." + value + ".name";
                                let translation = $translate.instant(key);
                                return key === translation ? value : translation;
                            }
                        }
                    }],
                yAxes: [{
                        type: 'logarithmic',
                        ticks: {
                            autoSkip: false,
                            padding: 10,
                            callback: function (value, index, values) {
                                if (Math.log10(value) % 1 !== 0) {
                                    return '';
                                }
                                if (value < 1000000) {
                                    return value.toLocaleString();
                                }
                                else {
                                    //divide by 100,000 then round, then divide by another 10 to make 1.0 equivalent to
                                    //1,000,000.
                                    return (Math.round(value / 100000) / 10).toLocaleString() + "M";
                                }
                            }
                        },
                        gridLines: {
                            drawTicks: false
                        }
                    }]
            },
            tooltips: {
                mode: "index"
            },
            hover: {
                onHover: function (hoverEvent, chartElement) {
                    let pointer = false;
                    if (chartElement.length > 0 && self.selectedChartElement !== undefined) {
                        pointer = chartElement[0]._index !== self.selectedChartElement._index;
                    }
                    else {
                        pointer = chartElement.length > 0;
                    }
                    document.getElementById('threatintel-chart').style.cursor = pointer ? "pointer" : "default";
                }
            }
        };
        $scope.refresh = function () {
            self.getTopN();
        };
        $scope.loading = false;
        $scope.showEventList = false;
    }
    ;
    $onInit() {
        let self = this;
        self.$translate.onReady(function () {
            self.getTopN();
        });
    }
    get selectedChartElement() {
        return this._selectedChartElement;
    }
    set selectedChartElement(chartElement) {
        //Deselect the previous bar
        if (this._selectedChartElement !== undefined) {
            let index = this.selectedChartElement._index;
            let bgColor = tinycolor(this.bgColors[index]);
            this.bgColors[index] = bgColor.setAlpha(0.2).toRgbString();
            this.hoverBgColors[index] = bgColor.setAlpha(0.5).toRgbString();
        }
        {
            let index = chartElement._index;
            let bgColor = tinycolor(this.bgColors[index]);
            let hoverBgColor = tinycolor(this.hoverBgColors[index]);
            this.bgColors[index] = bgColor.setAlpha(1.0).toRgbString();
            this.hoverBgColors[index] = hoverBgColor.setAlpha(1.0).toRgbString();
        }
        this._selectedChartElement = chartElement;
    }
    getTopN() {
        let self = this;
        self.$scope.loading = true;
        self.$scope.showEventList = false;
        self.threatIntelService.getThreatIntelTopn(self.field).then(function (topN) {
            self.$scope.start = topN.start;
            self.$scope.end = topN.end;
            let labels = [];
            let borderColors = [];
            self.bgColors = [];
            self.hoverBgColors = [];
            let data = [];
            self.$scope.chartData = {
                labels: labels,
                datasets: [{
                        label: "Event Count",
                        borderWidth: 2,
                        borderColor: borderColors,
                        hoverBorderColor: borderColors,
                        backgroundColor: self.bgColors,
                        hoverBackgroundColor: self.hoverBgColors,
                        data: data
                    }]
            };
            for (let index in topN.data) {
                let value = topN.data[index];
                labels.push(value.value);
                let color = tinycolor(ThreatIntelController.colors[parseInt(index) % 4]);
                borderColors.push(color);
                self.bgColors.push(tinycolor(color).setAlpha(0.2).toRgbString());
                self.hoverBgColors.push(tinycolor(color).setAlpha(0.5).toRgbString());
                data.push(value.count);
            }
            self.$scope.loading = false;
            if (data.length === 0) {
                self.$scope.showEventList = false;
            }
            else {
                // Logarithmic axis has issues when working with axis min value equal to 0, which was used to fix the issue
                // when user was unable to click on the bar, which value is equal to calculated minimum value of the logarithmic bar.
                // Dynamic calculation of min and max values based on data is implemented for logarithmic axis to workaround the problem.
                let min = Math.pow(10, Math.floor(Math.log10(Math.min(...data)))) / 10;
                let max = Math.pow(10, Math.ceil(Math.log10(Math.max(...data))));
                self.$scope.chartOptions.scales.yAxes[0].ticks.min = min;
                self.$scope.chartOptions.scales.yAxes[0].ticks.max = (max === 1 ? 10 : max);
            }
        }, function (errorResponse) {
            self.$scope.error = true;
            console.log("Error loading top N");
            console.log(errorResponse);
        });
    }
    drilldown(chartEvent) {
        //Bar wasn't selected
        if (chartEvent.element.length === 0) {
            return;
        }
        this.selectedChartElement = chartEvent.element[0];
        this.$scope.showEventList = true;
        this.value = this.selectedChartElement._model.label;
        this.$scope.$digest();
    }
    ;
}
exports.default = ThreatIntelController;
ThreatIntelController.$inject = ["$scope", "$rootScope", "$mdDialog", "$timeout", "$translate", "$interval", "threatIntelService"];
ThreatIntelController.colors = ["#007c3e", "#c89617", "#0360a3", "#ce1804"];
;


/***/ }),
/* 208 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
//ThreatintelListComponent.ts
const angular = __webpack_require__(3);
//Bundling the HTML files defined in the routes
var threatIntellistTemplate = __webpack_require__(209);
class ThreatIntelListComponent {
    constructor() {
        this.bindings = {
            field: '<',
            value: '<'
        };
        this.controller = ThreatIntelListController;
        this.template = threatIntellistTemplate;
    }
}
exports.default = ThreatIntelListComponent;
ThreatIntelListComponent.$$ngIsClass = true; //Fix for Firefox
class ThreatIntelListController {
    constructor($scope, $timeout, $window, threatIntelService) {
        this.$scope = $scope;
        this.$timeout = $timeout;
        this.$window = $window;
        this.threatIntelService = threatIntelService;
        this.error = false;
        this.columns = [];
        this.threatIntelList = [];
        this.limit = 100;
        let self = this;
        // Listens for window resize events and updates the event list size.
        angular.element($window).bind('resize', this.resize);
        $scope.mouseOver = false;
        $scope.pages = [];
        $scope.sortColumn = "log_time";
        /**
         * If the sort column goes from desc to asc, instead remove the sorting.
         */
        $scope.$watch('sortColumn', function (newValue, oldValue) {
            if (oldValue !== undefined && oldValue.startsWith("-") &&
                oldValue.endsWith(newValue)) {
                $scope.sortColumn = undefined;
            }
        }, true);
    }
    ;
    ;
    $onInit() {
        this.execute();
    }
    get value() {
        return this._value;
    }
    set value(value) {
        this._value = value;
        if (this.$scope !== undefined && value !== undefined) {
            this.execute();
        }
    }
    execute(next = undefined) {
        let self = this;
        self.error = false;
        self.threatIntelList = [];
        if (self.next === undefined) {
            self.$scope.pages = [];
        }
        self.$scope.promise = self.threatIntelService.getThreatIntelList(self.field, self.value, next);
        self.$scope.promise.then(function (data) {
            let columns = new Set();
            for (let i in data.result) {
                for (let columnName in data.result[i]) {
                    columns.add(columnName);
                }
            }
            self.columns = Array.from(columns.values());
            self.columns.sort(function (a, b) {
                if (a === b) {
                    return 0;
                }
                if (a === "log_time") {
                    return -1;
                }
                else if (b === "log_time") {
                    return 1;
                }
                if (a > b) {
                    return 1;
                }
                else {
                    return -1;
                }
            });
            self.threatIntelList = data.result;
            self.next = data.next;
            self.$scope.promise = null;
            self.$timeout(function () {
                self.resize();
            });
        }, function (errorResponse) {
            self.error = true;
            console.log("Error loading events");
            console.log(errorResponse);
        });
    }
    ;
    /**
         * Calculates where on the page the event list sits and sets
         * it's height to fill the screen.
         */
    resize() {
        let windowsHeight = angular.element(this.$window).height();
        let eventList = angular.element("#threatintellist");
        let paging = angular.element("#threatintellist-paging");
        var eventListOffset = eventList.offset().top;
        var height = windowsHeight - eventListOffset - paging.height() - 10;
        eventList.height(height < 300 ? 300 : height);
    }
    openExportMenu($mdOpenMenu, ev) {
        $mdOpenMenu(ev);
    }
    ;
    exportCsv($event) {
        let self = this;
        var eventsJson = angular.toJson(self.$scope.events);
        var fieldSet = new Set();
        angular.forEach(self.$scope.events, function (event) {
            angular.forEach(event, function (value, key) {
                fieldSet.add(key);
            });
        });
        var fields = Array.from(fieldSet);
        var csv = self.$scope.events.map(function (row) {
            return fields.map(function (fieldName) {
                return JSON.stringify(row[fieldName] || '');
            });
        });
        csv.unshift(fields); // add header column
        var blob = new Blob([csv.join('\r\n')], { type: "application/octet-stream" });
        var objectUrl = window.URL.createObjectURL(blob);
        var downloadLink = angular.element('<a></a>');
        downloadLink.attr('href', objectUrl);
        downloadLink.attr('download', 'events.csv');
        downloadLink[0].click();
        window.URL.revokeObjectURL(objectUrl);
    }
    ;
    exportJson($event) {
        var eventsJson = angular.toJson(this.$scope.events, true);
        var blob = new Blob([eventsJson], { type: "application/octet-stream" });
        var objectUrl = window.URL.createObjectURL(blob);
        var downloadLink = angular.element('<a></a>');
        downloadLink.attr('href', objectUrl);
        downloadLink.attr('download', 'events.json');
        downloadLink[0].click();
        window.URL.revokeObjectURL(objectUrl);
    }
    ;
    nextPage() {
        this.$scope.pages.push(this.next);
        this.execute(this.next);
    }
    prevPage() {
        this.$scope.query.next = this.$scope.pages.pop();
    }
}
ThreatIntelListController.$inject = ['$scope', '$timeout', '$window', 'threatIntelService'];
;


/***/ }),
/* 209 */
/***/ (function(module, exports) {

var angular=window.angular,ngModule;
try {ngModule=angular.module(["symc.event-viewer-templates"])}
catch(e){ngModule=angular.module("symc.event-viewer-templates",[])}
var v1="<div>\n<div ng-hide=\"error\">\n<md-table-container id=\"threatintellist\">\n<table class=\"event-table\" md-table>\n<thead md-head fix-head md-order=\"sortColumn\">\n<tr md-row>\n<th md-column ng-repeat=\"column in $ctrl.columns\" md-order-by=\"{{::column}}\">\n<span>{{column}}</span>\n</th>\n</tr>\n<md-progress-linear ng-if=\"promise\" md-mode=\"indeterminate\"></md-progress-linear>\n</thead>\n<tbody md-body style=\"overflow: auto;\">\n<tr md-row ng-repeat=\"threatIntel in $ctrl.threatIntelList | orderBy: sortColumn\" style=\"outline: none;\" ng-dblclick=\"showDetails(event)\" ng-right-click=\"$ctrl.attributeContextMenu($event, event)\">\n<td md-cell ng-repeat=\"column in $ctrl.columns\" id=\"{{::column}}\">\n{{threatIntel[column]}}\n</td>\n</tr>\n</tbody>\n</table>\n</md-table-container>\n</div>\n<div ng-show=\"error\" layout-padding flex>\n<div layout=\"column\" layout-align=\"center center\">\n<p>\n<md-icon style=\"color: red\">error</md-icon> Error loading events</p>\n<md-button class=\"md-raised\" ng-click=\"execute()\">Retry</md-button>\n</div>\n</div>\n<div id=\"threatintellist-paging\" ng-show=\"!promise\" layout=\"row\" layout-align=\"end center\">\n<span>{{(pages.length * $ctrl.limit) + 1}} - {{(pages.length * $ctrl.limit) + $ctrl.threatIntelList.length}}</span>\n<md-button class=\"md-icon-button\" ng-click=\"$ctrl.prevPage()\" ng-disabled=\"pages.length === 0\">\n<md-icon>navigate_before</md-icon>\n</md-button>\n<md-button class=\"md-icon-button\" ng-click=\"$ctrl.nextPage()\" ng-disabled=\"$ctrl.threatIntelList.length !== $ctrl.limit\">\n<md-icon>navigate_next</md-icon>\n</md-button>\n</div>\n</div>";
var id1="ThreatIntelList.html";
var inj=angular.element(window.document).injector();
if(inj){inj.get("$templateCache").put(id1,v1);}
else{ngModule.run(["$templateCache",function(c){c.put(id1,v1)}]);}
module.exports=v1;

/***/ }),
/* 210 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
class ThreatIntelService {
    constructor($http, $q, baseUrl, threatIntelPath) {
        this.$http = $http;
        this.$q = $q;
        this.baseUrl = baseUrl;
        this.threatIntelPath = threatIntelPath;
    }
    getThreatIntelList(field, value, next) {
        var defer = this.$q.defer();
        var threatIntelSearch = {};
        threatIntelSearch.id = 1;
        threatIntelSearch.limit = 100;
        threatIntelSearch.start = 0;
        threatIntelSearch.flatten = true;
        threatIntelSearch.where = field + "=\"" + value + "\"";
        if (next) {
            threatIntelSearch.next = next;
        }
        this.$http({
            method: 'POST',
            url: this.baseUrl + this.threatIntelPath,
            headers: { 'Content-Type': 'application/json' },
            data: JSON.stringify(threatIntelSearch)
        }).then(function (response) {
            defer.resolve(response.data);
        }, function (errorResponse) {
            defer.reject(errorResponse);
        });
        return defer.promise;
    }
    ;
    getThreatIntel(threatIntelId) {
        var defer = this.$q.defer();
        var threatIntelSearch = {};
        threatIntelSearch.id = 0;
        threatIntelSearch.uuid = threatIntelId;
        this.$http({
            method: 'POST',
            url: this.baseUrl + this.threatIntelPath,
            headers: { 'Content-Type': 'application/json' },
            data: JSON.stringify(threatIntelSearch)
        }).then(function (response) {
            defer.resolve(response.data);
        }, function (errorResponse) {
            defer.reject(errorResponse);
        });
        return defer.promise();
    }
    getThreatIntelTopn(field) {
        let defer = this.$q.defer();
        let topn = {};
        topn.id = 3;
        topn.field = field;
        topn.limit = 10;
        topn.start = 0;
        this.$http({
            method: 'POST',
            url: this.baseUrl + this.threatIntelPath,
            headers: { 'Content-Type': 'application/json' },
            data: JSON.stringify(topn)
        }).then(function (response) {
            defer.resolve({
                data: response.data
            });
        }, function (errorResponse) {
            defer.reject(errorResponse);
        });
        return defer.promise;
    }
    ;
}
exports.default = ThreatIntelService;
ThreatIntelService.$inject = ['$http', '$q', 'baseUrl', 'threatIntelPath'];
;


/***/ }),
/* 211 */
/***/ (function(module, exports) {

var angular=window.angular,ngModule;
try {ngModule=angular.module(["icdx.threatintel"])}
catch(e){ngModule=angular.module("icdx.threatintel",[])}
var v1="<div ng-controller=\"ThreatIntelController as $ctrl\" layout=\"column\">\n<md-content overflow: hidden>\n<div style=\"position: relative; float: right;\">\n<md-button ng-click=\"refresh()\" class=\"md-icon-button\">\n<md-icon>refresh</md-icon>\n</md-button>\n</div>\n<md-card style=\"position: inherit; clear: right;\">\n<div ng-hide=\"error\">\n<div ng-if=\"loading\" layout=\"row\" layout-align=\"center center\" style=\"min-height: 300px\">\n<md-progress-circular md-mode=\"indeterminate\"></md-progress-circular>\n</div>\n<div ng-if=\"!loading\">\n<canvas id=\"threatintel-chart\" tc-chartjs-bar chart-data=\"chartData\" chart-options=\"chartOptions\" width=\"100%\" height=\"300px\" style=\"overflow: visible\" chart-click=\"$ctrl.drilldown(event)\" flex></canvas>\n</div>\n</div>\n<div ng-show=\"error\" layout-padding flex>\n<div layout=\"column\" layout-align=\"center center\">\n<p>\n<md-icon style=\"color: red\">error</md-icon>\nError loading Top N\n</p>\n<md-button class=\"md-raised\" ng-click=\"refresh()\">Retry</md-button>\n</div>\n</div>\n</md-card>\n<threat-intel-list ng-show=\"showEventList && $ctrl.value !== undefined\" field=\"$ctrl.field\" value=\"$ctrl.value\"></threat-intel-list>\n</md-content>\n</div>";
var id1="ThreatIntel.html";
var inj=angular.element(window.document).injector();
if(inj){inj.get("$templateCache").put(id1,v1);}
else{ngModule.run(["$templateCache",function(c){c.put(id1,v1)}]);}
module.exports=v1;

/***/ })
/******/ ]);
//# sourceMappingURL=icdx-portal.39b51c5477083dc4a910.js.map