#!/bin/bash

# This script migrates the Endpoint Detection and Response Collector
# configurations.

ROOTDIR="$SYMC_HOME/apps/collector/network/atp_col_dx"
set -e

function migrate {
  SRC=$1
  echo "  $SRC"
  /bin/sed -i 's/atp_col_dx/sedr_col_dx/g' $SRC
  if [[ $? -ne 0 ]];then
    echo "Failed to migrate $SRC"
  fi
}

function migrate_configs {
  for file in $ROOTDIR/*.json; do
    migrate $file
  done
}

echo "Migrate Endpoint Detection and Response Collector configurations"

migrate_configs

echo ""
echo "Configuration migration completed"